# @GENERATED by build/buildTypes.py (see data/types.yml)
# Generated at 2022-10-06T23:55:24.018021+00:00
import builtins
import unittest
from pycsbinarywriter import cstypes
__all__ = ['TestSimpleSerializers']


class TestSimpleSerializers(unittest.TestCase):
    def test_uint8_pack(self) -> None:
        input_value: builtins.int = 127
        expected: bytes = b'\x7f'
        actual: bytes = cstypes.uint8.pack(input_value)
        self.assertEqual(actual, expected)

    def test_uint8_unpack(self) -> None:
        input_bytes: bytes = b'\x7f'
        expected: builtins.int = 127
        actual: bytes = cstypes.uint8.unpack(input_bytes)
        self.assertEqual(actual, expected)

    def test_int8_pack(self) -> None:
        input_value: builtins.int = -127
        expected: bytes = b'\x81'
        actual: bytes = cstypes.int8.pack(input_value)
        self.assertEqual(actual, expected)

    def test_int8_unpack(self) -> None:
        input_bytes: bytes = b'\x81'
        expected: builtins.int = -127
        actual: bytes = cstypes.int8.unpack(input_bytes)
        self.assertEqual(actual, expected)

    def test_int16_pack(self) -> None:
        input_value: builtins.int = -1234
        expected: bytes = b'\x2e\xfb'
        actual: bytes = cstypes.int16.pack(input_value)
        self.assertEqual(actual, expected)

    def test_int16_unpack(self) -> None:
        input_bytes: bytes = b'\x2e\xfb'
        expected: builtins.int = -1234
        actual: bytes = cstypes.int16.unpack(input_bytes)
        self.assertEqual(actual, expected)

    def test_uint16_pack(self) -> None:
        input_value: builtins.int = 1234
        expected: bytes = b'\xd2\x04'
        actual: bytes = cstypes.uint16.pack(input_value)
        self.assertEqual(actual, expected)

    def test_uint16_unpack(self) -> None:
        input_bytes: bytes = b'\xd2\x04'
        expected: builtins.int = 1234
        actual: bytes = cstypes.uint16.unpack(input_bytes)
        self.assertEqual(actual, expected)

    def test_int32_pack(self) -> None:
        input_value: builtins.int = -1234567
        expected: bytes = b'\x79\x29\xed\xff'
        actual: bytes = cstypes.int32.pack(input_value)
        self.assertEqual(actual, expected)

    def test_int32_unpack(self) -> None:
        input_bytes: bytes = b'\x79\x29\xed\xff'
        expected: builtins.int = -1234567
        actual: bytes = cstypes.int32.unpack(input_bytes)
        self.assertEqual(actual, expected)

    def test_uint32_pack(self) -> None:
        input_value: builtins.int = 1234567
        expected: bytes = b'\x87\xd6\x12\x00'
        actual: bytes = cstypes.uint32.pack(input_value)
        self.assertEqual(actual, expected)

    def test_uint32_unpack(self) -> None:
        input_bytes: bytes = b'\x87\xd6\x12\x00'
        expected: builtins.int = 1234567
        actual: bytes = cstypes.uint32.unpack(input_bytes)
        self.assertEqual(actual, expected)

    def test_int64_pack(self) -> None:
        input_value: builtins.int = -1234567890
        expected: bytes = b'\x2e\xfd\x69\xb6\xff\xff\xff\xff'
        actual: bytes = cstypes.int64.pack(input_value)
        self.assertEqual(actual, expected)

    def test_int64_unpack(self) -> None:
        input_bytes: bytes = b'\x2e\xfd\x69\xb6\xff\xff\xff\xff'
        expected: builtins.int = -1234567890
        actual: bytes = cstypes.int64.unpack(input_bytes)
        self.assertEqual(actual, expected)

    def test_uint64_pack(self) -> None:
        input_value: builtins.int = 1234567890
        expected: bytes = b'\xd2\x02\x96\x49\x00\x00\x00\x00'
        actual: bytes = cstypes.uint64.pack(input_value)
        self.assertEqual(actual, expected)

    def test_uint64_unpack(self) -> None:
        input_bytes: bytes = b'\xd2\x02\x96\x49\x00\x00\x00\x00'
        expected: builtins.int = 1234567890
        actual: bytes = cstypes.uint64.unpack(input_bytes)
        self.assertEqual(actual, expected)

    def test_float_pack(self) -> None:
        input_value: builtins.float = 1.5
        expected: bytes = b'\x00\x00\xc0\x3f'
        actual: bytes = cstypes.float.pack(input_value)
        self.assertEqual(actual, expected)

    def test_float_unpack(self) -> None:
        input_bytes: bytes = b'\x00\x00\xc0\x3f'
        expected: builtins.float = 1.5
        actual: bytes = cstypes.float.unpack(input_bytes)
        self.assertEqual(actual, expected)

    def test_double_pack(self) -> None:
        input_value: builtins.float = 1.0000005
        expected: bytes = b'\x06\xbd\x37\x86\x00\x00\xf0\x3f'
        actual: bytes = cstypes.double.pack(input_value)
        self.assertEqual(actual, expected)

    def test_double_unpack(self) -> None:
        input_bytes: bytes = b'\x06\xbd\x37\x86\x00\x00\xf0\x3f'
        expected: builtins.float = 1.0000005
        actual: bytes = cstypes.double.unpack(input_bytes)
        self.assertEqual(actual, expected)

    def test_bool_pack(self) -> None:
        input_value: builtins.bool = True
        expected: bytes = b'\x01'
        actual: bytes = cstypes.bool.pack(input_value)
        self.assertEqual(actual, expected)

    def test_bool_unpack(self) -> None:
        input_bytes: bytes = b'\x01'
        expected: builtins.bool = True
        actual: bytes = cstypes.bool.unpack(input_bytes)
        self.assertEqual(actual, expected)


if __name__ == '__main__':
    import unittest
    unittest.main()
