import VASSAL.build
import VASSAL.build.module
import VASSAL.build.module.documentation
import VASSAL.build.module.properties
import VASSAL.configure
import VASSAL.counters
import VASSAL.i18n
import VASSAL.script.expression
import VASSAL.script.proxy
import VASSAL.tools
import bsh
import java.awt
import java.lang
import java.util
import javax.swing
import typing



class AbstractInterpreter(bsh.Interpreter):
    def __init__(self): ...
    def alert(self, string: str) -> typing.Any: ...
    def findMap(self, string: str) -> VASSAL.script.proxy.Map: ...
    def getModuleProperty(self, string: str) -> typing.Any: ...
    def globalHotKey(self, keyStroke: javax.swing.KeyStroke) -> None: ...
    def setModuleProperty(self, string: str, string2: str) -> None: ...

class AbstractScript(VASSAL.build.AbstractConfigurable):
    NAME: typing.ClassVar[str] = ...
    DESC: typing.ClassVar[str] = ...
    SCRIPT: typing.ClassVar[str] = ...
    def __init__(self): ...
    def compile(self) -> 'CompileResult': ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getDescription(self) -> str: ...
    def getI18nData(self) -> VASSAL.i18n.ComponentI18nData: ...
    def getScript(self) -> str: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setDescription(self, string: str) -> None: ...
    def setScript(self, string: str) -> None: ...

class BshCommandEncoder(VASSAL.build.module.BasicCommandEncoder):
    def __init__(self): ...
    def createDecorator(self, string: str, gamePiece: VASSAL.counters.GamePiece) -> VASSAL.counters.Decorator: ...

class BshPlugin(VASSAL.build.module.Plugin):
    def __init__(self): ...
    def init(self) -> None: ...

class CompileResult:
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, evalError: bsh.EvalError): ...
    def getMessage(self) -> str: ...
    def isSuccess(self) -> bool: ...
    def printStackTrace(self) -> None: ...

class JavaNameConfigurer(VASSAL.configure.Configurer):
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str): ...
    def getControls(self) -> java.awt.Component: ...
    def getValueString(self) -> str: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...

class ScriptContainer(VASSAL.build.AbstractConfigurable):
    def __init__(self): ...
    def add(self, buildable: VASSAL.build.Buildable) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getConfigurer(self) -> VASSAL.configure.Configurer: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.ComponentI18nData: ...
    @staticmethod
    def getInstance() -> 'ScriptContainer': ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...

class ActionScript(AbstractScript, VASSAL.tools.UniqueIdManager.Identifyable, VASSAL.configure.ValidityChecker):
    def __init__(self): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def compile(self) -> CompileResult: ...
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getConfigurer(self) -> VASSAL.configure.Configurer: ...
    def getFullScript(self) -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getId(self) -> str: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setId(self, string: str) -> None: ...
    def validate(self, buildable: VASSAL.build.Buildable, validationReport: VASSAL.configure.ValidationReport) -> None: ...

class ExpressionInterpreter(AbstractInterpreter, VASSAL.tools.RecursionLimiter.Loopable):
    def __init__(self, string: str): ...
    @typing.overload
    def count(self, object: typing.Any, object2: typing.Any) -> typing.Any: ...
    @typing.overload
    def count(self, object: typing.Any, object2: typing.Any, object3: typing.Any) -> typing.Any: ...
    def countStack(self, string: str, propertySource: VASSAL.build.module.properties.PropertySource) -> typing.Any: ...
    @typing.overload
    def evaluate(self) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, boolean: bool) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, boolean: bool, auditable: VASSAL.script.expression.Auditable, auditTrail: VASSAL.script.expression.AuditTrail) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, map: typing.Union[java.util.Map[str, str], typing.Mapping[str, str]], boolean: bool, auditable: VASSAL.script.expression.Auditable, auditTrail: VASSAL.script.expression.AuditTrail) -> str: ...
    def getComponentName(self) -> str: ...
    def getComponentTypeName(self) -> str: ...
    def getExpression(self) -> str: ...
    def getLocalizedProperty(self, string: str) -> typing.Any: ...
    def getMapProperty(self, string: str, string2: str) -> typing.Any: ...
    def getProperty(self, string: str) -> typing.Any: ...
    @typing.overload
    def getZoneProperty(self, string: str, string2: str) -> typing.Any: ...
    @typing.overload
    def getZoneProperty(self, string: str, string2: str, string3: str) -> typing.Any: ...
    def isRandom(self, object: typing.Any, object2: typing.Any) -> typing.Any: ...
    def random(self, object: typing.Any, object2: typing.Any, object3: typing.Any) -> typing.Any: ...
    @typing.overload
    def sum(self, object: typing.Any, object2: typing.Any, object3: typing.Any) -> typing.Any: ...
    @typing.overload
    def sum(self, object: typing.Any, object2: typing.Any, object3: typing.Any, object4: typing.Any) -> typing.Any: ...
    def sumLocation(self, string: str, propertySource: VASSAL.build.module.properties.PropertySource) -> typing.Any: ...
    def sumStack(self, string: str, propertySource: VASSAL.build.module.properties.PropertySource) -> typing.Any: ...
    def wrap(self, string: str) -> typing.Any: ...

class GeneralScript(AbstractScript, VASSAL.tools.UniqueIdManager.Identifyable, VASSAL.configure.ValidityChecker):
    def __init__(self): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def compile(self) -> CompileResult: ...
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getConfigurer(self) -> VASSAL.configure.Configurer: ...
    def getFullScript(self) -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getId(self) -> str: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setId(self, string: str) -> None: ...
    def validate(self, buildable: VASSAL.build.Buildable, validationReport: VASSAL.configure.ValidationReport) -> None: ...

class ScriptInterpreter(AbstractInterpreter):
    def __init__(self, classLoader: java.lang.ClassLoader): ...
    @typing.overload
    def evaluate(self, string: str) -> typing.Any: ...
    @typing.overload
    def evaluate(self, string: str, propertySource: VASSAL.build.module.properties.PropertySource) -> typing.Any: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("VASSAL.script")``.

    AbstractInterpreter: typing.Type[AbstractInterpreter]
    AbstractScript: typing.Type[AbstractScript]
    ActionScript: typing.Type[ActionScript]
    BshCommandEncoder: typing.Type[BshCommandEncoder]
    BshPlugin: typing.Type[BshPlugin]
    CompileResult: typing.Type[CompileResult]
    ExpressionInterpreter: typing.Type[ExpressionInterpreter]
    GeneralScript: typing.Type[GeneralScript]
    JavaNameConfigurer: typing.Type[JavaNameConfigurer]
    ScriptContainer: typing.Type[ScriptContainer]
    ScriptInterpreter: typing.Type[ScriptInterpreter]
    expression: VASSAL.script.expression.__module_protocol__
    proxy: VASSAL.script.proxy.__module_protocol__
