import VASSAL.command
import java.util
import typing



class PersistentPropertyContainer:
    def getPersistentProperty(self, object: typing.Any) -> typing.Any: ...
    def setPersistentProperty(self, object: typing.Any, object2: typing.Any) -> VASSAL.command.Command: ...

_Property__T = typing.TypeVar('_Property__T')  # <T>
class Property(typing.Generic[_Property__T]):
    name: str = ...
    type: typing.Type = ...
    def_: typing.Any = ...
    @typing.overload
    def __init__(self, string: str, class_: typing.Type[_Property__T]): ...
    @typing.overload
    def __init__(self, string: str, class_: typing.Type[_Property__T], t: _Property__T): ...
    def equals(self, object: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...

class PropertyContainer:
    _addPropertyListener_0__T = typing.TypeVar('_addPropertyListener_0__T')  # <T>
    @typing.overload
    def addPropertyListener(self, property: Property[_addPropertyListener_0__T], propertyListener: 'PropertyListener'[_addPropertyListener_0__T]) -> None: ...
    @typing.overload
    def addPropertyListener(self, propertyListener: 'PropertyListener'[typing.Any]) -> None: ...
    def getProperties(self) -> java.util.Set[Property[typing.Any]]: ...
    _getPropertyListeners_1__T = typing.TypeVar('_getPropertyListeners_1__T')  # <T>
    @typing.overload
    def getPropertyListeners(self) -> java.util.List['PropertyListener'[typing.Any]]: ...
    @typing.overload
    def getPropertyListeners(self, property: Property[_getPropertyListeners_1__T]) -> java.util.List['PropertyListener'[_getPropertyListeners_1__T]]: ...
    _getValue__T = typing.TypeVar('_getValue__T')  # <T>
    def getValue(self, property: Property[_getValue__T]) -> _getValue__T: ...
    _hasListeners_1__T = typing.TypeVar('_hasListeners_1__T')  # <T>
    @typing.overload
    def hasListeners(self) -> bool: ...
    @typing.overload
    def hasListeners(self, property: Property[_hasListeners_1__T]) -> bool: ...
    _removePropertyListener_0__T = typing.TypeVar('_removePropertyListener_0__T')  # <T>
    @typing.overload
    def removePropertyListener(self, property: Property[_removePropertyListener_0__T], propertyListener: 'PropertyListener'[_removePropertyListener_0__T]) -> None: ...
    @typing.overload
    def removePropertyListener(self, propertyListener: 'PropertyListener'[typing.Any]) -> None: ...
    _setValue__T = typing.TypeVar('_setValue__T')  # <T>
    def setValue(self, property: Property[_setValue__T], t: _setValue__T) -> None: ...

_PropertyListener__T = typing.TypeVar('_PropertyListener__T')  # <T>
class PropertyListener(typing.Generic[_PropertyListener__T]):
    _propertyChanged__U = typing.TypeVar('_propertyChanged__U')  # <U>
    def propertyChanged(self, object: typing.Any, property: Property[_propertyChanged__U], u: _propertyChanged__U, u2: _propertyChanged__U) -> None: ...

class PropertySupport:
    _addPropertyListener_0__T = typing.TypeVar('_addPropertyListener_0__T')  # <T>
    @typing.overload
    def addPropertyListener(self, property: Property[_addPropertyListener_0__T], propertyListener: PropertyListener[_addPropertyListener_0__T]) -> None: ...
    @typing.overload
    def addPropertyListener(self, propertyListener: PropertyListener[typing.Any]) -> None: ...
    _fireChanged__T = typing.TypeVar('_fireChanged__T')  # <T>
    def fireChanged(self, object: typing.Any, property: Property[_fireChanged__T], t: _fireChanged__T, t2: _fireChanged__T) -> None: ...
    _getPropertyListeners_1__T = typing.TypeVar('_getPropertyListeners_1__T')  # <T>
    @typing.overload
    def getPropertyListeners(self) -> java.util.List[PropertyListener[typing.Any]]: ...
    @typing.overload
    def getPropertyListeners(self, property: Property[_getPropertyListeners_1__T]) -> java.util.List[PropertyListener[_getPropertyListeners_1__T]]: ...
    _hasListeners_1__T = typing.TypeVar('_hasListeners_1__T')  # <T>
    @typing.overload
    def hasListeners(self) -> bool: ...
    @typing.overload
    def hasListeners(self, property: Property[_hasListeners_1__T]) -> bool: ...
    _removePropertyListener_0__T = typing.TypeVar('_removePropertyListener_0__T')  # <T>
    @typing.overload
    def removePropertyListener(self, property: Property[_removePropertyListener_0__T], propertyListener: PropertyListener[_removePropertyListener_0__T]) -> None: ...
    @typing.overload
    def removePropertyListener(self, propertyListener: PropertyListener[typing.Any]) -> None: ...

class AbstractPropertyContainer(PropertyContainer):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, propertySupport: PropertySupport): ...
    _addPropertyListener_0__T = typing.TypeVar('_addPropertyListener_0__T')  # <T>
    @typing.overload
    def addPropertyListener(self, property: Property[_addPropertyListener_0__T], propertyListener: PropertyListener[_addPropertyListener_0__T]) -> None: ...
    @typing.overload
    def addPropertyListener(self, propertyListener: PropertyListener[typing.Any]) -> None: ...
    _getPropertyListeners_1__T = typing.TypeVar('_getPropertyListeners_1__T')  # <T>
    @typing.overload
    def getPropertyListeners(self) -> java.util.List[PropertyListener[typing.Any]]: ...
    @typing.overload
    def getPropertyListeners(self, property: Property[_getPropertyListeners_1__T]) -> java.util.List[PropertyListener[_getPropertyListeners_1__T]]: ...
    _hasListeners_1__T = typing.TypeVar('_hasListeners_1__T')  # <T>
    @typing.overload
    def hasListeners(self) -> bool: ...
    @typing.overload
    def hasListeners(self, property: Property[_hasListeners_1__T]) -> bool: ...
    _removePropertyListener_0__T = typing.TypeVar('_removePropertyListener_0__T')  # <T>
    @typing.overload
    def removePropertyListener(self, property: Property[_removePropertyListener_0__T], propertyListener: PropertyListener[_removePropertyListener_0__T]) -> None: ...
    @typing.overload
    def removePropertyListener(self, propertyListener: PropertyListener[typing.Any]) -> None: ...

class ConcurrentPropertySupport(PropertySupport):
    def __init__(self): ...
    _addPropertyListener_0__T = typing.TypeVar('_addPropertyListener_0__T')  # <T>
    @typing.overload
    def addPropertyListener(self, property: Property[_addPropertyListener_0__T], propertyListener: PropertyListener[_addPropertyListener_0__T]) -> None: ...
    @typing.overload
    def addPropertyListener(self, propertyListener: PropertyListener[typing.Any]) -> None: ...
    _fireChanged__T = typing.TypeVar('_fireChanged__T')  # <T>
    def fireChanged(self, object: typing.Any, property: Property[_fireChanged__T], t: _fireChanged__T, t2: _fireChanged__T) -> None: ...
    _getPropertyListeners_1__T = typing.TypeVar('_getPropertyListeners_1__T')  # <T>
    @typing.overload
    def getPropertyListeners(self) -> java.util.List[PropertyListener[typing.Any]]: ...
    @typing.overload
    def getPropertyListeners(self, property: Property[_getPropertyListeners_1__T]) -> java.util.List[PropertyListener[_getPropertyListeners_1__T]]: ...
    _hasListeners_1__T = typing.TypeVar('_hasListeners_1__T')  # <T>
    @typing.overload
    def hasListeners(self) -> bool: ...
    @typing.overload
    def hasListeners(self, property: Property[_hasListeners_1__T]) -> bool: ...
    _removePropertyListener_0__T = typing.TypeVar('_removePropertyListener_0__T')  # <T>
    @typing.overload
    def removePropertyListener(self, property: Property[_removePropertyListener_0__T], propertyListener: PropertyListener[_removePropertyListener_0__T]) -> None: ...
    @typing.overload
    def removePropertyListener(self, propertyListener: PropertyListener[typing.Any]) -> None: ...

_SinglePropertyContainer__V = typing.TypeVar('_SinglePropertyContainer__V')  # <V>
class SinglePropertyContainer(PropertyContainer, typing.Generic[_SinglePropertyContainer__V]):
    def __init__(self, property: Property[_SinglePropertyContainer__V], v: _SinglePropertyContainer__V): ...
    _addPropertyListener_0__T = typing.TypeVar('_addPropertyListener_0__T')  # <T>
    @typing.overload
    def addPropertyListener(self, property: Property[_addPropertyListener_0__T], propertyListener: PropertyListener[_addPropertyListener_0__T]) -> None: ...
    @typing.overload
    def addPropertyListener(self, propertyListener: PropertyListener[typing.Any]) -> None: ...
    def getProperties(self) -> java.util.Set[Property[typing.Any]]: ...
    _getPropertyListeners_1__T = typing.TypeVar('_getPropertyListeners_1__T')  # <T>
    @typing.overload
    def getPropertyListeners(self) -> java.util.List[PropertyListener[typing.Any]]: ...
    @typing.overload
    def getPropertyListeners(self, property: Property[_getPropertyListeners_1__T]) -> java.util.List[PropertyListener[_getPropertyListeners_1__T]]: ...
    _getValue__T = typing.TypeVar('_getValue__T')  # <T>
    def getValue(self, property: Property[_getValue__T]) -> _getValue__T: ...
    _hasListeners_1__T = typing.TypeVar('_hasListeners_1__T')  # <T>
    @typing.overload
    def hasListeners(self) -> bool: ...
    @typing.overload
    def hasListeners(self, property: Property[_hasListeners_1__T]) -> bool: ...
    _removePropertyListener_0__T = typing.TypeVar('_removePropertyListener_0__T')  # <T>
    @typing.overload
    def removePropertyListener(self, property: Property[_removePropertyListener_0__T], propertyListener: PropertyListener[_removePropertyListener_0__T]) -> None: ...
    @typing.overload
    def removePropertyListener(self, propertyListener: PropertyListener[typing.Any]) -> None: ...
    _setValue__T = typing.TypeVar('_setValue__T')  # <T>
    def setValue(self, property: Property[_setValue__T], t: _setValue__T) -> None: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("VASSAL.property")``.

    AbstractPropertyContainer: typing.Type[AbstractPropertyContainer]
    ConcurrentPropertySupport: typing.Type[ConcurrentPropertySupport]
    PersistentPropertyContainer: typing.Type[PersistentPropertyContainer]
    Property: typing.Type[Property]
    PropertyContainer: typing.Type[PropertyContainer]
    PropertyListener: typing.Type[PropertyListener]
    PropertySupport: typing.Type[PropertySupport]
    SinglePropertyContainer: typing.Type[SinglePropertyContainer]
