import VASSAL.build
import VASSAL.build.module
import VASSAL.configure
import VASSAL.tools
import VASSAL.tools.menu
import VASSAL.tools.version
import java.awt
import java.awt.event
import java.io
import java.lang
import java.net
import java.nio.channels
import java.nio.file
import java.util
import java.util.function
import javax.swing
import javax.swing.plaf
import jpype.protocol
import typing



class AboutVASSALAction(javax.swing.AbstractAction):
    def __init__(self, window: java.awt.Window): ...
    def actionPerformed(self, actionEvent: java.awt.event.ActionEvent) -> None: ...

class AbstractLaunchAction(javax.swing.AbstractAction):
    def __init__(self, string: str, window: java.awt.Window, string2: str, launchRequest: 'LaunchRequest'): ...
    def actionPerformed(self, actionEvent: java.awt.event.ActionEvent) -> None: ...
    @staticmethod
    def isEditing(file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> bool: ...
    @staticmethod
    def isInUse(file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> bool: ...

class BasicModule(VASSAL.build.GameModule):
    def __init__(self, dataArchive: VASSAL.tools.DataArchive): ...

class Config:
    def getBaseDir(self) -> java.nio.file.Path: ...
    def getCacheDir(self) -> java.nio.file.Path: ...
    def getConfDir(self) -> java.nio.file.Path: ...
    def getDocDir(self) -> java.nio.file.Path: ...
    def getErrorLogPath(self) -> java.nio.file.Path: ...
    def getJavaBinPath(self) -> java.nio.file.Path: ...
    def getPrefsDir(self) -> java.nio.file.Path: ...
    def getReportableVersion(self) -> str: ...
    def getTempDir(self) -> java.nio.file.Path: ...
    def getVersion(self) -> str: ...

class CustomVmOptions:
    def __init__(self): ...
    def ensureCustomVmOptionsFileExistsInConfDir(self) -> None: ...
    def getCustomVmOptions(self) -> java.util.List[str]: ...

class EditorWindow(javax.swing.JFrame):
    def getEditorType(self) -> str: ...
    def treeStateChanged(self, boolean: bool) -> None: ...

class ExceptionHandler(java.lang.Thread.UncaughtExceptionHandler):
    def __init__(self): ...
    def handle(self, throwable: java.lang.Throwable) -> None: ...
    def uncaughtException(self, thread: java.lang.Thread, throwable: java.lang.Throwable) -> None: ...

class FirstTimeDialog(javax.swing.JDialog):
    def __init__(self, frame: java.awt.Frame): ...

class GameModuleAction(javax.swing.AbstractAction):
    def __init__(self, string: str, component: java.awt.Component): ...
    def actionPerformed(self, actionEvent: java.awt.event.ActionEvent) -> None: ...
    def addAction(self, runnable: typing.Union[java.lang.Runnable, typing.Callable]) -> None: ...

class JavaVersionChecker:
    def __init__(self): ...
    @staticmethod
    def main(stringArray: typing.List[str]) -> None: ...

class LaunchRequest(java.io.Serializable):
    mode: 'LaunchRequest.Mode' = ...
    module: java.io.File = ...
    game: java.io.File = ...
    extension: java.io.File = ...
    importFile: java.io.File = ...
    builtInModule: bool = ...
    autoext: java.util.List = ...
    key: int = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, mode: 'LaunchRequest.Mode'): ...
    @typing.overload
    def __init__(self, mode: 'LaunchRequest.Mode', file: typing.Union[java.io.File, jpype.protocol.SupportsPath]): ...
    @typing.overload
    def __init__(self, mode: 'LaunchRequest.Mode', file: typing.Union[java.io.File, jpype.protocol.SupportsPath], file2: typing.Union[java.io.File, jpype.protocol.SupportsPath]): ...
    @typing.overload
    def __init__(self, launchRequest: 'LaunchRequest'): ...
    @staticmethod
    def parseArgs(stringArray: typing.List[str]) -> 'LaunchRequest': ...
    def toArgs(self) -> typing.List[str]: ...
    class Mode: ...

class LaunchRequestException(java.lang.Exception):
    def __init__(self, string: str, *string2: str): ...

class LaunchRequestHandler(java.lang.Runnable):
    def __init__(self, launchRequest: LaunchRequest): ...
    def getResult(self) -> str: ...
    def run(self) -> None: ...

class Launcher:
    @staticmethod
    def getInstance() -> 'Launcher': ...

class ModuleManager:
    MAXIMUM_HEAP: typing.ClassVar[str] = ...
    INITIAL_HEAP: typing.ClassVar[str] = ...
    def __init__(self, serverSocket: java.net.ServerSocket, long: int, fileChannel: java.nio.channels.FileChannel, fileLock: java.nio.channels.FileLock): ...
    @staticmethod
    def getInstance() -> 'ModuleManager': ...
    @staticmethod
    def main(stringArray: typing.List[str]) -> None: ...
    def shutDown(self) -> None: ...

class ModuleManagerMenuManager(VASSAL.tools.menu.MenuManager):
    def __init__(self): ...
    def getMenuBarFor(self, jFrame: javax.swing.JFrame) -> javax.swing.JMenuBar: ...
    def getMenuBarProxyFor(self, jFrame: javax.swing.JFrame) -> VASSAL.tools.menu.MenuBarProxy: ...

class ModuleManagerSocketListener(java.lang.Runnable):
    def __init__(self, serverSocket: java.net.ServerSocket, function: typing.Union[java.util.function.Function[typing.Any, str], typing.Callable[[typing.Any], str]]): ...
    def run(self) -> None: ...

class ModuleManagerUpdateHelper:
    @staticmethod
    def sendExtensionUpdate(file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> None: ...
    @staticmethod
    def sendGameUpdate(file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> None: ...
    @staticmethod
    def sendModuleUpdate(file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> None: ...

class PlayerWindow(javax.swing.JFrame):
    def __init__(self): ...
    def addChatter(self, chatter: VASSAL.build.module.Chatter) -> None: ...
    def getControlPanel(self) -> javax.swing.JPanel: ...
    def getToolBar(self) -> javax.swing.JToolBar: ...

class SaveModuleAction(VASSAL.configure.SaveAction):
    def __init__(self): ...
    def actionPerformed(self, actionEvent: java.awt.event.ActionEvent) -> None: ...

class SaveModuleAsAction(VASSAL.configure.SaveAsAction):
    def __init__(self): ...
    def actionPerformed(self, actionEvent: java.awt.event.ActionEvent) -> None: ...

class ShutDownAction(javax.swing.AbstractAction):
    def __init__(self): ...
    def actionPerformed(self, actionEvent: java.awt.event.ActionEvent) -> None: ...

class StartUp:
    def __init__(self): ...
    def initSystemProperties(self) -> None: ...
    def setUIFont(self, fontUIResource: javax.swing.plaf.FontUIResource, fontUIResource2: javax.swing.plaf.FontUIResource, fontUIResource3: javax.swing.plaf.FontUIResource, fontUIResource4: javax.swing.plaf.FontUIResource) -> None: ...
    def startErrorLog(self) -> None: ...

class TilingHandler:
    @typing.overload
    def __init__(self, string: str, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], dimension: java.awt.Dimension, int: int): ...
    @typing.overload
    def __init__(self, string: str, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], dimension: java.awt.Dimension, int: int, int2: int): ...
    def sliceTiles(self) -> None: ...

class UpdateCheckRequest(VASSAL.tools.version.AbstractUpdateCheckRequest):
    def __init__(self): ...

class CreateModuleAction(GameModuleAction):
    def __init__(self, component: java.awt.Component): ...
    def performAction(self, actionEvent: java.awt.event.ActionEvent) -> None: ...

class DummyConfig(Config):
    def __init__(self): ...
    def getBaseDir(self) -> java.nio.file.Path: ...
    def getCacheDir(self) -> java.nio.file.Path: ...
    def getConfDir(self) -> java.nio.file.Path: ...
    def getDocDir(self) -> java.nio.file.Path: ...
    def getErrorLogPath(self) -> java.nio.file.Path: ...
    def getJavaBinPath(self) -> java.nio.file.Path: ...
    def getPrefsDir(self) -> java.nio.file.Path: ...
    def getReportableVersion(self) -> str: ...
    def getTempDir(self) -> java.nio.file.Path: ...
    def getVersion(self) -> str: ...

class ExtensionEditorWindow(EditorWindow):
    def __init__(self, gameModule: VASSAL.build.GameModule, moduleExtension: VASSAL.build.module.ModuleExtension): ...
    def getEditorType(self) -> str: ...
    def getExtension(self) -> VASSAL.build.module.ModuleExtension: ...
    def moduleLoading(self, gameModule: VASSAL.build.GameModule) -> None: ...
    def updateWindowTitle(self) -> None: ...

class LaunchTourAction(AbstractLaunchAction):
    def __init__(self, window: java.awt.Window): ...

class LoadModuleAction(GameModuleAction):
    @typing.overload
    def __init__(self, component: java.awt.Component): ...
    @typing.overload
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]): ...
    def performAction(self, actionEvent: java.awt.event.ActionEvent) -> None: ...

class MacOSXStartUp(StartUp):
    def __init__(self): ...

class ModuleEditorWindow(EditorWindow):
    def __init__(self, gameModule: VASSAL.build.GameModule): ...
    def getEditorType(self) -> str: ...
    def updateWindowTitle(self) -> None: ...

class NewExtensionAction(GameModuleAction):
    def __init__(self, component: java.awt.Component): ...
    def performAction(self, actionEvent: java.awt.event.ActionEvent) -> None: ...

class StandardConfig(Config):
    def __init__(self): ...
    def getBaseDir(self) -> java.nio.file.Path: ...
    def getCacheDir(self) -> java.nio.file.Path: ...
    def getConfDir(self) -> java.nio.file.Path: ...
    def getDocDir(self) -> java.nio.file.Path: ...
    def getErrorLogPath(self) -> java.nio.file.Path: ...
    def getJavaBinPath(self) -> java.nio.file.Path: ...
    def getPrefsDir(self) -> java.nio.file.Path: ...
    def getReportableVersion(self) -> str: ...
    def getTempDir(self) -> java.nio.file.Path: ...
    def getVersion(self) -> str: ...

class EditExtensionAction(LoadModuleAction):
    @typing.overload
    def __init__(self, component: java.awt.Component): ...
    @typing.overload
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]): ...

class EditModuleAction(LoadModuleAction):
    @typing.overload
    def __init__(self, component: java.awt.Component): ...
    @typing.overload
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]): ...

class ModuleManagerMacOSXStartUp(MacOSXStartUp):
    def __init__(self): ...
    def initSystemProperties(self) -> None: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("VASSAL.launch")``.

    AboutVASSALAction: typing.Type[AboutVASSALAction]
    AbstractLaunchAction: typing.Type[AbstractLaunchAction]
    BasicModule: typing.Type[BasicModule]
    Config: typing.Type[Config]
    CreateModuleAction: typing.Type[CreateModuleAction]
    CustomVmOptions: typing.Type[CustomVmOptions]
    DummyConfig: typing.Type[DummyConfig]
    EditExtensionAction: typing.Type[EditExtensionAction]
    EditModuleAction: typing.Type[EditModuleAction]
    EditorWindow: typing.Type[EditorWindow]
    ExceptionHandler: typing.Type[ExceptionHandler]
    ExtensionEditorWindow: typing.Type[ExtensionEditorWindow]
    FirstTimeDialog: typing.Type[FirstTimeDialog]
    GameModuleAction: typing.Type[GameModuleAction]
    JavaVersionChecker: typing.Type[JavaVersionChecker]
    LaunchRequest: typing.Type[LaunchRequest]
    LaunchRequestException: typing.Type[LaunchRequestException]
    LaunchRequestHandler: typing.Type[LaunchRequestHandler]
    LaunchTourAction: typing.Type[LaunchTourAction]
    Launcher: typing.Type[Launcher]
    LoadModuleAction: typing.Type[LoadModuleAction]
    MacOSXStartUp: typing.Type[MacOSXStartUp]
    ModuleEditorWindow: typing.Type[ModuleEditorWindow]
    ModuleManager: typing.Type[ModuleManager]
    ModuleManagerMacOSXStartUp: typing.Type[ModuleManagerMacOSXStartUp]
    ModuleManagerMenuManager: typing.Type[ModuleManagerMenuManager]
    ModuleManagerSocketListener: typing.Type[ModuleManagerSocketListener]
    ModuleManagerUpdateHelper: typing.Type[ModuleManagerUpdateHelper]
    NewExtensionAction: typing.Type[NewExtensionAction]
    PlayerWindow: typing.Type[PlayerWindow]
    SaveModuleAction: typing.Type[SaveModuleAction]
    SaveModuleAsAction: typing.Type[SaveModuleAsAction]
    ShutDownAction: typing.Type[ShutDownAction]
    StandardConfig: typing.Type[StandardConfig]
    StartUp: typing.Type[StartUp]
    TilingHandler: typing.Type[TilingHandler]
    UpdateCheckRequest: typing.Type[UpdateCheckRequest]
