import VASSAL
import VASSAL.build
import VASSAL.build.module
import VASSAL.build.module.documentation
import VASSAL.build.module.map
import VASSAL.build.module.map.deck
import VASSAL.build.module.properties
import VASSAL.command
import VASSAL.configure
import VASSAL.i18n
import VASSAL.property
import VASSAL.script.expression
import VASSAL.search
import VASSAL.tools
import java.awt
import java.awt.event
import java.awt.geom
import java.io
import java.lang
import java.util
import java.util.function
import javax.swing
import javax.swing.event
import jpype.protocol
import typing



class AreaCache:
    def __init__(self): ...
    @staticmethod
    def get(shape: java.awt.Shape) -> java.awt.geom.Area: ...

class BoundsTracker:
    def __init__(self): ...
    def addPiece(self, gamePiece: 'GamePiece') -> None: ...
    def clear(self) -> None: ...
    def repaint(self) -> None: ...

class CounterNames:
    def nameOf(self, string: str) -> str: ...

class DragBuffer:
    def add(self, gamePiece: 'GamePiece') -> None: ...
    def addDragSource(self, component: java.awt.Component) -> None: ...
    def addDropTarget(self, component: java.awt.Component, mouseListener: java.awt.event.MouseListener) -> None: ...
    def asList(self) -> java.util.List['GamePiece']: ...
    def clear(self) -> None: ...
    def contains(self, gamePiece: 'GamePiece') -> bool: ...
    def containsAllMembers(self, stack: 'Stack') -> bool: ...
    def contents(self) -> str: ...
    def createDragCursor(self, component: java.awt.Component) -> java.awt.Cursor: ...
    @staticmethod
    def getBuffer() -> 'DragBuffer': ...
    def getFromMap(self) -> VASSAL.build.module.Map: ...
    def getIterator(self) -> 'PieceIterator': ...
    def isEmpty(self) -> bool: ...
    @staticmethod
    def main(stringArray: typing.List[str]) -> None: ...
    def remove(self, gamePiece: 'GamePiece') -> None: ...
    def sort(self, comparator: typing.Union[java.util.Comparator['GamePiece'], typing.Callable[['GamePiece', 'GamePiece'], int]]) -> None: ...

class EventFilter:
    def rejectEvent(self, inputEvent: java.awt.event.InputEvent) -> bool: ...

class GamePiece(VASSAL.build.module.properties.PropertySource):
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getId(self) -> str: ...
    def getLocalizedName(self) -> str: ...
    def getMap(self) -> VASSAL.build.module.Map: ...
    def getName(self) -> str: ...
    def getParent(self) -> 'Stack': ...
    def getPosition(self) -> java.awt.Point: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getShape(self) -> java.awt.Shape: ...
    def getState(self) -> str: ...
    def getType(self) -> str: ...
    def keyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def setId(self, string: str) -> None: ...
    def setMap(self, map: VASSAL.build.module.Map) -> None: ...
    def setParent(self, stack: 'Stack') -> None: ...
    def setPosition(self, point: java.awt.Point) -> None: ...
    def setProperty(self, object: typing.Any, object2: typing.Any) -> None: ...
    def setState(self, string: str) -> None: ...

class GlobalCommand(VASSAL.script.expression.Auditable):
    @typing.overload
    def __init__(self, loopable: VASSAL.tools.RecursionLimiter.Loopable): ...
    @typing.overload
    def __init__(self, loopable: VASSAL.tools.RecursionLimiter.Loopable, propertySource: VASSAL.build.module.properties.PropertySource): ...
    @typing.overload
    def apply(self, map: VASSAL.build.module.Map, pieceFilter: typing.Union['PieceFilter', typing.Callable]) -> VASSAL.command.Command: ...
    @typing.overload
    def apply(self, map: VASSAL.build.module.Map, pieceFilter: typing.Union['PieceFilter', typing.Callable], globalCommandTarget: 'GlobalCommandTarget') -> VASSAL.command.Command: ...
    @typing.overload
    def apply(self, map: VASSAL.build.module.Map, pieceFilter: typing.Union['PieceFilter', typing.Callable], globalCommandTarget: 'GlobalCommandTarget', auditTrail: VASSAL.script.expression.AuditTrail) -> VASSAL.command.Command: ...
    @typing.overload
    def apply(self, mapArray: typing.List[VASSAL.build.module.Map], pieceFilter: typing.Union['PieceFilter', typing.Callable]) -> VASSAL.command.Command: ...
    @typing.overload
    def apply(self, mapArray: typing.List[VASSAL.build.module.Map], pieceFilter: typing.Union['PieceFilter', typing.Callable], globalCommandTarget: 'GlobalCommandTarget') -> VASSAL.command.Command: ...
    @typing.overload
    def apply(self, mapArray: typing.List[VASSAL.build.module.Map], pieceFilter: typing.Union['PieceFilter', typing.Callable], globalCommandTarget: 'GlobalCommandTarget', auditTrail: VASSAL.script.expression.AuditTrail) -> VASSAL.command.Command: ...
    def equals(self, object: typing.Any) -> bool: ...
    def getComponentName(self) -> str: ...
    def getComponentTypeName(self) -> str: ...
    def getKeyStroke(self) -> javax.swing.KeyStroke: ...
    def getReportFormat(self) -> str: ...
    def getSelectFromDeck(self) -> int: ...
    def getTarget(self) -> 'GlobalCommandTarget': ...
    def hashCode(self) -> int: ...
    def isReportSingle(self) -> bool: ...
    @typing.overload
    def setKeyStroke(self, namedKeyStroke: VASSAL.tools.NamedKeyStroke) -> None: ...
    @typing.overload
    def setKeyStroke(self, keyStroke: javax.swing.KeyStroke) -> None: ...
    def setPropertySource(self, propertySource: VASSAL.build.module.properties.PropertySource) -> None: ...
    def setReportFormat(self, string: str) -> None: ...
    def setReportSingle(self, boolean: bool) -> None: ...
    def setSelectFromDeck(self, int: int) -> None: ...
    def setTarget(self, globalCommandTarget: 'GlobalCommandTarget') -> None: ...

class GlobalCommandTarget(VASSAL.configure.ConfigurerFactory, VASSAL.search.SearchTarget):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, gKCtype: 'GlobalCommandTarget.GKCtype'): ...
    @typing.overload
    def __init__(self, globalCommandTarget: 'GlobalCommandTarget'): ...
    @typing.overload
    def __init__(self, string: str): ...
    def decode(self, string: str) -> None: ...
    def encode(self) -> str: ...
    def equals(self, object: typing.Any) -> bool: ...
    def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    def getCurPiece(self) -> GamePiece: ...
    def getExpressionList(self) -> java.util.List[str]: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getGKCtype(self) -> 'GlobalCommandTarget.GKCtype': ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getPropertyList(self) -> java.util.List[str]: ...
    def getTargetBoard(self) -> VASSAL.script.expression.FormattedStringExpression: ...
    def getTargetCompare(self) -> 'GlobalCommandTarget.CompareMode': ...
    def getTargetDeck(self) -> VASSAL.script.expression.FormattedStringExpression: ...
    def getTargetLocation(self) -> VASSAL.script.expression.FormattedStringExpression: ...
    def getTargetMap(self) -> VASSAL.script.expression.FormattedStringExpression: ...
    def getTargetProperty(self) -> VASSAL.script.expression.FormattedStringExpression: ...
    def getTargetType(self) -> 'GlobalCommandTarget.Target': ...
    def getTargetValue(self) -> VASSAL.script.expression.FormattedStringExpression: ...
    def getTargetX(self) -> VASSAL.script.expression.Expression: ...
    def getTargetY(self) -> VASSAL.script.expression.Expression: ...
    def getTargetZone(self) -> VASSAL.script.expression.FormattedStringExpression: ...
    def isFastMatchLocation(self) -> bool: ...
    def isFastMatchProperty(self) -> bool: ...
    def setCurPiece(self, gamePiece: GamePiece) -> None: ...
    def setFastMatchLocation(self, boolean: bool) -> None: ...
    def setFastMatchProperty(self, boolean: bool) -> None: ...
    def setGKCtype(self, gKCtype: 'GlobalCommandTarget.GKCtype') -> None: ...
    @typing.overload
    def setTargetBoard(self, formattedStringExpression: VASSAL.script.expression.FormattedStringExpression) -> None: ...
    @typing.overload
    def setTargetBoard(self, string: str) -> None: ...
    @typing.overload
    def setTargetCompare(self, compareMode: 'GlobalCommandTarget.CompareMode') -> None: ...
    @typing.overload
    def setTargetCompare(self, string: str) -> None: ...
    @typing.overload
    def setTargetDeck(self, formattedStringExpression: VASSAL.script.expression.FormattedStringExpression) -> None: ...
    @typing.overload
    def setTargetDeck(self, string: str) -> None: ...
    @typing.overload
    def setTargetLocation(self, formattedStringExpression: VASSAL.script.expression.FormattedStringExpression) -> None: ...
    @typing.overload
    def setTargetLocation(self, string: str) -> None: ...
    @typing.overload
    def setTargetMap(self, formattedStringExpression: VASSAL.script.expression.FormattedStringExpression) -> None: ...
    @typing.overload
    def setTargetMap(self, string: str) -> None: ...
    @typing.overload
    def setTargetProperty(self, formattedStringExpression: VASSAL.script.expression.FormattedStringExpression) -> None: ...
    @typing.overload
    def setTargetProperty(self, string: str) -> None: ...
    @typing.overload
    def setTargetType(self, target: 'GlobalCommandTarget.Target') -> None: ...
    @typing.overload
    def setTargetType(self, string: str) -> None: ...
    @typing.overload
    def setTargetValue(self, formattedStringExpression: VASSAL.script.expression.FormattedStringExpression) -> None: ...
    @typing.overload
    def setTargetValue(self, string: str) -> None: ...
    @typing.overload
    def setTargetX(self, formattedStringExpression: VASSAL.script.expression.FormattedStringExpression) -> None: ...
    @typing.overload
    def setTargetX(self, int: int) -> None: ...
    @typing.overload
    def setTargetX(self, string: str) -> None: ...
    @typing.overload
    def setTargetY(self, formattedStringExpression: VASSAL.script.expression.FormattedStringExpression) -> None: ...
    @typing.overload
    def setTargetY(self, int: int) -> None: ...
    @typing.overload
    def setTargetY(self, string: str) -> None: ...
    @typing.overload
    def setTargetZone(self, formattedStringExpression: VASSAL.script.expression.FormattedStringExpression) -> None: ...
    @typing.overload
    def setTargetZone(self, string: str) -> None: ...
    class CompareMode(java.lang.Enum['GlobalCommandTarget.CompareMode']):
        EQUALS: typing.ClassVar['GlobalCommandTarget.CompareMode'] = ...
        NOT_EQUALS: typing.ClassVar['GlobalCommandTarget.CompareMode'] = ...
        GREATER: typing.ClassVar['GlobalCommandTarget.CompareMode'] = ...
        GREATER_EQUALS: typing.ClassVar['GlobalCommandTarget.CompareMode'] = ...
        LESS: typing.ClassVar['GlobalCommandTarget.CompareMode'] = ...
        LESS_EQUALS: typing.ClassVar['GlobalCommandTarget.CompareMode'] = ...
        MATCH: typing.ClassVar['GlobalCommandTarget.CompareMode'] = ...
        NOT_MATCH: typing.ClassVar['GlobalCommandTarget.CompareMode'] = ...
        def getSymbol(self) -> str: ...
        @staticmethod
        def getSymbols() -> typing.List[str]: ...
        _valueOf_1__T = typing.TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(string: str) -> 'GlobalCommandTarget.CompareMode': ...
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @staticmethod
        def values() -> typing.List['GlobalCommandTarget.CompareMode']: ...
        @staticmethod
        def whichSymbol(string: str) -> 'GlobalCommandTarget.CompareMode': ...
    class GKCtype(java.lang.Enum['GlobalCommandTarget.GKCtype']):
        COUNTER: typing.ClassVar['GlobalCommandTarget.GKCtype'] = ...
        MAP: typing.ClassVar['GlobalCommandTarget.GKCtype'] = ...
        MODULE: typing.ClassVar['GlobalCommandTarget.GKCtype'] = ...
        DECK: typing.ClassVar['GlobalCommandTarget.GKCtype'] = ...
        _valueOf_1__T = typing.TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(string: str) -> 'GlobalCommandTarget.GKCtype': ...
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @staticmethod
        def values() -> typing.List['GlobalCommandTarget.GKCtype']: ...
    class Target(java.lang.Enum['GlobalCommandTarget.Target']):
        CURSTACK: typing.ClassVar['GlobalCommandTarget.Target'] = ...
        CURMAP: typing.ClassVar['GlobalCommandTarget.Target'] = ...
        CURZONE: typing.ClassVar['GlobalCommandTarget.Target'] = ...
        CURLOC: typing.ClassVar['GlobalCommandTarget.Target'] = ...
        MAP: typing.ClassVar['GlobalCommandTarget.Target'] = ...
        ZONE: typing.ClassVar['GlobalCommandTarget.Target'] = ...
        LOCATION: typing.ClassVar['GlobalCommandTarget.Target'] = ...
        XY: typing.ClassVar['GlobalCommandTarget.Target'] = ...
        DECK: typing.ClassVar['GlobalCommandTarget.Target'] = ...
        CURMAT: typing.ClassVar['GlobalCommandTarget.Target'] = ...
        @staticmethod
        def getKeys() -> typing.List[str]: ...
        @staticmethod
        def geti18nKeys() -> typing.List[str]: ...
        def isCurrent(self) -> bool: ...
        def toTranslatedString(self) -> str: ...
        _valueOf_1__T = typing.TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(string: str) -> 'GlobalCommandTarget.Target': ...
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @staticmethod
        def values() -> typing.List['GlobalCommandTarget.Target']: ...

class Highlighter:
    def boundingBox(self, gamePiece: GamePiece) -> java.awt.Rectangle: ...
    def draw(self, gamePiece: GamePiece, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...

class ImagePicker(javax.swing.JPanel, java.awt.event.MouseListener, java.awt.event.ItemListener):
    def __init__(self): ...
    def getImageName(self) -> str: ...
    def itemStateChanged(self, itemEvent: java.awt.event.ItemEvent) -> None: ...
    def mouseClicked(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseEntered(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseExited(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mousePressed(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseReleased(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def pickImage(self) -> None: ...
    def setImageName(self, string: str) -> None: ...

class KeyBuffer:
    def add(self, gamePiece: GamePiece) -> None: ...
    def asList(self) -> java.util.List[GamePiece]: ...
    def clear(self) -> None: ...
    def contains(self, gamePiece: GamePiece) -> bool: ...
    def containsChild(self, stack: 'Stack') -> bool: ...
    @staticmethod
    def getBuffer() -> 'KeyBuffer': ...
    def getClickPoint(self) -> java.awt.Point: ...
    def getPieces(self) -> java.util.Enumeration[GamePiece]: ...
    def getPiecesIterator(self) -> java.util.Iterator[GamePiece]: ...
    @staticmethod
    def init(keyBuffer: 'KeyBuffer') -> None: ...
    def isEmpty(self) -> bool: ...
    def keyCommand(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def remove(self, gamePiece: GamePiece) -> None: ...
    def setClickPoint(self, point: java.awt.Point) -> None: ...
    def sort(self, comparator: typing.Union[java.util.Comparator[GamePiece], typing.Callable[[GamePiece, GamePiece], int]]) -> None: ...

class KeyCommand(javax.swing.AbstractAction):
    NONE: typing.ClassVar[typing.List['KeyCommand']] = ...
    @typing.overload
    def __init__(self, keyCommand: 'KeyCommand'): ...
    @typing.overload
    def __init__(self, string: str, namedKeyStroke: VASSAL.tools.NamedKeyStroke, gamePiece: GamePiece): ...
    @typing.overload
    def __init__(self, string: str, namedKeyStroke: VASSAL.tools.NamedKeyStroke, gamePiece: GamePiece, translatablePiece: VASSAL.i18n.TranslatablePiece): ...
    @typing.overload
    def __init__(self, string: str, namedKeyStroke: VASSAL.tools.NamedKeyStroke, gamePiece: GamePiece, translatablePiece: VASSAL.i18n.TranslatablePiece, boolean: bool): ...
    @typing.overload
    def __init__(self, string: str, namedKeyStroke: VASSAL.tools.NamedKeyStroke, gamePiece: GamePiece, boolean: bool): ...
    @typing.overload
    def __init__(self, string: str, keyStroke: javax.swing.KeyStroke, gamePiece: GamePiece): ...
    @typing.overload
    def __init__(self, string: str, keyStroke: javax.swing.KeyStroke, gamePiece: GamePiece, translatablePiece: VASSAL.i18n.TranslatablePiece): ...
    @typing.overload
    def __init__(self, string: str, keyStroke: javax.swing.KeyStroke, gamePiece: GamePiece, translatablePiece: VASSAL.i18n.TranslatablePiece, boolean: bool): ...
    @typing.overload
    def __init__(self, string: str, keyStroke: javax.swing.KeyStroke, gamePiece: GamePiece, boolean: bool): ...
    def actionPerformed(self, actionEvent: java.awt.event.ActionEvent) -> None: ...
    def getKeyStroke(self) -> javax.swing.KeyStroke: ...
    def getLocalizedMenuText(self) -> str: ...
    def getName(self) -> str: ...
    def getNamedKeyStroke(self) -> VASSAL.tools.NamedKeyStroke: ...
    def getTarget(self) -> GamePiece: ...
    def isEnabled(self) -> bool: ...
    def isGlobal(self) -> bool: ...
    def isMenuSeparator(self) -> bool: ...
    def matches(self, keyStroke: javax.swing.KeyStroke) -> bool: ...
    def setEnabled(self, boolean: bool) -> None: ...
    def setGlobal(self, boolean: bool) -> None: ...

class KeySpecifier(javax.swing.JPanel, java.awt.event.KeyListener):
    def __init__(self, char: str): ...
    def addActionListener(self, actionListener: java.awt.event.ActionListener) -> None: ...
    def addFocusListener(self, focusListener: java.awt.event.FocusListener) -> None: ...
    def getKey(self) -> str: ...
    def keyPressed(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
    def keyReleased(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
    def keyTyped(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
    def setEnabled(self, boolean: bool) -> None: ...
    @typing.overload
    def setKey(self, char: str) -> None: ...
    @typing.overload
    def setKey(self, string: str) -> None: ...

class MatHolder:
    def __init__(self, gamePiece: GamePiece): ...
    def getCargo(self) -> java.util.List[GamePiece]: ...
    def getMat(self) -> 'Mat': ...
    def getMatPiece(self) -> GamePiece: ...
    def grabCargo(self, list: java.util.List[GamePiece]) -> None: ...
    def setCargo(self, list: java.util.List[GamePiece]) -> None: ...

class MultiImagePicker(javax.swing.JPanel):
    def __init__(self): ...
    def addEntry(self) -> None: ...
    def addListSelectionListener(self, listSelectionListener: javax.swing.event.ListSelectionListener) -> None: ...
    def clear(self) -> None: ...
    def getImageNameList(self) -> java.util.List[str]: ...
    def getImageNames(self) -> java.util.Enumeration[str]: ...
    def getList(self) -> javax.swing.JList[str]: ...
    def removeEntryAt(self, int: int) -> None: ...
    def setImageList(self, stringArray: typing.List[str]) -> None: ...
    def showSelected(self) -> None: ...
    def swap(self, int: int, int2: int) -> None: ...

class PieceAccess:
    def currentPlayerCanModify(self, string: str) -> bool: ...
    def currentPlayerHasAccess(self, string: str) -> bool: ...
    def getCurrentPlayerId(self) -> str: ...
    class GlobalAccess:
        def __init__(self): ...
        @staticmethod
        def hideAll() -> None: ...
        @staticmethod
        def isHideAll() -> bool: ...
        @staticmethod
        def revertAll() -> None: ...

class PieceCloner:
    def clonePiece(self, gamePiece: GamePiece) -> GamePiece: ...
    @staticmethod
    def getInstance() -> 'PieceCloner': ...

class PieceDefiner(javax.swing.JPanel):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, gpIdSupport: VASSAL.build.GpIdSupport): ...
    @typing.overload
    def __init__(self, string: str, gpIdSupport: VASSAL.build.GpIdSupport): ...
    @staticmethod
    def addDefinition(gamePiece: GamePiece) -> None: ...
    def getPiece(self) -> GamePiece: ...
    @staticmethod
    def getSorted() -> bool: ...
    def isChanged(self) -> bool: ...
    def isSplitDragInProgress(self) -> bool: ...
    def setChanged(self, boolean: bool) -> None: ...
    def setPiece(self, gamePiece: GamePiece) -> None: ...
    @staticmethod
    def setSorted(boolean: bool) -> None: ...
    def setSplitDragInProgress(self, boolean: bool) -> None: ...

class PieceEditor:
    def getControls(self) -> java.awt.Component: ...
    def getState(self) -> str: ...
    def getType(self) -> str: ...

class PieceFilter:
    @typing.overload
    def accept(self, gamePiece: GamePiece) -> bool: ...
    @typing.overload
    def accept(self, gamePiece: GamePiece, auditable: VASSAL.script.expression.Auditable, auditTrail: VASSAL.script.expression.AuditTrail) -> bool: ...
    @typing.overload
    def accept(self, gamePiece: GamePiece, auditable: VASSAL.script.expression.Auditable, string: str) -> bool: ...

class PieceImage:
    def __init__(self, gamePiece: GamePiece): ...
    def getImage(self, component: java.awt.Component) -> java.awt.Image: ...
    def isChanged(self) -> bool: ...

class PieceIterator:
    VISIBLE: typing.ClassVar[java.util.function.Predicate] = ...
    ___init___0__T = typing.TypeVar('___init___0__T', bound=GamePiece)  # <T>
    @typing.overload
    def __init__(self, enumeration: java.util.Enumeration[___init___0__T], pieceFilter: typing.Union[PieceFilter, typing.Callable]): ...
    @typing.overload
    def __init__(self, iterator: java.util.Iterator[GamePiece]): ...
    @typing.overload
    def __init__(self, iterator: java.util.Iterator[GamePiece], pieceFilter: typing.Union[PieceFilter, typing.Callable]): ...
    def hasMoreElements(self) -> bool: ...
    def nextPiece(self) -> GamePiece: ...
    _visible_0__T = typing.TypeVar('_visible_0__T', bound=GamePiece)  # <T>
    _visible_1__T = typing.TypeVar('_visible_1__T', bound=GamePiece)  # <T>
    @typing.overload
    @staticmethod
    def visible(enumeration: java.util.Enumeration[_visible_0__T]) -> 'PieceIterator': ...
    @typing.overload
    @staticmethod
    def visible(iterator: java.util.Iterator[_visible_1__T]) -> 'PieceIterator': ...

class PieceSorter(java.util.Comparator[GamePiece]):
    def __init__(self): ...
    def compare(self, gamePiece: GamePiece, gamePiece2: GamePiece) -> int: ...

class PieceVisitor:
    def visitDefault(self, gamePiece: GamePiece) -> typing.Any: ...
    def visitStack(self, stack: 'Stack') -> typing.Any: ...

class PieceVisitorDispatcher:
    def __init__(self, pieceVisitor: PieceVisitor): ...
    def accept(self, gamePiece: GamePiece) -> typing.Any: ...

class Properties:
    INVISIBLE_TO_ME: typing.ClassVar[str] = ...
    INVISIBLE_TO_OTHERS: typing.ClassVar[str] = ...
    INVISIBLE_DISABLE_AUTO_REPORT_MOVE: typing.ClassVar[str] = ...
    OBSCURED_TO_OTHERS: typing.ClassVar[str] = ...
    OBSCURED_TO_ME: typing.ClassVar[str] = ...
    OBSCURED_BY: typing.ClassVar[str] = ...
    OBSCURED_BY_PRE_DRAW: typing.ClassVar[str] = ...
    BAND_SELECT_EVENT_FILTER: typing.ClassVar[str] = ...
    SELECT_EVENT_FILTER: typing.ClassVar[str] = ...
    MOVE_EVENT_FILTER: typing.ClassVar[str] = ...
    HIDDEN_BY: typing.ClassVar[str] = ...
    TERRAIN: typing.ClassVar[str] = ...
    IGNORE_GRID: typing.ClassVar[str] = ...
    NO_STACK: typing.ClassVar[str] = ...
    SELECTED: typing.ClassVar[str] = ...
    KEY_COMMANDS: typing.ClassVar[str] = ...
    INNER: typing.ClassVar[str] = ...
    OUTER: typing.ClassVar[str] = ...
    RESTRICTED: typing.ClassVar[str] = ...
    RESTRICTED_MOVEMENT: typing.ClassVar[str] = ...
    MOVED: typing.ClassVar[str] = ...
    SNAPSHOT: typing.ClassVar[str] = ...
    USE_UNROTATED_SHAPE: typing.ClassVar[str] = ...
    VISIBLE_STATE: typing.ClassVar[str] = ...
    NON_MOVABLE: typing.ClassVar[str] = ...
    PIECE_ID: typing.ClassVar[str] = ...

class PropertiesPieceFilter:
    def __init__(self): ...
    @staticmethod
    def parse(string: str) -> PieceFilter: ...
    @typing.overload
    @staticmethod
    def toBeanShellString(pieceFilter: typing.Union[PieceFilter, typing.Callable]) -> str: ...
    @typing.overload
    @staticmethod
    def toBeanShellString(string: str) -> str: ...

class PropertyExporter(VASSAL.build.module.properties.PropertyNameSource, VASSAL.build.module.properties.PropertySource):
    LOCALIZED_NAME: typing.ClassVar[str] = ...
    @typing.overload
    def getProperties(self) -> java.util.Map[str, typing.Any]: ...
    @typing.overload
    def getProperties(self, map: typing.Union[java.util.Map[str, typing.Any], typing.Mapping[str, typing.Any]]) -> java.util.Map[str, typing.Any]: ...

class StateMergeable:
    def mergeState(self, string: str, string2: str) -> None: ...

class TraitConfigPanel(javax.swing.JPanel):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, traitLayout: 'TraitLayout'): ...
    @typing.overload
    def __init__(self, boolean: bool): ...
    @typing.overload
    def add(self, component: java.awt.Component) -> java.awt.Component: ...
    @typing.overload
    def add(self, component: java.awt.Component, int: int) -> java.awt.Component: ...
    @typing.overload
    def add(self, string: str, component: java.awt.Component) -> java.awt.Component: ...
    @typing.overload
    def add(self, string: str, configurer: VASSAL.configure.Configurer) -> None: ...
    @typing.overload
    def add(self, string: str, configurer: VASSAL.configure.Configurer, string2: str) -> None: ...
    @typing.overload
    def add(self, string: str, jPanel: javax.swing.JPanel) -> None: ...
    @typing.overload
    def add(self, string: str, jPanel: javax.swing.JPanel, string2: str) -> None: ...
    @typing.overload
    def add(self, jLabel: javax.swing.JLabel, configurer: VASSAL.configure.Configurer) -> None: ...
    @typing.overload
    def add(self, jLabel: javax.swing.JLabel, configurer: VASSAL.configure.Configurer, string: str) -> None: ...
    @typing.overload
    def add(self, jLabel: javax.swing.JLabel, component: java.awt.Component, string: str) -> None: ...
    @typing.overload
    def add(self, jLabel: javax.swing.JLabel, jPanel: javax.swing.JPanel) -> None: ...
    @typing.overload
    def add(self, popupMenu: java.awt.PopupMenu) -> None: ...
    @typing.overload
    def add(self, component: java.awt.Component, object: typing.Any) -> None: ...
    @typing.overload
    def add(self, component: java.awt.Component, object: typing.Any, int: int) -> None: ...
    @typing.overload
    def addControls(self, configurer: VASSAL.configure.Configurer) -> None: ...
    @typing.overload
    def addControls(self, configurer: VASSAL.configure.Configurer, string: str) -> None: ...
    def addLabel(self, string: str) -> None: ...

class TraitLayout(VASSAL.configure.ConfigurerLayout):
    DEFAULT_TRAIT_LAYOUT_CONSTRAINTS: typing.ClassVar[str] = ...
    DEFAULT_TRAIT_COLUMN_CONSTRAINTS: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, boolean: bool): ...
    @typing.overload
    def __init__(self, boolean: bool, string: str, string2: str): ...

class BasicPiece(VASSAL.search.AbstractImageFinder, VASSAL.i18n.TranslatablePiece, StateMergeable, VASSAL.build.module.properties.PropertyNameSource, VASSAL.property.PersistentPropertyContainer, PropertyExporter):
    ID: typing.ClassVar[str] = ...
    LOCATION_NAME: typing.ClassVar[str] = ...
    CURRENT_MAP: typing.ClassVar[str] = ...
    CURRENT_BOARD: typing.ClassVar[str] = ...
    CURRENT_ZONE: typing.ClassVar[str] = ...
    CURRENT_X: typing.ClassVar[str] = ...
    CURRENT_Y: typing.ClassVar[str] = ...
    OLD_LOCATION_NAME: typing.ClassVar[str] = ...
    OLD_MAP: typing.ClassVar[str] = ...
    OLD_BOARD: typing.ClassVar[str] = ...
    OLD_ZONE: typing.ClassVar[str] = ...
    OLD_X: typing.ClassVar[str] = ...
    OLD_Y: typing.ClassVar[str] = ...
    OLD_MAT: typing.ClassVar[str] = ...
    OLD_MAT_ID: typing.ClassVar[str] = ...
    OLD_MAT_PIECE_NAME: typing.ClassVar[str] = ...
    OLD_MAT_BASIC_NAME: typing.ClassVar[str] = ...
    OLD_MAT_OFFSET_X: typing.ClassVar[str] = ...
    OLD_MAT_OFFSET_Y: typing.ClassVar[str] = ...
    BASIC_NAME: typing.ClassVar[str] = ...
    PIECE_NAME: typing.ClassVar[str] = ...
    LOCALIZED_BASIC_NAME: typing.ClassVar[str] = ...
    LOCALIZED_PIECE_NAME: typing.ClassVar[str] = ...
    DECK_NAME: typing.ClassVar[str] = ...
    DECK_POSITION: typing.ClassVar[str] = ...
    CLICKED_X: typing.ClassVar[str] = ...
    CLICKED_Y: typing.ClassVar[str] = ...
    PIECE_UID: typing.ClassVar[str] = ...
    POPUP_MENU_FONT: typing.ClassVar[java.awt.Font] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    def addLocalImageNames(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    @typing.overload
    def equals(self, gamePiece: GamePiece) -> bool: ...
    @typing.overload
    def equals(self, object: typing.Any) -> bool: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getGpId(self) -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    @staticmethod
    def getHighlighter() -> Highlighter: ...
    def getI18nData(self) -> VASSAL.i18n.PieceI18nData: ...
    def getId(self) -> str: ...
    def getLocalizedName(self) -> str: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getLocalizedPublicProperty(self, object: typing.Any) -> typing.Any: ...
    def getMap(self) -> VASSAL.build.module.Map: ...
    def getName(self) -> str: ...
    def getParent(self) -> 'Stack': ...
    def getPersistentProperty(self, object: typing.Any) -> typing.Any: ...
    def getPosition(self) -> java.awt.Point: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getPropertyNames(self) -> java.util.List[str]: ...
    def getPublicProperty(self, object: typing.Any) -> typing.Any: ...
    def getRealLocalizedName(self) -> str: ...
    def getRealName(self) -> str: ...
    def getShape(self) -> java.awt.Shape: ...
    def getState(self) -> str: ...
    def getType(self) -> str: ...
    def keyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mergeState(self, string: str, string2: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def setGpId(self, string: str) -> None: ...
    @staticmethod
    def setHighlighter(highlighter: Highlighter) -> None: ...
    def setId(self, string: str) -> None: ...
    def setMap(self, map: VASSAL.build.module.Map) -> None: ...
    def setParent(self, stack: 'Stack') -> None: ...
    def setPersistentProperty(self, object: typing.Any, object2: typing.Any) -> VASSAL.command.Command: ...
    def setPosition(self, point: java.awt.Point) -> None: ...
    def setProperty(self, object: typing.Any, object2: typing.Any) -> None: ...
    def setState(self, string: str) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...
    def toString(self) -> str: ...

class BooleanAndPieceFilter(PieceFilter):
    def __init__(self, pieceFilter: typing.Union[PieceFilter, typing.Callable], pieceFilter2: typing.Union[PieceFilter, typing.Callable]): ...
    @typing.overload
    def accept(self, gamePiece: GamePiece) -> bool: ...
    @typing.overload
    def accept(self, gamePiece: GamePiece, auditable: VASSAL.script.expression.Auditable, auditTrail: VASSAL.script.expression.AuditTrail) -> bool: ...
    @typing.overload
    def accept(self, gamePiece: GamePiece, auditable: VASSAL.script.expression.Auditable, string: str) -> bool: ...
    def getFilter1(self) -> PieceFilter: ...
    def getFilter2(self) -> PieceFilter: ...

class BooleanOrPieceFilter(PieceFilter):
    def __init__(self, pieceFilter: typing.Union[PieceFilter, typing.Callable], pieceFilter2: typing.Union[PieceFilter, typing.Callable]): ...
    @typing.overload
    def accept(self, gamePiece: GamePiece) -> bool: ...
    @typing.overload
    def accept(self, gamePiece: GamePiece, auditable: VASSAL.script.expression.Auditable, auditTrail: VASSAL.script.expression.AuditTrail) -> bool: ...
    @typing.overload
    def accept(self, gamePiece: GamePiece, auditable: VASSAL.script.expression.Auditable, string: str) -> bool: ...
    def getFilter1(self) -> PieceFilter: ...
    def getFilter2(self) -> PieceFilter: ...

class ColoredBorder(Highlighter):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, color: java.awt.Color, int: int): ...
    def addHighlighter(self, highlighter: Highlighter) -> None: ...
    def boundingBox(self, gamePiece: GamePiece) -> java.awt.Rectangle: ...
    def draw(self, gamePiece: GamePiece, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getColor(self) -> java.awt.Color: ...
    def getThickness(self) -> int: ...
    def removeHighlighter(self, highlighter: Highlighter) -> None: ...
    def setColor(self, color: java.awt.Color) -> None: ...
    def setThickness(self, int: int) -> None: ...

class DeckVisitor(PieceVisitor):
    def visitDeck(self, deck: 'Deck') -> typing.Any: ...

class DeckVisitorDispatcher(PieceVisitorDispatcher):
    def __init__(self, deckVisitor: DeckVisitor): ...
    def accept(self, gamePiece: GamePiece) -> typing.Any: ...

class EditablePiece(GamePiece):
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def mySetType(self, string: str) -> None: ...

class KeyCommandSubMenu(KeyCommand):
    def __init__(self, string: str, gamePiece: GamePiece, translatablePiece: VASSAL.i18n.TranslatablePiece): ...
    def actionPerformed(self, actionEvent: java.awt.event.ActionEvent) -> None: ...
    def addCommand(self, string: str) -> None: ...
    def getCommands(self) -> java.util.Iterator[str]: ...
    def setCommands(self, stringArray: typing.List[str]) -> None: ...

class MassPieceDefiner(PieceDefiner):
    def __init__(self, configurable: VASSAL.build.Configurable): ...
    def save(self) -> None: ...

class PlayerAccess(PieceAccess):
    def __init__(self): ...
    def currentPlayerCanModify(self, string: str) -> bool: ...
    def currentPlayerHasAccess(self, string: str) -> bool: ...
    def getCurrentPlayerId(self) -> str: ...
    @staticmethod
    def getInstance() -> 'PlayerAccess': ...

class RangeFilter(PieceFilter):
    def __init__(self, map: VASSAL.build.module.Map, point: java.awt.Point, int: int): ...
    @typing.overload
    def accept(self, gamePiece: GamePiece) -> bool: ...
    @typing.overload
    def accept(self, gamePiece: GamePiece, auditable: VASSAL.script.expression.Auditable, auditTrail: VASSAL.script.expression.AuditTrail) -> bool: ...
    @typing.overload
    def accept(self, gamePiece: GamePiece, auditable: VASSAL.script.expression.Auditable, string: str) -> bool: ...

class SideAccess(PieceAccess):
    def __init__(self): ...
    def currentPlayerCanModify(self, string: str) -> bool: ...
    def currentPlayerHasAccess(self, string: str) -> bool: ...
    def getCurrentPlayerId(self) -> str: ...
    @staticmethod
    def getInstance() -> 'SideAccess': ...

class SimplePieceEditor(PieceEditor):
    def __init__(self, gamePiece: GamePiece): ...
    def getControls(self) -> java.awt.Component: ...
    def getState(self) -> str: ...
    def getType(self) -> str: ...

class SpecifiedSideAccess(PieceAccess):
    def __init__(self, list: java.util.List[str]): ...
    def currentPlayerCanModify(self, string: str) -> bool: ...
    def currentPlayerHasAccess(self, string: str) -> bool: ...
    def getCurrentPlayerId(self) -> str: ...
    def getSides(self) -> java.util.List[str]: ...

class Stack(VASSAL.search.AbstractImageFinder, GamePiece, StateMergeable):
    TYPE: typing.ClassVar[str] = ...
    HAS_LAYER_MARKER: typing.ClassVar[str] = ...
    LAYER_NOT_SET: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, gamePiece: GamePiece): ...
    def add(self, gamePiece: GamePiece) -> None: ...
    def addImageNamesRecursively(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def asList(self) -> java.util.List[GamePiece]: ...
    @typing.overload
    def bottomPiece(self) -> GamePiece: ...
    @typing.overload
    def bottomPiece(self, string: str) -> GamePiece: ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getDefaultMetrics(self) -> VASSAL.build.module.map.StackMetrics: ...
    def getId(self) -> str: ...
    def getLayer(self) -> int: ...
    def getLocalizedName(self) -> str: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getMap(self) -> VASSAL.build.module.Map: ...
    def getMaximumVisiblePieceCount(self) -> int: ...
    @typing.overload
    def getName(self) -> str: ...
    @typing.overload
    def getName(self, boolean: bool) -> str: ...
    def getParent(self) -> 'Stack': ...
    def getPieceAbove(self, gamePiece: GamePiece) -> GamePiece: ...
    def getPieceAt(self, int: int) -> GamePiece: ...
    def getPieceBeneath(self, gamePiece: GamePiece) -> GamePiece: ...
    def getPieceCount(self) -> int: ...
    def getPieces(self) -> java.util.Enumeration[GamePiece]: ...
    def getPiecesInVisibleOrderIterator(self) -> java.util.Iterator[GamePiece]: ...
    def getPiecesIterator(self) -> java.util.Iterator[GamePiece]: ...
    def getPiecesReverseIterator(self) -> java.util.Iterator[GamePiece]: ...
    def getPosition(self) -> java.awt.Point: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getShape(self) -> java.awt.Shape: ...
    @typing.overload
    def getStackMetrics(self) -> VASSAL.build.module.map.StackMetrics: ...
    @typing.overload
    def getStackMetrics(self, map: VASSAL.build.module.Map) -> VASSAL.build.module.map.StackMetrics: ...
    def getState(self) -> str: ...
    def getType(self) -> str: ...
    def indexOf(self, gamePiece: GamePiece) -> int: ...
    def insert(self, gamePiece: GamePiece, int: int) -> None: ...
    def insertChild(self, gamePiece: GamePiece, int: int) -> None: ...
    def isExpanded(self) -> bool: ...
    def keyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mergeState(self, string: str, string2: str) -> None: ...
    def nVisible(self) -> int: ...
    def pieceAdded(self, gamePiece: GamePiece) -> VASSAL.command.Command: ...
    def pieceRemoved(self, gamePiece: GamePiece) -> VASSAL.command.Command: ...
    def remove(self, gamePiece: GamePiece) -> None: ...
    def removeAll(self) -> None: ...
    def selectNext(self, gamePiece: GamePiece) -> None: ...
    @staticmethod
    def setDefaultMetrics(stackMetrics: VASSAL.build.module.map.StackMetrics) -> None: ...
    def setExpanded(self, boolean: bool) -> None: ...
    def setId(self, string: str) -> None: ...
    def setMap(self, map: VASSAL.build.module.Map) -> None: ...
    def setParent(self, stack: 'Stack') -> None: ...
    def setPosition(self, point: java.awt.Point) -> None: ...
    def setProperty(self, object: typing.Any, object2: typing.Any) -> None: ...
    def setPropertyOnContents(self, object: typing.Any, object2: typing.Any) -> None: ...
    def setState(self, string: str) -> None: ...
    def toString(self) -> str: ...
    @typing.overload
    def topPiece(self) -> GamePiece: ...
    @typing.overload
    def topPiece(self, string: str) -> GamePiece: ...

class Deck(Stack, VASSAL.build.module.PlayerRoster.SideChangeListener):
    ID: typing.ClassVar[str] = ...
    ALWAYS: typing.ClassVar[str] = ...
    NEVER: typing.ClassVar[str] = ...
    USE_MENU: typing.ClassVar[str] = ...
    USE_MENU_UP: typing.ClassVar[str] = ...
    NO_USER: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, gameModule: VASSAL.build.GameModule): ...
    @typing.overload
    def __init__(self, gameModule: VASSAL.build.GameModule, string: str): ...
    @typing.overload
    def __init__(self, gameModule: VASSAL.build.GameModule, string: str, propertySource: VASSAL.build.module.properties.PropertySource): ...
    def addGlobalKeyCommand(self, deckGlobalKeyCommand: VASSAL.build.module.map.DeckGlobalKeyCommand) -> None: ...
    def addListeners(self) -> None: ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def doesExpressionCounting(self) -> bool: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def drawCards(self) -> PieceIterator: ...
    def extendedSend(self, deckSendKeyCommand: VASSAL.build.module.map.deck.DeckSendKeyCommand) -> VASSAL.command.Command: ...
    def getComponentName(self) -> str: ...
    def getComponentTypeName(self) -> str: ...
    def getCountExpressions(self) -> typing.List[str]: ...
    def getDeckName(self) -> str: ...
    def getDragCount(self) -> int: ...
    def getDrawMultipleMessage(self) -> str: ...
    def getDrawSpecificMessage(self) -> str: ...
    def getFaceDownMessage(self) -> str: ...
    def getFaceDownMsgFormat(self) -> str: ...
    def getFaceDownOption(self) -> str: ...
    def getFaceUpMessage(self) -> str: ...
    def getLocalizedDeckName(self) -> str: ...
    def getMaxStack(self) -> int: ...
    def getMaximumVisiblePieceCount(self) -> int: ...
    def getNamedEmptyKey(self) -> VASSAL.tools.NamedKeyStroke: ...
    def getOrderedPieces(self) -> java.util.List[GamePiece]: ...
    def getOutlineColor(self) -> java.awt.Color: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getReshuffleCommand(self) -> str: ...
    def getReshuffleKey(self) -> VASSAL.tools.NamedKeyStroke: ...
    def getReshuffleMsgFormat(self) -> str: ...
    def getReshuffleTarget(self) -> str: ...
    def getRestrictExpression(self) -> VASSAL.configure.PropertyExpression: ...
    def getReverseCommand(self) -> str: ...
    def getReverseKey(self) -> VASSAL.tools.NamedKeyStroke: ...
    def getReverseMsgFormat(self) -> str: ...
    def getSelectDisplayProperty(self) -> str: ...
    def getSelectSortProperty(self) -> str: ...
    def getShape(self) -> java.awt.Shape: ...
    def getShuffleCommand(self) -> str: ...
    def getShuffleKey(self) -> VASSAL.tools.NamedKeyStroke: ...
    def getShuffleMsgFormat(self) -> str: ...
    def getShuffleOption(self) -> str: ...
    def getSize(self) -> java.awt.Dimension: ...
    @typing.overload
    def getStackMetrics(self) -> VASSAL.build.module.map.StackMetrics: ...
    @typing.overload
    def getStackMetrics(self, map: VASSAL.build.module.Map) -> VASSAL.build.module.map.StackMetrics: ...
    def getState(self) -> str: ...
    def getType(self) -> str: ...
    def isAllowMultipleDraw(self) -> bool: ...
    def isAllowSelectDraw(self) -> bool: ...
    def isDrawFaceUp(self) -> bool: ...
    def isDrawOutline(self) -> bool: ...
    def isExpanded(self) -> bool: ...
    def isFaceDown(self) -> bool: ...
    def isHotkeyOnEmpty(self) -> bool: ...
    def isPersistable(self) -> bool: ...
    def isRestrictOption(self) -> bool: ...
    def isReversible(self) -> bool: ...
    def isShuffle(self) -> bool: ...
    def loadDeck(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> VASSAL.command.Command: ...
    def mayContain(self, gamePiece: GamePiece) -> bool: ...
    def mergeState(self, string: str, string2: str) -> None: ...
    def pieceAdded(self, gamePiece: GamePiece) -> VASSAL.command.Command: ...
    def pieceRemoved(self, gamePiece: GamePiece) -> VASSAL.command.Command: ...
    def promptForDragCount(self) -> None: ...
    def removeAll(self) -> None: ...
    def removeGlobalKeyCommand(self, deckGlobalKeyCommand: VASSAL.build.module.map.DeckGlobalKeyCommand) -> None: ...
    def removeListeners(self) -> None: ...
    def repaintMap(self) -> None: ...
    def reverse(self) -> VASSAL.command.Command: ...
    def saveDeck(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> None: ...
    def sendToDeck(self) -> VASSAL.command.Command: ...
    def setAllowMultipleDraw(self, boolean: bool) -> None: ...
    def setAllowSelectDraw(self, boolean: bool) -> None: ...
    def setContentsFaceDown(self, boolean: bool) -> VASSAL.command.Command: ...
    def setCountExpressions(self, stringArray: typing.List[str]) -> None: ...
    def setDeckName(self, string: str) -> None: ...
    def setDragCount(self, int: int) -> None: ...
    def setDrawFaceUp(self, boolean: bool) -> None: ...
    def setDrawMultipleMessage(self, string: str) -> None: ...
    def setDrawOutline(self, boolean: bool) -> None: ...
    def setDrawSpecificMessage(self, string: str) -> None: ...
    def setEmptyKey(self, namedKeyStroke: VASSAL.tools.NamedKeyStroke) -> None: ...
    def setExpressionCounting(self, boolean: bool) -> None: ...
    def setFaceDown(self, boolean: bool) -> None: ...
    def setFaceDownMessage(self, string: str) -> None: ...
    def setFaceDownMsgFormat(self, string: str) -> None: ...
    def setFaceDownOption(self, string: str) -> None: ...
    def setFaceUpMessage(self, string: str) -> None: ...
    def setHotkeyOnEmpty(self, boolean: bool) -> None: ...
    def setMap(self, map: VASSAL.build.module.Map) -> None: ...
    def setMaxStack(self, int: int) -> None: ...
    def setOutlineColor(self, color: java.awt.Color) -> None: ...
    def setPersistable(self, boolean: bool) -> None: ...
    def setPropertySource(self, propertySource: VASSAL.build.module.properties.PropertySource) -> None: ...
    def setReshuffleCommand(self, string: str) -> None: ...
    def setReshuffleKey(self, namedKeyStroke: VASSAL.tools.NamedKeyStroke) -> None: ...
    def setReshuffleMsgFormat(self, string: str) -> None: ...
    def setReshuffleTarget(self, string: str) -> None: ...
    def setRestrictExpression(self, propertyExpression: VASSAL.configure.PropertyExpression) -> None: ...
    def setRestrictOption(self, boolean: bool) -> None: ...
    def setReverseCommand(self, string: str) -> None: ...
    def setReverseKey(self, namedKeyStroke: VASSAL.tools.NamedKeyStroke) -> None: ...
    def setReverseMsgFormat(self, string: str) -> None: ...
    def setReversible(self, boolean: bool) -> None: ...
    def setSelectDisplayProperty(self, string: str) -> None: ...
    def setSelectSortProperty(self, string: str) -> None: ...
    def setShuffle(self, boolean: bool) -> None: ...
    def setShuffleCommand(self, string: str) -> None: ...
    def setShuffleKey(self, namedKeyStroke: VASSAL.tools.NamedKeyStroke) -> None: ...
    def setShuffleMsgFormat(self, string: str) -> None: ...
    def setShuffleOption(self, string: str) -> None: ...
    def setSize(self, dimension: java.awt.Dimension) -> None: ...
    def setState(self, string: str) -> None: ...
    def shuffle(self) -> VASSAL.command.Command: ...
    def sideChanged(self, string: str, string2: str) -> None: ...
    def sort(self, list: java.util.List[VASSAL.build.module.map.deck.SortParameter], formattedString: VASSAL.tools.FormattedString, string: str) -> VASSAL.command.Command: ...
    class CountExpression:
        def __init__(self, string: str): ...
        def getExpression(self) -> str: ...
        def getFullString(self) -> str: ...
        def getName(self) -> str: ...

class Decorator(VASSAL.search.AbstractImageFinder, EditablePiece, StateMergeable, VASSAL.build.module.properties.PropertyNameSource, VASSAL.property.PersistentPropertyContainer, PropertyExporter, VASSAL.search.SearchTarget, VASSAL.search.ImageSearchTarget):
    def __init__(self): ...
    def addImageNamesRecursively(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def getCommandDesc(self, string: str, namedKeyStroke: VASSAL.tools.NamedKeyStroke) -> str: ...
    def getComponentName(self) -> str: ...
    def getComponentTypeName(self) -> str: ...
    @staticmethod
    def getDecorator(gamePiece: GamePiece, class_: typing.Type[typing.Any]) -> GamePiece: ...
    def getEditor(self) -> PieceEditor: ...
    def getExpressionList(self) -> java.util.List[str]: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getI18nData(self) -> VASSAL.i18n.PieceI18nData: ...
    def getId(self) -> str: ...
    def getInner(self) -> GamePiece: ...
    @staticmethod
    def getInnermost(gamePiece: GamePiece) -> GamePiece: ...
    def getLocalizedName(self) -> str: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getMap(self) -> VASSAL.build.module.Map: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getOuter(self) -> 'Decorator': ...
    @staticmethod
    def getOutermost(gamePiece: GamePiece) -> GamePiece: ...
    def getParent(self) -> Stack: ...
    def getPersistentProperty(self, object: typing.Any) -> typing.Any: ...
    def getPosition(self) -> java.awt.Point: ...
    @typing.overload
    def getProperties(self) -> java.util.Map[str, typing.Any]: ...
    @typing.overload
    def getProperties(self, map: typing.Union[java.util.Map[str, typing.Any], typing.Mapping[str, typing.Any]]) -> java.util.Map[str, typing.Any]: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getPropertyList(self) -> java.util.List[str]: ...
    def getPropertyNames(self) -> java.util.List[str]: ...
    def getState(self) -> str: ...
    def getType(self) -> str: ...
    def keyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mergeState(self, string: str, string2: str) -> None: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    @staticmethod
    def putOldProperties(gamePiece: GamePiece) -> VASSAL.command.Command: ...
    @typing.overload
    @staticmethod
    def repack(configurer: VASSAL.configure.Configurer) -> None: ...
    @typing.overload
    @staticmethod
    def repack(component: java.awt.Component) -> None: ...
    def setId(self, string: str) -> None: ...
    def setInner(self, gamePiece: GamePiece) -> None: ...
    def setMap(self, map: VASSAL.build.module.Map) -> None: ...
    def setParent(self, stack: Stack) -> None: ...
    def setPersistentProperty(self, object: typing.Any, object2: typing.Any) -> VASSAL.command.Command: ...
    def setPosition(self, point: java.awt.Point) -> None: ...
    def setProperty(self, object: typing.Any, object2: typing.Any) -> None: ...
    def setState(self, string: str) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...
    def toString(self) -> str: ...

class ActionButton(Decorator, EditablePiece, VASSAL.tools.RecursionLimiter.Loopable):
    ID: typing.ClassVar[str] = ...
    LAUNCH_POPUP_MENU: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getName(self) -> str: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getShape(self) -> java.awt.Shape: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def setMap(self, map: VASSAL.build.module.Map) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...
    class Ed(PieceEditor):
        def __init__(self, actionButton: 'ActionButton'): ...
        def getControls(self) -> java.awt.Component: ...
        def getState(self) -> str: ...
        def getType(self) -> str: ...

class AreaOfEffect(Decorator, VASSAL.i18n.TranslatablePiece, VASSAL.build.module.map.MapShader.ShadedPiece):
    ID: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getArea(self, mapShader: VASSAL.build.module.map.MapShader) -> java.awt.geom.Area: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.PieceI18nData: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getName(self) -> str: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getShape(self) -> java.awt.Shape: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...

class BasicName(Decorator, VASSAL.i18n.TranslatablePiece):
    ID: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.PieceI18nData: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getName(self) -> str: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getShape(self) -> java.awt.Shape: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...
    class Ed(PieceEditor):
        def __init__(self, basicName: 'BasicName'): ...
        def getControls(self) -> java.awt.Component: ...
        def getState(self) -> str: ...
        def getType(self) -> str: ...

class CalculatedProperty(Decorator, EditablePiece, VASSAL.tools.RecursionLimiter.Loopable):
    ID: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getExpressionList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getName(self) -> str: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getPropertyList(self) -> java.util.List[str]: ...
    def getPropertyNames(self) -> java.util.List[str]: ...
    def getShape(self) -> java.awt.Shape: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...
    class Ed(PieceEditor):
        def __init__(self, calculatedProperty: 'CalculatedProperty'): ...
        def getControls(self) -> java.awt.Component: ...
        def getState(self) -> str: ...
        def getType(self) -> str: ...

class Clone(Decorator, VASSAL.i18n.TranslatablePiece):
    ID: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.PieceI18nData: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getName(self) -> str: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getShape(self) -> java.awt.Shape: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...
    class Ed(PieceEditor):
        def __init__(self, clone: 'Clone'): ...
        def getControls(self) -> java.awt.Component: ...
        def getState(self) -> str: ...
        def getType(self) -> str: ...

class CounterGlobalKeyCommand(Decorator, VASSAL.i18n.TranslatablePiece, VASSAL.tools.RecursionLimiter.Loopable):
    ID: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def apply(self) -> VASSAL.command.Command: ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getExpressionList(self) -> java.util.List[str]: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.PieceI18nData: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getName(self) -> str: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getPropertyList(self) -> java.util.List[str]: ...
    def getShape(self) -> java.awt.Shape: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...
    class Ed(PieceEditor):
        def __init__(self, counterGlobalKeyCommand: 'CounterGlobalKeyCommand'): ...
        def getControls(self) -> java.awt.Component: ...
        def getState(self) -> str: ...
        def getType(self) -> str: ...

class Delete(Decorator, VASSAL.i18n.TranslatablePiece):
    ID: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.PieceI18nData: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getName(self) -> str: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getShape(self) -> java.awt.Shape: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...
    class Ed(PieceEditor):
        def __init__(self, delete: 'Delete'): ...
        def getControls(self) -> java.awt.Component: ...
        def getState(self) -> str: ...
        def getType(self) -> str: ...

class Deselect(Decorator, VASSAL.i18n.TranslatablePiece):
    ID: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.PieceI18nData: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getName(self) -> str: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getPropertyNames(self) -> java.util.List[str]: ...
    def getShape(self) -> java.awt.Shape: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...
    class Ed(PieceEditor):
        def __init__(self, deselect: 'Deselect'): ...
        def getControls(self) -> java.awt.Component: ...
        def getState(self) -> str: ...
        def getType(self) -> str: ...

class DynamicProperty(Decorator, VASSAL.i18n.TranslatablePiece, VASSAL.build.module.properties.PropertyPrompt.DialogParent, VASSAL.build.module.properties.PropertyChangerConfigurer.Constraints):
    ID: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getComponent(self) -> java.awt.Component: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getExpressionList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.PieceI18nData: ...
    def getKey(self) -> str: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getMaximumValue(self) -> int: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getMinimumValue(self) -> int: ...
    def getName(self) -> str: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getPropertyList(self) -> java.util.List[str]: ...
    def getPropertyNames(self) -> java.util.List[str]: ...
    def getPropertySource(self) -> VASSAL.build.module.properties.PropertySource: ...
    def getShape(self) -> java.awt.Shape: ...
    def getValue(self) -> str: ...
    def isNumeric(self) -> bool: ...
    def isWrap(self) -> bool: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def setProperty(self, object: typing.Any, object2: typing.Any) -> None: ...
    def setValue(self, string: str) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...
    class DynamicKeyCommand(KeyCommand):
        def __init__(self, string: str, namedKeyStroke: VASSAL.tools.NamedKeyStroke, gamePiece: GamePiece, translatablePiece: VASSAL.i18n.TranslatablePiece, propertyChanger: typing.Union[VASSAL.build.module.properties.PropertyChanger, typing.Callable]): ...
        def getPropChanger(self) -> VASSAL.build.module.properties.PropertyChanger: ...
        def setPropChanger(self, propertyChanger: typing.Union[VASSAL.build.module.properties.PropertyChanger, typing.Callable]) -> None: ...

class Embellishment(Decorator, VASSAL.i18n.TranslatablePiece, VASSAL.tools.RecursionLimiter.Loopable):
    OLD_ID: typing.ClassVar[str] = ...
    ID: typing.ClassVar[str] = ...
    IMAGE: typing.ClassVar[str] = ...
    NAME: typing.ClassVar[str] = ...
    LEVEL: typing.ClassVar[str] = ...
    ACTIVE: typing.ClassVar[str] = ...
    BASE_VERSION: typing.ClassVar[int] = ...
    CURRENT_VERSION: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def addLocalImageNames(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def canBeActivated(self) -> bool: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getCurrentImageBounds(self) -> java.awt.Rectangle: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getExpressionList(self) -> java.util.List[str]: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.PieceI18nData: ...
    def getLayerName(self) -> str: ...
    @typing.overload
    @staticmethod
    def getLayerWithMatchingActivateCommand(gamePiece: GamePiece, namedKeyStroke: VASSAL.tools.NamedKeyStroke, boolean: bool) -> 'Embellishment': ...
    @typing.overload
    @staticmethod
    def getLayerWithMatchingActivateCommand(gamePiece: GamePiece, keyStroke: javax.swing.KeyStroke, boolean: bool) -> 'Embellishment': ...
    def getLocalizedName(self) -> str: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    @typing.overload
    def getName(self) -> str: ...
    @typing.overload
    def getName(self, boolean: bool) -> str: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getPropertyNames(self) -> java.util.List[str]: ...
    def getShape(self) -> java.awt.Shape: ...
    def getValue(self) -> int: ...
    def getVersion(self) -> int: ...
    def isActive(self) -> bool: ...
    def myGetKeyCommands(self) -> typing.List[KeyCommand]: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def setActive(self, boolean: bool) -> None: ...
    def setValue(self, int: int) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...

class Embellishment0(Decorator, VASSAL.i18n.TranslatablePiece):
    OLD_ID: typing.ClassVar[str] = ...
    ID: typing.ClassVar[str] = ...
    IMAGE: typing.ClassVar[str] = ...
    NAME: typing.ClassVar[str] = ...
    LEVEL: typing.ClassVar[str] = ...
    ACTIVE: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def addLocalImageNames(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getCurrentImageBounds(self) -> java.awt.Rectangle: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.PieceI18nData: ...
    @staticmethod
    def getLayerWithMatchingActivateCommand(gamePiece: GamePiece, keyStroke: javax.swing.KeyStroke, boolean: bool) -> Embellishment: ...
    def getLocalizedName(self) -> str: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    @typing.overload
    def getName(self) -> str: ...
    @typing.overload
    def getName(self, boolean: bool) -> str: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getShape(self) -> java.awt.Shape: ...
    def getValue(self) -> int: ...
    def isActive(self) -> bool: ...
    def myGetKeyCommands(self) -> typing.List[KeyCommand]: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def setActive(self, boolean: bool) -> None: ...
    def setValue(self, int: int) -> None: ...

class FreeRotator(Decorator, EditablePiece, java.awt.event.MouseListener, java.awt.event.MouseMotionListener, VASSAL.build.module.map.Drawable, VASSAL.i18n.TranslatablePiece):
    ID: typing.ClassVar[str] = ...
    FACING: typing.ClassVar[str] = ...
    DEGREES: typing.ClassVar[str] = ...
    PI_180: typing.ClassVar[float] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def beginInteractiveRotate(self) -> None: ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    @typing.overload
    def draw(self, graphics: java.awt.Graphics, map: VASSAL.build.module.Map) -> None: ...
    @typing.overload
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def drawAboveCounters(self) -> bool: ...
    def endInteractiveRotate(self) -> None: ...
    def getAngle(self) -> float: ...
    def getAngleInRadians(self) -> float: ...
    def getBaseDescription(self) -> str: ...
    def getCumulativeAngle(self) -> float: ...
    def getCumulativeAngleInRadians(self) -> float: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.PieceI18nData: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getName(self) -> str: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getPropertyNames(self) -> java.util.List[str]: ...
    def getShape(self) -> java.awt.Shape: ...
    def hasPieceMoved(self) -> bool: ...
    def isFreeRotation(self) -> bool: ...
    def mouseClicked(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseDragged(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseEntered(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseExited(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseMoved(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mousePressed(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseReleased(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def myGetKeyCommands(self) -> typing.List[KeyCommand]: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def rotateCargo(self, command: VASSAL.command.Command, point: java.awt.Point, double: float) -> VASSAL.command.Command: ...
    def setAngle(self, double: float) -> None: ...
    def setInner(self, gamePiece: GamePiece) -> None: ...
    def setPivot(self, int: int, int2: int) -> None: ...
    def setProperty(self, object: typing.Any, object2: typing.Any) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...

class GlobalHotKey(Decorator, VASSAL.i18n.TranslatablePiece):
    ID: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.PieceI18nData: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getName(self) -> str: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getShape(self) -> java.awt.Shape: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...
    class Ed(PieceEditor):
        def __init__(self, globalHotKey: 'GlobalHotKey'): ...
        def getControls(self) -> java.awt.Component: ...
        def getState(self) -> str: ...
        def getType(self) -> str: ...

class Hideable(Decorator, VASSAL.i18n.TranslatablePiece):
    ID: typing.ClassVar[str] = ...
    HIDDEN_BY: typing.ClassVar[str] = ...
    TRANSPARENCY: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.PieceI18nData: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getName(self) -> str: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getPropertyNames(self) -> java.util.List[str]: ...
    def getShape(self) -> java.awt.Shape: ...
    def invisibleToMe(self) -> bool: ...
    def invisibleToOthers(self) -> bool: ...
    def myGetKeyCommands(self) -> typing.List[KeyCommand]: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    @staticmethod
    def setAllHidden(boolean: bool) -> None: ...
    def setProperty(self, object: typing.Any, object2: typing.Any) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...

class Immobilized(Decorator, EditablePiece):
    ID: typing.ClassVar[str] = ...
    BASE_IGNORE_GRID: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, gamePiece: GamePiece, string: str): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getName(self) -> str: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getPropertyNames(self) -> java.util.List[str]: ...
    def getShape(self) -> java.awt.Shape: ...
    def myGetKeyCommands(self) -> typing.List[KeyCommand]: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...
    class UseAlt(EventFilter):
        def __init__(self, immobilized: 'Immobilized'): ...
        def rejectEvent(self, inputEvent: java.awt.event.InputEvent) -> bool: ...
    class UseAltShift(EventFilter):
        def __init__(self, immobilized: 'Immobilized'): ...
        def rejectEvent(self, inputEvent: java.awt.event.InputEvent) -> bool: ...
    class UseShift(EventFilter):
        def __init__(self, immobilized: 'Immobilized'): ...
        def rejectEvent(self, inputEvent: java.awt.event.InputEvent) -> bool: ...

class Labeler(Decorator, VASSAL.i18n.TranslatablePiece, VASSAL.tools.RecursionLimiter.Loopable):
    ID: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def addLocalImageNames(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    @typing.overload
    @staticmethod
    def drawLabel(graphics: java.awt.Graphics, string: str, int: int, int2: int, int3: int, int4: int, color: java.awt.Color, color2: java.awt.Color) -> None: ...
    @typing.overload
    @staticmethod
    def drawLabel(graphics: java.awt.Graphics, string: str, int: int, int2: int, font: java.awt.Font, int3: int, int4: int, color: java.awt.Color, color2: java.awt.Color, color3: java.awt.Color) -> None: ...
    def getActualDescription(self) -> str: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.PieceI18nData: ...
    def getLabel(self) -> str: ...
    def getLocalizedLabel(self) -> str: ...
    def getLocalizedName(self) -> str: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getName(self) -> str: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getPropertyList(self) -> java.util.List[str]: ...
    def getPropertyNames(self) -> java.util.List[str]: ...
    def getShape(self) -> java.awt.Shape: ...
    def myGetKeyCommands(self) -> typing.List[KeyCommand]: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def setBackground(self, color: java.awt.Color) -> None: ...
    def setForeground(self, color: java.awt.Color) -> None: ...
    def setLabel(self, string: str) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...

class Marker(Decorator, EditablePiece):
    ID: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getExpressionList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getKeys(self) -> typing.List[str]: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getName(self) -> str: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getPropertyList(self) -> java.util.List[str]: ...
    def getPropertyNames(self) -> java.util.List[str]: ...
    def getShape(self) -> java.awt.Shape: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def setProperty(self, object: typing.Any, object2: typing.Any) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...

class Mat(Decorator, VASSAL.i18n.TranslatablePiece):
    ID: typing.ClassVar[str] = ...
    MAT_NAME: typing.ClassVar[str] = ...
    MAT_ID: typing.ClassVar[str] = ...
    MAT_CONTENTS: typing.ClassVar[str] = ...
    MAT_NUM_CARGO: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def addCargo(self, gamePiece: GamePiece) -> None: ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def drawCargo(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getCargoCount(self) -> int: ...
    def getContents(self) -> java.util.List[GamePiece]: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getName(self) -> str: ...
    def getOffsets(self, int: int, int2: int) -> java.util.List[java.awt.Point]: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getPropertyNames(self) -> java.util.List[str]: ...
    def getShape(self) -> java.awt.Shape: ...
    def hasCargo(self, gamePiece: GamePiece) -> bool: ...
    def makeAddCargoCommand(self, gamePiece: GamePiece) -> VASSAL.command.Command: ...
    def makeRemoveAllCargoCommand(self) -> VASSAL.command.Command: ...
    def makeRemoveCargoCommand(self, gamePiece: GamePiece) -> VASSAL.command.Command: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def removeCargo(self, gamePiece: GamePiece) -> None: ...
    def setProperty(self, object: typing.Any, object2: typing.Any) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...
    class Ed(PieceEditor):
        def __init__(self, mat: 'Mat'): ...
        def getControls(self) -> java.awt.Component: ...
        def getState(self) -> str: ...
        def getType(self) -> str: ...

class MatCargo(Decorator, VASSAL.i18n.TranslatablePiece):
    ID: typing.ClassVar[str] = ...
    NO_MAT: typing.ClassVar[str] = ...
    CURRENT_MAT: typing.ClassVar[str] = ...
    CURRENT_MAT_ID: typing.ClassVar[str] = ...
    CURRENT_MAT_X: typing.ClassVar[str] = ...
    CURRENT_MAT_Y: typing.ClassVar[str] = ...
    CURRENT_MAT_OFFSET_X: typing.ClassVar[str] = ...
    CURRENT_MAT_OFFSET_Y: typing.ClassVar[str] = ...
    CURRENT_MAT_PIECE_NAME: typing.ClassVar[str] = ...
    CURRENT_MAT_BASIC_NAME: typing.ClassVar[str] = ...
    CURRENT_MAT_LOCATION_NAME: typing.ClassVar[str] = ...
    CURRENT_MAT_ZONE: typing.ClassVar[str] = ...
    CURRENT_MAT_BOARD: typing.ClassVar[str] = ...
    CURRENT_MAT_MAP: typing.ClassVar[str] = ...
    CURRENT_MAT_PROP0: typing.ClassVar[str] = ...
    CURRENT_MAT_PROP1: typing.ClassVar[str] = ...
    CURRENT_MAT_PROP2: typing.ClassVar[str] = ...
    CURRENT_MAT_PROP3: typing.ClassVar[str] = ...
    CURRENT_MAT_PROP4: typing.ClassVar[str] = ...
    CURRENT_MAT_PROP5: typing.ClassVar[str] = ...
    CURRENT_MAT_PROP6: typing.ClassVar[str] = ...
    CURRENT_MAT_PROP7: typing.ClassVar[str] = ...
    CURRENT_MAT_PROP8: typing.ClassVar[str] = ...
    CURRENT_MAT_PROP9: typing.ClassVar[str] = ...
    IS_CARGO: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def clearMat(self) -> None: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    @typing.overload
    def findNewMat(self) -> VASSAL.command.Command: ...
    @typing.overload
    def findNewMat(self, map: VASSAL.build.module.Map, point: java.awt.Point) -> VASSAL.command.Command: ...
    @typing.overload
    @staticmethod
    def findNewMat(command: VASSAL.command.Command, gamePiece: GamePiece) -> VASSAL.command.Command: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getMat(self) -> GamePiece: ...
    def getName(self) -> str: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getPropertyNames(self) -> java.util.List[str]: ...
    def getShape(self) -> java.awt.Shape: ...
    def locateNewMat(self, map: VASSAL.build.module.Map, point: java.awt.Point) -> GamePiece: ...
    def makeClearMatCommand(self) -> VASSAL.command.Command: ...
    def makeSetMatCommand(self, gamePiece: GamePiece) -> VASSAL.command.Command: ...
    def myGetKeyCommands(self) -> typing.List[KeyCommand]: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def setMat(self, gamePiece: GamePiece) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...
    class Ed(PieceEditor):
        def __init__(self, matCargo: 'MatCargo'): ...
        def getControls(self) -> java.awt.Component: ...
        def getState(self) -> str: ...
        def getType(self) -> str: ...

class MenuSeparator(Decorator, VASSAL.i18n.TranslatablePiece):
    ID: typing.ClassVar[str] = ...
    SEPARATOR_NAME: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getName(self) -> str: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getShape(self) -> java.awt.Shape: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...
    class Ed(PieceEditor):
        def __init__(self, menuSeparator: 'MenuSeparator'): ...
        def getControls(self) -> java.awt.Component: ...
        def getState(self) -> str: ...
        def getType(self) -> str: ...

class MovementMarkable(Decorator, VASSAL.i18n.TranslatablePiece):
    ID: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def addLocalImageNames(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.PieceI18nData: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getName(self) -> str: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getPropertyNames(self) -> java.util.List[str]: ...
    def getShape(self) -> java.awt.Shape: ...
    def isMoved(self) -> bool: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def setDescription(self, string: str) -> None: ...
    def setMoved(self, boolean: bool) -> None: ...
    def setProperty(self, object: typing.Any, object2: typing.Any) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...

class NonRectangular(Decorator, EditablePiece):
    ID: typing.ClassVar[str] = ...
    OLD_ID: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def addLocalImageNames(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getName(self) -> str: ...
    def getShape(self) -> java.awt.Shape: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def setScale(self, double: float) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...

class Obscurable(Decorator, VASSAL.i18n.TranslatablePiece):
    ID: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def addLocalImageNames(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.PieceI18nData: ...
    def getKeyCommands(self) -> typing.List[KeyCommand]: ...
    def getLocalizedName(self) -> str: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getName(self) -> str: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getPropertyNames(self) -> java.util.List[str]: ...
    def getShape(self) -> java.awt.Shape: ...
    def isAutoPeeking(self) -> bool: ...
    def isMaskable(self) -> bool: ...
    def isPeeking(self) -> bool: ...
    def keyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def myGetKeyCommands(self) -> typing.List[KeyCommand]: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def obscuredToMe(self) -> bool: ...
    def obscuredToOthers(self) -> bool: ...
    def setProperty(self, object: typing.Any, object2: typing.Any) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...

class Pivot(Decorator, VASSAL.i18n.TranslatablePiece):
    ID: typing.ClassVar[str] = ...
    DEGREES: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.PieceI18nData: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getName(self) -> str: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getShape(self) -> java.awt.Shape: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...
    class Ed(PieceEditor):
        def __init__(self, pivot: 'Pivot'): ...
        def getControls(self) -> java.awt.Component: ...
        def getState(self) -> str: ...
        def getType(self) -> str: ...

class PlaceMarker(Decorator, VASSAL.i18n.TranslatablePiece, VASSAL.tools.RecursionLimiter.Loopable):
    ID: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def addImageNamesRecursively(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def createBaseMarker(self) -> GamePiece: ...
    def createMarker(self) -> GamePiece: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getGpId(self) -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.PieceI18nData: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getName(self) -> str: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getShape(self) -> java.awt.Shape: ...
    def isMarkerStandalone(self) -> bool: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def setGpId(self, string: str) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...
    @typing.overload
    def updateGpId(self) -> None: ...
    @typing.overload
    def updateGpId(self, gpIdSupport: VASSAL.build.GpIdSupport) -> None: ...

class PlaySound(Decorator, VASSAL.i18n.TranslatablePiece):
    ID: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.PieceI18nData: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getName(self) -> str: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getShape(self) -> java.awt.Shape: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    class Ed(PieceEditor):
        def __init__(self, playSound: 'PlaySound'): ...
        def getControls(self) -> java.awt.Component: ...
        def getState(self) -> str: ...
        def getType(self) -> str: ...

class PropertySheet(Decorator, VASSAL.i18n.TranslatablePiece):
    ID: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.PieceI18nData: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getName(self) -> str: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getPropertyNames(self) -> java.util.List[str]: ...
    def getShape(self) -> java.awt.Shape: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...

class ReportState(Decorator, VASSAL.i18n.TranslatablePiece):
    ID: typing.ClassVar[str] = ...
    OLD_UNIT_NAME: typing.ClassVar[str] = ...
    NEW_UNIT_NAME: typing.ClassVar[str] = ...
    MAP_NAME: typing.ClassVar[str] = ...
    OLD_MAP_NAME: typing.ClassVar[str] = ...
    LOCATION_NAME: typing.ClassVar[str] = ...
    OLD_LOCATION_NAME: typing.ClassVar[str] = ...
    COMMAND_NAME: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def addLocalImageNames(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.PieceI18nData: ...
    def getName(self) -> str: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getShape(self) -> java.awt.Shape: ...
    def keyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...
    class Ed(PieceEditor):
        def __init__(self, reportState: 'ReportState'): ...
        def getControls(self) -> java.awt.Component: ...
        def getState(self) -> str: ...
        def getType(self) -> str: ...

class RestrictCommands(Decorator, EditablePiece):
    ID: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getExpressionList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getName(self) -> str: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getShape(self) -> java.awt.Shape: ...
    def keyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...
    class Ed(PieceEditor):
        def __init__(self, restrictCommands: 'RestrictCommands'): ...
        def getControls(self) -> java.awt.Component: ...
        def getState(self) -> str: ...
        def getType(self) -> str: ...

class Restricted(Decorator, EditablePiece):
    ID: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getName(self) -> str: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getShape(self) -> java.awt.Shape: ...
    def isRestricted(self) -> bool: ...
    def keyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def setDescription(self, string: str) -> None: ...
    def setProperty(self, object: typing.Any, object2: typing.Any) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...
    class Ed(PieceEditor):
        def __init__(self, restricted: 'Restricted'): ...
        def getControls(self) -> java.awt.Component: ...
        def getState(self) -> str: ...
        def getType(self) -> str: ...

class ReturnToDeck(Decorator, VASSAL.i18n.TranslatablePiece):
    ID: typing.ClassVar[str] = ...
    RtDversion: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.PieceI18nData: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getName(self) -> str: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getPropertyList(self) -> java.util.List[str]: ...
    def getShape(self) -> java.awt.Shape: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...

class SendToLocation(Decorator, VASSAL.i18n.TranslatablePiece):
    ID: typing.ClassVar[str] = ...
    BACK_MAP: typing.ClassVar[str] = ...
    BACK_POINT: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getExpressionList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.PieceI18nData: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getName(self) -> str: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getShape(self) -> java.awt.Shape: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...
    class Ed(PieceEditor):
        def __init__(self, sendToLocation: 'SendToLocation'): ...
        def getControls(self) -> java.awt.Component: ...
        def getState(self) -> str: ...
        def getType(self) -> str: ...

class SubMenu(Decorator, VASSAL.i18n.TranslatablePiece):
    ID: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.PieceI18nData: ...
    def getMenuName(self) -> str: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getName(self) -> str: ...
    def getShape(self) -> java.awt.Shape: ...
    def getSubcommands(self) -> typing.List[str]: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def setDescription(self, string: str) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...
    class Editor(PieceEditor):
        def __init__(self, subMenu: 'SubMenu'): ...
        def getControls(self) -> java.awt.Component: ...
        def getState(self) -> str: ...
        def getType(self) -> str: ...

class TableInfo(Decorator, VASSAL.i18n.TranslatablePiece):
    ID: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getColumnCount(self) -> int: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getExpressionList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.PieceI18nData: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getName(self) -> str: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getRowCount(self) -> int: ...
    def getShape(self) -> java.awt.Shape: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...

class TranslatableMessage(Decorator, VASSAL.i18n.TranslatablePiece):
    DELIMITER: typing.ClassVar[str] = ...
    ID: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.PieceI18nData: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getName(self) -> str: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getPropertyList(self) -> java.util.List[str]: ...
    def getPropertyNames(self) -> java.util.List[str]: ...
    def getShape(self) -> java.awt.Shape: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...

class Translate(Decorator, VASSAL.i18n.TranslatablePiece):
    ID: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.PieceI18nData: ...
    def getName(self) -> str: ...
    def getShape(self) -> java.awt.Shape: ...
    def keyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...
    class Editor(PieceEditor):
        def __init__(self, translate: 'Translate'): ...
        def getControls(self) -> java.awt.Component: ...
        def getState(self) -> str: ...
        def getType(self) -> str: ...
    class MoveExecuter(java.lang.Runnable):
        def __init__(self): ...
        def add(self, map: VASSAL.build.module.Map, gamePiece: GamePiece, point: java.awt.Point) -> None: ...
        def addKeyEventTarget(self, gamePiece: GamePiece) -> None: ...
        def getAdditionalCommand(self) -> VASSAL.command.Command: ...
        def getUpdatedPosition(self, gamePiece: GamePiece) -> java.awt.Point: ...
        def run(self) -> None: ...
        def setAdditionalCommand(self, command: VASSAL.command.Command) -> None: ...
        def setKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> None: ...

class TriggerAction(Decorator, VASSAL.i18n.TranslatablePiece, VASSAL.tools.RecursionLimiter.Loopable):
    ID: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getExpressionList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.PieceI18nData: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getName(self) -> str: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getPropertyList(self) -> java.util.List[str]: ...
    def getPropertyNames(self) -> java.util.List[str]: ...
    def getShape(self) -> java.awt.Shape: ...
    def keyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def setCommandName(self, string: str) -> None: ...
    def setKey(self, namedKeyStroke: VASSAL.tools.NamedKeyStroke) -> None: ...
    def setPropertyMatch(self, string: str) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...
    class Ed(PieceEditor):
        def __init__(self, triggerAction: 'TriggerAction'): ...
        def getControls(self) -> java.awt.Component: ...
        def getState(self) -> str: ...
        def getType(self) -> str: ...

class UsePrototype(Decorator, EditablePiece, VASSAL.tools.RecursionLimiter.Loopable):
    ID: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getBaseDescription(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getExpandedInner(self) -> GamePiece: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getName(self) -> str: ...
    def getPropertyList(self) -> java.util.List[str]: ...
    def getPrototypeName(self) -> str: ...
    def getShape(self) -> java.awt.Shape: ...
    def keyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def setInner(self, gamePiece: GamePiece) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...
    class Editor(PieceEditor):
        def __init__(self, usePrototype: 'UsePrototype'): ...
        def getControls(self) -> java.awt.Component: ...
        def getState(self) -> str: ...
        def getType(self) -> str: ...

class Footprint(MovementMarkable):
    ID: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.PieceI18nData: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getMyBoundingBox(self) -> java.awt.Rectangle: ...
    def getName(self) -> str: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getShape(self) -> java.awt.Shape: ...
    def myGetKeyCommands(self) -> typing.List[KeyCommand]: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def redraw(self) -> None: ...
    def setMoved(self, boolean: bool) -> None: ...
    def setProperty(self, object: typing.Any, object2: typing.Any) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...

class Replace(PlaceMarker):
    ID: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def createMarker(self) -> GamePiece: ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.PieceI18nData: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...

class SetGlobalProperty(DynamicProperty):
    ID: typing.ClassVar[str] = ...
    CURRENT_ZONE: typing.ClassVar[str] = ...
    NAMED_ZONE: typing.ClassVar[str] = ...
    NAMED_MAP: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: GamePiece): ...
    def getDescription(self) -> str: ...
    def getEditor(self) -> PieceEditor: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def myGetState(self) -> str: ...
    def myGetType(self) -> str: ...
    def myKeyEvent(self, keyStroke: javax.swing.KeyStroke) -> VASSAL.command.Command: ...
    def mySetState(self, string: str) -> None: ...
    def mySetType(self, string: str) -> None: ...
    def setProperty(self, object: typing.Any, object2: typing.Any) -> None: ...
    def testEquals(self, object: typing.Any) -> bool: ...

class PieceFinder:
    STACK_ONLY: typing.ClassVar['PieceFinder'] = ...
    PIECE_IN_STACK: typing.ClassVar['PieceFinder'] = ...
    DECK_OR_PIECE_IN_STACK: typing.ClassVar['PieceFinder'] = ...
    MOVABLE: typing.ClassVar['PieceFinder'] = ...
    MAT_ONLY: typing.ClassVar['PieceFinder'] = ...
    def select(self, map: VASSAL.build.module.Map, gamePiece: GamePiece, point: java.awt.Point) -> GamePiece: ...
    class DeckOrPieceInStack(VASSAL.counters.PieceFinder.PieceInStack):
        def __init__(self): ...
        def visitDeck(self, deck: Deck) -> typing.Any: ...
    class MatOnly(VASSAL.counters.PieceFinder.Movable):
        def __init__(self): ...
        def visitDefault(self, gamePiece: GamePiece) -> typing.Any: ...
        def visitStack(self, stack: Stack) -> typing.Any: ...
    class Movable(VASSAL.counters.PieceFinder, DeckVisitor):
        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, map: VASSAL.build.module.Map, point: java.awt.Point): ...
        def select(self, map: VASSAL.build.module.Map, gamePiece: GamePiece, point: java.awt.Point) -> GamePiece: ...
        def visitDeck(self, deck: Deck) -> typing.Any: ...
        def visitDefault(self, gamePiece: GamePiece) -> typing.Any: ...
        def visitStack(self, stack: Stack) -> typing.Any: ...
    class PieceInStack(VASSAL.counters.PieceFinder.Movable):
        def __init__(self): ...
        def visitStack(self, stack: Stack) -> typing.Any: ...
    class StackOnly(VASSAL.counters.PieceFinder.Movable):
        def __init__(self): ...
        def visitDefault(self, gamePiece: GamePiece) -> typing.Any: ...
        def visitStack(self, stack: Stack) -> typing.Any: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("VASSAL.counters")``.

    ActionButton: typing.Type[ActionButton]
    AreaCache: typing.Type[AreaCache]
    AreaOfEffect: typing.Type[AreaOfEffect]
    BasicName: typing.Type[BasicName]
    BasicPiece: typing.Type[BasicPiece]
    BooleanAndPieceFilter: typing.Type[BooleanAndPieceFilter]
    BooleanOrPieceFilter: typing.Type[BooleanOrPieceFilter]
    BoundsTracker: typing.Type[BoundsTracker]
    CalculatedProperty: typing.Type[CalculatedProperty]
    Clone: typing.Type[Clone]
    ColoredBorder: typing.Type[ColoredBorder]
    CounterGlobalKeyCommand: typing.Type[CounterGlobalKeyCommand]
    CounterNames: typing.Type[CounterNames]
    Deck: typing.Type[Deck]
    DeckVisitor: typing.Type[DeckVisitor]
    DeckVisitorDispatcher: typing.Type[DeckVisitorDispatcher]
    Decorator: typing.Type[Decorator]
    Delete: typing.Type[Delete]
    Deselect: typing.Type[Deselect]
    DragBuffer: typing.Type[DragBuffer]
    DynamicProperty: typing.Type[DynamicProperty]
    EditablePiece: typing.Type[EditablePiece]
    Embellishment: typing.Type[Embellishment]
    Embellishment0: typing.Type[Embellishment0]
    EventFilter: typing.Type[EventFilter]
    Footprint: typing.Type[Footprint]
    FreeRotator: typing.Type[FreeRotator]
    GamePiece: typing.Type[GamePiece]
    GlobalCommand: typing.Type[GlobalCommand]
    GlobalCommandTarget: typing.Type[GlobalCommandTarget]
    GlobalHotKey: typing.Type[GlobalHotKey]
    Hideable: typing.Type[Hideable]
    Highlighter: typing.Type[Highlighter]
    ImagePicker: typing.Type[ImagePicker]
    Immobilized: typing.Type[Immobilized]
    KeyBuffer: typing.Type[KeyBuffer]
    KeyCommand: typing.Type[KeyCommand]
    KeyCommandSubMenu: typing.Type[KeyCommandSubMenu]
    KeySpecifier: typing.Type[KeySpecifier]
    Labeler: typing.Type[Labeler]
    Marker: typing.Type[Marker]
    MassPieceDefiner: typing.Type[MassPieceDefiner]
    Mat: typing.Type[Mat]
    MatCargo: typing.Type[MatCargo]
    MatHolder: typing.Type[MatHolder]
    MenuSeparator: typing.Type[MenuSeparator]
    MovementMarkable: typing.Type[MovementMarkable]
    MultiImagePicker: typing.Type[MultiImagePicker]
    NonRectangular: typing.Type[NonRectangular]
    Obscurable: typing.Type[Obscurable]
    PieceAccess: typing.Type[PieceAccess]
    PieceCloner: typing.Type[PieceCloner]
    PieceDefiner: typing.Type[PieceDefiner]
    PieceEditor: typing.Type[PieceEditor]
    PieceFilter: typing.Type[PieceFilter]
    PieceFinder: typing.Type[PieceFinder]
    PieceImage: typing.Type[PieceImage]
    PieceIterator: typing.Type[PieceIterator]
    PieceSorter: typing.Type[PieceSorter]
    PieceVisitor: typing.Type[PieceVisitor]
    PieceVisitorDispatcher: typing.Type[PieceVisitorDispatcher]
    Pivot: typing.Type[Pivot]
    PlaceMarker: typing.Type[PlaceMarker]
    PlaySound: typing.Type[PlaySound]
    PlayerAccess: typing.Type[PlayerAccess]
    Properties: typing.Type[Properties]
    PropertiesPieceFilter: typing.Type[PropertiesPieceFilter]
    PropertyExporter: typing.Type[PropertyExporter]
    PropertySheet: typing.Type[PropertySheet]
    RangeFilter: typing.Type[RangeFilter]
    Replace: typing.Type[Replace]
    ReportState: typing.Type[ReportState]
    RestrictCommands: typing.Type[RestrictCommands]
    Restricted: typing.Type[Restricted]
    ReturnToDeck: typing.Type[ReturnToDeck]
    SendToLocation: typing.Type[SendToLocation]
    SetGlobalProperty: typing.Type[SetGlobalProperty]
    SideAccess: typing.Type[SideAccess]
    SimplePieceEditor: typing.Type[SimplePieceEditor]
    SpecifiedSideAccess: typing.Type[SpecifiedSideAccess]
    Stack: typing.Type[Stack]
    StateMergeable: typing.Type[StateMergeable]
    SubMenu: typing.Type[SubMenu]
    TableInfo: typing.Type[TableInfo]
    TraitConfigPanel: typing.Type[TraitConfigPanel]
    TraitLayout: typing.Type[TraitLayout]
    TranslatableMessage: typing.Type[TranslatableMessage]
    Translate: typing.Type[Translate]
    TriggerAction: typing.Type[TriggerAction]
    UsePrototype: typing.Type[UsePrototype]
