import VASSAL.build
import VASSAL.build.module
import VASSAL.build.module.documentation
import VASSAL.build.module.properties
import VASSAL.configure.password
import VASSAL.counters
import VASSAL.launch
import VASSAL.script.expression
import VASSAL.tools
import java.awt
import java.awt.event
import java.beans
import java.io
import java.lang
import java.net
import java.util
import javax.swing
import javax.swing.event
import javax.swing.tree
import net.miginfocom.swing
import typing



class BeanShellFunctionMenu(javax.swing.JPopupMenu):
    def __init__(self, editablePiece: VASSAL.counters.EditablePiece, beanShellExpressionConfigurer: 'BeanShellExpressionConfigurer'): ...

class ChooseComponentDialog(javax.swing.JDialog, javax.swing.event.TreeSelectionListener):
    def __init__(self, frame: java.awt.Frame, class_: typing.Type[VASSAL.build.Buildable]): ...
    def getTarget(self) -> VASSAL.build.Configurable: ...
    def valueChanged(self, treeSelectionEvent: javax.swing.event.TreeSelectionEvent) -> None: ...

class ComponentConfigPanel(VASSAL.counters.TraitConfigPanel):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, componentLayout: 'ComponentLayout'): ...
    @typing.overload
    def __init__(self, boolean: bool): ...

class ComponentLayout(VASSAL.counters.TraitLayout):
    COMPONENT_INSETS: typing.ClassVar[str] = ...
    DEFAULT_COMPONENT_LAYOUT_CONSTRAINTS: typing.ClassVar[str] = ...
    DEFAULT_COMPONENT_COLUMN_CONSTRAINTS: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, boolean: bool): ...

class ConfigurableList:
    DEFAULT_ICON_SIZE: typing.ClassVar[int] = ...
    def addEntry(self) -> None: ...
    def deleteEntry(self, configurableListEntry: 'ConfigurableListEntry') -> None: ...
    def entryChanged(self, configurableListEntry: 'ConfigurableListEntry') -> None: ...
    def getListController(self) -> javax.swing.JComponent: ...
    def getSelectedEntryIndex(self) -> int: ...
    def moveEntryDown(self) -> None: ...
    def moveEntryUp(self) -> None: ...
    def repack(self) -> None: ...
    def selectEntry(self, configurableListEntry: 'ConfigurableListEntry') -> None: ...
    def setSelectedEntryIndex(self, int: int) -> None: ...

class ConfigurableListController(javax.swing.JPanel):
    @typing.overload
    def __init__(self, configurableList: ConfigurableList): ...
    @typing.overload
    def __init__(self, configurableList: ConfigurableList, int: int): ...
    def setCanMoveDown(self, boolean: bool) -> None: ...
    def setCanMoveUp(self, boolean: bool) -> None: ...

class ConfigurableListEntry(java.beans.PropertyChangeListener):
    def addPropertyChangeListener(self, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def focusGained(self) -> None: ...
    def getConfigurer(self) -> 'Configurer': ...
    def getRemoveButton(self) -> javax.swing.JButton: ...
    def removePropertyChangeListener(self, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def requestFocus(self) -> None: ...
    def setHighlighted(self, boolean: bool) -> None: ...
    def updateVisibility(self) -> None: ...

class ConfigureTree(javax.swing.JTree, java.beans.PropertyChangeListener, java.awt.event.MouseListener, java.awt.event.MouseMotionListener, javax.swing.event.TreeSelectionListener, javax.swing.event.TreeExpansionListener):
    POPUP_MENU_FONT: typing.ClassVar[java.awt.Font] = ...
    @typing.overload
    def __init__(self, configurable: VASSAL.build.Configurable, helpWindow: VASSAL.build.module.documentation.HelpWindow): ...
    @typing.overload
    def __init__(self, configurable: VASSAL.build.Configurable, helpWindow: VASSAL.build.module.documentation.HelpWindow, editorWindow: VASSAL.launch.EditorWindow): ...
    @staticmethod
    def addAdditionalComponent(class_: typing.Type[VASSAL.build.Buildable], class2: typing.Type[VASSAL.build.Buildable]) -> None: ...
    def canContainGamePiece(self, configurable: VASSAL.build.Configurable) -> bool: ...
    def checkMinimumIndex(self, defaultMutableTreeNode: javax.swing.tree.DefaultMutableTreeNode, int: int) -> int: ...
    def externalInsert(self, configurable: VASSAL.build.Configurable, configurable2: VASSAL.build.Configurable) -> None: ...
    @typing.overload
    @staticmethod
    def getConfigureName(configurable: VASSAL.build.Configurable) -> str: ...
    @typing.overload
    @staticmethod
    def getConfigureName(class_: typing.Type[typing.Any]) -> str: ...
    def getFrame(self) -> javax.swing.JFrame: ...
    def getHelpAction(self) -> javax.swing.Action: ...
    def getSearchCmd(self) -> str: ...
    def getTreeNode(self, configurable: VASSAL.build.Configurable) -> javax.swing.tree.DefaultMutableTreeNode: ...
    def mouseClicked(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseDragged(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseEntered(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseExited(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseMoved(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mousePressed(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseReleased(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def nodeEdited(self, configurable: VASSAL.build.Configurable) -> None: ...
    def nodeUpdated(self, configurable: VASSAL.build.Configurable) -> None: ...
    def populateEditMenu(self, editorWindow: VASSAL.launch.EditorWindow) -> None: ...
    def propertyChange(self, propertyChangeEvent: java.beans.PropertyChangeEvent) -> None: ...
    def treeCollapsed(self, treeExpansionEvent: javax.swing.event.TreeExpansionEvent) -> None: ...
    def treeExpanded(self, treeExpansionEvent: javax.swing.event.TreeExpansionEvent) -> None: ...
    def updateGpIds(self, configurable: VASSAL.build.Configurable) -> None: ...
    def valueChanged(self, treeSelectionEvent: javax.swing.event.TreeSelectionEvent) -> None: ...
    class Mutable: ...

class Configurer:
    NAME_PROPERTY: typing.ClassVar[str] = ...
    LIST_ENTRY_HIGHLIGHT_COLOR: typing.ClassVar[java.awt.Color] = ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, object: typing.Any): ...
    def addFocusListener(self, focusListener: java.awt.event.FocusListener) -> None: ...
    def addPropertyChangeListener(self, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def fireUpdate(self) -> None: ...
    def getControls(self) -> java.awt.Component: ...
    def getHint(self) -> str: ...
    def getKey(self) -> str: ...
    def getName(self) -> str: ...
    def getValue(self) -> typing.Any: ...
    def getValueString(self) -> str: ...
    def isFrozen(self) -> bool: ...
    def isHighlighted(self) -> bool: ...
    def removeFocusListener(self, focusListener: java.awt.event.FocusListener) -> None: ...
    def removePropertyChangeListener(self, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def requestFocus(self) -> None: ...
    def setFrozen(self, boolean: bool) -> None: ...
    def setHighlighted(self, boolean: bool) -> None: ...
    def setHint(self, string: str) -> None: ...
    def setHintKey(self, string: str) -> None: ...
    def setLabelVisibile(self, boolean: bool) -> None: ...
    def setName(self, string: str) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...

class ConfigurerFactory:
    def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> Configurer: ...

class ConfigurerLayout(net.miginfocom.swing.MigLayout):
    STANDARD_INSETS: typing.ClassVar[str] = ...
    STANDARD_GAPY: typing.ClassVar[str] = ...
    STANDARD_INSERTS_GAPY: typing.ClassVar[str] = ...
    DEFAULT_CFG_LAYOUT_CONSTRAINTS: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str, string4: str): ...

class ConfigurerPanel(javax.swing.JPanel):
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str, string4: str): ...
    def setLabelVisibility(self, boolean: bool) -> None: ...

class ConfigurerWindow(javax.swing.JDialog):
    @typing.overload
    def __init__(self, configurer: Configurer): ...
    @typing.overload
    def __init__(self, configurer: Configurer, boolean: bool): ...
    def isCancelled(self) -> bool: ...

class EditContainedPiecesAction(javax.swing.AbstractAction):
    def __init__(self, configurable: VASSAL.build.Configurable): ...
    def actionPerformed(self, actionEvent: java.awt.event.ActionEvent) -> None: ...

class EditPropertiesAction(javax.swing.AbstractAction):
    @typing.overload
    def __init__(self, configurable: VASSAL.build.Configurable, helpWindow: VASSAL.build.module.documentation.HelpWindow, frame: java.awt.Frame): ...
    @typing.overload
    def __init__(self, configurable: VASSAL.build.Configurable, helpWindow: VASSAL.build.module.documentation.HelpWindow, frame: java.awt.Frame, configureTree: ConfigureTree): ...
    def actionPerformed(self, actionEvent: java.awt.event.ActionEvent) -> None: ...

class HintTextField(javax.swing.JTextField, java.awt.event.FocusListener):
    @typing.overload
    def __init__(self, int: int, string: str): ...
    @typing.overload
    def __init__(self, string: str): ...
    def focusGained(self, focusEvent: java.awt.event.FocusEvent) -> None: ...
    def focusLost(self, focusEvent: java.awt.event.FocusEvent) -> None: ...
    def getHint(self) -> str: ...
    def isFocusOnly(self) -> bool: ...
    def paint(self, graphics: java.awt.Graphics) -> None: ...
    def setFocusOnly(self, boolean: bool) -> None: ...
    def setHint(self, string: str) -> None: ...

class NoInsetButton(javax.swing.JButton):
    @typing.overload
    def __init__(self, string: str, int: int): ...
    @typing.overload
    def __init__(self, string: str, int: int, string2: str): ...

class PropertiesWindow(javax.swing.JDialog):
    def __init__(self, frame: java.awt.Frame, boolean: bool, configurable: VASSAL.build.Configurable, helpWindow: VASSAL.build.module.documentation.HelpWindow): ...
    def cancel(self) -> None: ...
    def save(self) -> None: ...

class PropertyExpression(VASSAL.counters.PieceFilter):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def accept(self, gamePiece: VASSAL.counters.GamePiece) -> bool: ...
    @typing.overload
    def accept(self, gamePiece: VASSAL.counters.GamePiece, gamePiece2: VASSAL.counters.GamePiece) -> bool: ...
    @typing.overload
    def accept(self, gamePiece: VASSAL.counters.GamePiece, gamePiece2: VASSAL.counters.GamePiece, auditable: VASSAL.script.expression.Auditable, auditTrail: VASSAL.script.expression.AuditTrail) -> bool: ...
    @typing.overload
    def accept(self, gamePiece: VASSAL.counters.GamePiece, auditable: VASSAL.script.expression.Auditable, auditTrail: VASSAL.script.expression.AuditTrail) -> bool: ...
    @typing.overload
    def accept(self, gamePiece: VASSAL.counters.GamePiece, auditable: VASSAL.script.expression.Auditable, string: str) -> bool: ...
    def equals(self, object: typing.Any) -> bool: ...
    def getExpression(self) -> str: ...
    @typing.overload
    def getFilter(self) -> VASSAL.counters.PieceFilter: ...
    @typing.overload
    def getFilter(self, propertySource: VASSAL.build.module.properties.PropertySource) -> VASSAL.counters.PieceFilter: ...
    @typing.overload
    def getFilter(self, propertySource: VASSAL.build.module.properties.PropertySource, auditable: VASSAL.script.expression.Auditable, auditTrail: VASSAL.script.expression.AuditTrail) -> VASSAL.counters.PieceFilter: ...
    @typing.overload
    def getFilter(self, propertySource: VASSAL.build.module.properties.PropertySource, auditable: VASSAL.script.expression.Auditable, string: str) -> VASSAL.counters.PieceFilter: ...
    def hashCode(self) -> int: ...
    def isNull(self) -> bool: ...
    @typing.overload
    def isTrue(self, propertySource: VASSAL.build.module.properties.PropertySource) -> bool: ...
    @typing.overload
    def isTrue(self, propertySource: VASSAL.build.module.properties.PropertySource, auditable: VASSAL.script.expression.Auditable, auditTrail: VASSAL.script.expression.AuditTrail) -> bool: ...
    def setExpression(self, string: str) -> None: ...

class RefreshPredefinedSetupsDialog(javax.swing.JDialog):
    def __init__(self, frame: java.awt.Frame): ...
    def isTestMode(self) -> bool: ...
    def log(self, string: str) -> None: ...

class RemoveUnusedImagesDialog(javax.swing.JDialog):
    def __init__(self, frame: java.awt.Frame): ...

class SaveAction(javax.swing.AbstractAction):
    def __init__(self): ...
    def setParent(self, string: str) -> None: ...

class SaveAsAction(javax.swing.AbstractAction):
    def __init__(self): ...
    def setParent(self, string: str) -> None: ...

class SavedGameUpdaterDialog(javax.swing.JDialog):
    def __init__(self, frame: java.awt.Frame): ...

class ShowHelpAction(javax.swing.AbstractAction):
    @typing.overload
    def __init__(self, helpWindow: VASSAL.build.module.documentation.HelpWindow, helpFile: VASSAL.build.module.documentation.HelpFile, uRL: java.net.URL): ...
    @typing.overload
    def __init__(self, helpWindow: VASSAL.build.module.documentation.HelpWindow, uRL: java.net.URL, uRL2: java.net.URL): ...
    @typing.overload
    def __init__(self, string: str, uRL: java.net.URL, uRL2: java.net.URL): ...
    @typing.overload
    def __init__(self, uRL: java.net.URL, uRL2: java.net.URL): ...
    def actionPerformed(self, actionEvent: java.awt.event.ActionEvent) -> None: ...

class StringEnum:
    def __init__(self): ...
    def getValidValues(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...

class ValidationReport:
    def __init__(self): ...
    def addWarning(self, string: str) -> None: ...
    def getWarnings(self) -> java.util.List[str]: ...

class ValidationReportDialog(javax.swing.JDialog):
    def __init__(self, validationReport: ValidationReport, callBack: 'ValidationReportDialog.CallBack'): ...
    class CallBack:
        def cancel(self) -> None: ...
        def ok(self) -> None: ...

class ValidityChecker:
    def validate(self, buildable: VASSAL.build.Buildable, validationReport: ValidationReport) -> None: ...

class VisibilityCondition:
    def shouldBeVisible(self) -> bool: ...

class AbstractConfigurableListEntry(ConfigurableListEntry):
    @typing.overload
    def __init__(self, configurableList: ConfigurableList, object: typing.Any): ...
    @typing.overload
    def __init__(self, configurableList: ConfigurableList, object: typing.Any, int: int): ...
    def buildChildConfigurer(self, object: typing.Any) -> Configurer: ...
    def focusGained(self) -> None: ...
    def getConfigurer(self) -> Configurer: ...
    def getParent(self) -> ConfigurableList: ...
    def getRemoveButton(self) -> javax.swing.JButton: ...
    def propertyChange(self, propertyChangeEvent: java.beans.PropertyChangeEvent) -> None: ...
    def requestFocus(self) -> None: ...
    def setHighlighted(self, boolean: bool) -> None: ...
    def updateVisibility(self) -> None: ...

class AutoConfigurer(Configurer, java.beans.PropertyChangeListener):
    def __init__(self, autoConfigurable: VASSAL.build.AutoConfigurable): ...
    @staticmethod
    def createConfigurer(class_: typing.Type[typing.Any], string: str, string2: str, autoConfigurable: VASSAL.build.AutoConfigurable) -> Configurer: ...
    def getConfigurer(self, string: str) -> Configurer: ...
    def getControls(self) -> java.awt.Component: ...
    def getLabel(self, string: str) -> javax.swing.JComponent: ...
    def getValueString(self) -> str: ...
    def propertyChange(self, propertyChangeEvent: java.beans.PropertyChangeEvent) -> None: ...
    def reset(self) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    def setVisibility(self, string: str, visibilityCondition: typing.Union[VisibilityCondition, typing.Callable]) -> None: ...

class BooleanConfigurer(Configurer):
    @typing.overload
    def __init__(self, boolean: bool): ...
    @typing.overload
    def __init__(self, boolean: bool): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, boolean: bool): ...
    @typing.overload
    def __init__(self, string: str, string2: str, boolean: bool): ...
    def addFocusListener(self, focusListener: java.awt.event.FocusListener) -> None: ...
    def booleanValue(self) -> bool: ...
    def getControls(self) -> java.awt.Component: ...
    def getValueBoolean(self) -> bool: ...
    def getValueString(self) -> str: ...
    def removeFocusListener(self, focusListener: java.awt.event.FocusListener) -> None: ...
    def setLabelVisibile(self, boolean: bool) -> None: ...
    def setName(self, string: str) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...

class ChooseComponentPathDialog(ChooseComponentDialog):
    def __init__(self, frame: java.awt.Frame, class_: typing.Type[VASSAL.build.Buildable]): ...
    def getPath(self) -> typing.List[VASSAL.build.Configurable]: ...
    def valueChanged(self, treeSelectionEvent: javax.swing.event.TreeSelectionEvent) -> None: ...

class ColorConfigurer(Configurer):
    @typing.overload
    def __init__(self, color: java.awt.Color): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, color: java.awt.Color): ...
    @staticmethod
    def colorToString(color: java.awt.Color) -> str: ...
    def getControls(self) -> java.awt.Component: ...
    def getValueString(self) -> str: ...
    def setLabelVisibile(self, boolean: bool) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...
    @staticmethod
    def stringToColor(string: str) -> java.awt.Color: ...

class CompoundValidityChecker(ValidityChecker):
    def __init__(self, validityChecker: typing.Union[ValidityChecker, typing.Callable], validityChecker2: typing.Union[ValidityChecker, typing.Callable]): ...
    def append(self, validityChecker: typing.Union[ValidityChecker, typing.Callable]) -> 'CompoundValidityChecker': ...
    def validate(self, buildable: VASSAL.build.Buildable, validationReport: ValidationReport) -> None: ...

class DynamicKeyCommandConfigurer(Configurer):
    def __init__(self, dynamicProperty: VASSAL.counters.DynamicProperty): ...
    def addFocusListener(self, focusListener: java.awt.event.FocusListener) -> None: ...
    def getChangerControls(self) -> java.awt.Component: ...
    def getCommandControls(self) -> java.awt.Component: ...
    def getControls(self) -> java.awt.Component: ...
    def getKeyCommand(self) -> VASSAL.counters.DynamicProperty.DynamicKeyCommand: ...
    def getKeyControls(self) -> java.awt.Component: ...
    def getTarget(self) -> VASSAL.counters.DynamicProperty: ...
    def getTypeControls(self) -> java.awt.Component: ...
    def getValueString(self) -> str: ...
    def getValuesControls(self) -> java.awt.Component: ...
    def isEnumType(self) -> bool: ...
    def removeFocusListener(self, focusListener: java.awt.event.FocusListener) -> None: ...
    def requestFocus(self) -> None: ...
    def setFrozen(self, boolean: bool) -> None: ...
    def setHighlighted(self, boolean: bool) -> None: ...
    def setTarget(self, dynamicProperty: VASSAL.counters.DynamicProperty) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...
    def updateValue(self) -> None: ...

class DynamicKeyCommandListConfigurer(Configurer, ConfigurableList):
    def __init__(self, string: str, string2: str, dynamicProperty: VASSAL.counters.DynamicProperty): ...
    def addEntry(self) -> None: ...
    def deleteEntry(self, configurableListEntry: ConfigurableListEntry) -> None: ...
    def entryChanged(self, configurableListEntry: ConfigurableListEntry) -> None: ...
    def getControls(self) -> java.awt.Component: ...
    def getListController(self) -> javax.swing.JComponent: ...
    def getListValue(self) -> java.util.List[typing.Any]: ...
    def getSelectedEntryIndex(self) -> int: ...
    def getTarget(self) -> VASSAL.counters.DynamicProperty: ...
    def getValueString(self) -> str: ...
    def moveEntryDown(self) -> None: ...
    def moveEntryUp(self) -> None: ...
    def repack(self) -> None: ...
    def selectEntry(self, configurableListEntry: ConfigurableListEntry) -> None: ...
    def setSelectedEntryIndex(self, int: int) -> None: ...
    def setTarget(self, dynamicProperty: VASSAL.counters.DynamicProperty) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...

class ExtensionTree(ConfigureTree):
    def __init__(self, configurable: VASSAL.build.Configurable, helpWindow: VASSAL.build.module.documentation.HelpWindow, moduleExtension: VASSAL.build.module.ModuleExtension, editorWindow: VASSAL.launch.EditorWindow): ...
    def checkMinimumIndex(self, defaultMutableTreeNode: javax.swing.tree.DefaultMutableTreeNode, int: int) -> int: ...
    def externalInsert(self, configurable: VASSAL.build.Configurable, configurable2: VASSAL.build.Configurable) -> None: ...
    def getPath(self, defaultMutableTreeNode: javax.swing.tree.DefaultMutableTreeNode) -> typing.List[VASSAL.build.Configurable]: ...
    @typing.overload
    def isEditable(self, defaultMutableTreeNode: javax.swing.tree.DefaultMutableTreeNode) -> bool: ...
    @typing.overload
    def isEditable(self) -> bool: ...
    def updateGpIds(self, configurable: VASSAL.build.Configurable) -> None: ...

class FileConfigurer(Configurer):
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, directoryConfigurer: 'DirectoryConfigurer'): ...
    @typing.overload
    def __init__(self, string: str, string2: str, archiveWriter: VASSAL.tools.ArchiveWriter): ...
    def chooseNewValue(self) -> None: ...
    def getControls(self) -> java.awt.Component: ...
    def getFileValue(self) -> java.io.File: ...
    def getValueString(self) -> str: ...
    def isEditable(self) -> bool: ...
    @staticmethod
    def main(stringArray: typing.List[str]) -> None: ...
    def setEditable(self, boolean: bool) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...

class FontConfigurer(Configurer):
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, font: java.awt.Font): ...
    @typing.overload
    def __init__(self, string: str, string2: str, font: java.awt.Font, intArray: typing.List[int]): ...
    @staticmethod
    def decode(string: str) -> java.awt.Font: ...
    @staticmethod
    def encode(font: java.awt.Font) -> str: ...
    def getControls(self) -> java.awt.Component: ...
    def getValueString(self) -> str: ...
    @staticmethod
    def main(stringArray: typing.List[str]) -> None: ...
    def setLabelVisibile(self, boolean: bool) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...

class GlobalCommandTargetConfigurer(Configurer):
    @typing.overload
    def __init__(self, globalCommandTarget: VASSAL.counters.GlobalCommandTarget): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, globalCommandTarget: VASSAL.counters.GlobalCommandTarget): ...
    def getControls(self) -> java.awt.Component: ...
    def getTarget(self) -> VASSAL.counters.GlobalCommandTarget: ...
    def getValueString(self) -> str: ...
    def repack(self) -> None: ...
    def setFrozen(self, boolean: bool) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...

class HotKeyConfigurer(Configurer, java.awt.event.KeyListener):
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, keyStroke: javax.swing.KeyStroke): ...
    @staticmethod
    def decode(string: str) -> javax.swing.KeyStroke: ...
    @staticmethod
    def encode(keyStroke: javax.swing.KeyStroke) -> str: ...
    def getControls(self) -> java.awt.Component: ...
    @staticmethod
    def getString(keyStroke: javax.swing.KeyStroke) -> str: ...
    def getValueString(self) -> str: ...
    def keyPressed(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
    def keyReleased(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
    def keyToString(self) -> str: ...
    def keyTyped(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...

class IconConfigurer(Configurer):
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str): ...
    def getControls(self) -> java.awt.Component: ...
    def getIconValue(self) -> javax.swing.Icon: ...
    def getValueString(self) -> str: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...

class ImageSelector(Configurer, java.awt.event.ItemListener):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, int: int, int2: int): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str, int: int, int2: int): ...
    def getControls(self) -> java.awt.Component: ...
    def getImageName(self) -> str: ...
    def getValueString(self) -> str: ...
    def itemStateChanged(self, itemEvent: java.awt.event.ItemEvent) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...

class KeyModifiersConfigurer(Configurer, java.awt.event.KeyListener):
    def __init__(self, string: str, string2: str): ...
    def getControls(self) -> java.awt.Component: ...
    def getValueString(self) -> str: ...
    def keyPressed(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
    def keyReleased(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
    def keyTyped(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...

class KeyStrokeArrayConfigurer(Configurer):
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, keyStrokeArray: typing.List[javax.swing.KeyStroke]): ...
    @staticmethod
    def decode(string: str) -> typing.List[javax.swing.KeyStroke]: ...
    @staticmethod
    def encode(keyStrokeArray: typing.List[javax.swing.KeyStroke]) -> str: ...
    def getControls(self) -> java.awt.Component: ...
    def getKeyStrokes(self) -> typing.List[javax.swing.KeyStroke]: ...
    def getValueString(self) -> str: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...

class ListConfigurer(Configurer, java.beans.PropertyChangeListener):
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, list: java.util.List[typing.Any]): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getControls(self) -> java.awt.Component: ...
    def getListValue(self) -> java.util.List[typing.Any]: ...
    def getValueString(self) -> str: ...
    def hashCode(self) -> int: ...
    def propertyChange(self, propertyChangeEvent: java.beans.PropertyChangeEvent) -> None: ...
    def repack(self) -> None: ...
    def resize(self) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...

class MandatoryComponent(ValidityChecker):
    def __init__(self, abstractConfigurable: VASSAL.build.AbstractConfigurable, class_: typing.Type[typing.Any]): ...
    def validate(self, buildable: VASSAL.build.Buildable, validationReport: ValidationReport) -> None: ...

class NamedHotKeyConfigurer(Configurer, java.awt.event.FocusListener):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, namedKeyStroke: VASSAL.tools.NamedKeyStroke): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, namedKeyStroke: VASSAL.tools.NamedKeyStroke): ...
    def addFocusListener(self, focusListener: java.awt.event.FocusListener) -> None: ...
    @staticmethod
    def decode(string: str) -> VASSAL.tools.NamedKeyStroke: ...
    @staticmethod
    def encode(namedKeyStroke: VASSAL.tools.NamedKeyStroke) -> str: ...
    def focusGained(self, focusEvent: java.awt.event.FocusEvent) -> None: ...
    def focusLost(self, focusEvent: java.awt.event.FocusEvent) -> None: ...
    def getControls(self) -> java.awt.Component: ...
    @staticmethod
    def getFancyString(namedKeyStroke: VASSAL.tools.NamedKeyStroke) -> str: ...
    @typing.overload
    @staticmethod
    def getString(namedKeyStroke: VASSAL.tools.NamedKeyStroke) -> str: ...
    @typing.overload
    @staticmethod
    def getString(keyStroke: javax.swing.KeyStroke) -> str: ...
    def getValueNamedKeyStroke(self) -> VASSAL.tools.NamedKeyStroke: ...
    def getValueString(self) -> str: ...
    def isNamed(self) -> bool: ...
    def keyToString(self) -> str: ...
    def removeFocusListener(self, focusListener: java.awt.event.FocusListener) -> None: ...
    def requestFocus(self) -> None: ...
    def setHighlighted(self, boolean: bool) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...

class NamedKeyStrokeArrayConfigurer(Configurer, ConfigurableList):
    @typing.overload
    def __init__(self, namedKeyStrokeArray: typing.List[VASSAL.tools.NamedKeyStroke]): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, namedKeyStrokeArray: typing.List[VASSAL.tools.NamedKeyStroke]): ...
    @typing.overload
    def __init__(self, string: str, string2: str, list: java.util.List[VASSAL.tools.NamedKeyStroke]): ...
    def addEntry(self) -> None: ...
    @staticmethod
    def decode(string: str) -> typing.List[VASSAL.tools.NamedKeyStroke]: ...
    def deleteEntry(self, configurableListEntry: ConfigurableListEntry) -> None: ...
    @staticmethod
    def encode(namedKeyStrokeArray: typing.List[VASSAL.tools.NamedKeyStroke]) -> str: ...
    def entryChanged(self, configurableListEntry: ConfigurableListEntry) -> None: ...
    def getControls(self) -> java.awt.Component: ...
    def getKeyStrokes(self) -> typing.List[VASSAL.tools.NamedKeyStroke]: ...
    def getListController(self) -> javax.swing.JComponent: ...
    def getNameKeyStrokeArrayValue(self) -> typing.List[VASSAL.tools.NamedKeyStroke]: ...
    def getSelectedEntryIndex(self) -> int: ...
    def getValueString(self) -> str: ...
    def moveEntryDown(self) -> None: ...
    def moveEntryUp(self) -> None: ...
    def repack(self) -> None: ...
    def selectEntry(self, configurableListEntry: ConfigurableListEntry) -> None: ...
    def setSelectedEntryIndex(self, int: int) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...

class NotNullConfigureName(ValidityChecker):
    def __init__(self, abstractConfigurable: VASSAL.build.AbstractConfigurable): ...
    def validate(self, buildable: VASSAL.build.Buildable, validationReport: ValidationReport) -> None: ...

class PieceAccessConfigurer(Configurer):
    @typing.overload
    def __init__(self, pieceAccess: VASSAL.counters.PieceAccess): ...
    @typing.overload
    def __init__(self, string: str, string2: str, pieceAccess: VASSAL.counters.PieceAccess): ...
    @staticmethod
    def decode(string: str) -> VASSAL.counters.PieceAccess: ...
    @staticmethod
    def encode(pieceAccess: VASSAL.counters.PieceAccess) -> str: ...
    def getControls(self) -> java.awt.Component: ...
    def getPieceAccess(self) -> VASSAL.counters.PieceAccess: ...
    def getPrompts(self) -> typing.List[str]: ...
    def getValueString(self) -> str: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...

class SimpleConfigurer(Configurer, java.beans.PropertyChangeListener):
    def __init__(self, configurable: VASSAL.build.Configurable, configurerArray: typing.List[Configurer]): ...
    def getControls(self) -> java.awt.Component: ...
    def getValueString(self) -> str: ...
    def propertyChange(self, propertyChangeEvent: java.beans.PropertyChangeEvent) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...

class SingleChildInstance(ValidityChecker):
    def __init__(self, abstractConfigurable: VASSAL.build.AbstractConfigurable, class_: typing.Type[typing.Any]): ...
    def validate(self, buildable: VASSAL.build.Buildable, validationReport: ValidationReport) -> None: ...

class SoundConfigurer(Configurer):
    DEFAULT: typing.ClassVar[str] = ...
    def __init__(self, string: str, string2: str, string3: str): ...
    def chooseClip(self) -> None: ...
    def getControls(self) -> java.awt.Component: ...
    def getValueString(self) -> str: ...
    def play(self) -> None: ...
    def setLabelVisibile(self, boolean: bool) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...

class StringArrayConfigurer(Configurer, ConfigurableList):
    @typing.overload
    def __init__(self, object: typing.Any): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, object: typing.Any): ...
    def addEntry(self) -> None: ...
    def addFocusListener(self, focusListener: java.awt.event.FocusListener) -> None: ...
    def addValue(self, string: str) -> None: ...
    @staticmethod
    def arrayToString(stringArray: typing.List[str]) -> str: ...
    def buildChildConfigurer(self, object: typing.Any) -> Configurer: ...
    def deleteEntry(self, configurableListEntry: ConfigurableListEntry) -> None: ...
    def entryChanged(self, configurableListEntry: ConfigurableListEntry) -> None: ...
    def getControls(self) -> java.awt.Component: ...
    def getEntries(self) -> java.util.List['StringArrayConfigurer.StringEntry']: ...
    def getListController(self) -> javax.swing.JComponent: ...
    def getModel(self) -> javax.swing.DefaultListModel[str]: ...
    def getSelectedEntryIndex(self) -> int: ...
    def getStringArray(self) -> typing.List[str]: ...
    def getValueString(self) -> str: ...
    def moveEntryDown(self) -> None: ...
    def moveEntryUp(self) -> None: ...
    def removeFocusListener(self, focusListener: java.awt.event.FocusListener) -> None: ...
    def removeValue(self, string: str) -> None: ...
    def repack(self) -> None: ...
    def selectEntry(self, configurableListEntry: ConfigurableListEntry) -> None: ...
    def setHighlighted(self, boolean: bool) -> None: ...
    def setSelectedEntryIndex(self, int: int) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...
    @staticmethod
    def stringToArray(string: str) -> typing.List[str]: ...
    def updateViewable(self, int: int) -> None: ...
    class StringEntry: ...

class StringConfigurer(Configurer):
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int, string3: str, string4: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str): ...
    def addFocusListener(self, focusListener: java.awt.event.FocusListener) -> None: ...
    def getControls(self) -> java.awt.Component: ...
    def getValueString(self) -> str: ...
    def removeFocusListener(self, focusListener: java.awt.event.FocusListener) -> None: ...
    def requestFocus(self) -> None: ...
    def setHighlighted(self, boolean: bool) -> None: ...
    def setLabelVisibile(self, boolean: bool) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...
    def updateHint(self, string: str) -> None: ...

class StringEnumConfigurer(Configurer):
    def __init__(self, string: str, string2: str, stringArray: typing.List[str]): ...
    def getBox(self) -> javax.swing.JComboBox[str]: ...
    def getControls(self) -> java.awt.Component: ...
    def getValidValues(self) -> typing.List[str]: ...
    def getValueString(self) -> str: ...
    def isValidValue(self, object: typing.Any) -> bool: ...
    def setBox(self, jComboBox: javax.swing.JComboBox[str]) -> None: ...
    def setEditable(self, boolean: bool) -> None: ...
    def setEnabled(self, boolean: bool) -> None: ...
    def setLabelVisibile(self, boolean: bool) -> None: ...
    def setValidValues(self, stringArray: typing.List[str]) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...

class TableConfigurer(Configurer, java.awt.event.ActionListener):
    ADD_ACTION: typing.ClassVar[str] = ...
    DEL_ACTION: typing.ClassVar[str] = ...
    INS_ACTION: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, stringArray: typing.List[str], classArray: typing.List[typing.Type[typing.Any]]): ...
    def actionPerformed(self, actionEvent: java.awt.event.ActionEvent) -> None: ...
    def getColumnCount(self) -> int: ...
    def getControls(self) -> java.awt.Component: ...
    def getValueString(self) -> str: ...
    def setColDelimiter(self, char: str) -> None: ...
    def setRowDelimiter(self, char: str) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...

class TextConfigurer(Configurer, ConfigurerFactory):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str, boolean: bool): ...
    @staticmethod
    def escapeNewlines(string: str) -> str: ...
    def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> Configurer: ...
    def getControls(self) -> java.awt.Component: ...
    def getValueString(self) -> str: ...
    @staticmethod
    def restoreNewlines(string: str) -> str: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...
    def setWordWrap(self, boolean: bool) -> None: ...

class TranslatableStringEnum(StringEnum):
    def __init__(self): ...
    def getI18nKeys(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
    def isDisplayNames(self) -> bool: ...

class TranslatingStringEnumConfigurer(Configurer):
    @typing.overload
    def __init__(self, string: str, string2: str, stringArray: typing.List[str], stringArray2: typing.List[str]): ...
    @typing.overload
    def __init__(self, string: str, string2: str, stringArray: typing.List[str], stringArray2: typing.List[str], boolean: bool): ...
    @typing.overload
    def __init__(self, string: str, string2: str, stringArray: typing.List[str], stringArray2: typing.List[str], char: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, stringArray: typing.List[str], stringArray2: typing.List[str], string5: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, stringArray: typing.List[str], stringArray2: typing.List[str], string5: str, boolean: bool): ...
    @typing.overload
    def __init__(self, string: str, string2: str, list: java.util.List[str], list2: java.util.List[str]): ...
    @typing.overload
    def __init__(self, string: str, string2: str, list: java.util.List[str], list2: java.util.List[str], boolean: bool): ...
    @typing.overload
    def __init__(self, string: str, string2: str, list: java.util.List[str], list2: java.util.List[str], string3: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, list: java.util.List[str], list2: java.util.List[str], string3: str, boolean: bool): ...
    @typing.overload
    def __init__(self, stringArray: typing.List[str], stringArray2: typing.List[str]): ...
    @typing.overload
    def __init__(self, stringArray: typing.List[str], stringArray2: typing.List[str], boolean: bool): ...
    @typing.overload
    def __init__(self, stringArray: typing.List[str], stringArray2: typing.List[str], char: str): ...
    @typing.overload
    def __init__(self, stringArray: typing.List[str], stringArray2: typing.List[str], string3: str): ...
    @typing.overload
    def __init__(self, list: java.util.List[str], list2: java.util.List[str]): ...
    @typing.overload
    def __init__(self, list: java.util.List[str], list2: java.util.List[str], string: str): ...
    def getControls(self) -> java.awt.Component: ...
    def getSelectedIndex(self) -> int: ...
    def getValidValues(self) -> typing.List[str]: ...
    def getValueIndex(self, object: typing.Any) -> int: ...
    def getValueString(self) -> str: ...
    def isDisplayNames(self) -> bool: ...
    def isValidValue(self, object: typing.Any) -> bool: ...
    def setDisplayNames(self, boolean: bool) -> None: ...
    def setEditable(self, boolean: bool) -> None: ...
    def setEnabled(self, boolean: bool) -> None: ...
    def setLabelVisibile(self, boolean: bool) -> None: ...
    def setValidValues(self, stringArray: typing.List[str], stringArray2: typing.List[str]) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...

class AudioClipConfigurer(FileConfigurer):
    def __init__(self, string: str, string2: str, archiveWriter: VASSAL.tools.ArchiveWriter): ...
    def getControls(self) -> java.awt.Component: ...

class BeanShellExpressionConfigurer(StringConfigurer):
    @typing.overload
    def __init__(self, string: str, gamePiece: VASSAL.counters.GamePiece): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str, gamePiece: VASSAL.counters.GamePiece): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str, gamePiece: VASSAL.counters.GamePiece, option: 'BeanShellExpressionConfigurer.Option'): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str, gamePiece: VASSAL.counters.GamePiece, option: 'BeanShellExpressionConfigurer.Option', functionBuilder: VASSAL.script.expression.FunctionBuilder): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str, gamePiece: VASSAL.counters.GamePiece, option: 'BeanShellExpressionConfigurer.Option', boolean: bool): ...
    def getControls(self) -> java.awt.Component: ...
    def getOption(self) -> 'BeanShellExpressionConfigurer.Option': ...
    def getSelectedText(self) -> str: ...
    def getValueString(self) -> str: ...
    def isDisplayOnly(self) -> bool: ...
    def setDisplayOnly(self, boolean: bool) -> None: ...
    def setSelectedText(self, string: str) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    def validate(self) -> None: ...
    class Option(java.lang.Enum['BeanShellExpressionConfigurer.Option']):
        NONE: typing.ClassVar['BeanShellExpressionConfigurer.Option'] = ...
        PME: typing.ClassVar['BeanShellExpressionConfigurer.Option'] = ...
        _valueOf_1__T = typing.TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(string: str) -> 'BeanShellExpressionConfigurer.Option': ...
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @staticmethod
        def values() -> typing.List['BeanShellExpressionConfigurer.Option']: ...

class DirectoryConfigurer(FileConfigurer):
    def __init__(self, string: str, string2: str): ...
    def chooseNewValue(self) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...

class DoubleConfigurer(StringConfigurer):
    @typing.overload
    def __init__(self, double: float): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, double: float): ...
    def getValueString(self) -> str: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...

class FormattedStringArrayConfigurer(StringArrayConfigurer):
    @typing.overload
    def __init__(self, constraints: VASSAL.build.module.properties.PropertyChangerConfigurer.Constraints): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, constraints: VASSAL.build.module.properties.PropertyChangerConfigurer.Constraints): ...
    @typing.overload
    def __init__(self, string: str, string2: str, gamePiece: VASSAL.counters.GamePiece): ...
    @typing.overload
    def __init__(self, string: str, string2: str, object: typing.Any): ...
    def buildChildConfigurer(self, object: typing.Any) -> Configurer: ...

class FormattedStringConfigurer(StringConfigurer, java.awt.event.ActionListener, java.awt.event.FocusListener):
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, stringArray: typing.List[str]): ...
    @typing.overload
    def __init__(self, stringArray: typing.List[str]): ...
    def actionPerformed(self, actionEvent: java.awt.event.ActionEvent) -> None: ...
    def focusGained(self, focusEvent: java.awt.event.FocusEvent) -> None: ...
    def focusLost(self, focusEvent: java.awt.event.FocusEvent) -> None: ...
    def getControls(self) -> java.awt.Component: ...
    def getOptions(self) -> typing.List[str]: ...
    def setOptions(self, stringArray: typing.List[str]) -> None: ...

class ImageConfigurer(FileConfigurer):
    def __init__(self, string: str, string2: str, archiveWriter: VASSAL.tools.ArchiveWriter): ...

class IntConfigurer(StringConfigurer):
    @typing.overload
    def __init__(self, integer: int): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, integer: int): ...
    def getIntValue(self, int: int) -> int: ...
    def getValueString(self) -> str: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...

class LongConfigurer(StringConfigurer):
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, long: int): ...
    def getLongValue(self, long: int) -> int: ...
    def getValueString(self) -> str: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...

class PasswordConfigurer(StringConfigurer):
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str): ...

class FlareFormattedStringConfigurer(FormattedStringConfigurer):
    def __init__(self, string: str, string2: str, stringArray: typing.List[str]): ...

class FormattedExpressionConfigurer(FormattedStringConfigurer):
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, constraints: VASSAL.build.module.properties.PropertyChangerConfigurer.Constraints): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: VASSAL.counters.GamePiece): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, formattedString: VASSAL.tools.FormattedString): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str, constraints: VASSAL.build.module.properties.PropertyChangerConfigurer.Constraints): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str, editablePiece: VASSAL.counters.EditablePiece): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str, gamePiece: VASSAL.counters.GamePiece): ...
    @typing.overload
    def __init__(self, string: str, string2: str, stringArray: typing.List[str]): ...
    def getControls(self) -> java.awt.Component: ...
    class ExpressionButton(javax.swing.JButton, java.awt.event.ActionListener):
        @typing.overload
        def __init__(self, configurer: Configurer, int: int): ...
        @typing.overload
        def __init__(self, configurer: Configurer, int: int, editablePiece: VASSAL.counters.EditablePiece): ...
        def actionPerformed(self, actionEvent: java.awt.event.ActionEvent) -> None: ...
        @typing.overload
        def setSize(self, int: int) -> None: ...
        @typing.overload
        def setSize(self, int: int, int2: int) -> None: ...
        @typing.overload
        def setSize(self, dimension: java.awt.Dimension) -> None: ...

class GamePieceFormattedStringConfigurer(FormattedStringConfigurer):
    def __init__(self, string: str, string2: str): ...

class PlayerIdFormattedStringConfigurer(FormattedStringConfigurer):
    @typing.overload
    def __init__(self, string: str, string2: str, stringArray: typing.List[str]): ...
    @typing.overload
    def __init__(self, stringArray: typing.List[str], string2: str): ...

class DeckSelectionConfigurer(FormattedExpressionConfigurer):
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, gamePiece: VASSAL.counters.GamePiece): ...
    def getControls(self) -> java.awt.Component: ...
    def showPopup(self) -> None: ...

class PropertyExpressionConfigurer(FormattedExpressionConfigurer):
    @typing.overload
    def __init__(self, propertyExpression: PropertyExpression): ...
    @typing.overload
    def __init__(self, propertyExpression: PropertyExpression, gamePiece: VASSAL.counters.GamePiece): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, propertyExpression: PropertyExpression): ...
    @typing.overload
    def __init__(self, string: str, string2: str, propertyExpression: PropertyExpression, gamePiece: VASSAL.counters.GamePiece): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str, gamePiece: VASSAL.counters.GamePiece): ...
    class PropertyExpressionButton(FormattedExpressionConfigurer.ExpressionButton):
        def __init__(self, configurer: Configurer, int: int, editablePiece: VASSAL.counters.EditablePiece): ...
        def actionPerformed(self, actionEvent: java.awt.event.ActionEvent) -> None: ...

class PropertyNameExpressionConfigurer(FormattedExpressionConfigurer):
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, propertyExpression: PropertyExpression): ...
    @typing.overload
    def __init__(self, string: str, string2: str, propertyExpression: PropertyExpression, gamePiece: VASSAL.counters.GamePiece): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str, gamePiece: VASSAL.counters.GamePiece): ...
    class PropertyNameExpressionButton(FormattedExpressionConfigurer.ExpressionButton):
        def __init__(self, configurer: Configurer, int: int, editablePiece: VASSAL.counters.EditablePiece): ...
        def actionPerformed(self, actionEvent: java.awt.event.ActionEvent) -> None: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("VASSAL.configure")``.

    AbstractConfigurableListEntry: typing.Type[AbstractConfigurableListEntry]
    AudioClipConfigurer: typing.Type[AudioClipConfigurer]
    AutoConfigurer: typing.Type[AutoConfigurer]
    BeanShellExpressionConfigurer: typing.Type[BeanShellExpressionConfigurer]
    BeanShellFunctionMenu: typing.Type[BeanShellFunctionMenu]
    BooleanConfigurer: typing.Type[BooleanConfigurer]
    ChooseComponentDialog: typing.Type[ChooseComponentDialog]
    ChooseComponentPathDialog: typing.Type[ChooseComponentPathDialog]
    ColorConfigurer: typing.Type[ColorConfigurer]
    ComponentConfigPanel: typing.Type[ComponentConfigPanel]
    ComponentLayout: typing.Type[ComponentLayout]
    CompoundValidityChecker: typing.Type[CompoundValidityChecker]
    ConfigurableList: typing.Type[ConfigurableList]
    ConfigurableListController: typing.Type[ConfigurableListController]
    ConfigurableListEntry: typing.Type[ConfigurableListEntry]
    ConfigureTree: typing.Type[ConfigureTree]
    Configurer: typing.Type[Configurer]
    ConfigurerFactory: typing.Type[ConfigurerFactory]
    ConfigurerLayout: typing.Type[ConfigurerLayout]
    ConfigurerPanel: typing.Type[ConfigurerPanel]
    ConfigurerWindow: typing.Type[ConfigurerWindow]
    DeckSelectionConfigurer: typing.Type[DeckSelectionConfigurer]
    DirectoryConfigurer: typing.Type[DirectoryConfigurer]
    DoubleConfigurer: typing.Type[DoubleConfigurer]
    DynamicKeyCommandConfigurer: typing.Type[DynamicKeyCommandConfigurer]
    DynamicKeyCommandListConfigurer: typing.Type[DynamicKeyCommandListConfigurer]
    EditContainedPiecesAction: typing.Type[EditContainedPiecesAction]
    EditPropertiesAction: typing.Type[EditPropertiesAction]
    ExtensionTree: typing.Type[ExtensionTree]
    FileConfigurer: typing.Type[FileConfigurer]
    FlareFormattedStringConfigurer: typing.Type[FlareFormattedStringConfigurer]
    FontConfigurer: typing.Type[FontConfigurer]
    FormattedExpressionConfigurer: typing.Type[FormattedExpressionConfigurer]
    FormattedStringArrayConfigurer: typing.Type[FormattedStringArrayConfigurer]
    FormattedStringConfigurer: typing.Type[FormattedStringConfigurer]
    GamePieceFormattedStringConfigurer: typing.Type[GamePieceFormattedStringConfigurer]
    GlobalCommandTargetConfigurer: typing.Type[GlobalCommandTargetConfigurer]
    HintTextField: typing.Type[HintTextField]
    HotKeyConfigurer: typing.Type[HotKeyConfigurer]
    IconConfigurer: typing.Type[IconConfigurer]
    ImageConfigurer: typing.Type[ImageConfigurer]
    ImageSelector: typing.Type[ImageSelector]
    IntConfigurer: typing.Type[IntConfigurer]
    KeyModifiersConfigurer: typing.Type[KeyModifiersConfigurer]
    KeyStrokeArrayConfigurer: typing.Type[KeyStrokeArrayConfigurer]
    ListConfigurer: typing.Type[ListConfigurer]
    LongConfigurer: typing.Type[LongConfigurer]
    MandatoryComponent: typing.Type[MandatoryComponent]
    NamedHotKeyConfigurer: typing.Type[NamedHotKeyConfigurer]
    NamedKeyStrokeArrayConfigurer: typing.Type[NamedKeyStrokeArrayConfigurer]
    NoInsetButton: typing.Type[NoInsetButton]
    NotNullConfigureName: typing.Type[NotNullConfigureName]
    PasswordConfigurer: typing.Type[PasswordConfigurer]
    PieceAccessConfigurer: typing.Type[PieceAccessConfigurer]
    PlayerIdFormattedStringConfigurer: typing.Type[PlayerIdFormattedStringConfigurer]
    PropertiesWindow: typing.Type[PropertiesWindow]
    PropertyExpression: typing.Type[PropertyExpression]
    PropertyExpressionConfigurer: typing.Type[PropertyExpressionConfigurer]
    PropertyNameExpressionConfigurer: typing.Type[PropertyNameExpressionConfigurer]
    RefreshPredefinedSetupsDialog: typing.Type[RefreshPredefinedSetupsDialog]
    RemoveUnusedImagesDialog: typing.Type[RemoveUnusedImagesDialog]
    SaveAction: typing.Type[SaveAction]
    SaveAsAction: typing.Type[SaveAsAction]
    SavedGameUpdaterDialog: typing.Type[SavedGameUpdaterDialog]
    ShowHelpAction: typing.Type[ShowHelpAction]
    SimpleConfigurer: typing.Type[SimpleConfigurer]
    SingleChildInstance: typing.Type[SingleChildInstance]
    SoundConfigurer: typing.Type[SoundConfigurer]
    StringArrayConfigurer: typing.Type[StringArrayConfigurer]
    StringConfigurer: typing.Type[StringConfigurer]
    StringEnum: typing.Type[StringEnum]
    StringEnumConfigurer: typing.Type[StringEnumConfigurer]
    TableConfigurer: typing.Type[TableConfigurer]
    TextConfigurer: typing.Type[TextConfigurer]
    TranslatableStringEnum: typing.Type[TranslatableStringEnum]
    TranslatingStringEnumConfigurer: typing.Type[TranslatingStringEnumConfigurer]
    ValidationReport: typing.Type[ValidationReport]
    ValidationReportDialog: typing.Type[ValidationReportDialog]
    ValidityChecker: typing.Type[ValidityChecker]
    VisibilityCondition: typing.Type[VisibilityCondition]
    password: VASSAL.configure.password.__module_protocol__
