import VASSAL
import VASSAL.build.module.map
import VASSAL.counters
import java.awt
import java.util
import typing



class ChangeTracker:
    def __init__(self, gamePiece: VASSAL.counters.GamePiece): ...
    def getChangeCommand(self) -> 'Command': ...
    def isChanged(self) -> bool: ...

class Command:
    def __init__(self): ...
    def append(self, command: 'Command') -> 'Command': ...
    def execute(self) -> None: ...
    def getDetails(self) -> str: ...
    def getSubCommands(self) -> typing.List['Command']: ...
    def getUndoCommand(self) -> 'Command': ...
    def isLoggable(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isNullOrContainsOnly(self, class_: typing.Type[typing.Any]) -> bool: ...
    def stripSubCommands(self) -> None: ...
    def toString(self) -> str: ...

class CommandEncoder:
    def decode(self, string: str) -> Command: ...
    def encode(self, command: Command) -> str: ...

class CommandFilter:
    def __init__(self): ...
    def apply(self, command: Command) -> Command: ...

class Logger:
    def log(self, command: Command) -> None: ...

class MoveTracker:
    def __init__(self, gamePiece: VASSAL.counters.GamePiece): ...
    def getMoveCommand(self) -> Command: ...

class AddPiece(Command):
    @typing.overload
    def __init__(self, gamePiece: VASSAL.counters.GamePiece): ...
    @typing.overload
    def __init__(self, gamePiece: VASSAL.counters.GamePiece, string: str): ...
    def getState(self) -> str: ...
    def getTarget(self) -> VASSAL.counters.GamePiece: ...

class AlertCommand(Command):
    def __init__(self, string: str): ...
    def getMessage(self) -> str: ...

class ChangePiece(Command):
    def __init__(self, string: str, string2: str, string3: str): ...
    def append(self, command: Command) -> Command: ...
    def getDetails(self) -> str: ...
    def getId(self) -> str: ...
    def getNewState(self) -> str: ...
    def getOldState(self) -> str: ...
    def isNull(self) -> bool: ...

class FlareCommand(Command):
    def __init__(self, flare: VASSAL.build.module.map.Flare): ...
    def getClickPoint(self) -> java.awt.Point: ...
    def getId(self) -> str: ...
    def getValue(self) -> int: ...

class MovePiece(Command):
    def __init__(self, string: str, string2: str, point: java.awt.Point, string3: str, string4: str, point2: java.awt.Point, string5: str, string6: str): ...
    def getDetails(self) -> str: ...
    def getId(self) -> str: ...
    def getNewMapId(self) -> str: ...
    def getNewPosition(self) -> java.awt.Point: ...
    def getNewUnderneathId(self) -> str: ...
    def getOldMapId(self) -> str: ...
    def getOldPosition(self) -> java.awt.Point: ...
    def getOldUnderneathId(self) -> str: ...
    def getPlayerId(self) -> str: ...

class NullCommand(Command):
    def __init__(self): ...
    def isNull(self) -> bool: ...

class PlayAudioClipCommand(Command):
    COMMAND_PREFIX: typing.ClassVar[str] = ...
    def __init__(self, string: str): ...
    @staticmethod
    def decode(string: str) -> 'PlayAudioClipCommand': ...
    def encode(self) -> str: ...

class RemovePiece(Command):
    @typing.overload
    def __init__(self, gamePiece: VASSAL.counters.GamePiece): ...
    @typing.overload
    def __init__(self, string: str): ...
    def getId(self) -> str: ...
    def getTarget(self) -> VASSAL.counters.GamePiece: ...

class SetPersistentPropertyCommand(Command):
    COMMAND_PREFIX: typing.ClassVar[str] = ...
    def __init__(self, string: str, object: typing.Any, object2: typing.Any, object3: typing.Any): ...
    def getDetails(self) -> str: ...
    def getId(self) -> str: ...
    def getKey(self) -> typing.Any: ...
    def getNewValue(self) -> typing.Any: ...
    def getOldValue(self) -> typing.Any: ...
    def setId(self, string: str) -> None: ...
    def setKey(self, object: typing.Any) -> None: ...
    def setNewValue(self, object: typing.Any) -> None: ...
    def setOldValue(self, object: typing.Any) -> None: ...

class ConditionalCommand(Command):
    def __init__(self, conditionArray: typing.List['ConditionalCommand.Condition'], command: Command): ...
    def getConditions(self) -> typing.List['ConditionalCommand.Condition']: ...
    def getDelegate(self) -> Command: ...
    class Condition:
        def __init__(self): ...
        def isSatisfied(self) -> bool: ...
    class Eq(VASSAL.command.ConditionalCommand.Condition):
        @typing.overload
        def __init__(self, string: str, list: java.util.List[str]): ...
        @typing.overload
        def __init__(self, string: str, vector: java.util.Vector[str]): ...
        def getProperty(self) -> str: ...
        def getValueList(self) -> java.util.List[str]: ...
        def isSatisfied(self) -> bool: ...
    class Gt(VASSAL.command.ConditionalCommand.Condition):
        def __init__(self, string: str, string2: str): ...
        def getProperty(self) -> str: ...
        def getValue(self) -> str: ...
        def isSatisfied(self) -> bool: ...
    class Lt(VASSAL.command.ConditionalCommand.Condition):
        def __init__(self, string: str, string2: str): ...
        def getProperty(self) -> str: ...
        def getValue(self) -> str: ...
        def isSatisfied(self) -> bool: ...
    class Not(VASSAL.command.ConditionalCommand.Condition):
        def __init__(self, condition: 'ConditionalCommand.Condition'): ...
        def getSubCondition(self) -> 'ConditionalCommand.Condition': ...
        def isSatisfied(self) -> bool: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("VASSAL.command")``.

    AddPiece: typing.Type[AddPiece]
    AlertCommand: typing.Type[AlertCommand]
    ChangePiece: typing.Type[ChangePiece]
    ChangeTracker: typing.Type[ChangeTracker]
    Command: typing.Type[Command]
    CommandEncoder: typing.Type[CommandEncoder]
    CommandFilter: typing.Type[CommandFilter]
    ConditionalCommand: typing.Type[ConditionalCommand]
    FlareCommand: typing.Type[FlareCommand]
    Logger: typing.Type[Logger]
    MovePiece: typing.Type[MovePiece]
    MoveTracker: typing.Type[MoveTracker]
    NullCommand: typing.Type[NullCommand]
    PlayAudioClipCommand: typing.Type[PlayAudioClipCommand]
    RemovePiece: typing.Type[RemovePiece]
    SetPersistentPropertyCommand: typing.Type[SetPersistentPropertyCommand]
