import VASSAL.chat
import VASSAL.chat.messageboard
import VASSAL.chat.ui
import VASSAL.command
import java.beans
import java.lang
import java.net
import java.util
import typing



class ConnectionLimiter:
    def __init__(self): ...
    def register(self, string: str, socketHandler: 'SocketHandler') -> None: ...

class LockWatcher(java.lang.Thread):
    def __init__(self, long: int, long2: int, int: int): ...
    def run(self) -> None: ...

class LockableNodeRoomControls(VASSAL.chat.ui.LockableRoomControls):
    def __init__(self, nodeClient: 'NodeClient'): ...

class MsgSender:
    def send(self, string: str) -> None: ...

class NodeClientFactory(VASSAL.chat.ChatServerFactory):
    NODE_TYPE: typing.ClassVar[str] = ...
    NODE_HOST: typing.ClassVar[str] = ...
    NODE_PORT: typing.ClassVar[str] = ...
    def __init__(self): ...
    def buildServer(self, properties: java.util.Properties) -> VASSAL.chat.ChatServerConnection: ...

class NodePlayer(VASSAL.chat.SimplePlayer):
    ID: typing.ClassVar[str] = ...
    def __init__(self, string: str): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getId(self) -> str: ...
    def hashCode(self) -> int: ...
    def setInfo(self, properties: java.util.Properties) -> None: ...
    def toProperties(self) -> java.util.Properties: ...

class NodeRoom(VASSAL.chat.SimpleRoom, VASSAL.chat.LockableRoom):
    OWNER: typing.ClassVar[str] = ...
    MEMBERS: typing.ClassVar[str] = ...
    STATUS: typing.ClassVar[str] = ...
    LOCKED: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, playerArray: typing.List[VASSAL.chat.Player]): ...
    def getInfo(self) -> java.util.Properties: ...
    def getMembers(self) -> typing.List[str]: ...
    def getOwner(self) -> str: ...
    def getOwningPlayer(self) -> VASSAL.chat.Player: ...
    def isLocked(self) -> bool: ...
    def isMember(self, nodePlayer: NodePlayer) -> bool: ...
    @typing.overload
    def isOwner(self, nodePlayer: NodePlayer) -> bool: ...
    @typing.overload
    def isOwner(self, string: str) -> bool: ...
    def lock(self) -> None: ...
    def setInfo(self, properties: java.util.Properties) -> None: ...
    def setMembersToCurrentPlayers(self) -> None: ...
    def setOwner(self, string: str) -> None: ...
    def toggleLock(self) -> None: ...

class Protocol:
    REGISTER: typing.ClassVar[str] = ...
    REG_REQUEST: typing.ClassVar[str] = ...
    JOIN: typing.ClassVar[str] = ...
    FORWARD: typing.ClassVar[str] = ...
    STATS: typing.ClassVar[str] = ...
    LIST: typing.ClassVar[str] = ...
    CONTENTS: typing.ClassVar[str] = ...
    NODE_INFO: typing.ClassVar[str] = ...
    ROOM_INFO: typing.ClassVar[str] = ...
    LOGIN: typing.ClassVar[str] = ...
    KICK: typing.ClassVar[str] = ...
    def __init__(self): ...
    @staticmethod
    def decodeForwardCommand(string: str) -> typing.List[str]: ...
    @staticmethod
    def decodeJoinCommand(string: str) -> typing.List[str]: ...
    @staticmethod
    def decodeKickCommand(string: str) -> typing.List[str]: ...
    @staticmethod
    def decodeListCommand(string: str) -> 'Node': ...
    @staticmethod
    def decodeLoginCommand(string: str) -> str: ...
    @staticmethod
    def decodeNodeInfoCommand(string: str) -> typing.List[str]: ...
    @staticmethod
    def decodeRegisterCommand(string: str) -> typing.List[str]: ...
    @staticmethod
    def decodeRegisterRequest(string: str) -> bool: ...
    @staticmethod
    def decodeRoomsInfo(string: str) -> java.util.Properties: ...
    @staticmethod
    def decodeStatsCommand(string: str) -> typing.List[str]: ...
    @staticmethod
    def encodeForwardCommand(string: str, string2: str) -> str: ...
    @typing.overload
    @staticmethod
    def encodeJoinCommand(string: str) -> str: ...
    @typing.overload
    @staticmethod
    def encodeJoinCommand(string: str, string2: str) -> str: ...
    @staticmethod
    def encodeKickCommand(string: str) -> str: ...
    @staticmethod
    def encodeListCommand(nodeArray: typing.List['Node']) -> str: ...
    @staticmethod
    def encodeLoginCommand(string: str) -> str: ...
    @staticmethod
    def encodeNodeInfoCommand(node: 'Node') -> str: ...
    @staticmethod
    def encodeRegisterCommand(string: str, string2: str, string3: str) -> str: ...
    @staticmethod
    def encodeRegisterRequest() -> str: ...
    @staticmethod
    def encodeRoomsInfo(nodeArray: typing.List['Node']) -> str: ...
    @staticmethod
    def encodeStatsCommand(string: str) -> str: ...

class Server(java.lang.Thread):
    def __init__(self, asynchronousServerNode: 'AsynchronousServerNode', int: int): ...
    @staticmethod
    def main(stringArray: typing.List[str]) -> None: ...
    def run(self) -> None: ...

class SocketHandler:
    def __init__(self, socket: java.net.Socket, socketWatcher: 'SocketWatcher'): ...
    def close(self) -> None: ...
    def getInetAddress(self) -> java.net.InetAddress: ...
    def start(self) -> None: ...
    def writeLine(self, string: str) -> None: ...

class SocketWatcher:
    def handleMessage(self, string: str) -> None: ...
    def socketClosed(self, socketHandler: SocketHandler) -> None: ...

class StatusReporter(java.lang.Runnable):
    def __init__(self, httpRequestWrapper: VASSAL.chat.HttpRequestWrapper, asynchronousServerNode: 'AsynchronousServerNode'): ...
    def run(self) -> None: ...
    def updateContents(self, nodeArray: typing.List['Node']) -> None: ...

class Node(MsgSender):
    def __init__(self, node: 'Node', string: str, string2: str): ...
    def add(self, node: 'Node') -> None: ...
    @staticmethod
    def build(node: 'Node', string: str) -> 'Node': ...
    def buildWithInfo(self, node: 'Node', string: str) -> 'Node': ...
    def equals(self, object: typing.Any) -> bool: ...
    def getChild(self, string: str) -> 'Node': ...
    def getChildren(self) -> typing.List['Node']: ...
    def getDescendant(self, string: str) -> 'Node': ...
    def getId(self) -> str: ...
    def getInfo(self) -> str: ...
    def getInfoProperty(self, string: str) -> str: ...
    def getLeafDescendants(self) -> typing.List['Node']: ...
    def getParent(self) -> 'Node': ...
    def getPath(self) -> str: ...
    def getPathAndInfo(self) -> str: ...
    def hashCode(self) -> int: ...
    def isLeaf(self) -> bool: ...
    def remove(self, node: 'Node') -> None: ...
    def send(self, string: str) -> None: ...
    def setInfo(self, string: str) -> None: ...
    def setParent(self, node: 'Node') -> None: ...
    def toString(self) -> str: ...

class NodeClient(VASSAL.chat.LockableChatServerConnection, VASSAL.chat.PlayerEncoder, VASSAL.chat.ui.ChatControlsInitializer, SocketWatcher):
    ZIP_HEADER: typing.ClassVar[str] = ...
    def __init__(self, string: str, string2: str, commandEncoder: VASSAL.command.CommandEncoder, string3: str, int: int, welcomeMessageServer: typing.Union[VASSAL.chat.WelcomeMessageServer, typing.Callable]): ...
    @typing.overload
    def addPropertyChangeListener(self, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    @typing.overload
    def addPropertyChangeListener(self, string: str, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def doInvite(self, string: str, string2: str) -> None: ...
    def doKick(self, player: VASSAL.chat.Player) -> None: ...
    def forward(self, string: str, string2: str) -> None: ...
    def getAvailableRooms(self) -> typing.List[VASSAL.chat.Room]: ...
    def getDefaultRoomName(self) -> str: ...
    def getMyInfo(self) -> NodePlayer: ...
    def getRoom(self) -> VASSAL.chat.Room: ...
    def getUserInfo(self) -> VASSAL.chat.Player: ...
    def handleMessage(self, string: str) -> None: ...
    def handleMessageFromServer(self, string: str) -> None: ...
    def initializeControls(self, chatServerControls: VASSAL.chat.ui.ChatServerControls) -> None: ...
    def isConnected(self) -> bool: ...
    def isDefaultRoom(self, room: VASSAL.chat.Room) -> bool: ...
    def isInvitable(self, player: VASSAL.chat.Player) -> bool: ...
    def isKickable(self, player: VASSAL.chat.Player) -> bool: ...
    def lockRoom(self, lockableRoom: VASSAL.chat.LockableRoom) -> None: ...
    def playerToString(self, player: VASSAL.chat.Player) -> str: ...
    def send(self, string: str) -> None: ...
    def sendInvite(self, player: VASSAL.chat.Player) -> None: ...
    def sendRoomInfo(self, nodeRoom: NodeRoom) -> None: ...
    def sendTo(self, player: VASSAL.chat.Player, command: VASSAL.command.Command) -> None: ...
    def sendToAll(self, string: str) -> None: ...
    @typing.overload
    def sendToOthers(self, command: VASSAL.command.Command) -> None: ...
    @typing.overload
    def sendToOthers(self, string: str) -> None: ...
    def setConnected(self, boolean: bool) -> None: ...
    def setDefaultRoomName(self, string: str) -> None: ...
    @typing.overload
    def setRoom(self, room: VASSAL.chat.Room) -> None: ...
    @typing.overload
    def setRoom(self, room: VASSAL.chat.Room, string: str) -> None: ...
    def setUserInfo(self, player: VASSAL.chat.Player) -> None: ...
    def socketClosed(self, socketHandler: SocketHandler) -> None: ...
    def stringToPlayer(self, string: str) -> VASSAL.chat.Player: ...
    def uninitializeControls(self, chatServerControls: VASSAL.chat.ui.ChatServerControls) -> None: ...

class OfficialNodeClientFactory(NodeClientFactory):
    OFFICIAL_TYPE: typing.ClassVar[str] = ...
    OFFICIAL_HOST: typing.ClassVar[str] = ...
    OFFICIAL_PORT: typing.ClassVar[str] = ...
    def __init__(self): ...

class PrivateNodeClientFactory(NodeClientFactory):
    PRIVATE_TYPE: typing.ClassVar[str] = ...
    PRIVATE_HOST: typing.ClassVar[str] = ...
    PRIVATE_PORT: typing.ClassVar[str] = ...
    def __init__(self): ...

class OfficialNodeClient(NodeClient):
    def __init__(self, string: str, string2: str, commandEncoder: VASSAL.command.CommandEncoder, string3: str, int: int, messageBoard: VASSAL.chat.messageboard.MessageBoard, welcomeMessageServer: typing.Union[VASSAL.chat.WelcomeMessageServer, typing.Callable]): ...
    def initializeControls(self, chatServerControls: VASSAL.chat.ui.ChatServerControls) -> None: ...
    def uninitializeControls(self, chatServerControls: VASSAL.chat.ui.ChatServerControls) -> None: ...

class PlayerNode(Node, SocketWatcher):
    def __init__(self, socket: java.net.Socket, asynchronousServerNode: 'AsynchronousServerNode'): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getId(self) -> str: ...
    def getInfo(self) -> str: ...
    def handleMessage(self, string: str) -> None: ...
    def hashCode(self) -> int: ...
    def isLeaf(self) -> bool: ...
    def send(self, string: str) -> None: ...
    def socketClosed(self, socketHandler: SocketHandler) -> None: ...

class PrivateNodeClient(NodeClient):
    def __init__(self, string: str, string2: str, commandEncoder: VASSAL.command.CommandEncoder, string3: str, int: int): ...

class ServerNode(Node):
    def __init__(self): ...
    def disconnect(self, node: Node) -> None: ...
    def forward(self, string: str, string2: str) -> None: ...
    def getModule(self, node: Node) -> Node: ...
    def getMsgSender(self, string: str) -> MsgSender: ...
    def kick(self, playerNode: PlayerNode, string: str) -> None: ...
    def move(self, node: Node, string: str) -> None: ...
    def registerNode(self, string: str, node: Node) -> None: ...
    def updateInfo(self, node: Node) -> None: ...

class AsynchronousServerNode(ServerNode):
    def __init__(self, string: str): ...
    class ReportContentsThread(java.lang.Thread):
        def __init__(self, asynchronousServerNode: 'AsynchronousServerNode'): ...
        def markChanged(self, node: Node) -> None: ...
        def run(self) -> None: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("VASSAL.chat.node")``.

    AsynchronousServerNode: typing.Type[AsynchronousServerNode]
    ConnectionLimiter: typing.Type[ConnectionLimiter]
    LockWatcher: typing.Type[LockWatcher]
    LockableNodeRoomControls: typing.Type[LockableNodeRoomControls]
    MsgSender: typing.Type[MsgSender]
    Node: typing.Type[Node]
    NodeClient: typing.Type[NodeClient]
    NodeClientFactory: typing.Type[NodeClientFactory]
    NodePlayer: typing.Type[NodePlayer]
    NodeRoom: typing.Type[NodeRoom]
    OfficialNodeClient: typing.Type[OfficialNodeClient]
    OfficialNodeClientFactory: typing.Type[OfficialNodeClientFactory]
    PlayerNode: typing.Type[PlayerNode]
    PrivateNodeClient: typing.Type[PrivateNodeClient]
    PrivateNodeClientFactory: typing.Type[PrivateNodeClientFactory]
    Protocol: typing.Type[Protocol]
    Server: typing.Type[Server]
    ServerNode: typing.Type[ServerNode]
    SocketHandler: typing.Type[SocketHandler]
    SocketWatcher: typing.Type[SocketWatcher]
    StatusReporter: typing.Type[StatusReporter]
