import VASSAL.build
import VASSAL.build.module
import VASSAL.build.module.documentation
import VASSAL.configure
import VASSAL.counters
import VASSAL.i18n
import java.awt
import java.awt.event
import java.beans
import java.util
import javax.swing
import javax.swing.event
import javax.swing.text
import javax.swing.text.html
import org.w3c.dom
import typing



class BoxWidget(VASSAL.build.Widget, java.awt.event.ItemListener, java.beans.PropertyChangeListener):
    def __init__(self): ...
    def add(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getComponent(self) -> java.awt.Component: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def itemStateChanged(self, itemEvent: java.awt.event.ItemEvent) -> None: ...
    def propertyChange(self, propertyChangeEvent: java.beans.PropertyChangeEvent) -> None: ...
    def remove(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...

class Chart(VASSAL.build.Widget):
    NAME: typing.ClassVar[str] = ...
    FILE: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addLocalImageNames(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getComponent(self) -> java.awt.Component: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getFileName(self) -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...

class HtmlChart(VASSAL.build.Widget, java.awt.event.MouseListener):
    NAME: typing.ClassVar[str] = ...
    FILE: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addLocalImageNames(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getComponent(self) -> java.awt.Component: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getFileName(self) -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def mouseClicked(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseEntered(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseExited(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mousePressed(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseReleased(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    class HtmlChartHyperlinkListener(javax.swing.event.HyperlinkListener):
        def __init__(self, htmlChart: 'HtmlChart'): ...
        def hyperlinkUpdate(self, hyperlinkEvent: javax.swing.event.HyperlinkEvent) -> None: ...
    class XTMLEditorKit(javax.swing.text.html.HTMLEditorKit):
        def __init__(self): ...
        def getViewFactory(self) -> javax.swing.text.ViewFactory: ...
        class XTMLFactory(javax.swing.text.html.HTMLEditorKit.HTMLFactory, javax.swing.text.ViewFactory):
            def __init__(self): ...
            def create(self, element: javax.swing.text.Element) -> javax.swing.text.View: ...
            class ImageComponentView(javax.swing.text.ComponentView):
                def __init__(self, element: javax.swing.text.Element): ...

class ListWidget(VASSAL.build.Widget, javax.swing.event.ListSelectionListener):
    SCALE: typing.ClassVar[str] = ...
    def __init__(self): ...
    def add(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getComponent(self) -> java.awt.Component: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getScale(self) -> float: ...
    def hasScale(self) -> bool: ...
    def remove(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def valueChanged(self, listSelectionEvent: javax.swing.event.ListSelectionEvent) -> None: ...

class MapWidget(VASSAL.build.Widget):
    def __init__(self): ...
    def add(self, buildable: VASSAL.build.Buildable) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def build(self, element: org.w3c.dom.Element) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getComponent(self) -> java.awt.Component: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getMap(self) -> 'WidgetMap': ...
    def remove(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...

class PanelWidget(VASSAL.build.Widget):
    SCALE: typing.ClassVar[str] = ...
    FIXED: typing.ClassVar[str] = ...
    COLS: typing.ClassVar[str] = ...
    VERTICAL: typing.ClassVar[str] = ...
    def __init__(self): ...
    def add(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    def getComponent(self) -> java.awt.Component: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getScale(self) -> float: ...
    def hasScale(self) -> bool: ...
    def remove(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...

class PieceSlot(VASSAL.build.Widget, java.awt.event.MouseListener, java.awt.event.KeyListener):
    GP_ID: typing.ClassVar[str] = ...
    PIECE_PALETTE_SCALE: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, cardSlot: 'CardSlot'): ...
    @typing.overload
    def __init__(self, pieceSlot: 'PieceSlot'): ...
    @typing.overload
    def __init__(self, gamePiece: VASSAL.counters.GamePiece): ...
    def addImageNamesRecursively(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def build(self, element: org.w3c.dom.Element) -> None: ...
    def clearCache(self) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getBuildElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    def getComponent(self) -> java.awt.Component: ...
    def getConfigureComponents(self) -> typing.List[VASSAL.build.Configurable]: ...
    def getConfigureName(self) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getConfigurer(self) -> VASSAL.configure.Configurer: ...
    def getGpId(self) -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.ComponentI18nData: ...
    def getName(self) -> str: ...
    def getPiece(self) -> VASSAL.counters.GamePiece: ...
    def getPieceDefinition(self) -> str: ...
    def getPreferredSize(self) -> java.awt.Dimension: ...
    def getScale(self) -> float: ...
    def isValid(self) -> bool: ...
    def keyPressed(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
    def keyReleased(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
    def keyTyped(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
    def mouseClicked(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseEntered(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseExited(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mousePressed(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseReleased(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def paint(self, graphics: java.awt.Graphics) -> None: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setGpId(self, string: str) -> None: ...
    def setGpidSupport(self, gpIdSupport: VASSAL.build.GpIdSupport) -> None: ...
    def setPiece(self, gamePiece: VASSAL.counters.GamePiece) -> None: ...
    @typing.overload
    def updateGpId(self) -> None: ...
    @typing.overload
    def updateGpId(self, gpIdSupport: VASSAL.build.GpIdSupport) -> None: ...
    @typing.overload
    def updateGpId(self, gamePiece: VASSAL.counters.GamePiece) -> None: ...
    class Panel(javax.swing.JPanel):
        def __init__(self, pieceSlot: 'PieceSlot', pieceSlot2: 'PieceSlot'): ...
        def getPieceSlot(self) -> 'PieceSlot': ...
        def getPreferredSize(self) -> java.awt.Dimension: ...
        def paint(self, graphics: java.awt.Graphics) -> None: ...

class TabWidget(VASSAL.build.Widget, javax.swing.event.ChangeListener, java.beans.PropertyChangeListener):
    def __init__(self): ...
    def add(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getComponent(self) -> java.awt.Component: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def propertyChange(self, propertyChangeEvent: java.beans.PropertyChangeEvent) -> None: ...
    def remove(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def stateChanged(self, changeEvent: javax.swing.event.ChangeEvent) -> None: ...

class WidgetMap(VASSAL.build.module.Map):
    def __init__(self): ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    def getScroll(self) -> javax.swing.JScrollPane: ...
    def setup(self, boolean: bool) -> None: ...
    def shouldDockIntoMainWindow(self) -> bool: ...

class CardSlot(PieceSlot):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, pieceSlot: PieceSlot): ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getConfigurer(self) -> VASSAL.configure.Configurer: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("VASSAL.build.widget")``.

    BoxWidget: typing.Type[BoxWidget]
    CardSlot: typing.Type[CardSlot]
    Chart: typing.Type[Chart]
    HtmlChart: typing.Type[HtmlChart]
    ListWidget: typing.Type[ListWidget]
    MapWidget: typing.Type[MapWidget]
    PanelWidget: typing.Type[PanelWidget]
    PieceSlot: typing.Type[PieceSlot]
    TabWidget: typing.Type[TabWidget]
    WidgetMap: typing.Type[WidgetMap]
