import VASSAL
import VASSAL.build
import VASSAL.build.module
import VASSAL.build.module.documentation
import VASSAL.command
import VASSAL.configure
import VASSAL.counters
import VASSAL.i18n
import VASSAL.script.expression
import VASSAL.tools
import java.awt
import java.awt.event
import java.beans
import java.util
import javax.swing
import typing



class ChangePropertyCommand(VASSAL.command.Command):
    def __init__(self, mutableProperty: 'MutableProperty', string: str, string2: str, string3: str): ...
    def getNewValue(self) -> str: ...
    def getOldValue(self) -> str: ...
    def getProperty(self) -> 'MutableProperty': ...
    def getPropertyName(self) -> str: ...

class ChangePropertyCommandEncoder(VASSAL.command.CommandEncoder):
    def __init__(self, mutablePropertiesContainer: 'MutablePropertiesContainer'): ...
    def decode(self, string: str) -> VASSAL.command.Command: ...
    def encode(self, command: VASSAL.command.Command) -> str: ...

class GlobalPropertiesContainer:
    def getGlobalProperty(self, string: str) -> 'GlobalProperty': ...
    def getPropertyListener(self) -> java.beans.PropertyChangeListener: ...

class PropertyChanger:
    def getNewValue(self, string: str) -> str: ...

class PropertyNameSource:
    def getPropertyNames(self) -> java.util.List[str]: ...

class PropertySource(VASSAL.script.expression.Auditable):
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...

class IncrementProperty(PropertyChanger):
    def __init__(self, propertyChangerConfigurer: 'PropertyChangerConfigurer', string: str, constraints: 'IncrementProperty.Constraints'): ...
    def getIncrement(self) -> str: ...
    def getNewValue(self, string: str) -> str: ...
    class Constraints(PropertySource):
        def getMaximumValue(self) -> int: ...
        def getMinimumValue(self) -> int: ...
        def getPropertySource(self) -> PropertySource: ...
        def isWrap(self) -> bool: ...

class PropertySetter(PropertyChanger):
    def __init__(self, string: str, constraints: 'PropertyChangerConfigurer.Constraints'): ...
    def getNewValue(self, string: str) -> str: ...
    def getRawValue(self) -> str: ...
    def setNewValue(self, string: str) -> None: ...

class SumProperties(PropertySource):
    def __init__(self, collection: typing.Union[java.util.Collection[VASSAL.counters.GamePiece], typing.Sequence[VASSAL.counters.GamePiece], typing.Set[VASSAL.counters.GamePiece]]): ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...

class ChangePropertyButton(VASSAL.build.AbstractToolbarItem, VASSAL.build.module.properties.PropertyChangerConfigurer.Constraints):
    BUTTON_TEXT: typing.ClassVar[str] = ...
    BUTTON_TOOLTIP: typing.ClassVar[str] = ...
    BUTTON_ICON: typing.ClassVar[str] = ...
    HOTKEY: typing.ClassVar[str] = ...
    PROPERTY_CHANGER: typing.ClassVar[str] = ...
    REPORT_FORMAT: typing.ClassVar[str] = ...
    OLD_VALUE_FORMAT: typing.ClassVar[str] = ...
    NEW_VALUE_FORMAT: typing.ClassVar[str] = ...
    DESCRIPTION_FORMAT: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getComponent(self) -> java.awt.Component: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getExpressionList(self) -> java.util.List[str]: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getMaximumValue(self) -> int: ...
    def getMinimumValue(self) -> int: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getPropertyChanger(self) -> PropertyChanger: ...
    def getPropertySource(self) -> PropertySource: ...
    def isNumeric(self) -> bool: ...
    def isWrap(self) -> bool: ...
    def launch(self) -> None: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    class PropChangerOptions(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class ReportFormatConfig(VASSAL.i18n.TranslatableConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class EnumeratedPropertyPrompt(VASSAL.build.module.properties.PropertyPrompt):
    def __init__(self, dialogParent: typing.Union['PropertyPrompt.DialogParent', typing.Callable], string: str, stringArray: typing.List[str], constraints: 'PropertyPrompt.Constraints'): ...
    def getNewValue(self, string: str) -> str: ...
    def getValidValues(self) -> typing.List[str]: ...
    def getValueExpressions(self) -> typing.List[VASSAL.script.expression.Expression]: ...

class GlobalProperties(VASSAL.build.AbstractConfigurable, VASSAL.build.module.properties.MutablePropertiesContainer, VASSAL.tools.ToolBarComponent, PropertySource):
    def __init__(self): ...
    def addMutableProperty(self, string: str, mutableProperty: 'MutableProperty') -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getConfigurer(self) -> VASSAL.configure.Configurer: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nPrefix(self) -> str: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getMutablePropertiesContainerId(self) -> str: ...
    def getMutableProperty(self, string: str) -> 'GlobalProperty': ...
    def getParent(self) -> 'MutablePropertiesContainer': ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getPropertyNames(self) -> java.util.List[str]: ...
    def getToolBar(self) -> javax.swing.JToolBar: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def removeMutableProperty(self, string: str) -> 'MutableProperty': ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...

class GlobalProperty(VASSAL.build.AbstractConfigurable, VASSAL.tools.ToolBarComponent, VASSAL.build.module.GameComponent, VASSAL.command.CommandEncoder, PropertySource, VASSAL.build.module.properties.MutableProperty):
    NAME: typing.ClassVar[str] = ...
    INITIAL_VALUE: typing.ClassVar[str] = ...
    DESCRIPTION: typing.ClassVar[str] = ...
    NUMERIC: typing.ClassVar[str] = ...
    MIN_VALUE: typing.ClassVar[str] = ...
    MAX_VALUE: typing.ClassVar[str] = ...
    WRAP: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, globalProperty: 'GlobalProperty'): ...
    def addMutablePropertyChangeListener(self, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def decode(self, string: str) -> VASSAL.command.Command: ...
    def encode(self, command: VASSAL.command.Command) -> str: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getDescription(self) -> str: ...
    def getExpressionList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getMaxValue(self) -> int: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getMinValue(self) -> int: ...
    def getParent(self) -> 'MutablePropertiesContainer': ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getPropertyList(self) -> java.util.List[str]: ...
    def getPropertyValue(self) -> str: ...
    def getRestoreCommand(self) -> VASSAL.command.Command: ...
    def getToolBar(self) -> javax.swing.JToolBar: ...
    def isNumeric(self) -> bool: ...
    def isWrap(self) -> bool: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def removeMutablePropertyChangeListener(self, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setPropertyName(self, string: str) -> None: ...
    def setPropertyValue(self, string: str) -> VASSAL.command.Command: ...
    def setup(self, boolean: bool) -> None: ...
    class SetGlobalProperty(VASSAL.command.Command):
        def __init__(self, globalProperty: 'GlobalProperty', string: str, string2: str): ...
        def getProperty(self) -> 'GlobalProperty': ...
        def getTargetName(self) -> str: ...

class GlobalTranslatableMessage(VASSAL.build.AbstractConfigurable, VASSAL.tools.ToolBarComponent, VASSAL.build.module.GameComponent, PropertySource, VASSAL.build.module.properties.TranslatableString):
    NAME: typing.ClassVar[str] = ...
    INITIAL_VALUE: typing.ClassVar[str] = ...
    DESCRIPTION: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, globalTranslatableMessage: 'GlobalTranslatableMessage'): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getDescription(self) -> str: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getParent(self) -> 'TranslatableStringContainer': ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getPropertyList(self) -> java.util.List[str]: ...
    def getPropertyValue(self) -> str: ...
    def getRestoreCommand(self) -> VASSAL.command.Command: ...
    def getToolBar(self) -> javax.swing.JToolBar: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setPropertyName(self, string: str) -> None: ...
    def setPropertyValue(self, string: str) -> None: ...
    def setup(self, boolean: bool) -> None: ...

class GlobalTranslatableMessages(VASSAL.build.AbstractConfigurable, VASSAL.build.module.properties.TranslatableStringContainer, VASSAL.tools.ToolBarComponent, PropertySource):
    def __init__(self): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def addTranslatableString(self, string: str, translatableString: 'TranslatableString') -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getConfigurer(self) -> VASSAL.configure.Configurer: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nPrefix(self) -> str: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getParent(self) -> 'TranslatableStringContainer': ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getPropertyNames(self) -> java.util.List[str]: ...
    def getToolBar(self) -> javax.swing.JToolBar: ...
    def getTranslatableString(self, string: str) -> GlobalTranslatableMessage: ...
    def getTranslatableStringContainerId(self) -> str: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def removeTranslatableString(self, string: str) -> 'TranslatableString': ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...

class MutablePropertiesContainer:
    def addMutableProperty(self, string: str, mutableProperty: 'MutableProperty') -> None: ...
    def getMutablePropertiesContainerId(self) -> str: ...
    def getMutableProperty(self, string: str) -> 'MutableProperty': ...
    def removeMutableProperty(self, string: str) -> 'MutableProperty': ...
    class Impl(VASSAL.build.module.properties.MutablePropertiesContainer):
        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, string: str): ...
        def addMutableProperty(self, string: str, mutableProperty: 'MutableProperty') -> None: ...
        def getMutablePropertiesContainerId(self) -> str: ...
        def getMutableProperty(self, string: str) -> 'MutableProperty': ...
        def removeMutableProperty(self, string: str) -> 'MutableProperty': ...

class MutableProperty:
    def addMutablePropertyChangeListener(self, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def getParent(self) -> MutablePropertiesContainer: ...
    def getPropertyValue(self) -> str: ...
    def removeMutablePropertyChangeListener(self, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def setPropertyValue(self, string: str) -> VASSAL.command.Command: ...
    class Impl(VASSAL.build.module.properties.MutableProperty):
        def __init__(self, string: str, object: typing.Any): ...
        def addMutablePropertyChangeListener(self, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
        def addTo(self, mutablePropertiesContainer: MutablePropertiesContainer) -> None: ...
        @staticmethod
        def getAllProperties() -> java.util.List['MutableProperty.Impl']: ...
        def getName(self) -> str: ...
        def getParent(self) -> MutablePropertiesContainer: ...
        def getPropertyValue(self) -> str: ...
        def removeFromContainer(self) -> None: ...
        def removeMutablePropertyChangeListener(self, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
        def setPropertyName(self, string: str) -> None: ...
        def setPropertyValue(self, string: str) -> VASSAL.command.Command: ...
    class Util:
        def __init__(self): ...
        @staticmethod
        def findMutableProperty(string: str, list: java.util.List[MutablePropertiesContainer]) -> 'MutableProperty': ...

class NumericPropertyPrompt(VASSAL.build.module.properties.PropertyPrompt):
    def __init__(self, component: java.awt.Component, string: str, int: int, int2: int): ...
    def getNewValue(self, string: str) -> str: ...

class PropertyChangerConfigurer(VASSAL.configure.Configurer):
    def __init__(self, string: str, string2: str, constraints: 'PropertyChangerConfigurer.Constraints'): ...
    def addFocusListener(self, focusListener: java.awt.event.FocusListener) -> None: ...
    def getChangerControls(self) -> java.awt.Component: ...
    def getChangerLabel(self) -> java.awt.Component: ...
    def getControls(self) -> java.awt.Component: ...
    def getPropertyChanger(self) -> PropertyChanger: ...
    def getTypeControls(self) -> java.awt.Component: ...
    def getTypeLabel(self) -> java.awt.Component: ...
    def getValueString(self) -> str: ...
    def getValuesControls(self) -> java.awt.Component: ...
    def isEnumType(self) -> bool: ...
    def removeFocusListener(self, focusListener: java.awt.event.FocusListener) -> None: ...
    def setHighlighted(self, boolean: bool) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    class Constraints(VASSAL.build.module.properties.PropertyPrompt.Constraints, IncrementProperty.Constraints, PropertySource): ...

class PropertyPrompt(PropertyChanger):
    def __init__(self, constraints: 'PropertyPrompt.Constraints', string: str): ...
    def getNewValue(self, string: str) -> str: ...
    def getPrompt(self) -> str: ...
    class Constraints(VASSAL.build.module.properties.PropertyPrompt.DialogParent):
        def getMaximumValue(self) -> int: ...
        def getMinimumValue(self) -> int: ...
        def getPropertySource(self) -> PropertySource: ...
        def isNumeric(self) -> bool: ...
    class DialogParent:
        def getComponent(self) -> java.awt.Component: ...

class TranslatableString:
    def getParent(self) -> 'TranslatableStringContainer': ...
    def getPropertyValue(self) -> str: ...
    def setPropertyValue(self, string: str) -> None: ...
    class Impl(VASSAL.build.module.properties.TranslatableString):
        def __init__(self, string: str, object: typing.Any): ...
        def addTo(self, translatableStringContainer: 'TranslatableStringContainer') -> None: ...
        @staticmethod
        def getAllProperties() -> java.util.List['TranslatableString.Impl']: ...
        def getName(self) -> str: ...
        def getParent(self) -> 'TranslatableStringContainer': ...
        def getPropertyValue(self) -> str: ...
        def removeFromContainer(self) -> None: ...
        def setPropertyName(self, string: str) -> None: ...
        def setPropertyValue(self, string: str) -> None: ...
    class Util:
        def __init__(self): ...
        @staticmethod
        def findTranslatableString(string: str, list: java.util.List['TranslatableStringContainer']) -> 'TranslatableString': ...

class TranslatableStringContainer:
    def addTranslatableString(self, string: str, translatableString: TranslatableString) -> None: ...
    def getTranslatableString(self, string: str) -> TranslatableString: ...
    def getTranslatableStringContainerId(self) -> str: ...
    def removeTranslatableString(self, string: str) -> TranslatableString: ...
    class Impl(VASSAL.build.module.properties.TranslatableStringContainer):
        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, string: str): ...
        def addTranslatableString(self, string: str, translatableString: TranslatableString) -> None: ...
        def getTranslatableString(self, string: str) -> TranslatableString: ...
        def getTranslatableStringContainerId(self) -> str: ...
        def removeTranslatableString(self, string: str) -> TranslatableString: ...

class ZoneProperty(GlobalProperty):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, globalProperty: GlobalProperty): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("VASSAL.build.module.properties")``.

    ChangePropertyButton: typing.Type[ChangePropertyButton]
    ChangePropertyCommand: typing.Type[ChangePropertyCommand]
    ChangePropertyCommandEncoder: typing.Type[ChangePropertyCommandEncoder]
    EnumeratedPropertyPrompt: typing.Type[EnumeratedPropertyPrompt]
    GlobalProperties: typing.Type[GlobalProperties]
    GlobalPropertiesContainer: typing.Type[GlobalPropertiesContainer]
    GlobalProperty: typing.Type[GlobalProperty]
    GlobalTranslatableMessage: typing.Type[GlobalTranslatableMessage]
    GlobalTranslatableMessages: typing.Type[GlobalTranslatableMessages]
    IncrementProperty: typing.Type[IncrementProperty]
    MutablePropertiesContainer: typing.Type[MutablePropertiesContainer]
    MutableProperty: typing.Type[MutableProperty]
    NumericPropertyPrompt: typing.Type[NumericPropertyPrompt]
    PropertyChanger: typing.Type[PropertyChanger]
    PropertyChangerConfigurer: typing.Type[PropertyChangerConfigurer]
    PropertyNameSource: typing.Type[PropertyNameSource]
    PropertyPrompt: typing.Type[PropertyPrompt]
    PropertySetter: typing.Type[PropertySetter]
    PropertySource: typing.Type[PropertySource]
    SumProperties: typing.Type[SumProperties]
    TranslatableString: typing.Type[TranslatableString]
    TranslatableStringContainer: typing.Type[TranslatableStringContainer]
    ZoneProperty: typing.Type[ZoneProperty]
