import VASSAL.build
import VASSAL.build.module
import VASSAL.build.module.documentation
import VASSAL.build.module.map.boardPicker
import VASSAL.build.module.map.boardPicker.board
import VASSAL.build.module.properties
import VASSAL.command
import VASSAL.configure
import VASSAL.i18n
import java.awt
import java.beans
import java.util
import javax.swing
import typing



class GridContainer:
    def contains(self, point: java.awt.Point) -> bool: ...
    def getBoard(self) -> VASSAL.build.module.map.boardPicker.Board: ...
    def getSize(self) -> java.awt.Dimension: ...
    def removeGrid(self, mapGrid: VASSAL.build.module.map.boardPicker.board.MapGrid) -> None: ...
    def setGrid(self, mapGrid: VASSAL.build.module.map.boardPicker.board.MapGrid) -> None: ...

class GridNumbering:
    def draw(self, graphics: java.awt.Graphics, rectangle: java.awt.Rectangle, rectangle2: java.awt.Rectangle, double: float, boolean: bool) -> None: ...
    def getLocation(self, string: str) -> java.awt.Point: ...
    def isVisible(self) -> bool: ...
    def localizedLocationName(self, point: java.awt.Point) -> str: ...
    def locationName(self, point: java.awt.Point) -> str: ...

class PolygonEditor(javax.swing.JPanel):
    def __init__(self, polygon: java.awt.Polygon): ...
    def center(self, point: java.awt.Point) -> None: ...
    def clonePolygon(self) -> java.awt.Polygon: ...
    def getPolygon(self) -> java.awt.Polygon: ...
    @staticmethod
    def main(stringArray: typing.List[str]) -> None: ...
    def paint(self, graphics: java.awt.Graphics) -> None: ...
    @staticmethod
    def polygonToString(polygon: java.awt.Polygon) -> str: ...
    @staticmethod
    def reset(polygon: java.awt.Polygon, string: str) -> None: ...
    def scrollAtEdge(self, point: java.awt.Point, int: int) -> None: ...
    def setPolygon(self, polygon: java.awt.Polygon) -> None: ...
    def setScroll(self, jScrollPane: javax.swing.JScrollPane) -> None: ...

class ZoneHighlight(VASSAL.build.AbstractConfigurable):
    NAME: typing.ClassVar[str] = ...
    COLOR: typing.ClassVar[str] = ...
    COVERAGE: typing.ClassVar[str] = ...
    WIDTH: typing.ClassVar[str] = ...
    STYLE: typing.ClassVar[str] = ...
    IMAGE: typing.ClassVar[str] = ...
    OPACITY: typing.ClassVar[str] = ...
    COVERAGE_FULL: typing.ClassVar[str] = ...
    COVERAGE_BORDER: typing.ClassVar[str] = ...
    STYLE_PLAIN: typing.ClassVar[str] = ...
    STYLE_STRIPES: typing.ClassVar[str] = ...
    STYLE_CROSS: typing.ClassVar[str] = ...
    STYLE_IMAGE: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def draw(self, graphics2D: java.awt.Graphics2D, shape: java.awt.Shape, double: float) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    def getColor(self) -> java.awt.Color: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getName(self) -> str: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setOpacity(self, int: int) -> None: ...
    class Coverage(VASSAL.configure.TranslatableStringEnum):
        def __init__(self): ...
        def getI18nKeys(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
        def getValidValues(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
    class OpacityConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class PercentageConfigurer(VASSAL.configure.Configurer):
        def __init__(self, zoneHighlight: 'ZoneHighlight', string: str, string2: str, object: typing.Any): ...
        def getControls(self) -> java.awt.Component: ...
        def getValueString(self) -> str: ...
        @typing.overload
        def setValue(self, string: str) -> None: ...
        @typing.overload
        def setValue(self, object: typing.Any) -> None: ...
    class Style(VASSAL.configure.TranslatableStringEnum):
        def __init__(self): ...
        def getI18nKeys(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
        def getValidValues(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...

class ZonedGridHighlighter(VASSAL.build.AbstractConfigurable):
    def __init__(self): ...
    def addHighlight(self, zoneHighlight: ZoneHighlight) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getName(self) -> str: ...
    def getZoneHighlightByName(self, string: str) -> ZoneHighlight: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def removeHighlight(self, zoneHighlight: ZoneHighlight) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...

class RegularGridNumbering(VASSAL.build.AbstractConfigurable, GridNumbering):
    FIRST: typing.ClassVar[str] = ...
    SEP: typing.ClassVar[str] = ...
    H_TYPE: typing.ClassVar[str] = ...
    V_TYPE: typing.ClassVar[str] = ...
    H_LEADING: typing.ClassVar[str] = ...
    V_LEADING: typing.ClassVar[str] = ...
    H_OFF: typing.ClassVar[str] = ...
    V_OFF: typing.ClassVar[str] = ...
    V_DESCEND: typing.ClassVar[str] = ...
    H_DESCEND: typing.ClassVar[str] = ...
    FONT_SIZE: typing.ClassVar[str] = ...
    COLOR: typing.ClassVar[str] = ...
    VISIBLE: typing.ClassVar[str] = ...
    ROTATE_TEXT: typing.ClassVar[str] = ...
    H_DRAW_OFF: typing.ClassVar[str] = ...
    V_DRAW_OFF: typing.ClassVar[str] = ...
    LOCATION_FORMAT: typing.ClassVar[str] = ...
    GRID_LOCATION: typing.ClassVar[str] = ...
    ROW: typing.ClassVar[str] = ...
    COLUMN: typing.ClassVar[str] = ...
    VISUALIZER_GRID_SIZE: typing.ClassVar[float] = ...
    ALPHABET: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addPropertyChangeListener(self, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    def getCenterPoint(self, int: int, int2: int) -> java.awt.Point: ...
    def getColumn(self, point: java.awt.Point) -> int: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getConfigurer(self) -> VASSAL.configure.Configurer: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getLocation(self, string: str) -> java.awt.Point: ...
    def getRow(self, point: java.awt.Point) -> int: ...
    def isVisible(self) -> bool: ...
    def localizedLocationName(self, point: java.awt.Point) -> str: ...
    def locationName(self, point: java.awt.Point) -> str: ...
    @typing.overload
    def offsetLabelCenter(self, int: int, int2: int, double: float) -> java.awt.Point: ...
    @typing.overload
    def offsetLabelCenter(self, point: java.awt.Point, double: float) -> java.awt.Point: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    class F(VASSAL.configure.TranslatableStringEnum):
        def __init__(self): ...
        def getI18nKeys(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
        def getValidValues(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
    class LocationFormatConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class R(VASSAL.configure.StringEnum):
        def __init__(self): ...
        def getValidValues(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
    class T(VASSAL.configure.TranslatableStringEnum):
        def __init__(self): ...
        def getI18nKeys(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
        def getValidValues(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...

class Zone(VASSAL.build.AbstractConfigurable, GridContainer, VASSAL.build.module.properties.MutablePropertiesContainer, VASSAL.build.module.properties.PropertySource, VASSAL.build.module.GameComponent):
    NAME: typing.ClassVar[str] = ...
    PATH: typing.ClassVar[str] = ...
    USE_PARENT_GRID: typing.ClassVar[str] = ...
    LOCATION_FORMAT: typing.ClassVar[str] = ...
    GRID_LOCATION: typing.ClassVar[str] = ...
    USE_HIGHLIGHT: typing.ClassVar[str] = ...
    HIGHLIGHT_PROPERTY: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addMutableProperty(self, string: str, mutableProperty: VASSAL.build.module.properties.MutableProperty) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def contains(self, point: java.awt.Point) -> bool: ...
    def draw(self, graphics: java.awt.Graphics, rectangle: java.awt.Rectangle, rectangle2: java.awt.Rectangle, double: float, boolean: bool) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    def getBoard(self) -> VASSAL.build.module.map.boardPicker.Board: ...
    def getBounds(self) -> java.awt.Rectangle: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getGrid(self) -> VASSAL.build.module.map.boardPicker.board.MapGrid: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getLocalizedName(self) -> str: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getLocation(self, string: str) -> java.awt.Point: ...
    def getMap(self) -> VASSAL.build.module.Map: ...
    def getMutablePropertiesContainerId(self) -> str: ...
    def getMutableProperty(self, string: str) -> VASSAL.build.module.properties.MutableProperty: ...
    def getName(self) -> str: ...
    def getParentGrid(self) -> VASSAL.build.module.map.boardPicker.board.ZonedGrid: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getPropertyNames(self) -> java.util.List[str]: ...
    def getRestoreCommand(self) -> VASSAL.command.Command: ...
    def getShape(self) -> java.awt.Shape: ...
    def getSize(self) -> java.awt.Dimension: ...
    def isUseParentGrid(self) -> bool: ...
    def localizedLocationName(self, point: java.awt.Point) -> str: ...
    def locationName(self, point: java.awt.Point) -> str: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def removeGrid(self, mapGrid: VASSAL.build.module.map.boardPicker.board.MapGrid) -> None: ...
    def removeMutableProperty(self, string: str) -> VASSAL.build.module.properties.MutableProperty: ...
    def repaint(self) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setGrid(self, mapGrid: VASSAL.build.module.map.boardPicker.board.MapGrid) -> None: ...
    def setHighlight(self, zoneHighlight: ZoneHighlight) -> None: ...
    def setHighlighter(self, string: str) -> None: ...
    def setup(self, boolean: bool) -> None: ...
    def snapTo(self, point: java.awt.Point) -> java.awt.Point: ...
    class Editor(VASSAL.configure.Configurer):
        def __init__(self, zone: 'Zone'): ...
        def getControls(self) -> java.awt.Component: ...
        def getValueString(self) -> str: ...
        @typing.overload
        def setValue(self, string: str) -> None: ...
        @typing.overload
        def setValue(self, object: typing.Any) -> None: ...
    class LocationFormatConfig(VASSAL.i18n.TranslatableConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class ShapeEditor(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class HexGridNumbering(RegularGridNumbering):
    STAGGER: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def draw(self, graphics: java.awt.Graphics, rectangle: java.awt.Rectangle, rectangle2: java.awt.Rectangle, double: float, boolean: bool) -> None: ...
    def forceDraw(self, graphics: java.awt.Graphics, rectangle: java.awt.Rectangle, rectangle2: java.awt.Rectangle, double: float, boolean: bool) -> None: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getCenterPoint(self, int: int, int2: int) -> java.awt.Point: ...
    def getColumn(self, point: java.awt.Point) -> int: ...
    def getGrid(self) -> VASSAL.build.module.map.boardPicker.board.HexGrid: ...
    def getRawColumn(self, point: java.awt.Point) -> int: ...
    def getRawRow(self, point: java.awt.Point) -> int: ...
    def getRow(self, point: java.awt.Point) -> int: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...

class SquareGridNumbering(RegularGridNumbering):
    def __init__(self): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def draw(self, graphics: java.awt.Graphics, rectangle: java.awt.Rectangle, rectangle2: java.awt.Rectangle, double: float, boolean: bool) -> None: ...
    def forceDraw(self, graphics: java.awt.Graphics, rectangle: java.awt.Rectangle, rectangle2: java.awt.Rectangle, double: float, boolean: bool) -> None: ...
    def getCenterPoint(self, int: int, int2: int) -> java.awt.Point: ...
    def getColumn(self, point: java.awt.Point) -> int: ...
    def getRow(self, point: java.awt.Point) -> int: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("VASSAL.build.module.map.boardPicker.board.mapgrid")``.

    GridContainer: typing.Type[GridContainer]
    GridNumbering: typing.Type[GridNumbering]
    HexGridNumbering: typing.Type[HexGridNumbering]
    PolygonEditor: typing.Type[PolygonEditor]
    RegularGridNumbering: typing.Type[RegularGridNumbering]
    SquareGridNumbering: typing.Type[SquareGridNumbering]
    Zone: typing.Type[Zone]
    ZoneHighlight: typing.Type[ZoneHighlight]
    ZonedGridHighlighter: typing.Type[ZonedGridHighlighter]
