/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.version;

import VASSAL.i18n.Resources;
import VASSAL.tools.BrowserSupport;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.WarningDialog;
import VASSAL.tools.version.AbstractUpdateCheckRequest;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateCheckAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(UpdateCheckAction.class);
    private final Frame frame;

    public UpdateCheckAction(Frame frame) {
        super(Resources.getString("UpdateCheckAction.update_check"));
        this.frame = frame;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new Request().execute();
    }

    private class Request
    extends AbstractUpdateCheckRequest {
        private Request() {
        }

        @Override
        protected void done() {
            try {
                Boolean update = (Boolean)this.get();
                if (!update.booleanValue()) {
                    JOptionPane.showMessageDialog(UpdateCheckAction.this.frame, Resources.getString("UpdateCheckAction.version_current_message"), Resources.getString("UpdateCheckAction.version_current_title"), 1);
                } else if (JOptionPane.showConfirmDialog(UpdateCheckAction.this.frame, Resources.getString("UpdateCheckAction.update_available_message"), Resources.getString("UpdateCheckAction.update_available_title"), 0, 3) == 0) {
                    BrowserSupport.openURL("https://github.com/vassalengine/vassal/releases");
                }
                return;
            }
            catch (InterruptedException e) {
                ErrorDialog.bug(e);
            }
            catch (ExecutionException e) {
                logger.error("", (Throwable)e);
            }
            WarningDialog.show((Component)UpdateCheckAction.this.frame, "UpdateCheckAction.check_failed", new Object[0]);
        }
    }
}

