/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.menu;

import VASSAL.tools.menu.ChildProxy;
import VASSAL.tools.menu.Functor;
import VASSAL.tools.menu.ParentProxy;
import java.awt.Component;
import java.awt.Container;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public abstract class AbstractProxy<T extends JComponent>
implements ChildProxy<T> {
    protected final List<WeakReference<T>> peers = new ArrayList<WeakReference<T>>();
    protected final ReferenceQueue<T> queue = new ReferenceQueue();
    protected ParentProxy parent;

    protected void processQueue() {
        Reference<T> ref;
        while ((ref = this.queue.poll()) != null) {
            this.peers.remove(ref);
        }
    }

    protected void forEachPeer(Functor<T> functor) {
        this.processQueue();
        for (WeakReference<T> ref : this.peers) {
            JComponent peer = (JComponent)ref.get();
            if (peer == null) continue;
            functor.apply(peer);
        }
    }

    @Override
    public ParentProxy getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ParentProxy parent) {
        this.parent = parent;
        if (parent == null) {
            this.forEachPeer(peer -> {
                Container par = peer.getParent();
                if (par != null) {
                    par.remove((Component)peer);
                }
            });
        }
    }

    @Override
    public abstract T createPeer();
}

