/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.tools.ErrorDialog;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.Repainter;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class OpIcon
extends ImageIcon
implements Icon {
    private static final long serialVersionUID = 1L;
    protected ImageOp sop;

    public OpIcon() {
    }

    public OpIcon(ImageOp op) {
        this.sop = op;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        AffineTransform orig_t;
        Graphics2D g2d;
        block4: {
            if (this.sop == null) {
                return;
            }
            Repainter r = c == null ? null : new Repainter(c, g.getClipBounds());
            g2d = (Graphics2D)g;
            double os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
            orig_t = g2d.getTransform();
            g2d.setTransform(SwingUtils.descaleTransform(orig_t));
            x = (int)((double)x * os_scale);
            y = (int)((double)y * os_scale);
            try {
                g.drawImage(Op.scale(this.sop, os_scale).getImage(r), x, y, c);
            }
            catch (InterruptedException | CancellationException e) {
                ErrorDialog.bug(e);
            }
            catch (ExecutionException e) {
                if (Op.handleException(e)) break block4;
                ErrorDialog.bug(e);
            }
        }
        g2d.setTransform(orig_t);
    }

    @Override
    public Image getImage() {
        return this.sop == null ? null : this.sop.getImage();
    }

    @Override
    public void setImage(Image img) {
    }

    @Override
    public int getIconWidth() {
        return this.sop == null ? -1 : this.sop.getWidth();
    }

    @Override
    public int getIconHeight() {
        return this.sop == null ? -1 : this.sop.getHeight();
    }

    public ImageOp getOp() {
        return this.sop;
    }

    public void setOp(ImageOp op) {
        this.sop = op;
    }
}

