/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.AbstractTiledOpImpl;
import VASSAL.tools.imageop.CropOp;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.opcache.Op;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class CropOpBitmapImpl
extends AbstractTiledOpImpl
implements CropOp {
    private final ImageOp sop;
    private final int x0;
    private final int y0;
    private final int x1;
    private final int y1;
    private final int hash;

    public CropOpBitmapImpl(ImageOp sop, int x0, int y0, int x1, int y1) {
        if (sop == null) {
            throw new IllegalArgumentException();
        }
        if (x0 < 0) {
            throw new IllegalArgumentException("left = " + x0);
        }
        if (y0 < 0) {
            throw new IllegalArgumentException("top = " + y0);
        }
        if (x1 <= x0) {
            throw new IllegalArgumentException("left = " + x0 + ", right = " + x1);
        }
        if (y1 <= y0) {
            throw new IllegalArgumentException("top = " + y0 + ", bottom = " + y1);
        }
        this.sop = sop;
        this.x0 = x0;
        this.y0 = y0;
        this.x1 = x1;
        this.y1 = y1;
        this.size = new Dimension(x1 - x0, y1 - y0);
        this.hash = new HashCodeBuilder().append((Object)sop).append(x0).append(y0).append(x1).append(y1).toHashCode();
    }

    @Override
    public List<Op<?>> getSources() {
        Point[] tiles = this.sop.getTileIndices(new Rectangle(this.x0, this.y0, this.x1 - this.x0, this.y1 - this.y0));
        ArrayList ops = new ArrayList(tiles.length);
        for (Point tile : tiles) {
            ops.add(this.sop.getTileOp(tile));
        }
        return ops;
    }

    @Override
    public BufferedImage eval() throws Exception {
        Point[] tiles = this.sop.getTileIndices(new Rectangle(this.x0, this.y0, this.x1 - this.x0, this.y1 - this.y0));
        int tw = this.sop.getTileWidth();
        int th = this.sop.getTileHeight();
        BufferedImage dst = ImageUtils.createCompatibleImage(this.size.width, this.size.height, this.sop.getTile(tiles[0], null).getTransparency() != 1);
        Graphics2D g = dst.createGraphics();
        for (Point tile : tiles) {
            g.drawImage((Image)this.sop.getTile(tile, null), tile.x * tw - this.x0, tile.y * th - this.y0, null);
        }
        g.dispose();
        return dst;
    }

    @Override
    protected void fixSize() {
    }

    @Override
    protected ImageOp createTileOp(int tileX, int tileY) {
        return new CropOpBitmapImpl(this, tileX * this.tileSize.width, tileY * this.tileSize.height, Math.min((tileX + 1) * this.tileSize.width, this.size.width), Math.min((tileY + 1) * this.tileSize.height, this.size.height));
    }

    @Override
    public Rectangle getRect() {
        return new Rectangle(this.x0, this.y0, this.size.width, this.size.height);
    }

    @Override
    public int getX0() {
        return this.x0;
    }

    @Override
    public int getY0() {
        return this.y0;
    }

    @Override
    public int getX1() {
        return this.x1;
    }

    @Override
    public int getY1() {
        return this.y1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        CropOpBitmapImpl op = (CropOpBitmapImpl)o;
        return this.x0 == op.getX0() && this.y0 == op.getY0() && this.x1 == op.getX1() && this.y1 == op.getY1() && this.sop.equals(op.sop);
    }

    public int hashCode() {
        return this.hash;
    }
}

