/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image;

import VASSAL.tools.image.FileImageTypeConverter;
import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageTypeConverter;
import VASSAL.tools.image.MemoryImageTypeConverter;
import VASSAL.tools.io.TemporaryFileFactory;
import VASSAL.tools.lang.Reference;
import java.awt.image.BufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FallbackImageTypeConverter
implements ImageTypeConverter {
    private static final Logger logger = LoggerFactory.getLogger(FallbackImageTypeConverter.class);
    protected final TemporaryFileFactory tfactory;
    protected final ImageTypeConverter memory_converter;
    protected final ImageTypeConverter file_converter;

    public FallbackImageTypeConverter(TemporaryFileFactory tfactory) {
        this(tfactory, new MemoryImageTypeConverter(), new FileImageTypeConverter(tfactory));
    }

    FallbackImageTypeConverter(TemporaryFileFactory tfactory, ImageTypeConverter memory_converter, ImageTypeConverter file_converter) {
        this.tfactory = tfactory;
        this.memory_converter = memory_converter;
        this.file_converter = file_converter;
    }

    @Override
    public BufferedImage convert(Reference<BufferedImage> ref, int type) throws ImageIOException {
        try {
            return this.memory_converter.convert(ref, type);
        }
        catch (OutOfMemoryError e) {
            logger.info("Switching to FileImageTypeConverter...");
            return this.file_converter.convert(ref, type);
        }
    }
}

