/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.filechooser;

import VASSAL.tools.filechooser.FileFilter;
import java.io.File;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public class ExtensionFileFilter
extends FileFilter {
    private final String[] types;
    private final String desc;

    public ExtensionFileFilter(String desc, String[] types) {
        this.desc = desc + " (*" + StringUtils.join((Object[])types, (String)", *") + ")";
        this.types = Arrays.copyOf(types, types.length);
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String name = f.getName().toLowerCase();
        for (String type : this.types) {
            if (!name.endsWith(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }
}

