/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class CountingReadWriteLock
implements ReadWriteLock {
    protected final ReadLock r = new ReadLock();
    protected final WriteLock w = new WriteLock();
    protected final Sync sync = new Sync();

    @Override
    public Lock readLock() {
        return this.r;
    }

    @Override
    public Lock writeLock() {
        return this.w;
    }

    protected class ReadLock
    extends BaseLock {
        protected ReadLock() {
        }

        @Override
        public void lock() {
            CountingReadWriteLock.this.sync.acquireShared(0);
        }

        @Override
        public void unlock() {
            CountingReadWriteLock.this.sync.releaseShared(0);
        }

        @Override
        public boolean tryLock() {
            return CountingReadWriteLock.this.sync.tryAcquireShared(0) >= 0;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return CountingReadWriteLock.this.sync.tryAcquireSharedNanos(0, unit.toNanos(time));
        }
    }

    protected class WriteLock
    extends BaseLock {
        protected WriteLock() {
        }

        @Override
        public void lock() {
            CountingReadWriteLock.this.sync.acquire(0);
        }

        @Override
        public void unlock() {
            CountingReadWriteLock.this.sync.release(0);
        }

        @Override
        public boolean tryLock() {
            return CountingReadWriteLock.this.sync.tryAcquire(0);
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return CountingReadWriteLock.this.sync.tryAcquireNanos(0, unit.toNanos(time));
        }
    }

    protected static class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 1L;

        protected Sync() {
        }

        @Override
        protected boolean tryAcquire(int dummy) {
            return this.compareAndSetState(0, -1);
        }

        @Override
        protected boolean tryRelease(int dummy) {
            if (this.getState() != -1) {
                throw new IllegalMonitorStateException();
            }
            return this.compareAndSetState(-1, 0);
        }

        @Override
        protected int tryAcquireShared(int dummy) {
            int s = this.getState();
            return s >= 0 && this.compareAndSetState(s, s + 1) ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int dummy) {
            int s = this.getState();
            if (s < 1) {
                throw new IllegalMonitorStateException();
            }
            return this.compareAndSetState(s, s - 1);
        }
    }

    protected static abstract class BaseLock
    implements Lock {
        protected BaseLock() {
        }

        @Override
        public void lockInterruptibly() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }
}

