/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.search;

import VASSAL.build.BadDataReport;
import VASSAL.build.GameModule;
import VASSAL.i18n.Resources;
import VASSAL.tools.DataArchive;
import VASSAL.tools.ErrorDialog;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.jsoup.Jsoup;

public class HTMLImageFinder {
    private String fileString;

    public HTMLImageFinder(File file) {
        if (file != null) {
            DataArchive mda = GameModule.getGameModule().getDataArchive();
            try (InputStream inner = mda.getInputStream(file.getPath());
                 BufferedInputStream in = new BufferedInputStream(inner);){
                this.fileString = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                ErrorDialog.dataWarning(new BadDataReport(Resources.getString("Error.not_found", "HTMLImageFinder"), file.getName(), e));
            }
        }
    }

    public HTMLImageFinder(String string) {
        if (string != null) {
            this.fileString = string.toLowerCase().contains("<html>") ? string : "<html>" + string.trim() + "</html>";
        }
    }

    public void addImageNames(Collection<String> s) {
        if (this.fileString != null) {
            s.addAll(Jsoup.parse((String)this.fileString).getElementsByTag("img").eachAttr("src"));
        }
    }
}

