/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.property;

import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class Property<T> {
    public final String name;
    public final Class<T> type;
    public final T def;
    private final int hash;

    public Property(String name, Class<T> type) {
        this(name, type, null);
    }

    public Property(String name, Class<T> type, T def) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.type = type;
        this.def = def;
        this.hash = new HashCodeBuilder().append((Object)name).append(type).toHashCode();
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Property p = (Property)o;
        return this.name.equals(p.name) && this.type.equals(p.type);
    }
}

