/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.launch.Config;
import VASSAL.tools.version.GitProperties;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.lang3.SystemUtils;

public class StandardConfig
implements Config {
    private final Path baseDir;
    private final Path docDir;
    private final Path cacheDir;
    private final Path confDir;
    private final Path tmpDir;
    private final Path prefsDir;
    private final Path errorLogPath;
    private final Path javaBinPath;
    private final String version;
    private final String reportableVersion;

    public StandardConfig() throws IOException {
        GitProperties gitProperties = new GitProperties();
        this.version = gitProperties.getVersion();
        this.reportableVersion = this.version.contains("-") && !this.version.matches(".*-beta\\d+") ? this.version.substring(0, this.version.indexOf(45)) : this.version;
        this.baseDir = Path.of(System.getProperty("user.dir"), new String[0]);
        this.docDir = this.baseDir.resolve(SystemUtils.IS_OS_MAC ? "Contents/Resources/doc" : "doc");
        String confProp = System.getProperty("VASSAL.conf");
        this.confDir = confProp != null ? Path.of(confProp, new String[0]) : (SystemUtils.IS_OS_MAC ? Path.of(System.getProperty("user.home"), "Library/Application Support/VASSAL") : (SystemUtils.IS_OS_WINDOWS ? Path.of(System.getenv("APPDATA"), "VASSAL") : Path.of(System.getProperty("user.home"), ".VASSAL")));
        String cacheProp = System.getProperty("VASSAL.cache");
        this.cacheDir = cacheProp != null ? Path.of(cacheProp, new String[0]) : (SystemUtils.IS_OS_WINDOWS ? Path.of(System.getenv("LOCALAPPDATA"), "VASSAL") : this.confDir);
        Files.createDirectories(this.confDir, new FileAttribute[0]);
        this.prefsDir = this.confDir.resolve("prefs");
        this.errorLogPath = this.confDir.resolve("errorLog-" + this.getVersion());
        this.javaBinPath = Path.of(System.getProperty("java.home"), "bin", "java");
        this.tmpDir = Files.createTempDirectory("vassal_", new FileAttribute[0]);
        this.tmpDir.toFile().deleteOnExit();
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getReportableVersion() {
        return this.reportableVersion;
    }

    @Override
    public Path getBaseDir() {
        return this.baseDir;
    }

    @Override
    public Path getDocDir() {
        return this.docDir;
    }

    @Override
    public Path getConfDir() {
        return this.confDir;
    }

    @Override
    public Path getCacheDir() {
        return this.cacheDir;
    }

    @Override
    public Path getTempDir() {
        return this.tmpDir;
    }

    @Override
    public Path getPrefsDir() {
        return this.prefsDir;
    }

    @Override
    public Path getErrorLogPath() {
        return this.errorLogPath;
    }

    @Override
    public Path getJavaBinPath() {
        return this.javaBinPath;
    }
}

