/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.tools.io.ArgEncoding;
import VASSAL.tools.io.ProcessLauncher;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleManagerUpdateHelper {
    private static final Logger logger = LoggerFactory.getLogger(ModuleManagerUpdateHelper.class);

    private ModuleManagerUpdateHelper() {
    }

    private static void sendUpdate(File f, String type) {
        ArrayList<CallSite> args = new ArrayList<CallSite>(List.of(Info.getJavaBinPath().getAbsolutePath(), "-classpath", System.getProperty("java.class.path"), "-Duser.dir=" + System.getProperty("user.dir"), "VASSAL.launch.ModuleManager", "--update-" + type));
        String p = f.getPath();
        if (ArgEncoding.requires(p)) {
            args.add((CallSite)((Object)"--encoded-args"));
            args.add((CallSite)((Object)ArgEncoding.encode(p)));
        } else {
            args.add((CallSite)((Object)p));
        }
        try {
            new ProcessLauncher().launch(args.toArray(new String[0]));
        }
        catch (IOException e) {
            logger.error("Failed to notify Module Manager of update", (Throwable)e);
        }
    }

    public static void sendModuleUpdate(File f) {
        ModuleManagerUpdateHelper.sendUpdate(f, "module");
    }

    public static void sendExtensionUpdate(File f) {
        ModuleManagerUpdateHelper.sendUpdate(f, "extension");
    }

    public static void sendGameUpdate(File f) {
        ModuleManagerUpdateHelper.sendUpdate(f, "game");
    }
}

