/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.Command;
import VASSAL.command.PlayAudioClipCommand;
import VASSAL.configure.AudioClipConfigurer;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.script.expression.AuditTrail;
import VASSAL.script.expression.Auditable;
import VASSAL.script.expression.AuditableException;
import VASSAL.tools.AudioClip;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.KeyStroke;

public class PlaySound
extends Decorator
implements TranslatablePiece {
    public static final String ID = "playSound;";
    protected String menuText;
    protected NamedKeyStroke stroke;
    protected boolean sendToOthers;
    protected KeyCommand command;
    protected KeyCommand[] commands;
    protected FormattedString format = new FormattedString();
    protected String description = "";

    public PlaySound() {
        this(ID, null);
    }

    public PlaySound(String type, GamePiece piece) {
        this.mySetType(type);
        this.setInner(piece);
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.format.getFormat()).append(this.menuText).append(this.stroke).append(this.sendToOthers).append(this.description);
        return ID + se.getValue();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            this.command = new KeyCommand(this.menuText, this.stroke, Decorator.getOutermost(this), (TranslatablePiece)this);
            this.commands = this.menuText.length() > 0 && this.stroke != null && !this.stroke.isNull() ? new KeyCommand[]{this.command} : KeyCommand.NONE;
        }
        return this.commands;
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        this.myGetKeyCommands();
        PlayAudioClipCommand c = null;
        if (this.command.matches(stroke)) {
            AuditTrail audit = AuditTrail.create((Auditable)this, this.format, Resources.getString("Editor.PlaySound.sound_clip"));
            String clipName = this.format.getText((PropertySource)Decorator.getOutermost(this), (Auditable)this, audit);
            c = new PlayAudioClipCommand(clipName);
            try {
                AudioClip clip;
                if (!GlobalOptions.getInstance().isSoundGlobalMute().booleanValue() && (clip = GameModule.getGameModule().getDataArchive().getCachedAudioClip(clipName)) != null) {
                    clip.play();
                }
            }
            catch (IOException e) {
                PlaySound.reportDataError(this, Resources.getString("Error.not_found", "Audio Clip"), "Clip=" + clipName, new AuditableException(this, audit));
            }
        }
        return c;
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public String getDescription() {
        Object s = this.buildDescription("Editor.PlaySound.trait_description", this.format.getFormat(), this.description);
        s = (String)s + this.getCommandDesc(this.menuText, this.stroke);
        return s;
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.PlaySound.trait_description");
    }

    @Override
    public void mySetType(String type) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        st.nextToken();
        this.format = new FormattedString(st.nextToken(""));
        this.menuText = st.nextToken(Resources.getString("Editor.PlaySound.default_command"));
        this.stroke = st.nextNamedKeyStroke('P');
        this.sendToOthers = st.nextBoolean(false);
        this.description = st.nextToken("");
        this.commands = null;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("PlaySound.html");
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.menuText, Resources.getString("Editor.PlaySound.play_sound_command"));
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Arrays.asList(this.stroke);
    }

    @Override
    public List<String> getMenuTextList() {
        return List.of(this.menuText);
    }

    public static class Ed
    implements PieceEditor {
        private final StringConfigurer menuConfig;
        private final NamedHotKeyConfigurer keyConfig;
        private final AudioClipConfigurer soundConfig;
        private final BooleanConfigurer sendConfig;
        private final TraitConfigPanel panel;
        private final StringConfigurer descConfig;

        public Ed(PlaySound p) {
            this.descConfig = new StringConfigurer(p.description);
            this.descConfig.setHintKey("Editor.description_hint");
            this.menuConfig = new StringConfigurer(p.menuText);
            this.menuConfig.setHintKey("Editor.menu_command_hint");
            this.keyConfig = new NamedHotKeyConfigurer(p.stroke);
            this.soundConfig = new AudioClipConfigurer(null, "", GameModule.getGameModule().getArchiveWriter());
            this.soundConfig.setValue(p.format.getFormat());
            this.soundConfig.setEditable(true);
            this.sendConfig = new BooleanConfigurer(p.sendToOthers);
            this.panel = new TraitConfigPanel();
            this.panel.add("Editor.description_label", (Configurer)this.descConfig);
            this.panel.add("Editor.menu_command", (Configurer)this.menuConfig);
            this.panel.add("Editor.keyboard_command", (Configurer)this.keyConfig);
            this.panel.add("Editor.PlaySound.sound_clip", (Configurer)this.soundConfig);
            this.panel.add("Editor.PlaySound.other_players", (Configurer)this.sendConfig);
        }

        @Override
        public Component getControls() {
            return this.panel;
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.soundConfig.getValueString()).append(this.menuConfig.getValueString()).append(this.keyConfig.getValueString()).append(this.sendConfig.getValueString()).append(this.descConfig.getValueString());
            return PlaySound.ID + se.getValue();
        }

        @Override
        public String getState() {
            return "";
        }
    }
}

