/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerPanel;
import VASSAL.tools.ScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class FontConfigurer
extends Configurer {
    private JPanel p;
    private JComboBox<Integer> size;
    private JComboBox<String> family;
    private final int[] sizes;

    public FontConfigurer(String key, String name) {
        this(key, name, new Font("SansSerif", 0, 12));
    }

    public FontConfigurer(String key, String name, Font val) {
        this(key, name, val, new int[]{9, 10, 11, 12, 15, 18});
    }

    public FontConfigurer(String key, String name, Font val, int[] sizes) {
        super(key, name, val);
        this.sizes = sizes;
    }

    @Override
    public String getValueString() {
        return FontConfigurer.encode((Font)this.value);
    }

    @Override
    public void setValue(String s) {
        this.setValue(FontConfigurer.decode(s));
    }

    @Override
    public Component getControls() {
        if (this.p == null) {
            String[] s;
            this.p = new ConfigurerPanel(this.getName(), "[]rel[]", "[]rel[]rel[]");
            this.family = new JComboBox();
            for (String element : s = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
                this.family.addItem(element);
            }
            this.family.setSelectedItem(this.value == null ? "SansSerif" : ((Font)this.value).getFamily());
            this.family.setMaximumSize(new Dimension(this.family.getMaximumSize().width, this.family.getPreferredSize().height));
            this.p.add(this.family);
            this.size = new JComboBox();
            for (int item : this.sizes) {
                this.size.addItem(item);
            }
            this.size.setSelectedItem(this.value == null ? this.sizes[this.sizes.length / 2] : ((Font)this.value).getSize());
            this.size.setMaximumSize(new Dimension(this.size.getMaximumSize().width, this.size.getPreferredSize().height));
            this.p.add(this.size);
            ItemListener itemListener = evt -> this.setValue(new Font((String)this.family.getSelectedItem(), 0, (Integer)this.size.getSelectedItem()));
            this.size.addItemListener(itemListener);
            this.family.addItemListener(itemListener);
        }
        return this.p;
    }

    public static Font decode(String s) {
        int i = s.indexOf(44);
        return new Font(s.substring(0, i), 0, Integer.parseInt(s.substring(i + 1)));
    }

    public static String encode(Font f) {
        return f.getName() + "," + f.getSize();
    }

    @Override
    public void setLabelVisibile(boolean visible) {
        if (this.p instanceof ConfigurerPanel) {
            ((ConfigurerPanel)this.p).setLabelVisibility(visible);
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setLayout(new BoxLayout(f.getContentPane(), 1));
        FontConfigurer c = new FontConfigurer("a", "Font: ", null, new int[]{4, 5, 6, 13});
        f.add(c.getControls());
        JTextArea tf = new JTextArea();
        tf.setText("The quick brown fox jumps over the lazy dog.");
        f.add(new ScrollPane(tf));
        c.addPropertyChangeListener(evt -> {
            Font font = (Font)evt.getNewValue();
            FontConfigurer fc = new FontConfigurer(null, null, font);
            fc.setValue(fc.getValueString());
            font = (Font)fc.getValue();
            tf.setFont(font);
            f.pack();
        });
        f.pack();
        f.setVisible(true);
    }
}

