/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.build.GameModule;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.LockableChatServerConnection;
import VASSAL.chat.Player;
import VASSAL.chat.Room;
import VASSAL.chat.SoundEncoder;
import VASSAL.chat.ui.PlayerActionFactory;
import VASSAL.configure.SoundConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.preferences.Prefs;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class SendSoundAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static Room lastRoom;
    private static Player lastPlayer;
    private static long lastSound;
    private final ChatServerConnection client;
    private final Player target;
    private final String soundKey;

    public SendSoundAction(String name, ChatServerConnection client, String soundKey, Player target) {
        super(name);
        this.client = client;
        this.soundKey = soundKey;
        this.target = target;
        Room targetRoom = null;
        for (Room room : client.getAvailableRooms()) {
            if (!room.getPlayerList().contains(target)) continue;
            targetRoom = room;
        }
        this.setEnabled(target != null && GameModule.getGameModule() != null && !target.equals(client.getUserInfo()) && client.getRoom() != null && client.getRoom().equals(targetRoom) && (!targetRoom.equals(lastRoom) || !target.equals(lastPlayer) || System.currentTimeMillis() - lastSound > 10000L));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.client.sendTo(this.target, new SoundEncoder.Cmd(this.soundKey, this.client.getUserInfo()));
        lastPlayer = this.target;
        lastRoom = this.client.getRoom();
        lastSound = System.currentTimeMillis();
    }

    public static PlayerActionFactory factory(ChatServerConnection client, String name, String soundKey, String defaultSoundFile) {
        if (GameModule.getGameModule() != null) {
            Prefs.getGlobalPrefs().addOption(Resources.getString("Prefs.sounds_tab"), new SoundConfigurer(soundKey, name, defaultSoundFile));
        }
        return (p, tree) -> {
            Room r = client.getRoom();
            if (client instanceof LockableChatServerConnection && ((LockableChatServerConnection)client).isDefaultRoom(r)) {
                return null;
            }
            return new SendSoundAction(name, client, soundKey, p);
        };
    }

    static {
        lastSound = System.currentTimeMillis();
    }
}

