/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.Info;
import VASSAL.build.GameModule;
import VASSAL.chat.PlayerStatus;
import VASSAL.tools.SequenceEncoder;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SimpleStatus
implements PlayerStatus {
    public static final String CRC = "crc";
    public static final String MODULE_VERSION = "moduleVersion";
    public static final String IP = "ip";
    public static final String CLIENT = "client";
    public static final String PROFILE = "profile";
    public static final String AWAY = "away";
    public static final String LOOKING = "looking";
    public static final String NAME = "name";
    private final boolean looking;
    private final boolean away;
    private String profile;
    private String client;
    private String ip;
    private String moduleVersion;
    private String crc;

    public SimpleStatus() {
        this(false, false, "");
    }

    public SimpleStatus(boolean looking, boolean away) {
        this(looking, away, "");
    }

    public SimpleStatus(boolean looking, boolean away, String profile) {
        this(looking, away, profile, "", "", "", "");
    }

    public SimpleStatus(boolean looking, boolean away, String profile, String client, String ip, String module, String crc) {
        this.looking = looking;
        this.away = away;
        this.profile = profile;
        this.client = client;
        this.ip = ip;
        this.moduleVersion = module;
        this.crc = crc;
    }

    public boolean isAway() {
        return this.away;
    }

    public boolean isLooking() {
        return this.looking;
    }

    public String getProfile() {
        return this.profile;
    }

    public String getClient() {
        return this.client;
    }

    public String getIp() {
        return this.ip;
    }

    public String getModuleVersion() {
        return this.moduleVersion;
    }

    public String getCrc() {
        return this.crc;
    }

    public static String encode(SimpleStatus s) {
        SequenceEncoder se = new SequenceEncoder(',');
        se.append(s.looking);
        se.append(s.away);
        se.append(s.profile);
        se.append(s.client);
        se.append(s.ip);
        se.append(s.moduleVersion);
        se.append(s.crc);
        return se.getValue();
    }

    public static SimpleStatus decode(String s) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, ',');
        return new SimpleStatus(sd.nextBoolean(false), sd.nextBoolean(false), sd.nextToken(""), sd.nextToken(""), sd.nextToken(""), sd.nextToken(""), sd.nextToken(""));
    }

    public void updateStatus() {
        GameModule g = GameModule.getGameModule();
        this.profile = (String)g.getPrefs().getValue("Profile");
        this.client = Info.getVersion();
        this.ip = "";
        try {
            this.ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.moduleVersion = g.getGameVersion() + (g.getArchiveWriter() == null ? "" : " (Editing)");
        this.crc = Long.toHexString(g.getCrc());
    }
}

