/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.properties;

import VASSAL.build.module.properties.EnumeratedPropertyPrompt;
import VASSAL.build.module.properties.IncrementProperty;
import VASSAL.build.module.properties.NumericPropertyPrompt;
import VASSAL.build.module.properties.PropertyChanger;
import VASSAL.build.module.properties.PropertyPrompt;
import VASSAL.build.module.properties.PropertySetter;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.configure.ConfigurableListEntry;
import VASSAL.configure.Configurer;
import VASSAL.configure.FormattedExpressionConfigurer;
import VASSAL.configure.FormattedStringArrayConfigurer;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.TranslatingStringEnumConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class PropertyChangerConfigurer
extends Configurer {
    protected static final String PLAIN_TYPE = "Set value directly";
    protected static final String INCREMENT_TYPE = "Increment numeric value";
    protected static final String PROMPT_TYPE = "Prompt user";
    protected static final String SELECT_TYPE = "Prompt user to select from list";
    protected static final char PLAIN_CODE = 'P';
    protected static final char PROMPT_CODE = 'R';
    protected static final char ENUM_CODE = 'E';
    protected static final char INCR_CODE = 'I';
    protected static final Map<Class<? extends PropertyChanger>, Character> typeToCode = new HashMap<Class<? extends PropertyChanger>, Character>();
    protected static final Map<Class<? extends PropertyChanger>, String> typeToDescription = new HashMap<Class<? extends PropertyChanger>, String>();
    protected static final Map<String, Character> descriptionToCode = new HashMap<String, Character>();
    protected Constraints constraints;
    protected JPanel controls;
    protected JLabel typeLabel;
    protected TranslatingStringEnumConfigurer typeConfig;
    protected JLabel valueLabel;
    protected FormattedExpressionConfigurer valueConfig;
    private JPanel valueControlsPanel;
    protected JLabel promptLabel;
    protected StringConfigurer promptConfig;
    protected JLabel incrLabel;
    protected FormattedExpressionConfigurer incrConfig;
    protected StringArrayConfigurer validValuesConfig;
    protected JPanel changerLabelControls;
    protected JPanel changerControls;
    private List<Configurer> subConfigurers;

    public PropertyChangerConfigurer(String key, String name, Constraints constraints) {
        super(key, name);
        this.constraints = constraints;
        this.setValue(new PropertySetter("", null));
    }

    @Override
    public Component getControls() {
        if (this.controls == null) {
            PropertyChangeListener l = evt -> {
                this.updateValue();
                this.updateControls();
                this.updateValue();
            };
            this.controls = new JPanel();
            this.controls.setLayout((LayoutManager)new MigLayout("ins 0,hidemode 3", "[]rel[][]rel[fill,grow][fill,grow]"));
            this.typeLabel = new JLabel(Resources.getString("Editor.PropertyChangeConfigurer.type"));
            this.typeConfig = new TranslatingStringEnumConfigurer(new String[]{PLAIN_TYPE, INCREMENT_TYPE, PROMPT_TYPE, SELECT_TYPE}, new String[]{"Editor.PropertyChangeConfigurer.plain_type", "Editor.PropertyChangeConfigurer.increment_type", "Editor.PropertyChangeConfigurer.prompt_type", "Editor.PropertyChangeConfigurer.select_type"});
            this.typeConfig.addPropertyChangeListener(l);
            this.typeLabel.setLabelFor(this.typeConfig.getControls());
            this.valueLabel = new JLabel(Resources.getString("Editor.PropertyChangeConfigurer.new_value"));
            this.valueConfig = new FormattedExpressionConfigurer("", this.constraints);
            this.valueConfig.setHint(Resources.getString("Editor.PropertyChangeConfigurer.plain_hint"));
            this.valueLabel.setLabelFor(this.valueConfig.getControls());
            this.valueConfig.addPropertyChangeListener(l);
            this.promptLabel = new JLabel(Resources.getString("Editor.PropertyChangeConfigurer.prompt"));
            this.promptConfig = new StringConfigurer("");
            this.promptConfig.setHint(Resources.getString("Editor.PropertyChangeConfigurer.prompt_hint"));
            this.promptLabel.setLabelFor(this.promptConfig.getControls());
            this.promptConfig.addPropertyChangeListener(l);
            this.incrLabel = new JLabel(Resources.getString("Editor.PropertyChangeConfigurer.increment_by"));
            this.incrConfig = new FormattedExpressionConfigurer("", this.constraints);
            this.incrConfig.setHint(Resources.getString("Editor.PropertyChangeConfigurer.increment_hint"));
            this.incrLabel.setLabelFor(this.incrConfig.getControls());
            this.incrConfig.addPropertyChangeListener(l);
            this.validValuesConfig = new NoUpdateFormattedStringArrayConfigurer(null, Resources.getString("Editor.PropertyChangeConfigurer.valid_values"), this.constraints);
            this.validValuesConfig.setHint(Resources.getString("Editor.PropertyChangeConfigurer.valid_values_hint"));
            this.validValuesConfig.addPropertyChangeListener(l);
            this.valueControlsPanel = new JPanel((LayoutManager)new MigLayout("ins 0,hidemode 3", "[]rel[grow,fill]rel[]"));
            this.valueControlsPanel.add(new JLabel(Resources.getString("Editor.PropertyChangeConfigurer.values")));
            this.valueControlsPanel.add(this.validValuesConfig.getControls(), "grow");
            this.valueControlsPanel.add((Component)this.validValuesConfig.getListController(), "aligny center");
            this.controls.add((Component)this.typeLabel, "aligny center");
            this.controls.add(this.typeConfig.getControls(), "aligny center");
            this.changerLabelControls = new JPanel((LayoutManager)new MigLayout("ins 0,hidemode 3", "[]", "[]"));
            this.changerLabelControls.add((Component)this.valueLabel, "aligny center");
            this.changerLabelControls.add((Component)this.promptLabel, "aligny center");
            this.changerLabelControls.add((Component)this.incrLabel, "aligny center");
            this.controls.add((Component)this.changerLabelControls, "aligny center");
            this.changerControls = new JPanel((LayoutManager)new MigLayout("ins 0,hidemode 3", "[fill,grow]"));
            this.changerControls.add(this.valueConfig.getControls(), "growx,aligny center");
            this.changerControls.add(this.promptConfig.getControls(), "growx,aligny center");
            this.changerControls.add(this.incrConfig.getControls(), "growx,aligny center");
            this.controls.add((Component)this.changerControls, "aligny center,growx");
            this.controls.add((Component)this.valueControlsPanel, "aligny center,growx");
            this.subConfigurers = List.of(this.typeConfig, this.incrConfig, this.valueConfig, this.promptConfig, this.validValuesConfig);
            this.updateControls();
        }
        return this.controls;
    }

    public Component getTypeLabel() {
        this.getControls();
        return this.typeLabel;
    }

    public Component getTypeControls() {
        this.getControls();
        return this.typeConfig.getControls();
    }

    public Component getChangerLabel() {
        this.getControls();
        return this.changerLabelControls;
    }

    public Component getChangerControls() {
        this.getControls();
        return this.changerControls;
    }

    public Component getValuesControls() {
        this.getControls();
        return this.valueControlsPanel;
    }

    protected void updateControls() {
        PropertyChanger pc = this.getPropertyChanger();
        this.typeConfig.setValue(typeToDescription.get(pc.getClass()));
        if (pc instanceof PropertySetter) {
            this.valueConfig.setValue(((PropertySetter)pc).getRawValue());
            this.valueConfig.getControls().setVisible(true);
            this.valueControlsPanel.setVisible(true);
        } else {
            this.valueConfig.getControls().setVisible(false);
            this.valueLabel.setVisible(false);
        }
        if (pc instanceof IncrementProperty) {
            this.incrConfig.setValue(String.valueOf(((IncrementProperty)pc).getIncrement()));
            this.incrConfig.getControls().setVisible(true);
            this.incrLabel.setVisible(true);
        } else {
            this.incrConfig.getControls().setVisible(false);
            this.incrLabel.setVisible(false);
        }
        if (pc instanceof PropertyPrompt) {
            this.promptConfig.setValue(((PropertyPrompt)pc).getPrompt());
            this.promptConfig.getControls().setVisible(true);
            this.promptLabel.setVisible(true);
        } else {
            this.promptConfig.getControls().setVisible(false);
            this.promptLabel.setVisible(false);
        }
        if (pc instanceof EnumeratedPropertyPrompt) {
            this.validValuesConfig.setValue(((EnumeratedPropertyPrompt)pc).getValidValues());
            this.valueControlsPanel.setVisible(true);
        } else {
            this.valueControlsPanel.setVisible(false);
        }
        this.repack();
    }

    protected void updateValue() {
        PropertyChanger p;
        switch (descriptionToCode.get(this.typeConfig.getValueString()).charValue()) {
            case 'R': {
                p = new PropertyPrompt(this.constraints, this.promptConfig.getValueString());
                break;
            }
            case 'I': {
                p = new IncrementProperty(this, this.incrConfig.getValueString(), this.constraints);
                break;
            }
            case 'E': {
                p = new EnumeratedPropertyPrompt(this.constraints, this.promptConfig.getValueString(), this.validValuesConfig.getStringArray(), this.constraints);
                break;
            }
            default: {
                p = new PropertySetter(this.valueConfig.getValueString(), this.constraints);
            }
        }
        this.setValue(p);
    }

    @Override
    public String getValueString() {
        PropertyChanger propChanger = this.getPropertyChanger();
        SequenceEncoder se = new SequenceEncoder(',');
        if (propChanger != null) {
            switch (typeToCode.get(propChanger.getClass()).charValue()) {
                case 'R': {
                    se.append('R').append(((PropertyPrompt)propChanger).getPrompt());
                    break;
                }
                case 'I': {
                    se.append('I').append(((IncrementProperty)propChanger).getIncrement());
                    break;
                }
                case 'E': {
                    se.append('E').append(((PropertyPrompt)propChanger).getPrompt()).append(((EnumeratedPropertyPrompt)propChanger).getValidValues());
                    break;
                }
                case 'P': {
                    se.append('P').append(((PropertySetter)propChanger).getRawValue());
                }
            }
        }
        return se.getValue();
    }

    public boolean isEnumType() {
        return typeToCode.get(this.getPropertyChanger().getClass()).charValue() == 'E';
    }

    public PropertyChanger getPropertyChanger() {
        return (PropertyChanger)this.getValue();
    }

    @Override
    public void setValue(String s) {
        PropertyChanger p;
        if (s == null || s.length() == 0) {
            s = Character.toString('P');
        }
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, ',');
        switch (sd.nextChar('P')) {
            case 'R': {
                p = new PropertyPrompt(this.constraints, sd.nextToken(Resources.getString("Editor.PropertyChangeConfigurer.enter_new_value")));
                break;
            }
            case 'I': {
                p = new IncrementProperty(this, sd.nextToken("1"), this.constraints);
                break;
            }
            case 'E': {
                p = new EnumeratedPropertyPrompt(this.constraints, sd.nextToken(Resources.getString("Editor.PropertyChangeConfigurer.select_new_value")), sd.nextStringArray(0), this.constraints);
                break;
            }
            default: {
                p = new PropertySetter(sd.nextToken("new value"), this.constraints);
            }
        }
        this.setValue(p);
    }

    @Override
    public void setHighlighted(boolean highlighted) {
        super.setHighlighted(highlighted);
        this.getControls();
        this.subConfigurers.forEach(c -> c.setHighlighted(highlighted));
    }

    @Override
    public void addFocusListener(FocusListener listener) {
        super.addFocusListener(listener);
        this.getControls();
        this.subConfigurers.forEach(c -> c.addFocusListener(listener));
    }

    @Override
    public void removeFocusListener(FocusListener listener) {
        super.removeFocusListener(listener);
        this.getControls();
        this.subConfigurers.forEach(c -> c.removeFocusListener(listener));
    }

    static {
        typeToCode.put(PropertySetter.class, Character.valueOf('P'));
        typeToCode.put(PropertyPrompt.class, Character.valueOf('R'));
        typeToCode.put(NumericPropertyPrompt.class, Character.valueOf('R'));
        typeToCode.put(IncrementProperty.class, Character.valueOf('I'));
        typeToCode.put(EnumeratedPropertyPrompt.class, Character.valueOf('E'));
        typeToDescription.put(PropertySetter.class, PLAIN_TYPE);
        typeToDescription.put(PropertyPrompt.class, PROMPT_TYPE);
        typeToDescription.put(NumericPropertyPrompt.class, PROMPT_TYPE);
        typeToDescription.put(IncrementProperty.class, INCREMENT_TYPE);
        typeToDescription.put(EnumeratedPropertyPrompt.class, SELECT_TYPE);
        descriptionToCode.put(PLAIN_TYPE, Character.valueOf('P'));
        descriptionToCode.put(INCREMENT_TYPE, Character.valueOf('I'));
        descriptionToCode.put(PROMPT_TYPE, Character.valueOf('R'));
        descriptionToCode.put(SELECT_TYPE, Character.valueOf('E'));
    }

    public static interface Constraints
    extends PropertyPrompt.Constraints,
    IncrementProperty.Constraints,
    PropertySource {
    }

    private static class NoUpdateFormattedStringArrayConfigurer
    extends FormattedStringArrayConfigurer {
        public NoUpdateFormattedStringArrayConfigurer(String key, String name, Constraints c) {
            super(key, name, c);
        }

        @Override
        public void entryChanged(ConfigurableListEntry entry) {
            this.getStringArray()[this.getEntries().indexOf((Object)entry)] = entry.getConfigurer().getValueString();
        }
    }
}

