/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Map;
import VASSAL.build.module.map.Drawable;
import VASSAL.counters.ColoredBorder;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitor;
import VASSAL.counters.DragBuffer;
import VASSAL.counters.EventFilter;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Immobilized;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.PieceFinder;
import VASSAL.counters.PieceVisitorDispatcher;
import VASSAL.counters.Stack;
import VASSAL.tools.swing.SwingUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.JComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KeyBufferer
extends MouseAdapter
implements Buildable,
MouseMotionListener,
Drawable {
    protected Map map;
    protected Rectangle selection;
    protected Point anchor;
    protected Color color = Color.black;
    protected int thickness = 3;
    protected GamePiece bandSelectPiece = null;
    private GamePiece maybeClickPiece = null;
    protected boolean isLasso = false;

    @Override
    public void addTo(Buildable b) {
        this.map = (Map)b;
        this.map.addLocalMouseListenerFirst(this);
        this.map.getView().addMouseMotionListener(this);
        this.map.addDrawComponent(this);
        this.map.setKeyBufferer(this);
    }

    public void dragStarted() {
        this.maybeClickPiece = null;
    }

    @Override
    public void add(Buildable b) {
    }

    @Override
    public Element getBuildElement(Document doc) {
        return doc.createElement(this.getClass().getName());
    }

    @Override
    public void build(Element e) {
    }

    public boolean isLasso() {
        return this.isLasso;
    }

    private void removePieceOrStack(GamePiece p) {
        if (Boolean.TRUE.equals(p.getProperty("Selected"))) {
            Stack s = p.getParent();
            if (s == null) {
                KeyBuffer.getBuffer().remove(p);
            } else if (!s.isExpanded()) {
                s.asList().forEach(gamePiece -> KeyBuffer.getBuffer().remove((GamePiece)gamePiece));
            } else {
                KeyBuffer.getBuffer().remove(p);
            }
        }
    }

    private void selectOnlyPieceOrStack(GamePiece p) {
        DragBuffer.getBuffer().clear();
        KeyBuffer.getBuffer().clear();
        Stack s = p.getParent();
        if (s == null) {
            KeyBuffer.getBuffer().add(p);
        } else if (!s.isExpanded()) {
            s.asList().forEach(gamePiece -> KeyBuffer.getBuffer().add((GamePiece)gamePiece));
        } else {
            KeyBuffer.getBuffer().add(p);
        }
        for (GamePiece piece : KeyBuffer.getBuffer().asList()) {
            DragBuffer.getBuffer().add(piece);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        boolean ignoreEvent;
        if (e.isConsumed()) {
            return;
        }
        KeyBuffer kbuf = KeyBuffer.getBuffer();
        GamePiece p = this.map.findPiece(e.getPoint(), PieceFinder.DECK_OR_PIECE_IN_STACK);
        this.maybeClickPiece = null;
        this.isLasso = false;
        EventFilter filter = null;
        BandSelectType bandSelect = BandSelectType.NONE;
        boolean isDeck = p instanceof Deck;
        if (p != null) {
            if (isDeck) {
                p = null;
            } else {
                filter = (EventFilter)p.getProperty("selectEventFilter");
                if (SwingUtils.isMainMouseButtonDown(e) && Boolean.TRUE.equals(p.getProperty("cannotMove"))) {
                    bandSelect = BandSelectType.SPECIAL;
                }
            }
        }
        boolean bl = ignoreEvent = filter != null && filter.rejectEvent(e);
        if (p != null && !ignoreEvent) {
            boolean movingStacksPickupUnits = (Boolean)GameModule.getGameModule().getPrefs().getValue("movingStacksPickupUnits");
            if (!kbuf.contains(p)) {
                if (!e.isShiftDown() && !SwingUtils.isSelectionToggle(e)) {
                    kbuf.clear();
                }
                if (movingStacksPickupUnits || p.getParent() == null || p.getParent().isExpanded() || SwingUtils.isSelectionToggle(e) || SwingUtils.isContextMouseButtonDown(e) || Boolean.TRUE.equals(p.getProperty("Selected"))) {
                    Object o;
                    kbuf.add(p);
                    if (GameModule.getGameModule().isMatSupport() && !SwingUtils.isSelectionToggle(e) && (o = p.getProperty("MatContents")) instanceof List) {
                        List matPieces = (List)o;
                        for (GamePiece mp : matPieces) {
                            kbuf.add(mp);
                        }
                    }
                } else {
                    Stack s = p.getParent();
                    s.asList().forEach(gamePiece -> KeyBuffer.getBuffer().add((GamePiece)gamePiece));
                }
            } else {
                if (SwingUtils.isSelectionToggle(e) && !SwingUtils.isContextMouseButtonDown(e)) {
                    this.removePieceOrStack(p);
                }
                if (GameModule.getGameModule().isMatSupport() && !SwingUtils.isSelectionToggle(e) && !SwingUtils.isContextMouseButtonDown(e) && !e.isShiftDown()) {
                    String matName = (String)p.getProperty("CurrentMat");
                    if (matName != null && !matName.isEmpty()) {
                        this.maybeClickPiece = p;
                        bandSelect = BandSelectType.NONE;
                    }
                    if ((matName = (String)p.getProperty("MatName")) != null && !matName.isEmpty()) {
                        if (e.getClickCount() > 1) {
                            kbuf.clear();
                            kbuf.add(p);
                        } else {
                            Object o = p.getProperty("MatContents");
                            if (o instanceof List) {
                                List matPieces = (List)o;
                                for (GamePiece mp : matPieces) {
                                    kbuf.add(mp);
                                }
                            }
                        }
                    }
                }
            }
            GamePiece to_front = p.getParent() != null ? p.getParent() : p;
            this.map.getPieceCollection().moveToFront(to_front);
        } else {
            bandSelect = BandSelectType.NORMAL;
        }
        if (bandSelect != BandSelectType.NONE) {
            this.bandSelectPiece = null;
            if (!e.isShiftDown() && !SwingUtils.isSelectionToggle(e)) {
                kbuf.clear();
                if (bandSelect == BandSelectType.SPECIAL && p != null && !ignoreEvent) {
                    kbuf.add(p);
                    this.bandSelectPiece = p;
                }
            }
            if (!isDeck) {
                this.anchor = this.map.mapToComponent(e.getPoint());
                this.selection = new Rectangle(this.anchor.x, this.anchor.y, 0, 0);
                if (this.map.getHighlighter() instanceof ColoredBorder) {
                    ColoredBorder b = (ColoredBorder)this.map.getHighlighter();
                    this.color = b.getColor();
                    this.thickness = b.getThickness();
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.selection == null) {
            if (this.maybeClickPiece != null) {
                this.selectOnlyPieceOrStack(this.maybeClickPiece);
            }
            this.isLasso = false;
            return;
        }
        PieceVisitorDispatcher d = this.createDragSelector(!SwingUtils.isSelectionToggle(e), e.isAltDown(), this.map.componentToMap(this.selection));
        int dragThreshold = GlobalOptions.getInstance().getDragThreshold();
        boolean bl = this.isLasso = this.selection.width >= dragThreshold || this.selection.height >= dragThreshold;
        if (this.bandSelectPiece != null) {
            boolean pieceAllowedToBeBandSelected;
            EventFilter bandFilter = (EventFilter)this.bandSelectPiece.getProperty("bandSelectEventFilter");
            boolean bl2 = pieceAllowedToBeBandSelected = bandFilter != null && !e.isAltDown() && bandFilter instanceof Immobilized.UseAlt;
            if (pieceAllowedToBeBandSelected && this.isLasso) {
                this.bandSelectPiece = null;
            }
        }
        if (this.bandSelectPiece == null && !e.isShiftDown() && !SwingUtils.isSelectionToggle(e)) {
            KeyBuffer.getBuffer().clear();
        }
        this.map.apply(d);
        this.repaintSelectionRect();
        this.selection = null;
    }

    protected PieceVisitorDispatcher createDragSelector(boolean selecting, boolean altDown, Rectangle mapsel) {
        return new PieceVisitorDispatcher(new KBDeckVisitor(selecting, altDown, mapsel));
    }

    protected void repaintSelectionRect() {
        int ht = this.thickness / 2 + this.thickness % 2;
        int ht2 = 2 * ht;
        JComponent view = this.map.getView();
        view.repaint(this.selection.x - ht, this.selection.y - ht, ht2, this.selection.height + ht2);
        view.repaint(this.selection.x + this.selection.width - ht, this.selection.y - ht, ht2, this.selection.height + ht2);
        view.repaint(this.selection.x - ht, this.selection.y - ht, this.selection.width + ht2, ht2);
        view.repaint(this.selection.x - ht, this.selection.y + this.selection.width - ht, this.selection.width + ht2, ht2);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int dragThreshold;
        if (this.selection == null || !SwingUtils.isMainMouseButtonDown(e)) {
            return;
        }
        this.repaintSelectionRect();
        int ex = e.getX();
        int ey = e.getY();
        this.selection.x = Math.min(ex, this.anchor.x);
        this.selection.y = Math.min(ey, this.anchor.y);
        this.selection.width = Math.abs(ex - this.anchor.x);
        this.selection.height = Math.abs(ey - this.anchor.y);
        if (!(this.isLasso || this.selection.width < (dragThreshold = GlobalOptions.getInstance().getDragThreshold()) && this.selection.height < dragThreshold)) {
            this.isLasso = true;
        }
        this.repaintSelectionRect();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void draw(Graphics g, Map map) {
        if (this.selection == null || !this.isLasso()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        double os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
        Stroke str = g2d.getStroke();
        g2d.setStroke(new BasicStroke((float)((double)this.thickness * os_scale)));
        g2d.setColor(this.color);
        g2d.drawRect((int)((double)this.selection.x * os_scale), (int)((double)this.selection.y * os_scale), (int)((double)this.selection.width * os_scale), (int)((double)this.selection.height * os_scale));
        g2d.setStroke(str);
    }

    @Override
    public boolean drawAboveCounters() {
        return true;
    }

    private static enum BandSelectType {
        NONE,
        NORMAL,
        SPECIAL;

    }

    public class KBDeckVisitor
    implements DeckVisitor {
        boolean selecting;
        boolean altDown;
        Rectangle mapsel;

        public KBDeckVisitor(boolean b, boolean c, Rectangle ms) {
            this.selecting = b;
            this.altDown = c;
            this.mapsel = ms;
        }

        @Override
        public Object visitDeck(Deck d) {
            return null;
        }

        @Override
        public Object visitStack(Stack s) {
            if (s.topPiece() != null) {
                KeyBuffer kbuf = KeyBuffer.getBuffer();
                if (s instanceof Deck) {
                    s.asList().forEach(kbuf::remove);
                    return null;
                }
                if (s.isExpanded()) {
                    Point[] pos = new Point[s.getPieceCount()];
                    KeyBufferer.this.map.getStackMetrics().getContents(s, pos, null, null, s.getPosition().x, s.getPosition().y);
                    for (int i = 0; i < pos.length; ++i) {
                        if (!this.mapsel.contains(pos[i])) continue;
                        if (this.selecting) {
                            kbuf.add(s.getPieceAt(i));
                            continue;
                        }
                        kbuf.remove(s.getPieceAt(i));
                    }
                } else if (this.mapsel.contains(s.getPosition())) {
                    s.asList().forEach(this.selecting ? kbuf::add : kbuf::remove);
                }
            }
            return null;
        }

        @Override
        public Object visitDefault(GamePiece p) {
            Stack s = p.getParent();
            if (s instanceof Deck) {
                KeyBuffer.getBuffer().remove(p);
                return null;
            }
            if (this.mapsel.contains(p.getPosition()) && !Boolean.TRUE.equals(p.getProperty("Invisible"))) {
                if (this.selecting) {
                    boolean altBand;
                    EventFilter filter = (EventFilter)p.getProperty("selectEventFilter");
                    EventFilter bandFilter = (EventFilter)p.getProperty("bandSelectEventFilter");
                    boolean altSelect = this.altDown && filter instanceof Immobilized.UseAlt;
                    boolean bl = altBand = this.altDown && bandFilter instanceof Immobilized.UseAlt;
                    if ((filter == null || altSelect) && (bandFilter == null || altBand)) {
                        KeyBuffer.getBuffer().add(p);
                    }
                } else {
                    KeyBuffer.getBuffer().remove(p);
                }
            }
            return null;
        }
    }
}

