/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.module.gamepieceimage.Visualizable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Visualizer
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected static final int OFFSET = 20;
    protected Visualizable observer;
    protected JPanel visPanel;

    public Visualizer() {
    }

    public Visualizer(Visualizable obs) {
        this.observer = obs;
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.visPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paint(Graphics g) {
                g.clearRect(0, 0, Visualizer.this.observer.getVisualizerWidth(), Visualizer.this.observer.getVisualizerHeight());
                g.drawImage(Visualizer.this.observer.getVisualizerImage(), 0, 0, this);
            }
        };
        this.add((Component)this.visPanel, "Center");
    }

    public void setObserver(Visualizable obs) {
        this.observer = obs;
        this.rebuild();
        this.refresh();
    }

    public void rebuild() {
        if (this.observer != null) {
            this.observer.rebuildVisualizerImage();
            this.refresh();
        }
    }

    public void refresh() {
        if (this.observer != null) {
            int width = this.observer.getVisualizerWidth();
            int height = this.observer.getVisualizerHeight();
            this.visPanel.setSize(width, height);
            this.visPanel.setPreferredSize(new Dimension(width, height));
            this.setSize(width + 20, height + 20);
            this.setPreferredSize(new Dimension(width + 20, height + 20));
            Window w = SwingUtilities.getWindowAncestor(this);
            if (w != null) {
                w.pack();
            }
            this.repaint();
        }
    }
}

