/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.module.gamepieceimage.StringEnumConfigurer;
import VASSAL.build.module.gamepieceimage.Symbol;
import VASSAL.i18n.Resources;
import VASSAL.tools.image.ImageUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class SymbolConfigurer
extends StringEnumConfigurer {
    private static final Map<String, String> symbolMap = new HashMap<String, String>();

    public SymbolConfigurer(String key, String name) {
        super(key, name, Symbol.NatoUnitSymbolSet.getSymbolNames());
        if (symbolMap.isEmpty()) {
            String[] symbolNames = Symbol.NatoUnitSymbolSet.getSymbolNames();
            String[] symbolKeys = Symbol.NatoUnitSymbolSet.getSymbolDisplayNames();
            for (int i = 0; i < symbolNames.length; ++i) {
                symbolMap.put(symbolNames[i], Resources.getString(symbolKeys[i]));
            }
        }
    }

    public JComboBox getComboBox() {
        return new SymbolComboBox();
    }

    public class SymbolComboBox
    extends JComboBox {
        private static final long serialVersionUID = 1L;
        static final int sample_w = 20;
        static final int sample_h = 13;

        public SymbolComboBox() {
            String[] s;
            for (String item : s = Symbol.NatoUnitSymbolSet.getSymbolNames()) {
                this.addItem(item);
            }
            SymbolRenderer renderer = new SymbolRenderer();
            this.setRenderer(renderer);
        }

        public SymbolComboBox(ItemListener l) {
            this();
            this.addItemListener(l);
        }

        public SymbolComboBox(ItemListener l, String symbolName) {
            this();
            this.setSelectedItem(symbolName);
            this.addItemListener(l);
        }

        public class SymbolRenderer
        extends JLabel
        implements ListCellRenderer {
            private static final long serialVersionUID = 1L;

            public SymbolRenderer() {
                this.setOpaque(true);
                this.setHorizontalAlignment(2);
                this.setVerticalAlignment(0);
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                BufferedImage img = ImageUtils.createCompatibleTranslucentImage(20, 13);
                Graphics2D g = img.createGraphics();
                String symbol1 = (String)value;
                String symbol2 = "None";
                Rectangle bounds = new Rectangle(0, 0, 19, 12);
                Symbol.NatoUnitSymbolSet.draw(symbol1, "None", g, bounds, Color.BLACK, Color.WHITE, Color.BLACK, 1.0f, "");
                g.dispose();
                this.setIcon(new ImageIcon(img));
                this.setText(symbolMap.get(value));
                this.setHorizontalTextPosition(2);
                this.setHorizontalAlignment(4);
                this.setFont(list.getFont());
                return this;
            }
        }
    }
}

