/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.module.gamepieceimage.ColorSwatch;
import VASSAL.build.module.gamepieceimage.ColorSwatchConfigurer;
import VASSAL.build.module.gamepieceimage.GamePieceImage;
import VASSAL.build.module.gamepieceimage.ItemInstance;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.i18n.Resources;
import VASSAL.tools.SequenceEncoder;

public class ShapeItemInstance
extends ItemInstance {
    public static final String BORDER_COLOR = "borderColor";
    private ColorSwatch borderColor = ColorSwatch.getBlack();

    public ShapeItemInstance() {
        this.setFgColor(ColorSwatch.getClear());
    }

    public ShapeItemInstance(String code, GamePieceImage defn) {
        super(defn);
        this.decode(code);
    }

    public ShapeItemInstance(String name, String type, String location) {
        super(name, type, location);
        this.setFgColor(ColorSwatch.getClear());
    }

    @Override
    public String encode() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.getType());
        se.append(this.getName());
        se.append(this.getLocation());
        se.append(this.getFgColor().encode());
        se.append(this.getBorderColor().encode());
        return se.getValue();
    }

    public void decode(String code) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(code, ';');
        this.setType(sd.nextToken(""));
        this.setName(sd.nextToken(""));
        this.setLocation(sd.nextToken(""));
        this.setFgColor(new ColorSwatch(sd.nextToken("")));
        this.setBorderColor(new ColorSwatch(sd.nextToken("")));
    }

    protected void setBorderColor(ColorSwatch borderColor) {
        this.borderColor = borderColor;
    }

    protected ColorSwatch getBorderColor() {
        return this.borderColor;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.foreground_color"), Resources.getString("Editor.border_color")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{FgColorSwatchConfig.class, BorderColorSwatchConfig.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{"fgColor", BORDER_COLOR};
    }

    @Override
    public void setAttribute(String key, Object o) {
        if ("fgColor".equals(key)) {
            if (o instanceof String) {
                o = new ColorSwatch((String)o);
            }
            this.fgColor = (ColorSwatch)o;
        } else if (BORDER_COLOR.equals(key)) {
            if (o instanceof String) {
                o = new ColorSwatch((String)o);
            }
            this.setBorderColor((ColorSwatch)o);
        }
        if (this.myConfig != null) {
            this.myConfig.rebuildViz();
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if ("fgColor".equals(key)) {
            return this.fgColor.encode();
        }
        if (BORDER_COLOR.equals(key)) {
            return this.getBorderColor().encode();
        }
        return null;
    }

    public static class FgColorSwatchConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new ColorSwatchConfigurer(key, name, ((ItemInstance)c).getFgColor());
        }
    }

    public static class BorderColorSwatchConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new ColorSwatchConfigurer(key, name, ((ItemInstance)c).getBgColor());
        }
    }
}

