/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.documentation;

import VASSAL.Info;
import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.i18n.Resources;
import VASSAL.tools.BrowserSupport;
import VASSAL.tools.DataArchive;
import VASSAL.tools.menu.MenuItemProxy;
import VASSAL.tools.menu.MenuManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserPDFFile
extends AbstractConfigurable {
    private static final Logger logger = LoggerFactory.getLogger(BrowserPDFFile.class);
    public static final String TITLE = "title";
    public static final String PDF_FILE = "pdfFile";
    protected String menuText = Resources.getString("Editor.BrowserPDFFile.default_menu_text");
    protected String pdfFile = Resources.getString("Editor.BrowserPDFFile.default_filename");
    protected Action launch = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            BrowserPDFFile.this.launch();
        }
    };
    protected URL url;
    protected MenuItemProxy launchItem;

    public void launch() {
        if (this.url == null) {
            this.extractPDF();
        }
        if (this.url != null) {
            BrowserSupport.openURL(this.url.toString());
        }
    }

    protected void extractPDF() {
        DataArchive archive = GameModule.getGameModule().getDataArchive();
        try (InputStream in = archive.getInputStream(this.pdfFile);){
            Path out = Files.createTempFile(Info.getTempDir().toPath(), "pdfhelp_", ".pdf", new FileAttribute[0]);
            try {
                Files.copy(in, out, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                logger.error("Error while copying file {} from data archive", (Object)this.pdfFile, (Object)e);
            }
            this.url = out.toUri().toURL();
            out.toFile().deleteOnExit();
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            logger.error("File not found in data archive: {}", (Object)this.pdfFile, (Object)e);
            this.url = null;
        }
        catch (IOException e) {
            logger.error("Error while reading file {} from data archive", (Object)this.pdfFile, (Object)e);
            this.url = null;
        }
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{TITLE, PDF_FILE};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.menu_command"), Resources.getString("Editor.BrowserPDFFile.pdf_file")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, File.class};
    }

    @Override
    public String getAttributeValueString(String key) {
        if (TITLE.equals(key)) {
            return this.menuText;
        }
        if (PDF_FILE.equals(key)) {
            return this.pdfFile;
        }
        return null;
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (TITLE.equals(key)) {
            this.menuText = (String)value;
            this.launch.putValue("Name", this.menuText);
            this.url = null;
        } else if (PDF_FILE.equals(key)) {
            if (value instanceof File) {
                value = ((File)value).getName();
            }
            this.pdfFile = (String)value;
            this.url = null;
        }
    }

    @Override
    public void addTo(Buildable parent) {
        this.launchItem = new MenuItemProxy(this.launch);
        MenuManager.getInstance().addToSection("Documentation.Module", this.launchItem);
        this.launch.setEnabled(true);
    }

    @Override
    public void removeFrom(Buildable parent) {
        MenuManager.getInstance().removeFromSection("Documentation.Module", this.launchItem);
        this.launch.setEnabled(false);
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public String getConfigureName() {
        return this.menuText;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("HelpMenu.html", "PDF");
    }

    @Override
    public void remove(Buildable child) {
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.BrowserPDFFile.component_type");
    }
}

