/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build;

import VASSAL.build.Configurable;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Localization;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public interface AutoConfigurable
extends Configurable {
    public String[] getAttributeNames();

    @Override
    public void setAttribute(String var1, Object var2);

    @Override
    public String getAttributeValueString(String var1);

    public String[] getAttributeDescriptions();

    public Class<?>[] getAttributeTypes();

    public VisibilityCondition getAttributeVisibility(String var1);

    public static class Util {
        public static void buildAttributes(Element e, AutoConfigurable parent) {
            if (e != null) {
                NamedNodeMap n = e.getAttributes();
                for (int i = 0; i < n.getLength(); ++i) {
                    Attr att = (Attr)n.item(i);
                    parent.setAttribute(att.getName(), att.getValue());
                    Localization.getInstance().saveTranslatableAttribute(parent, att.getName(), att.getValue());
                }
            }
        }

        public static Element getBuildElement(Document doc, AutoConfigurable parent) {
            String[] names;
            Element el = doc.createElement(parent.getClass().getName());
            for (String name : names = parent.getAttributeNames()) {
                String val = parent.getAttributeValueString(name);
                if (val == null) continue;
                el.setAttribute(name, val);
            }
            return el;
        }
    }
}

