/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build;

import VASSAL.build.AbstractFolder;
import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.module.properties.PropertyNameSource;
import VASSAL.configure.ValidationReport;
import VASSAL.configure.ValidityChecker;
import VASSAL.i18n.Localization;
import VASSAL.i18n.Translatable;
import VASSAL.script.expression.Auditable;
import VASSAL.search.AbstractImageFinder;
import VASSAL.search.ImageSearchTarget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public abstract class AbstractBuildable
extends AbstractImageFinder
implements Buildable,
ValidityChecker,
PropertyNameSource,
Auditable {
    protected List<Buildable> buildComponents = new ArrayList<Buildable>();
    protected ValidityChecker validator;
    private Buildable ancestor;

    public Buildable getAncestor() {
        return this.ancestor;
    }

    public void setAncestor(Buildable ancestor) {
        this.ancestor = ancestor;
    }

    public Buildable getNonFolderAncestor() {
        Buildable nonFolderAncestor = this.ancestor;
        while (nonFolderAncestor instanceof AbstractFolder) {
            nonFolderAncestor = ((AbstractFolder)nonFolderAncestor).getAncestor();
        }
        return nonFolderAncestor;
    }

    @Override
    public void build(Element e) {
        if (e == null) {
            return;
        }
        NamedNodeMap n = e.getAttributes();
        for (int i = 0; i < n.getLength(); ++i) {
            Attr att = (Attr)n.item(i);
            this.setAttribute(att.getName(), att.getValue().intern());
            if (!(this instanceof Translatable)) continue;
            Localization.getInstance().saveTranslatableAttribute((Translatable)((Object)this), att.getName(), att.getValue());
        }
        Builder.build(e, this);
    }

    public abstract String[] getAttributeNames();

    public abstract void setAttribute(String var1, Object var2);

    public abstract String getAttributeValueString(String var1);

    public <T> List<T> getComponentsOf(Class<T> target) {
        ArrayList<T> l = new ArrayList<T>();
        for (Buildable b : this.buildComponents) {
            if (target.isInstance(b)) {
                l.add(target.cast(b));
                continue;
            }
            if (!(b instanceof AbstractFolder)) continue;
            l.addAll(((AbstractFolder)b).getComponentsOf(target));
        }
        return l;
    }

    public <T> List<T> getAllDescendantComponentsOf(Class<T> target) {
        ArrayList l = new ArrayList();
        this.addComponents(target, l);
        return l;
    }

    private <T> void addComponents(Class<T> target, List<T> l) {
        if (target.isInstance(this)) {
            l.add(target.cast(this));
        }
        for (Buildable b : this.buildComponents) {
            if (!(b instanceof AbstractBuildable)) continue;
            ((AbstractBuildable)b).addComponents(target, l);
        }
    }

    @Override
    public Element getBuildElement(Document doc) {
        Element el = doc.createElement(this.getClass().getName());
        String[] names = this.getAttributeNames();
        for (String name : names) {
            String val = this.getAttributeValueString(name);
            if (val == null) continue;
            el.setAttribute(name, val);
        }
        for (Buildable b : this.getBuildables()) {
            el.appendChild(b.getBuildElement(doc));
        }
        return el;
    }

    @Override
    public void add(Buildable b) {
        this.buildComponents.add(b);
        if (b instanceof AbstractBuildable) {
            ((AbstractBuildable)b).setAncestor(this);
        }
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public Enumeration<Buildable> getBuildComponents() {
        return Collections.enumeration(this.getBuildables());
    }

    public List<Buildable> getBuildables() {
        return Collections.unmodifiableList(this.buildComponents);
    }

    @Override
    public void validate(Buildable target, ValidationReport report) {
        if (this.validator != null) {
            this.validator.validate(target, report);
        }
        for (Buildable child : this.buildComponents) {
            if (!(child instanceof ValidityChecker)) continue;
            ((ValidityChecker)((Object)child)).validate(child, report);
        }
    }

    @Override
    public List<String> getPropertyNames() {
        return new ArrayList<String>();
    }

    @Override
    public void addImageNamesRecursively(Collection<String> s) {
        this.addLocalImageNames(s);
        for (Buildable child : this.buildComponents) {
            if (!(child instanceof ImageSearchTarget)) continue;
            ((ImageSearchTarget)((Object)child)).addImageNamesRecursively(s);
        }
    }
}

