# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.  # noqa: E501

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from docusign_esign.client.configuration import Configuration


class UserSettingsInformation(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'account_management_granular': 'UserAccountManagementGranularInformation',
        'admin_only': 'str',
        'admin_only_metadata': 'SettingsMetadata',
        'allow_auto_tagging': 'str',
        'allow_envelope_transfer_to': 'str',
        'allow_envelope_transfer_to_metadata': 'SettingsMetadata',
        'allow_eseal_recipients': 'str',
        'allow_eseal_recipients_metadata': 'SettingsMetadata',
        'allow_power_forms_admin_to_access_all_power_form_envelope': 'str',
        'allow_power_forms_admin_to_access_all_power_form_envelope_metadata': 'SettingsMetadata',
        'allow_recipient_language_selection': 'str',
        'allow_recipient_language_selection_metadata': 'SettingsMetadata',
        'allow_send_on_behalf_of': 'str',
        'allow_send_on_behalf_of_metadata': 'SettingsMetadata',
        'allow_supplemental_documents': 'str',
        'allow_supplemental_documents_metadata': 'SettingsMetadata',
        'anchor_tag_versioned_placement_enabled': 'str',
        'api_account_wide_access': 'str',
        'api_account_wide_access_metadata': 'SettingsMetadata',
        'api_can_export_ac': 'str',
        'api_can_export_ac_metadata': 'SettingsMetadata',
        'bulk_send': 'str',
        'bulk_send_metadata': 'SettingsMetadata',
        'can_charge_account': 'str',
        'can_charge_account_metadata': 'SettingsMetadata',
        'can_edit_shared_addressbook': 'str',
        'can_edit_shared_addressbook_metadata': 'SettingsMetadata',
        'can_lock_envelopes': 'str',
        'can_lock_envelopes_metadata': 'SettingsMetadata',
        'can_manage_account': 'str',
        'can_manage_account_metadata': 'SettingsMetadata',
        'can_manage_distributor': 'str',
        'can_manage_distributor_metadata': 'SettingsMetadata',
        'can_manage_templates': 'str',
        'can_manage_templates_metadata': 'SettingsMetadata',
        'can_send_api_requests': 'str',
        'can_send_api_requests_metadata': 'SettingsMetadata',
        'can_send_envelope': 'str',
        'can_send_envelope_metadata': 'SettingsMetadata',
        'can_send_envelopes_via_sms': 'str',
        'can_send_envelopes_via_sms_metadata': 'SettingsMetadata',
        'can_sign_envelope': 'str',
        'can_sign_envelope_metadata': 'SettingsMetadata',
        'can_use_scratchpad': 'str',
        'can_use_scratchpad_metadata': 'SettingsMetadata',
        'can_use_smart_contracts': 'str',
        'can_use_smart_contracts_metadata': 'SettingsMetadata',
        'disable_document_upload': 'str',
        'disable_document_upload_metadata': 'SettingsMetadata',
        'disable_other_actions': 'str',
        'disable_other_actions_metadata': 'SettingsMetadata',
        'enable_ds_pro': 'str',
        'enable_ds_pro_metadata': 'SettingsMetadata',
        'enable_key_terms_suggestions_by_document_type': 'str',
        'enable_key_terms_suggestions_by_document_type_metadata': 'SettingsMetadata',
        'enable_sequential_signing_api': 'str',
        'enable_sequential_signing_api_metadata': 'SettingsMetadata',
        'enable_sequential_signing_ui': 'str',
        'enable_sequential_signing_ui_metadata': 'SettingsMetadata',
        'enable_signer_attachments': 'str',
        'enable_signer_attachments_metadata': 'SettingsMetadata',
        'enable_sign_on_paper_override': 'str',
        'enable_sign_on_paper_override_metadata': 'SettingsMetadata',
        'enable_transaction_point': 'str',
        'enable_transaction_point_metadata': 'SettingsMetadata',
        'enable_vaulting': 'str',
        'enable_vaulting_metadata': 'SettingsMetadata',
        'express_send_only': 'str',
        'locale': 'str',
        'locale_metadata': 'SettingsMetadata',
        'locale_policy': 'LocalePolicy',
        'manage_clickwraps_mode': 'str',
        'manage_clickwraps_mode_metadata': 'SettingsMetadata',
        'modified_by': 'str',
        'modified_by_metadata': 'SettingsMetadata',
        'modified_date': 'str',
        'modified_date_metadata': 'SettingsMetadata',
        'modified_page': 'str',
        'modified_page_metadata': 'SettingsMetadata',
        'new_send_ui': 'str',
        'new_send_ui_metadata': 'SettingsMetadata',
        'power_form_mode': 'str',
        'power_form_mode_metadata': 'SettingsMetadata',
        'recipient_viewed_notification': 'str',
        'recipient_viewed_notification_metadata': 'SettingsMetadata',
        'seal_identifiers': 'list[SealIdentifier]',
        'self_signed_recipient_email_document': 'str',
        'self_signed_recipient_email_document_metadata': 'SettingsMetadata',
        'sender_email_notifications': 'SenderEmailNotifications',
        'signer_email_notifications': 'SignerEmailNotifications',
        'supplemental_document_include_in_download': 'str',
        'supplemental_documents_must_accept': 'str',
        'supplemental_documents_must_accept_metadata': 'SettingsMetadata',
        'supplemental_documents_must_read': 'str',
        'supplemental_documents_must_read_metadata': 'SettingsMetadata',
        'supplemental_documents_must_view': 'str',
        'supplemental_documents_must_view_metadata': 'SettingsMetadata',
        'template_active_creation': 'str',
        'template_active_creation_metadata': 'SettingsMetadata',
        'template_apply_notify': 'str',
        'template_apply_notify_metadata': 'SettingsMetadata',
        'template_auto_matching': 'str',
        'template_auto_matching_metadata': 'SettingsMetadata',
        'template_matching_sensitivity': 'str',
        'template_matching_sensitivity_metadata': 'SettingsMetadata',
        'template_page_level_matching': 'str',
        'template_page_level_matching_metadata': 'SettingsMetadata',
        'timezone_dst': 'str',
        'timezone_dst_metadata': 'SettingsMetadata',
        'timezone_mask': 'str',
        'timezone_mask_metadata': 'SettingsMetadata',
        'timezone_offset': 'str',
        'timezone_offset_metadata': 'SettingsMetadata',
        'timezone_sending_pref': 'str',
        'timezone_sending_pref_metadata': 'SettingsMetadata',
        'timezone_signing_pref': 'str',
        'timezone_signing_pref_metadata': 'SettingsMetadata',
        'transaction_point_site_name_url': 'str',
        'transaction_point_site_name_url_metadata': 'SettingsMetadata',
        'transaction_point_user_name': 'str',
        'transaction_point_user_name_metadata': 'SettingsMetadata',
        'vaulting_mode': 'str',
        'vaulting_mode_metadata': 'SettingsMetadata',
        'web_forms': 'str',
        'web_forms_metadata': 'SettingsMetadata'
    }

    attribute_map = {
        'account_management_granular': 'accountManagementGranular',
        'admin_only': 'adminOnly',
        'admin_only_metadata': 'adminOnlyMetadata',
        'allow_auto_tagging': 'allowAutoTagging',
        'allow_envelope_transfer_to': 'allowEnvelopeTransferTo',
        'allow_envelope_transfer_to_metadata': 'allowEnvelopeTransferToMetadata',
        'allow_eseal_recipients': 'allowEsealRecipients',
        'allow_eseal_recipients_metadata': 'allowEsealRecipientsMetadata',
        'allow_power_forms_admin_to_access_all_power_form_envelope': 'allowPowerFormsAdminToAccessAllPowerFormEnvelope',
        'allow_power_forms_admin_to_access_all_power_form_envelope_metadata': 'allowPowerFormsAdminToAccessAllPowerFormEnvelopeMetadata',
        'allow_recipient_language_selection': 'allowRecipientLanguageSelection',
        'allow_recipient_language_selection_metadata': 'allowRecipientLanguageSelectionMetadata',
        'allow_send_on_behalf_of': 'allowSendOnBehalfOf',
        'allow_send_on_behalf_of_metadata': 'allowSendOnBehalfOfMetadata',
        'allow_supplemental_documents': 'allowSupplementalDocuments',
        'allow_supplemental_documents_metadata': 'allowSupplementalDocumentsMetadata',
        'anchor_tag_versioned_placement_enabled': 'anchorTagVersionedPlacementEnabled',
        'api_account_wide_access': 'apiAccountWideAccess',
        'api_account_wide_access_metadata': 'apiAccountWideAccessMetadata',
        'api_can_export_ac': 'apiCanExportAC',
        'api_can_export_ac_metadata': 'apiCanExportACMetadata',
        'bulk_send': 'bulkSend',
        'bulk_send_metadata': 'bulkSendMetadata',
        'can_charge_account': 'canChargeAccount',
        'can_charge_account_metadata': 'canChargeAccountMetadata',
        'can_edit_shared_addressbook': 'canEditSharedAddressbook',
        'can_edit_shared_addressbook_metadata': 'canEditSharedAddressbookMetadata',
        'can_lock_envelopes': 'canLockEnvelopes',
        'can_lock_envelopes_metadata': 'canLockEnvelopesMetadata',
        'can_manage_account': 'canManageAccount',
        'can_manage_account_metadata': 'canManageAccountMetadata',
        'can_manage_distributor': 'canManageDistributor',
        'can_manage_distributor_metadata': 'canManageDistributorMetadata',
        'can_manage_templates': 'canManageTemplates',
        'can_manage_templates_metadata': 'canManageTemplatesMetadata',
        'can_send_api_requests': 'canSendAPIRequests',
        'can_send_api_requests_metadata': 'canSendAPIRequestsMetadata',
        'can_send_envelope': 'canSendEnvelope',
        'can_send_envelope_metadata': 'canSendEnvelopeMetadata',
        'can_send_envelopes_via_sms': 'canSendEnvelopesViaSMS',
        'can_send_envelopes_via_sms_metadata': 'canSendEnvelopesViaSMSMetadata',
        'can_sign_envelope': 'canSignEnvelope',
        'can_sign_envelope_metadata': 'canSignEnvelopeMetadata',
        'can_use_scratchpad': 'canUseScratchpad',
        'can_use_scratchpad_metadata': 'canUseScratchpadMetadata',
        'can_use_smart_contracts': 'canUseSmartContracts',
        'can_use_smart_contracts_metadata': 'canUseSmartContractsMetadata',
        'disable_document_upload': 'disableDocumentUpload',
        'disable_document_upload_metadata': 'disableDocumentUploadMetadata',
        'disable_other_actions': 'disableOtherActions',
        'disable_other_actions_metadata': 'disableOtherActionsMetadata',
        'enable_ds_pro': 'enableDSPro',
        'enable_ds_pro_metadata': 'enableDSProMetadata',
        'enable_key_terms_suggestions_by_document_type': 'enableKeyTermsSuggestionsByDocumentType',
        'enable_key_terms_suggestions_by_document_type_metadata': 'enableKeyTermsSuggestionsByDocumentTypeMetadata',
        'enable_sequential_signing_api': 'enableSequentialSigningAPI',
        'enable_sequential_signing_api_metadata': 'enableSequentialSigningAPIMetadata',
        'enable_sequential_signing_ui': 'enableSequentialSigningUI',
        'enable_sequential_signing_ui_metadata': 'enableSequentialSigningUIMetadata',
        'enable_signer_attachments': 'enableSignerAttachments',
        'enable_signer_attachments_metadata': 'enableSignerAttachmentsMetadata',
        'enable_sign_on_paper_override': 'enableSignOnPaperOverride',
        'enable_sign_on_paper_override_metadata': 'enableSignOnPaperOverrideMetadata',
        'enable_transaction_point': 'enableTransactionPoint',
        'enable_transaction_point_metadata': 'enableTransactionPointMetadata',
        'enable_vaulting': 'enableVaulting',
        'enable_vaulting_metadata': 'enableVaultingMetadata',
        'express_send_only': 'expressSendOnly',
        'locale': 'locale',
        'locale_metadata': 'localeMetadata',
        'locale_policy': 'localePolicy',
        'manage_clickwraps_mode': 'manageClickwrapsMode',
        'manage_clickwraps_mode_metadata': 'manageClickwrapsModeMetadata',
        'modified_by': 'modifiedBy',
        'modified_by_metadata': 'modifiedByMetadata',
        'modified_date': 'modifiedDate',
        'modified_date_metadata': 'modifiedDateMetadata',
        'modified_page': 'modifiedPage',
        'modified_page_metadata': 'modifiedPageMetadata',
        'new_send_ui': 'newSendUI',
        'new_send_ui_metadata': 'newSendUIMetadata',
        'power_form_mode': 'powerFormMode',
        'power_form_mode_metadata': 'powerFormModeMetadata',
        'recipient_viewed_notification': 'recipientViewedNotification',
        'recipient_viewed_notification_metadata': 'recipientViewedNotificationMetadata',
        'seal_identifiers': 'sealIdentifiers',
        'self_signed_recipient_email_document': 'selfSignedRecipientEmailDocument',
        'self_signed_recipient_email_document_metadata': 'selfSignedRecipientEmailDocumentMetadata',
        'sender_email_notifications': 'senderEmailNotifications',
        'signer_email_notifications': 'signerEmailNotifications',
        'supplemental_document_include_in_download': 'supplementalDocumentIncludeInDownload',
        'supplemental_documents_must_accept': 'supplementalDocumentsMustAccept',
        'supplemental_documents_must_accept_metadata': 'supplementalDocumentsMustAcceptMetadata',
        'supplemental_documents_must_read': 'supplementalDocumentsMustRead',
        'supplemental_documents_must_read_metadata': 'supplementalDocumentsMustReadMetadata',
        'supplemental_documents_must_view': 'supplementalDocumentsMustView',
        'supplemental_documents_must_view_metadata': 'supplementalDocumentsMustViewMetadata',
        'template_active_creation': 'templateActiveCreation',
        'template_active_creation_metadata': 'templateActiveCreationMetadata',
        'template_apply_notify': 'templateApplyNotify',
        'template_apply_notify_metadata': 'templateApplyNotifyMetadata',
        'template_auto_matching': 'templateAutoMatching',
        'template_auto_matching_metadata': 'templateAutoMatchingMetadata',
        'template_matching_sensitivity': 'templateMatchingSensitivity',
        'template_matching_sensitivity_metadata': 'templateMatchingSensitivityMetadata',
        'template_page_level_matching': 'templatePageLevelMatching',
        'template_page_level_matching_metadata': 'templatePageLevelMatchingMetadata',
        'timezone_dst': 'timezoneDST',
        'timezone_dst_metadata': 'timezoneDSTMetadata',
        'timezone_mask': 'timezoneMask',
        'timezone_mask_metadata': 'timezoneMaskMetadata',
        'timezone_offset': 'timezoneOffset',
        'timezone_offset_metadata': 'timezoneOffsetMetadata',
        'timezone_sending_pref': 'timezoneSendingPref',
        'timezone_sending_pref_metadata': 'timezoneSendingPrefMetadata',
        'timezone_signing_pref': 'timezoneSigningPref',
        'timezone_signing_pref_metadata': 'timezoneSigningPrefMetadata',
        'transaction_point_site_name_url': 'transactionPointSiteNameURL',
        'transaction_point_site_name_url_metadata': 'transactionPointSiteNameURLMetadata',
        'transaction_point_user_name': 'transactionPointUserName',
        'transaction_point_user_name_metadata': 'transactionPointUserNameMetadata',
        'vaulting_mode': 'vaultingMode',
        'vaulting_mode_metadata': 'vaultingModeMetadata',
        'web_forms': 'webForms',
        'web_forms_metadata': 'webFormsMetadata'
    }

    def __init__(self, _configuration=None, **kwargs):  # noqa: E501
        """UserSettingsInformation - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._account_management_granular = None
        self._admin_only = None
        self._admin_only_metadata = None
        self._allow_auto_tagging = None
        self._allow_envelope_transfer_to = None
        self._allow_envelope_transfer_to_metadata = None
        self._allow_eseal_recipients = None
        self._allow_eseal_recipients_metadata = None
        self._allow_power_forms_admin_to_access_all_power_form_envelope = None
        self._allow_power_forms_admin_to_access_all_power_form_envelope_metadata = None
        self._allow_recipient_language_selection = None
        self._allow_recipient_language_selection_metadata = None
        self._allow_send_on_behalf_of = None
        self._allow_send_on_behalf_of_metadata = None
        self._allow_supplemental_documents = None
        self._allow_supplemental_documents_metadata = None
        self._anchor_tag_versioned_placement_enabled = None
        self._api_account_wide_access = None
        self._api_account_wide_access_metadata = None
        self._api_can_export_ac = None
        self._api_can_export_ac_metadata = None
        self._bulk_send = None
        self._bulk_send_metadata = None
        self._can_charge_account = None
        self._can_charge_account_metadata = None
        self._can_edit_shared_addressbook = None
        self._can_edit_shared_addressbook_metadata = None
        self._can_lock_envelopes = None
        self._can_lock_envelopes_metadata = None
        self._can_manage_account = None
        self._can_manage_account_metadata = None
        self._can_manage_distributor = None
        self._can_manage_distributor_metadata = None
        self._can_manage_templates = None
        self._can_manage_templates_metadata = None
        self._can_send_api_requests = None
        self._can_send_api_requests_metadata = None
        self._can_send_envelope = None
        self._can_send_envelope_metadata = None
        self._can_send_envelopes_via_sms = None
        self._can_send_envelopes_via_sms_metadata = None
        self._can_sign_envelope = None
        self._can_sign_envelope_metadata = None
        self._can_use_scratchpad = None
        self._can_use_scratchpad_metadata = None
        self._can_use_smart_contracts = None
        self._can_use_smart_contracts_metadata = None
        self._disable_document_upload = None
        self._disable_document_upload_metadata = None
        self._disable_other_actions = None
        self._disable_other_actions_metadata = None
        self._enable_ds_pro = None
        self._enable_ds_pro_metadata = None
        self._enable_key_terms_suggestions_by_document_type = None
        self._enable_key_terms_suggestions_by_document_type_metadata = None
        self._enable_sequential_signing_api = None
        self._enable_sequential_signing_api_metadata = None
        self._enable_sequential_signing_ui = None
        self._enable_sequential_signing_ui_metadata = None
        self._enable_signer_attachments = None
        self._enable_signer_attachments_metadata = None
        self._enable_sign_on_paper_override = None
        self._enable_sign_on_paper_override_metadata = None
        self._enable_transaction_point = None
        self._enable_transaction_point_metadata = None
        self._enable_vaulting = None
        self._enable_vaulting_metadata = None
        self._express_send_only = None
        self._locale = None
        self._locale_metadata = None
        self._locale_policy = None
        self._manage_clickwraps_mode = None
        self._manage_clickwraps_mode_metadata = None
        self._modified_by = None
        self._modified_by_metadata = None
        self._modified_date = None
        self._modified_date_metadata = None
        self._modified_page = None
        self._modified_page_metadata = None
        self._new_send_ui = None
        self._new_send_ui_metadata = None
        self._power_form_mode = None
        self._power_form_mode_metadata = None
        self._recipient_viewed_notification = None
        self._recipient_viewed_notification_metadata = None
        self._seal_identifiers = None
        self._self_signed_recipient_email_document = None
        self._self_signed_recipient_email_document_metadata = None
        self._sender_email_notifications = None
        self._signer_email_notifications = None
        self._supplemental_document_include_in_download = None
        self._supplemental_documents_must_accept = None
        self._supplemental_documents_must_accept_metadata = None
        self._supplemental_documents_must_read = None
        self._supplemental_documents_must_read_metadata = None
        self._supplemental_documents_must_view = None
        self._supplemental_documents_must_view_metadata = None
        self._template_active_creation = None
        self._template_active_creation_metadata = None
        self._template_apply_notify = None
        self._template_apply_notify_metadata = None
        self._template_auto_matching = None
        self._template_auto_matching_metadata = None
        self._template_matching_sensitivity = None
        self._template_matching_sensitivity_metadata = None
        self._template_page_level_matching = None
        self._template_page_level_matching_metadata = None
        self._timezone_dst = None
        self._timezone_dst_metadata = None
        self._timezone_mask = None
        self._timezone_mask_metadata = None
        self._timezone_offset = None
        self._timezone_offset_metadata = None
        self._timezone_sending_pref = None
        self._timezone_sending_pref_metadata = None
        self._timezone_signing_pref = None
        self._timezone_signing_pref_metadata = None
        self._transaction_point_site_name_url = None
        self._transaction_point_site_name_url_metadata = None
        self._transaction_point_user_name = None
        self._transaction_point_user_name_metadata = None
        self._vaulting_mode = None
        self._vaulting_mode_metadata = None
        self._web_forms = None
        self._web_forms_metadata = None
        self.discriminator = None

        setattr(self, "_{}".format('account_management_granular'), kwargs.get('account_management_granular', None))
        setattr(self, "_{}".format('admin_only'), kwargs.get('admin_only', None))
        setattr(self, "_{}".format('admin_only_metadata'), kwargs.get('admin_only_metadata', None))
        setattr(self, "_{}".format('allow_auto_tagging'), kwargs.get('allow_auto_tagging', None))
        setattr(self, "_{}".format('allow_envelope_transfer_to'), kwargs.get('allow_envelope_transfer_to', None))
        setattr(self, "_{}".format('allow_envelope_transfer_to_metadata'), kwargs.get('allow_envelope_transfer_to_metadata', None))
        setattr(self, "_{}".format('allow_eseal_recipients'), kwargs.get('allow_eseal_recipients', None))
        setattr(self, "_{}".format('allow_eseal_recipients_metadata'), kwargs.get('allow_eseal_recipients_metadata', None))
        setattr(self, "_{}".format('allow_power_forms_admin_to_access_all_power_form_envelope'), kwargs.get('allow_power_forms_admin_to_access_all_power_form_envelope', None))
        setattr(self, "_{}".format('allow_power_forms_admin_to_access_all_power_form_envelope_metadata'), kwargs.get('allow_power_forms_admin_to_access_all_power_form_envelope_metadata', None))
        setattr(self, "_{}".format('allow_recipient_language_selection'), kwargs.get('allow_recipient_language_selection', None))
        setattr(self, "_{}".format('allow_recipient_language_selection_metadata'), kwargs.get('allow_recipient_language_selection_metadata', None))
        setattr(self, "_{}".format('allow_send_on_behalf_of'), kwargs.get('allow_send_on_behalf_of', None))
        setattr(self, "_{}".format('allow_send_on_behalf_of_metadata'), kwargs.get('allow_send_on_behalf_of_metadata', None))
        setattr(self, "_{}".format('allow_supplemental_documents'), kwargs.get('allow_supplemental_documents', None))
        setattr(self, "_{}".format('allow_supplemental_documents_metadata'), kwargs.get('allow_supplemental_documents_metadata', None))
        setattr(self, "_{}".format('anchor_tag_versioned_placement_enabled'), kwargs.get('anchor_tag_versioned_placement_enabled', None))
        setattr(self, "_{}".format('api_account_wide_access'), kwargs.get('api_account_wide_access', None))
        setattr(self, "_{}".format('api_account_wide_access_metadata'), kwargs.get('api_account_wide_access_metadata', None))
        setattr(self, "_{}".format('api_can_export_ac'), kwargs.get('api_can_export_ac', None))
        setattr(self, "_{}".format('api_can_export_ac_metadata'), kwargs.get('api_can_export_ac_metadata', None))
        setattr(self, "_{}".format('bulk_send'), kwargs.get('bulk_send', None))
        setattr(self, "_{}".format('bulk_send_metadata'), kwargs.get('bulk_send_metadata', None))
        setattr(self, "_{}".format('can_charge_account'), kwargs.get('can_charge_account', None))
        setattr(self, "_{}".format('can_charge_account_metadata'), kwargs.get('can_charge_account_metadata', None))
        setattr(self, "_{}".format('can_edit_shared_addressbook'), kwargs.get('can_edit_shared_addressbook', None))
        setattr(self, "_{}".format('can_edit_shared_addressbook_metadata'), kwargs.get('can_edit_shared_addressbook_metadata', None))
        setattr(self, "_{}".format('can_lock_envelopes'), kwargs.get('can_lock_envelopes', None))
        setattr(self, "_{}".format('can_lock_envelopes_metadata'), kwargs.get('can_lock_envelopes_metadata', None))
        setattr(self, "_{}".format('can_manage_account'), kwargs.get('can_manage_account', None))
        setattr(self, "_{}".format('can_manage_account_metadata'), kwargs.get('can_manage_account_metadata', None))
        setattr(self, "_{}".format('can_manage_distributor'), kwargs.get('can_manage_distributor', None))
        setattr(self, "_{}".format('can_manage_distributor_metadata'), kwargs.get('can_manage_distributor_metadata', None))
        setattr(self, "_{}".format('can_manage_templates'), kwargs.get('can_manage_templates', None))
        setattr(self, "_{}".format('can_manage_templates_metadata'), kwargs.get('can_manage_templates_metadata', None))
        setattr(self, "_{}".format('can_send_api_requests'), kwargs.get('can_send_api_requests', None))
        setattr(self, "_{}".format('can_send_api_requests_metadata'), kwargs.get('can_send_api_requests_metadata', None))
        setattr(self, "_{}".format('can_send_envelope'), kwargs.get('can_send_envelope', None))
        setattr(self, "_{}".format('can_send_envelope_metadata'), kwargs.get('can_send_envelope_metadata', None))
        setattr(self, "_{}".format('can_send_envelopes_via_sms'), kwargs.get('can_send_envelopes_via_sms', None))
        setattr(self, "_{}".format('can_send_envelopes_via_sms_metadata'), kwargs.get('can_send_envelopes_via_sms_metadata', None))
        setattr(self, "_{}".format('can_sign_envelope'), kwargs.get('can_sign_envelope', None))
        setattr(self, "_{}".format('can_sign_envelope_metadata'), kwargs.get('can_sign_envelope_metadata', None))
        setattr(self, "_{}".format('can_use_scratchpad'), kwargs.get('can_use_scratchpad', None))
        setattr(self, "_{}".format('can_use_scratchpad_metadata'), kwargs.get('can_use_scratchpad_metadata', None))
        setattr(self, "_{}".format('can_use_smart_contracts'), kwargs.get('can_use_smart_contracts', None))
        setattr(self, "_{}".format('can_use_smart_contracts_metadata'), kwargs.get('can_use_smart_contracts_metadata', None))
        setattr(self, "_{}".format('disable_document_upload'), kwargs.get('disable_document_upload', None))
        setattr(self, "_{}".format('disable_document_upload_metadata'), kwargs.get('disable_document_upload_metadata', None))
        setattr(self, "_{}".format('disable_other_actions'), kwargs.get('disable_other_actions', None))
        setattr(self, "_{}".format('disable_other_actions_metadata'), kwargs.get('disable_other_actions_metadata', None))
        setattr(self, "_{}".format('enable_ds_pro'), kwargs.get('enable_ds_pro', None))
        setattr(self, "_{}".format('enable_ds_pro_metadata'), kwargs.get('enable_ds_pro_metadata', None))
        setattr(self, "_{}".format('enable_key_terms_suggestions_by_document_type'), kwargs.get('enable_key_terms_suggestions_by_document_type', None))
        setattr(self, "_{}".format('enable_key_terms_suggestions_by_document_type_metadata'), kwargs.get('enable_key_terms_suggestions_by_document_type_metadata', None))
        setattr(self, "_{}".format('enable_sequential_signing_api'), kwargs.get('enable_sequential_signing_api', None))
        setattr(self, "_{}".format('enable_sequential_signing_api_metadata'), kwargs.get('enable_sequential_signing_api_metadata', None))
        setattr(self, "_{}".format('enable_sequential_signing_ui'), kwargs.get('enable_sequential_signing_ui', None))
        setattr(self, "_{}".format('enable_sequential_signing_ui_metadata'), kwargs.get('enable_sequential_signing_ui_metadata', None))
        setattr(self, "_{}".format('enable_signer_attachments'), kwargs.get('enable_signer_attachments', None))
        setattr(self, "_{}".format('enable_signer_attachments_metadata'), kwargs.get('enable_signer_attachments_metadata', None))
        setattr(self, "_{}".format('enable_sign_on_paper_override'), kwargs.get('enable_sign_on_paper_override', None))
        setattr(self, "_{}".format('enable_sign_on_paper_override_metadata'), kwargs.get('enable_sign_on_paper_override_metadata', None))
        setattr(self, "_{}".format('enable_transaction_point'), kwargs.get('enable_transaction_point', None))
        setattr(self, "_{}".format('enable_transaction_point_metadata'), kwargs.get('enable_transaction_point_metadata', None))
        setattr(self, "_{}".format('enable_vaulting'), kwargs.get('enable_vaulting', None))
        setattr(self, "_{}".format('enable_vaulting_metadata'), kwargs.get('enable_vaulting_metadata', None))
        setattr(self, "_{}".format('express_send_only'), kwargs.get('express_send_only', None))
        setattr(self, "_{}".format('locale'), kwargs.get('locale', None))
        setattr(self, "_{}".format('locale_metadata'), kwargs.get('locale_metadata', None))
        setattr(self, "_{}".format('locale_policy'), kwargs.get('locale_policy', None))
        setattr(self, "_{}".format('manage_clickwraps_mode'), kwargs.get('manage_clickwraps_mode', None))
        setattr(self, "_{}".format('manage_clickwraps_mode_metadata'), kwargs.get('manage_clickwraps_mode_metadata', None))
        setattr(self, "_{}".format('modified_by'), kwargs.get('modified_by', None))
        setattr(self, "_{}".format('modified_by_metadata'), kwargs.get('modified_by_metadata', None))
        setattr(self, "_{}".format('modified_date'), kwargs.get('modified_date', None))
        setattr(self, "_{}".format('modified_date_metadata'), kwargs.get('modified_date_metadata', None))
        setattr(self, "_{}".format('modified_page'), kwargs.get('modified_page', None))
        setattr(self, "_{}".format('modified_page_metadata'), kwargs.get('modified_page_metadata', None))
        setattr(self, "_{}".format('new_send_ui'), kwargs.get('new_send_ui', None))
        setattr(self, "_{}".format('new_send_ui_metadata'), kwargs.get('new_send_ui_metadata', None))
        setattr(self, "_{}".format('power_form_mode'), kwargs.get('power_form_mode', None))
        setattr(self, "_{}".format('power_form_mode_metadata'), kwargs.get('power_form_mode_metadata', None))
        setattr(self, "_{}".format('recipient_viewed_notification'), kwargs.get('recipient_viewed_notification', None))
        setattr(self, "_{}".format('recipient_viewed_notification_metadata'), kwargs.get('recipient_viewed_notification_metadata', None))
        setattr(self, "_{}".format('seal_identifiers'), kwargs.get('seal_identifiers', None))
        setattr(self, "_{}".format('self_signed_recipient_email_document'), kwargs.get('self_signed_recipient_email_document', None))
        setattr(self, "_{}".format('self_signed_recipient_email_document_metadata'), kwargs.get('self_signed_recipient_email_document_metadata', None))
        setattr(self, "_{}".format('sender_email_notifications'), kwargs.get('sender_email_notifications', None))
        setattr(self, "_{}".format('signer_email_notifications'), kwargs.get('signer_email_notifications', None))
        setattr(self, "_{}".format('supplemental_document_include_in_download'), kwargs.get('supplemental_document_include_in_download', None))
        setattr(self, "_{}".format('supplemental_documents_must_accept'), kwargs.get('supplemental_documents_must_accept', None))
        setattr(self, "_{}".format('supplemental_documents_must_accept_metadata'), kwargs.get('supplemental_documents_must_accept_metadata', None))
        setattr(self, "_{}".format('supplemental_documents_must_read'), kwargs.get('supplemental_documents_must_read', None))
        setattr(self, "_{}".format('supplemental_documents_must_read_metadata'), kwargs.get('supplemental_documents_must_read_metadata', None))
        setattr(self, "_{}".format('supplemental_documents_must_view'), kwargs.get('supplemental_documents_must_view', None))
        setattr(self, "_{}".format('supplemental_documents_must_view_metadata'), kwargs.get('supplemental_documents_must_view_metadata', None))
        setattr(self, "_{}".format('template_active_creation'), kwargs.get('template_active_creation', None))
        setattr(self, "_{}".format('template_active_creation_metadata'), kwargs.get('template_active_creation_metadata', None))
        setattr(self, "_{}".format('template_apply_notify'), kwargs.get('template_apply_notify', None))
        setattr(self, "_{}".format('template_apply_notify_metadata'), kwargs.get('template_apply_notify_metadata', None))
        setattr(self, "_{}".format('template_auto_matching'), kwargs.get('template_auto_matching', None))
        setattr(self, "_{}".format('template_auto_matching_metadata'), kwargs.get('template_auto_matching_metadata', None))
        setattr(self, "_{}".format('template_matching_sensitivity'), kwargs.get('template_matching_sensitivity', None))
        setattr(self, "_{}".format('template_matching_sensitivity_metadata'), kwargs.get('template_matching_sensitivity_metadata', None))
        setattr(self, "_{}".format('template_page_level_matching'), kwargs.get('template_page_level_matching', None))
        setattr(self, "_{}".format('template_page_level_matching_metadata'), kwargs.get('template_page_level_matching_metadata', None))
        setattr(self, "_{}".format('timezone_dst'), kwargs.get('timezone_dst', None))
        setattr(self, "_{}".format('timezone_dst_metadata'), kwargs.get('timezone_dst_metadata', None))
        setattr(self, "_{}".format('timezone_mask'), kwargs.get('timezone_mask', None))
        setattr(self, "_{}".format('timezone_mask_metadata'), kwargs.get('timezone_mask_metadata', None))
        setattr(self, "_{}".format('timezone_offset'), kwargs.get('timezone_offset', None))
        setattr(self, "_{}".format('timezone_offset_metadata'), kwargs.get('timezone_offset_metadata', None))
        setattr(self, "_{}".format('timezone_sending_pref'), kwargs.get('timezone_sending_pref', None))
        setattr(self, "_{}".format('timezone_sending_pref_metadata'), kwargs.get('timezone_sending_pref_metadata', None))
        setattr(self, "_{}".format('timezone_signing_pref'), kwargs.get('timezone_signing_pref', None))
        setattr(self, "_{}".format('timezone_signing_pref_metadata'), kwargs.get('timezone_signing_pref_metadata', None))
        setattr(self, "_{}".format('transaction_point_site_name_url'), kwargs.get('transaction_point_site_name_url', None))
        setattr(self, "_{}".format('transaction_point_site_name_url_metadata'), kwargs.get('transaction_point_site_name_url_metadata', None))
        setattr(self, "_{}".format('transaction_point_user_name'), kwargs.get('transaction_point_user_name', None))
        setattr(self, "_{}".format('transaction_point_user_name_metadata'), kwargs.get('transaction_point_user_name_metadata', None))
        setattr(self, "_{}".format('vaulting_mode'), kwargs.get('vaulting_mode', None))
        setattr(self, "_{}".format('vaulting_mode_metadata'), kwargs.get('vaulting_mode_metadata', None))
        setattr(self, "_{}".format('web_forms'), kwargs.get('web_forms', None))
        setattr(self, "_{}".format('web_forms_metadata'), kwargs.get('web_forms_metadata', None))

    @property
    def account_management_granular(self):
        """Gets the account_management_granular of this UserSettingsInformation.  # noqa: E501

        Describes which account management capabilities a user has.  # noqa: E501

        :return: The account_management_granular of this UserSettingsInformation.  # noqa: E501
        :rtype: UserAccountManagementGranularInformation
        """
        return self._account_management_granular

    @account_management_granular.setter
    def account_management_granular(self, account_management_granular):
        """Sets the account_management_granular of this UserSettingsInformation.

        Describes which account management capabilities a user has.  # noqa: E501

        :param account_management_granular: The account_management_granular of this UserSettingsInformation.  # noqa: E501
        :type: UserAccountManagementGranularInformation
        """

        self._account_management_granular = account_management_granular

    @property
    def admin_only(self):
        """Gets the admin_only of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The admin_only of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._admin_only

    @admin_only.setter
    def admin_only(self, admin_only):
        """Sets the admin_only of this UserSettingsInformation.

          # noqa: E501

        :param admin_only: The admin_only of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._admin_only = admin_only

    @property
    def admin_only_metadata(self):
        """Gets the admin_only_metadata of this UserSettingsInformation.  # noqa: E501

        Reserved for DocuSign.  # noqa: E501

        :return: The admin_only_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._admin_only_metadata

    @admin_only_metadata.setter
    def admin_only_metadata(self, admin_only_metadata):
        """Sets the admin_only_metadata of this UserSettingsInformation.

        Reserved for DocuSign.  # noqa: E501

        :param admin_only_metadata: The admin_only_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._admin_only_metadata = admin_only_metadata

    @property
    def allow_auto_tagging(self):
        """Gets the allow_auto_tagging of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The allow_auto_tagging of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._allow_auto_tagging

    @allow_auto_tagging.setter
    def allow_auto_tagging(self, allow_auto_tagging):
        """Sets the allow_auto_tagging of this UserSettingsInformation.

          # noqa: E501

        :param allow_auto_tagging: The allow_auto_tagging of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._allow_auto_tagging = allow_auto_tagging

    @property
    def allow_envelope_transfer_to(self):
        """Gets the allow_envelope_transfer_to of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The allow_envelope_transfer_to of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._allow_envelope_transfer_to

    @allow_envelope_transfer_to.setter
    def allow_envelope_transfer_to(self, allow_envelope_transfer_to):
        """Sets the allow_envelope_transfer_to of this UserSettingsInformation.

          # noqa: E501

        :param allow_envelope_transfer_to: The allow_envelope_transfer_to of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._allow_envelope_transfer_to = allow_envelope_transfer_to

    @property
    def allow_envelope_transfer_to_metadata(self):
        """Gets the allow_envelope_transfer_to_metadata of this UserSettingsInformation.  # noqa: E501

        Reserved for DocuSign.  # noqa: E501

        :return: The allow_envelope_transfer_to_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._allow_envelope_transfer_to_metadata

    @allow_envelope_transfer_to_metadata.setter
    def allow_envelope_transfer_to_metadata(self, allow_envelope_transfer_to_metadata):
        """Sets the allow_envelope_transfer_to_metadata of this UserSettingsInformation.

        Reserved for DocuSign.  # noqa: E501

        :param allow_envelope_transfer_to_metadata: The allow_envelope_transfer_to_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._allow_envelope_transfer_to_metadata = allow_envelope_transfer_to_metadata

    @property
    def allow_eseal_recipients(self):
        """Gets the allow_eseal_recipients of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The allow_eseal_recipients of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._allow_eseal_recipients

    @allow_eseal_recipients.setter
    def allow_eseal_recipients(self, allow_eseal_recipients):
        """Sets the allow_eseal_recipients of this UserSettingsInformation.

          # noqa: E501

        :param allow_eseal_recipients: The allow_eseal_recipients of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._allow_eseal_recipients = allow_eseal_recipients

    @property
    def allow_eseal_recipients_metadata(self):
        """Gets the allow_eseal_recipients_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata about the `allowEsealRecipientsMetadata` property.  # noqa: E501

        :return: The allow_eseal_recipients_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._allow_eseal_recipients_metadata

    @allow_eseal_recipients_metadata.setter
    def allow_eseal_recipients_metadata(self, allow_eseal_recipients_metadata):
        """Sets the allow_eseal_recipients_metadata of this UserSettingsInformation.

        Metadata about the `allowEsealRecipientsMetadata` property.  # noqa: E501

        :param allow_eseal_recipients_metadata: The allow_eseal_recipients_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._allow_eseal_recipients_metadata = allow_eseal_recipients_metadata

    @property
    def allow_power_forms_admin_to_access_all_power_form_envelope(self):
        """Gets the allow_power_forms_admin_to_access_all_power_form_envelope of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The allow_power_forms_admin_to_access_all_power_form_envelope of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._allow_power_forms_admin_to_access_all_power_form_envelope

    @allow_power_forms_admin_to_access_all_power_form_envelope.setter
    def allow_power_forms_admin_to_access_all_power_form_envelope(self, allow_power_forms_admin_to_access_all_power_form_envelope):
        """Sets the allow_power_forms_admin_to_access_all_power_form_envelope of this UserSettingsInformation.

          # noqa: E501

        :param allow_power_forms_admin_to_access_all_power_form_envelope: The allow_power_forms_admin_to_access_all_power_form_envelope of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._allow_power_forms_admin_to_access_all_power_form_envelope = allow_power_forms_admin_to_access_all_power_form_envelope

    @property
    def allow_power_forms_admin_to_access_all_power_form_envelope_metadata(self):
        """Gets the allow_power_forms_admin_to_access_all_power_form_envelope_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata about the `allowPowerFormsAdminToAccessAllPowerFormEnvelopeMetadata` property.  # noqa: E501

        :return: The allow_power_forms_admin_to_access_all_power_form_envelope_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._allow_power_forms_admin_to_access_all_power_form_envelope_metadata

    @allow_power_forms_admin_to_access_all_power_form_envelope_metadata.setter
    def allow_power_forms_admin_to_access_all_power_form_envelope_metadata(self, allow_power_forms_admin_to_access_all_power_form_envelope_metadata):
        """Sets the allow_power_forms_admin_to_access_all_power_form_envelope_metadata of this UserSettingsInformation.

        Metadata about the `allowPowerFormsAdminToAccessAllPowerFormEnvelopeMetadata` property.  # noqa: E501

        :param allow_power_forms_admin_to_access_all_power_form_envelope_metadata: The allow_power_forms_admin_to_access_all_power_form_envelope_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._allow_power_forms_admin_to_access_all_power_form_envelope_metadata = allow_power_forms_admin_to_access_all_power_form_envelope_metadata

    @property
    def allow_recipient_language_selection(self):
        """Gets the allow_recipient_language_selection of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The allow_recipient_language_selection of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._allow_recipient_language_selection

    @allow_recipient_language_selection.setter
    def allow_recipient_language_selection(self, allow_recipient_language_selection):
        """Sets the allow_recipient_language_selection of this UserSettingsInformation.

          # noqa: E501

        :param allow_recipient_language_selection: The allow_recipient_language_selection of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._allow_recipient_language_selection = allow_recipient_language_selection

    @property
    def allow_recipient_language_selection_metadata(self):
        """Gets the allow_recipient_language_selection_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata for allowRecipientLanguageSelection.  # noqa: E501

        :return: The allow_recipient_language_selection_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._allow_recipient_language_selection_metadata

    @allow_recipient_language_selection_metadata.setter
    def allow_recipient_language_selection_metadata(self, allow_recipient_language_selection_metadata):
        """Sets the allow_recipient_language_selection_metadata of this UserSettingsInformation.

        Metadata for allowRecipientLanguageSelection.  # noqa: E501

        :param allow_recipient_language_selection_metadata: The allow_recipient_language_selection_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._allow_recipient_language_selection_metadata = allow_recipient_language_selection_metadata

    @property
    def allow_send_on_behalf_of(self):
        """Gets the allow_send_on_behalf_of of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The allow_send_on_behalf_of of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._allow_send_on_behalf_of

    @allow_send_on_behalf_of.setter
    def allow_send_on_behalf_of(self, allow_send_on_behalf_of):
        """Sets the allow_send_on_behalf_of of this UserSettingsInformation.

          # noqa: E501

        :param allow_send_on_behalf_of: The allow_send_on_behalf_of of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._allow_send_on_behalf_of = allow_send_on_behalf_of

    @property
    def allow_send_on_behalf_of_metadata(self):
        """Gets the allow_send_on_behalf_of_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata for allowSendOnBehalfOf.  # noqa: E501

        :return: The allow_send_on_behalf_of_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._allow_send_on_behalf_of_metadata

    @allow_send_on_behalf_of_metadata.setter
    def allow_send_on_behalf_of_metadata(self, allow_send_on_behalf_of_metadata):
        """Sets the allow_send_on_behalf_of_metadata of this UserSettingsInformation.

        Metadata for allowSendOnBehalfOf.  # noqa: E501

        :param allow_send_on_behalf_of_metadata: The allow_send_on_behalf_of_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._allow_send_on_behalf_of_metadata = allow_send_on_behalf_of_metadata

    @property
    def allow_supplemental_documents(self):
        """Gets the allow_supplemental_documents of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The allow_supplemental_documents of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._allow_supplemental_documents

    @allow_supplemental_documents.setter
    def allow_supplemental_documents(self, allow_supplemental_documents):
        """Sets the allow_supplemental_documents of this UserSettingsInformation.

          # noqa: E501

        :param allow_supplemental_documents: The allow_supplemental_documents of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._allow_supplemental_documents = allow_supplemental_documents

    @property
    def allow_supplemental_documents_metadata(self):
        """Gets the allow_supplemental_documents_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata that indicates whether the `allowSupplementalDocuments` property is editable.  # noqa: E501

        :return: The allow_supplemental_documents_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._allow_supplemental_documents_metadata

    @allow_supplemental_documents_metadata.setter
    def allow_supplemental_documents_metadata(self, allow_supplemental_documents_metadata):
        """Sets the allow_supplemental_documents_metadata of this UserSettingsInformation.

        Metadata that indicates whether the `allowSupplementalDocuments` property is editable.  # noqa: E501

        :param allow_supplemental_documents_metadata: The allow_supplemental_documents_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._allow_supplemental_documents_metadata = allow_supplemental_documents_metadata

    @property
    def anchor_tag_versioned_placement_enabled(self):
        """Gets the anchor_tag_versioned_placement_enabled of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The anchor_tag_versioned_placement_enabled of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._anchor_tag_versioned_placement_enabled

    @anchor_tag_versioned_placement_enabled.setter
    def anchor_tag_versioned_placement_enabled(self, anchor_tag_versioned_placement_enabled):
        """Sets the anchor_tag_versioned_placement_enabled of this UserSettingsInformation.

          # noqa: E501

        :param anchor_tag_versioned_placement_enabled: The anchor_tag_versioned_placement_enabled of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._anchor_tag_versioned_placement_enabled = anchor_tag_versioned_placement_enabled

    @property
    def api_account_wide_access(self):
        """Gets the api_account_wide_access of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The api_account_wide_access of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._api_account_wide_access

    @api_account_wide_access.setter
    def api_account_wide_access(self, api_account_wide_access):
        """Sets the api_account_wide_access of this UserSettingsInformation.

          # noqa: E501

        :param api_account_wide_access: The api_account_wide_access of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._api_account_wide_access = api_account_wide_access

    @property
    def api_account_wide_access_metadata(self):
        """Gets the api_account_wide_access_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata for apiAccountWideAccess.  # noqa: E501

        :return: The api_account_wide_access_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._api_account_wide_access_metadata

    @api_account_wide_access_metadata.setter
    def api_account_wide_access_metadata(self, api_account_wide_access_metadata):
        """Sets the api_account_wide_access_metadata of this UserSettingsInformation.

        Metadata for apiAccountWideAccess.  # noqa: E501

        :param api_account_wide_access_metadata: The api_account_wide_access_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._api_account_wide_access_metadata = api_account_wide_access_metadata

    @property
    def api_can_export_ac(self):
        """Gets the api_can_export_ac of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The api_can_export_ac of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._api_can_export_ac

    @api_can_export_ac.setter
    def api_can_export_ac(self, api_can_export_ac):
        """Sets the api_can_export_ac of this UserSettingsInformation.

          # noqa: E501

        :param api_can_export_ac: The api_can_export_ac of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._api_can_export_ac = api_can_export_ac

    @property
    def api_can_export_ac_metadata(self):
        """Gets the api_can_export_ac_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata about the `apiCanExportACMetadata` property.  # noqa: E501

        :return: The api_can_export_ac_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._api_can_export_ac_metadata

    @api_can_export_ac_metadata.setter
    def api_can_export_ac_metadata(self, api_can_export_ac_metadata):
        """Sets the api_can_export_ac_metadata of this UserSettingsInformation.

        Metadata about the `apiCanExportACMetadata` property.  # noqa: E501

        :param api_can_export_ac_metadata: The api_can_export_ac_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._api_can_export_ac_metadata = api_can_export_ac_metadata

    @property
    def bulk_send(self):
        """Gets the bulk_send of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The bulk_send of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._bulk_send

    @bulk_send.setter
    def bulk_send(self, bulk_send):
        """Sets the bulk_send of this UserSettingsInformation.

          # noqa: E501

        :param bulk_send: The bulk_send of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._bulk_send = bulk_send

    @property
    def bulk_send_metadata(self):
        """Gets the bulk_send_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata that indicates whether the `bulkSend` property is editable.   # noqa: E501

        :return: The bulk_send_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._bulk_send_metadata

    @bulk_send_metadata.setter
    def bulk_send_metadata(self, bulk_send_metadata):
        """Sets the bulk_send_metadata of this UserSettingsInformation.

        Metadata that indicates whether the `bulkSend` property is editable.   # noqa: E501

        :param bulk_send_metadata: The bulk_send_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._bulk_send_metadata = bulk_send_metadata

    @property
    def can_charge_account(self):
        """Gets the can_charge_account of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The can_charge_account of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._can_charge_account

    @can_charge_account.setter
    def can_charge_account(self, can_charge_account):
        """Sets the can_charge_account of this UserSettingsInformation.

          # noqa: E501

        :param can_charge_account: The can_charge_account of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._can_charge_account = can_charge_account

    @property
    def can_charge_account_metadata(self):
        """Gets the can_charge_account_metadata of this UserSettingsInformation.  # noqa: E501

        Reserved for DocuSign.  # noqa: E501

        :return: The can_charge_account_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._can_charge_account_metadata

    @can_charge_account_metadata.setter
    def can_charge_account_metadata(self, can_charge_account_metadata):
        """Sets the can_charge_account_metadata of this UserSettingsInformation.

        Reserved for DocuSign.  # noqa: E501

        :param can_charge_account_metadata: The can_charge_account_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._can_charge_account_metadata = can_charge_account_metadata

    @property
    def can_edit_shared_addressbook(self):
        """Gets the can_edit_shared_addressbook of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The can_edit_shared_addressbook of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._can_edit_shared_addressbook

    @can_edit_shared_addressbook.setter
    def can_edit_shared_addressbook(self, can_edit_shared_addressbook):
        """Sets the can_edit_shared_addressbook of this UserSettingsInformation.

          # noqa: E501

        :param can_edit_shared_addressbook: The can_edit_shared_addressbook of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._can_edit_shared_addressbook = can_edit_shared_addressbook

    @property
    def can_edit_shared_addressbook_metadata(self):
        """Gets the can_edit_shared_addressbook_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata about the `canEditSharedAddressbookMetadata` property.  # noqa: E501

        :return: The can_edit_shared_addressbook_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._can_edit_shared_addressbook_metadata

    @can_edit_shared_addressbook_metadata.setter
    def can_edit_shared_addressbook_metadata(self, can_edit_shared_addressbook_metadata):
        """Sets the can_edit_shared_addressbook_metadata of this UserSettingsInformation.

        Metadata about the `canEditSharedAddressbookMetadata` property.  # noqa: E501

        :param can_edit_shared_addressbook_metadata: The can_edit_shared_addressbook_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._can_edit_shared_addressbook_metadata = can_edit_shared_addressbook_metadata

    @property
    def can_lock_envelopes(self):
        """Gets the can_lock_envelopes of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The can_lock_envelopes of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._can_lock_envelopes

    @can_lock_envelopes.setter
    def can_lock_envelopes(self, can_lock_envelopes):
        """Sets the can_lock_envelopes of this UserSettingsInformation.

          # noqa: E501

        :param can_lock_envelopes: The can_lock_envelopes of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._can_lock_envelopes = can_lock_envelopes

    @property
    def can_lock_envelopes_metadata(self):
        """Gets the can_lock_envelopes_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata about the `canLockEnvelopes` property.  # noqa: E501

        :return: The can_lock_envelopes_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._can_lock_envelopes_metadata

    @can_lock_envelopes_metadata.setter
    def can_lock_envelopes_metadata(self, can_lock_envelopes_metadata):
        """Sets the can_lock_envelopes_metadata of this UserSettingsInformation.

        Metadata about the `canLockEnvelopes` property.  # noqa: E501

        :param can_lock_envelopes_metadata: The can_lock_envelopes_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._can_lock_envelopes_metadata = can_lock_envelopes_metadata

    @property
    def can_manage_account(self):
        """Gets the can_manage_account of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The can_manage_account of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._can_manage_account

    @can_manage_account.setter
    def can_manage_account(self, can_manage_account):
        """Sets the can_manage_account of this UserSettingsInformation.

          # noqa: E501

        :param can_manage_account: The can_manage_account of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._can_manage_account = can_manage_account

    @property
    def can_manage_account_metadata(self):
        """Gets the can_manage_account_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata about the `canManageAccountMetadata` property.  # noqa: E501

        :return: The can_manage_account_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._can_manage_account_metadata

    @can_manage_account_metadata.setter
    def can_manage_account_metadata(self, can_manage_account_metadata):
        """Sets the can_manage_account_metadata of this UserSettingsInformation.

        Metadata about the `canManageAccountMetadata` property.  # noqa: E501

        :param can_manage_account_metadata: The can_manage_account_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._can_manage_account_metadata = can_manage_account_metadata

    @property
    def can_manage_distributor(self):
        """Gets the can_manage_distributor of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The can_manage_distributor of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._can_manage_distributor

    @can_manage_distributor.setter
    def can_manage_distributor(self, can_manage_distributor):
        """Sets the can_manage_distributor of this UserSettingsInformation.

          # noqa: E501

        :param can_manage_distributor: The can_manage_distributor of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._can_manage_distributor = can_manage_distributor

    @property
    def can_manage_distributor_metadata(self):
        """Gets the can_manage_distributor_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata about the `canManageDistributor` property.  # noqa: E501

        :return: The can_manage_distributor_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._can_manage_distributor_metadata

    @can_manage_distributor_metadata.setter
    def can_manage_distributor_metadata(self, can_manage_distributor_metadata):
        """Sets the can_manage_distributor_metadata of this UserSettingsInformation.

        Metadata about the `canManageDistributor` property.  # noqa: E501

        :param can_manage_distributor_metadata: The can_manage_distributor_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._can_manage_distributor_metadata = can_manage_distributor_metadata

    @property
    def can_manage_templates(self):
        """Gets the can_manage_templates of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The can_manage_templates of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._can_manage_templates

    @can_manage_templates.setter
    def can_manage_templates(self, can_manage_templates):
        """Sets the can_manage_templates of this UserSettingsInformation.

          # noqa: E501

        :param can_manage_templates: The can_manage_templates of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._can_manage_templates = can_manage_templates

    @property
    def can_manage_templates_metadata(self):
        """Gets the can_manage_templates_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata about the `canManageTemplates` property.  # noqa: E501

        :return: The can_manage_templates_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._can_manage_templates_metadata

    @can_manage_templates_metadata.setter
    def can_manage_templates_metadata(self, can_manage_templates_metadata):
        """Sets the can_manage_templates_metadata of this UserSettingsInformation.

        Metadata about the `canManageTemplates` property.  # noqa: E501

        :param can_manage_templates_metadata: The can_manage_templates_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._can_manage_templates_metadata = can_manage_templates_metadata

    @property
    def can_send_api_requests(self):
        """Gets the can_send_api_requests of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The can_send_api_requests of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._can_send_api_requests

    @can_send_api_requests.setter
    def can_send_api_requests(self, can_send_api_requests):
        """Sets the can_send_api_requests of this UserSettingsInformation.

          # noqa: E501

        :param can_send_api_requests: The can_send_api_requests of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._can_send_api_requests = can_send_api_requests

    @property
    def can_send_api_requests_metadata(self):
        """Gets the can_send_api_requests_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata about the `canSendAPIRequests` property.  # noqa: E501

        :return: The can_send_api_requests_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._can_send_api_requests_metadata

    @can_send_api_requests_metadata.setter
    def can_send_api_requests_metadata(self, can_send_api_requests_metadata):
        """Sets the can_send_api_requests_metadata of this UserSettingsInformation.

        Metadata about the `canSendAPIRequests` property.  # noqa: E501

        :param can_send_api_requests_metadata: The can_send_api_requests_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._can_send_api_requests_metadata = can_send_api_requests_metadata

    @property
    def can_send_envelope(self):
        """Gets the can_send_envelope of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The can_send_envelope of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._can_send_envelope

    @can_send_envelope.setter
    def can_send_envelope(self, can_send_envelope):
        """Sets the can_send_envelope of this UserSettingsInformation.

          # noqa: E501

        :param can_send_envelope: The can_send_envelope of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._can_send_envelope = can_send_envelope

    @property
    def can_send_envelope_metadata(self):
        """Gets the can_send_envelope_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata about the `canSendEnvelope` property.  # noqa: E501

        :return: The can_send_envelope_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._can_send_envelope_metadata

    @can_send_envelope_metadata.setter
    def can_send_envelope_metadata(self, can_send_envelope_metadata):
        """Sets the can_send_envelope_metadata of this UserSettingsInformation.

        Metadata about the `canSendEnvelope` property.  # noqa: E501

        :param can_send_envelope_metadata: The can_send_envelope_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._can_send_envelope_metadata = can_send_envelope_metadata

    @property
    def can_send_envelopes_via_sms(self):
        """Gets the can_send_envelopes_via_sms of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The can_send_envelopes_via_sms of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._can_send_envelopes_via_sms

    @can_send_envelopes_via_sms.setter
    def can_send_envelopes_via_sms(self, can_send_envelopes_via_sms):
        """Sets the can_send_envelopes_via_sms of this UserSettingsInformation.

          # noqa: E501

        :param can_send_envelopes_via_sms: The can_send_envelopes_via_sms of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._can_send_envelopes_via_sms = can_send_envelopes_via_sms

    @property
    def can_send_envelopes_via_sms_metadata(self):
        """Gets the can_send_envelopes_via_sms_metadata of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The can_send_envelopes_via_sms_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._can_send_envelopes_via_sms_metadata

    @can_send_envelopes_via_sms_metadata.setter
    def can_send_envelopes_via_sms_metadata(self, can_send_envelopes_via_sms_metadata):
        """Sets the can_send_envelopes_via_sms_metadata of this UserSettingsInformation.

          # noqa: E501

        :param can_send_envelopes_via_sms_metadata: The can_send_envelopes_via_sms_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._can_send_envelopes_via_sms_metadata = can_send_envelopes_via_sms_metadata

    @property
    def can_sign_envelope(self):
        """Gets the can_sign_envelope of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The can_sign_envelope of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._can_sign_envelope

    @can_sign_envelope.setter
    def can_sign_envelope(self, can_sign_envelope):
        """Sets the can_sign_envelope of this UserSettingsInformation.

          # noqa: E501

        :param can_sign_envelope: The can_sign_envelope of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._can_sign_envelope = can_sign_envelope

    @property
    def can_sign_envelope_metadata(self):
        """Gets the can_sign_envelope_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata about the `canSignEnvelope` property.  # noqa: E501

        :return: The can_sign_envelope_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._can_sign_envelope_metadata

    @can_sign_envelope_metadata.setter
    def can_sign_envelope_metadata(self, can_sign_envelope_metadata):
        """Sets the can_sign_envelope_metadata of this UserSettingsInformation.

        Metadata about the `canSignEnvelope` property.  # noqa: E501

        :param can_sign_envelope_metadata: The can_sign_envelope_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._can_sign_envelope_metadata = can_sign_envelope_metadata

    @property
    def can_use_scratchpad(self):
        """Gets the can_use_scratchpad of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The can_use_scratchpad of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._can_use_scratchpad

    @can_use_scratchpad.setter
    def can_use_scratchpad(self, can_use_scratchpad):
        """Sets the can_use_scratchpad of this UserSettingsInformation.

          # noqa: E501

        :param can_use_scratchpad: The can_use_scratchpad of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._can_use_scratchpad = can_use_scratchpad

    @property
    def can_use_scratchpad_metadata(self):
        """Gets the can_use_scratchpad_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata about the `canUseScratchpad` property.  # noqa: E501

        :return: The can_use_scratchpad_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._can_use_scratchpad_metadata

    @can_use_scratchpad_metadata.setter
    def can_use_scratchpad_metadata(self, can_use_scratchpad_metadata):
        """Sets the can_use_scratchpad_metadata of this UserSettingsInformation.

        Metadata about the `canUseScratchpad` property.  # noqa: E501

        :param can_use_scratchpad_metadata: The can_use_scratchpad_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._can_use_scratchpad_metadata = can_use_scratchpad_metadata

    @property
    def can_use_smart_contracts(self):
        """Gets the can_use_smart_contracts of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The can_use_smart_contracts of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._can_use_smart_contracts

    @can_use_smart_contracts.setter
    def can_use_smart_contracts(self, can_use_smart_contracts):
        """Sets the can_use_smart_contracts of this UserSettingsInformation.

          # noqa: E501

        :param can_use_smart_contracts: The can_use_smart_contracts of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._can_use_smart_contracts = can_use_smart_contracts

    @property
    def can_use_smart_contracts_metadata(self):
        """Gets the can_use_smart_contracts_metadata of this UserSettingsInformation.  # noqa: E501

        Reserved for DocuSign.  # noqa: E501

        :return: The can_use_smart_contracts_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._can_use_smart_contracts_metadata

    @can_use_smart_contracts_metadata.setter
    def can_use_smart_contracts_metadata(self, can_use_smart_contracts_metadata):
        """Sets the can_use_smart_contracts_metadata of this UserSettingsInformation.

        Reserved for DocuSign.  # noqa: E501

        :param can_use_smart_contracts_metadata: The can_use_smart_contracts_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._can_use_smart_contracts_metadata = can_use_smart_contracts_metadata

    @property
    def disable_document_upload(self):
        """Gets the disable_document_upload of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The disable_document_upload of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._disable_document_upload

    @disable_document_upload.setter
    def disable_document_upload(self, disable_document_upload):
        """Sets the disable_document_upload of this UserSettingsInformation.

          # noqa: E501

        :param disable_document_upload: The disable_document_upload of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._disable_document_upload = disable_document_upload

    @property
    def disable_document_upload_metadata(self):
        """Gets the disable_document_upload_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata that indicates whether the `disableDocumentUpload` property is editable.   # noqa: E501

        :return: The disable_document_upload_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._disable_document_upload_metadata

    @disable_document_upload_metadata.setter
    def disable_document_upload_metadata(self, disable_document_upload_metadata):
        """Sets the disable_document_upload_metadata of this UserSettingsInformation.

        Metadata that indicates whether the `disableDocumentUpload` property is editable.   # noqa: E501

        :param disable_document_upload_metadata: The disable_document_upload_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._disable_document_upload_metadata = disable_document_upload_metadata

    @property
    def disable_other_actions(self):
        """Gets the disable_other_actions of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The disable_other_actions of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._disable_other_actions

    @disable_other_actions.setter
    def disable_other_actions(self, disable_other_actions):
        """Sets the disable_other_actions of this UserSettingsInformation.

          # noqa: E501

        :param disable_other_actions: The disable_other_actions of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._disable_other_actions = disable_other_actions

    @property
    def disable_other_actions_metadata(self):
        """Gets the disable_other_actions_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata that indicates whether the `disableOtherActions` property is editable.   # noqa: E501

        :return: The disable_other_actions_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._disable_other_actions_metadata

    @disable_other_actions_metadata.setter
    def disable_other_actions_metadata(self, disable_other_actions_metadata):
        """Sets the disable_other_actions_metadata of this UserSettingsInformation.

        Metadata that indicates whether the `disableOtherActions` property is editable.   # noqa: E501

        :param disable_other_actions_metadata: The disable_other_actions_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._disable_other_actions_metadata = disable_other_actions_metadata

    @property
    def enable_ds_pro(self):
        """Gets the enable_ds_pro of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The enable_ds_pro of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._enable_ds_pro

    @enable_ds_pro.setter
    def enable_ds_pro(self, enable_ds_pro):
        """Sets the enable_ds_pro of this UserSettingsInformation.

          # noqa: E501

        :param enable_ds_pro: The enable_ds_pro of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._enable_ds_pro = enable_ds_pro

    @property
    def enable_ds_pro_metadata(self):
        """Gets the enable_ds_pro_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata that indicates whether the `enableDSPro` property is editable.   # noqa: E501

        :return: The enable_ds_pro_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._enable_ds_pro_metadata

    @enable_ds_pro_metadata.setter
    def enable_ds_pro_metadata(self, enable_ds_pro_metadata):
        """Sets the enable_ds_pro_metadata of this UserSettingsInformation.

        Metadata that indicates whether the `enableDSPro` property is editable.   # noqa: E501

        :param enable_ds_pro_metadata: The enable_ds_pro_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._enable_ds_pro_metadata = enable_ds_pro_metadata

    @property
    def enable_key_terms_suggestions_by_document_type(self):
        """Gets the enable_key_terms_suggestions_by_document_type of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The enable_key_terms_suggestions_by_document_type of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._enable_key_terms_suggestions_by_document_type

    @enable_key_terms_suggestions_by_document_type.setter
    def enable_key_terms_suggestions_by_document_type(self, enable_key_terms_suggestions_by_document_type):
        """Sets the enable_key_terms_suggestions_by_document_type of this UserSettingsInformation.

          # noqa: E501

        :param enable_key_terms_suggestions_by_document_type: The enable_key_terms_suggestions_by_document_type of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._enable_key_terms_suggestions_by_document_type = enable_key_terms_suggestions_by_document_type

    @property
    def enable_key_terms_suggestions_by_document_type_metadata(self):
        """Gets the enable_key_terms_suggestions_by_document_type_metadata of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The enable_key_terms_suggestions_by_document_type_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._enable_key_terms_suggestions_by_document_type_metadata

    @enable_key_terms_suggestions_by_document_type_metadata.setter
    def enable_key_terms_suggestions_by_document_type_metadata(self, enable_key_terms_suggestions_by_document_type_metadata):
        """Sets the enable_key_terms_suggestions_by_document_type_metadata of this UserSettingsInformation.

          # noqa: E501

        :param enable_key_terms_suggestions_by_document_type_metadata: The enable_key_terms_suggestions_by_document_type_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._enable_key_terms_suggestions_by_document_type_metadata = enable_key_terms_suggestions_by_document_type_metadata

    @property
    def enable_sequential_signing_api(self):
        """Gets the enable_sequential_signing_api of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The enable_sequential_signing_api of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._enable_sequential_signing_api

    @enable_sequential_signing_api.setter
    def enable_sequential_signing_api(self, enable_sequential_signing_api):
        """Sets the enable_sequential_signing_api of this UserSettingsInformation.

          # noqa: E501

        :param enable_sequential_signing_api: The enable_sequential_signing_api of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._enable_sequential_signing_api = enable_sequential_signing_api

    @property
    def enable_sequential_signing_api_metadata(self):
        """Gets the enable_sequential_signing_api_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata that indicates whether the `enableSequentialSigningAPI` property is editable.   # noqa: E501

        :return: The enable_sequential_signing_api_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._enable_sequential_signing_api_metadata

    @enable_sequential_signing_api_metadata.setter
    def enable_sequential_signing_api_metadata(self, enable_sequential_signing_api_metadata):
        """Sets the enable_sequential_signing_api_metadata of this UserSettingsInformation.

        Metadata that indicates whether the `enableSequentialSigningAPI` property is editable.   # noqa: E501

        :param enable_sequential_signing_api_metadata: The enable_sequential_signing_api_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._enable_sequential_signing_api_metadata = enable_sequential_signing_api_metadata

    @property
    def enable_sequential_signing_ui(self):
        """Gets the enable_sequential_signing_ui of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The enable_sequential_signing_ui of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._enable_sequential_signing_ui

    @enable_sequential_signing_ui.setter
    def enable_sequential_signing_ui(self, enable_sequential_signing_ui):
        """Sets the enable_sequential_signing_ui of this UserSettingsInformation.

          # noqa: E501

        :param enable_sequential_signing_ui: The enable_sequential_signing_ui of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._enable_sequential_signing_ui = enable_sequential_signing_ui

    @property
    def enable_sequential_signing_ui_metadata(self):
        """Gets the enable_sequential_signing_ui_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata that indicates whether the `enableSequentialSigningUI` property is editable.   # noqa: E501

        :return: The enable_sequential_signing_ui_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._enable_sequential_signing_ui_metadata

    @enable_sequential_signing_ui_metadata.setter
    def enable_sequential_signing_ui_metadata(self, enable_sequential_signing_ui_metadata):
        """Sets the enable_sequential_signing_ui_metadata of this UserSettingsInformation.

        Metadata that indicates whether the `enableSequentialSigningUI` property is editable.   # noqa: E501

        :param enable_sequential_signing_ui_metadata: The enable_sequential_signing_ui_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._enable_sequential_signing_ui_metadata = enable_sequential_signing_ui_metadata

    @property
    def enable_signer_attachments(self):
        """Gets the enable_signer_attachments of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The enable_signer_attachments of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._enable_signer_attachments

    @enable_signer_attachments.setter
    def enable_signer_attachments(self, enable_signer_attachments):
        """Sets the enable_signer_attachments of this UserSettingsInformation.

          # noqa: E501

        :param enable_signer_attachments: The enable_signer_attachments of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._enable_signer_attachments = enable_signer_attachments

    @property
    def enable_signer_attachments_metadata(self):
        """Gets the enable_signer_attachments_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata that indicates whether the `enableSignerAttachments` property is editable.   # noqa: E501

        :return: The enable_signer_attachments_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._enable_signer_attachments_metadata

    @enable_signer_attachments_metadata.setter
    def enable_signer_attachments_metadata(self, enable_signer_attachments_metadata):
        """Sets the enable_signer_attachments_metadata of this UserSettingsInformation.

        Metadata that indicates whether the `enableSignerAttachments` property is editable.   # noqa: E501

        :param enable_signer_attachments_metadata: The enable_signer_attachments_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._enable_signer_attachments_metadata = enable_signer_attachments_metadata

    @property
    def enable_sign_on_paper_override(self):
        """Gets the enable_sign_on_paper_override of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The enable_sign_on_paper_override of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._enable_sign_on_paper_override

    @enable_sign_on_paper_override.setter
    def enable_sign_on_paper_override(self, enable_sign_on_paper_override):
        """Sets the enable_sign_on_paper_override of this UserSettingsInformation.

          # noqa: E501

        :param enable_sign_on_paper_override: The enable_sign_on_paper_override of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._enable_sign_on_paper_override = enable_sign_on_paper_override

    @property
    def enable_sign_on_paper_override_metadata(self):
        """Gets the enable_sign_on_paper_override_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata that indicates whether the `enableSignOnPaperOverride` property is editable.   # noqa: E501

        :return: The enable_sign_on_paper_override_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._enable_sign_on_paper_override_metadata

    @enable_sign_on_paper_override_metadata.setter
    def enable_sign_on_paper_override_metadata(self, enable_sign_on_paper_override_metadata):
        """Sets the enable_sign_on_paper_override_metadata of this UserSettingsInformation.

        Metadata that indicates whether the `enableSignOnPaperOverride` property is editable.   # noqa: E501

        :param enable_sign_on_paper_override_metadata: The enable_sign_on_paper_override_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._enable_sign_on_paper_override_metadata = enable_sign_on_paper_override_metadata

    @property
    def enable_transaction_point(self):
        """Gets the enable_transaction_point of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The enable_transaction_point of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._enable_transaction_point

    @enable_transaction_point.setter
    def enable_transaction_point(self, enable_transaction_point):
        """Sets the enable_transaction_point of this UserSettingsInformation.

          # noqa: E501

        :param enable_transaction_point: The enable_transaction_point of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._enable_transaction_point = enable_transaction_point

    @property
    def enable_transaction_point_metadata(self):
        """Gets the enable_transaction_point_metadata of this UserSettingsInformation.  # noqa: E501

        Reserved for DocuSign.  # noqa: E501

        :return: The enable_transaction_point_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._enable_transaction_point_metadata

    @enable_transaction_point_metadata.setter
    def enable_transaction_point_metadata(self, enable_transaction_point_metadata):
        """Sets the enable_transaction_point_metadata of this UserSettingsInformation.

        Reserved for DocuSign.  # noqa: E501

        :param enable_transaction_point_metadata: The enable_transaction_point_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._enable_transaction_point_metadata = enable_transaction_point_metadata

    @property
    def enable_vaulting(self):
        """Gets the enable_vaulting of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The enable_vaulting of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._enable_vaulting

    @enable_vaulting.setter
    def enable_vaulting(self, enable_vaulting):
        """Sets the enable_vaulting of this UserSettingsInformation.

          # noqa: E501

        :param enable_vaulting: The enable_vaulting of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._enable_vaulting = enable_vaulting

    @property
    def enable_vaulting_metadata(self):
        """Gets the enable_vaulting_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata that indicates whether the `enableVaulting` property is editable.   # noqa: E501

        :return: The enable_vaulting_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._enable_vaulting_metadata

    @enable_vaulting_metadata.setter
    def enable_vaulting_metadata(self, enable_vaulting_metadata):
        """Sets the enable_vaulting_metadata of this UserSettingsInformation.

        Metadata that indicates whether the `enableVaulting` property is editable.   # noqa: E501

        :param enable_vaulting_metadata: The enable_vaulting_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._enable_vaulting_metadata = enable_vaulting_metadata

    @property
    def express_send_only(self):
        """Gets the express_send_only of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The express_send_only of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._express_send_only

    @express_send_only.setter
    def express_send_only(self, express_send_only):
        """Sets the express_send_only of this UserSettingsInformation.

          # noqa: E501

        :param express_send_only: The express_send_only of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._express_send_only = express_send_only

    @property
    def locale(self):
        """Gets the locale of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The locale of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._locale

    @locale.setter
    def locale(self, locale):
        """Sets the locale of this UserSettingsInformation.

          # noqa: E501

        :param locale: The locale of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._locale = locale

    @property
    def locale_metadata(self):
        """Gets the locale_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata about the `locale` property.  # noqa: E501

        :return: The locale_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._locale_metadata

    @locale_metadata.setter
    def locale_metadata(self, locale_metadata):
        """Sets the locale_metadata of this UserSettingsInformation.

        Metadata about the `locale` property.  # noqa: E501

        :param locale_metadata: The locale_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._locale_metadata = locale_metadata

    @property
    def locale_policy(self):
        """Gets the locale_policy of this UserSettingsInformation.  # noqa: E501

        Reserved for DocuSign.  # noqa: E501

        :return: The locale_policy of this UserSettingsInformation.  # noqa: E501
        :rtype: LocalePolicy
        """
        return self._locale_policy

    @locale_policy.setter
    def locale_policy(self, locale_policy):
        """Sets the locale_policy of this UserSettingsInformation.

        Reserved for DocuSign.  # noqa: E501

        :param locale_policy: The locale_policy of this UserSettingsInformation.  # noqa: E501
        :type: LocalePolicy
        """

        self._locale_policy = locale_policy

    @property
    def manage_clickwraps_mode(self):
        """Gets the manage_clickwraps_mode of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The manage_clickwraps_mode of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._manage_clickwraps_mode

    @manage_clickwraps_mode.setter
    def manage_clickwraps_mode(self, manage_clickwraps_mode):
        """Sets the manage_clickwraps_mode of this UserSettingsInformation.

          # noqa: E501

        :param manage_clickwraps_mode: The manage_clickwraps_mode of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._manage_clickwraps_mode = manage_clickwraps_mode

    @property
    def manage_clickwraps_mode_metadata(self):
        """Gets the manage_clickwraps_mode_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata about the `manageClickwrapsMode` property.  # noqa: E501

        :return: The manage_clickwraps_mode_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._manage_clickwraps_mode_metadata

    @manage_clickwraps_mode_metadata.setter
    def manage_clickwraps_mode_metadata(self, manage_clickwraps_mode_metadata):
        """Sets the manage_clickwraps_mode_metadata of this UserSettingsInformation.

        Metadata about the `manageClickwrapsMode` property.  # noqa: E501

        :param manage_clickwraps_mode_metadata: The manage_clickwraps_mode_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._manage_clickwraps_mode_metadata = manage_clickwraps_mode_metadata

    @property
    def modified_by(self):
        """Gets the modified_by of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The modified_by of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by):
        """Sets the modified_by of this UserSettingsInformation.

          # noqa: E501

        :param modified_by: The modified_by of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._modified_by = modified_by

    @property
    def modified_by_metadata(self):
        """Gets the modified_by_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata about the `modifiedBy` property.  # noqa: E501

        :return: The modified_by_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._modified_by_metadata

    @modified_by_metadata.setter
    def modified_by_metadata(self, modified_by_metadata):
        """Sets the modified_by_metadata of this UserSettingsInformation.

        Metadata about the `modifiedBy` property.  # noqa: E501

        :param modified_by_metadata: The modified_by_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._modified_by_metadata = modified_by_metadata

    @property
    def modified_date(self):
        """Gets the modified_date of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The modified_date of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._modified_date

    @modified_date.setter
    def modified_date(self, modified_date):
        """Sets the modified_date of this UserSettingsInformation.

          # noqa: E501

        :param modified_date: The modified_date of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._modified_date = modified_date

    @property
    def modified_date_metadata(self):
        """Gets the modified_date_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata about the `modifiedDate` property.  # noqa: E501

        :return: The modified_date_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._modified_date_metadata

    @modified_date_metadata.setter
    def modified_date_metadata(self, modified_date_metadata):
        """Sets the modified_date_metadata of this UserSettingsInformation.

        Metadata about the `modifiedDate` property.  # noqa: E501

        :param modified_date_metadata: The modified_date_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._modified_date_metadata = modified_date_metadata

    @property
    def modified_page(self):
        """Gets the modified_page of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The modified_page of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._modified_page

    @modified_page.setter
    def modified_page(self, modified_page):
        """Sets the modified_page of this UserSettingsInformation.

          # noqa: E501

        :param modified_page: The modified_page of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._modified_page = modified_page

    @property
    def modified_page_metadata(self):
        """Gets the modified_page_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata about the `modifiedPage` property.  # noqa: E501

        :return: The modified_page_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._modified_page_metadata

    @modified_page_metadata.setter
    def modified_page_metadata(self, modified_page_metadata):
        """Sets the modified_page_metadata of this UserSettingsInformation.

        Metadata about the `modifiedPage` property.  # noqa: E501

        :param modified_page_metadata: The modified_page_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._modified_page_metadata = modified_page_metadata

    @property
    def new_send_ui(self):
        """Gets the new_send_ui of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The new_send_ui of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._new_send_ui

    @new_send_ui.setter
    def new_send_ui(self, new_send_ui):
        """Sets the new_send_ui of this UserSettingsInformation.

          # noqa: E501

        :param new_send_ui: The new_send_ui of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._new_send_ui = new_send_ui

    @property
    def new_send_ui_metadata(self):
        """Gets the new_send_ui_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata about the `newSendUI` property.  # noqa: E501

        :return: The new_send_ui_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._new_send_ui_metadata

    @new_send_ui_metadata.setter
    def new_send_ui_metadata(self, new_send_ui_metadata):
        """Sets the new_send_ui_metadata of this UserSettingsInformation.

        Metadata about the `newSendUI` property.  # noqa: E501

        :param new_send_ui_metadata: The new_send_ui_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._new_send_ui_metadata = new_send_ui_metadata

    @property
    def power_form_mode(self):
        """Gets the power_form_mode of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The power_form_mode of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._power_form_mode

    @power_form_mode.setter
    def power_form_mode(self, power_form_mode):
        """Sets the power_form_mode of this UserSettingsInformation.

          # noqa: E501

        :param power_form_mode: The power_form_mode of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._power_form_mode = power_form_mode

    @property
    def power_form_mode_metadata(self):
        """Gets the power_form_mode_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata about the `powerFormMode` property.  # noqa: E501

        :return: The power_form_mode_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._power_form_mode_metadata

    @power_form_mode_metadata.setter
    def power_form_mode_metadata(self, power_form_mode_metadata):
        """Sets the power_form_mode_metadata of this UserSettingsInformation.

        Metadata about the `powerFormMode` property.  # noqa: E501

        :param power_form_mode_metadata: The power_form_mode_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._power_form_mode_metadata = power_form_mode_metadata

    @property
    def recipient_viewed_notification(self):
        """Gets the recipient_viewed_notification of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The recipient_viewed_notification of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._recipient_viewed_notification

    @recipient_viewed_notification.setter
    def recipient_viewed_notification(self, recipient_viewed_notification):
        """Sets the recipient_viewed_notification of this UserSettingsInformation.

          # noqa: E501

        :param recipient_viewed_notification: The recipient_viewed_notification of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._recipient_viewed_notification = recipient_viewed_notification

    @property
    def recipient_viewed_notification_metadata(self):
        """Gets the recipient_viewed_notification_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata about the `recipientViewedNotification` property.  # noqa: E501

        :return: The recipient_viewed_notification_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._recipient_viewed_notification_metadata

    @recipient_viewed_notification_metadata.setter
    def recipient_viewed_notification_metadata(self, recipient_viewed_notification_metadata):
        """Sets the recipient_viewed_notification_metadata of this UserSettingsInformation.

        Metadata about the `recipientViewedNotification` property.  # noqa: E501

        :param recipient_viewed_notification_metadata: The recipient_viewed_notification_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._recipient_viewed_notification_metadata = recipient_viewed_notification_metadata

    @property
    def seal_identifiers(self):
        """Gets the seal_identifiers of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The seal_identifiers of this UserSettingsInformation.  # noqa: E501
        :rtype: list[SealIdentifier]
        """
        return self._seal_identifiers

    @seal_identifiers.setter
    def seal_identifiers(self, seal_identifiers):
        """Sets the seal_identifiers of this UserSettingsInformation.

          # noqa: E501

        :param seal_identifiers: The seal_identifiers of this UserSettingsInformation.  # noqa: E501
        :type: list[SealIdentifier]
        """

        self._seal_identifiers = seal_identifiers

    @property
    def self_signed_recipient_email_document(self):
        """Gets the self_signed_recipient_email_document of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The self_signed_recipient_email_document of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._self_signed_recipient_email_document

    @self_signed_recipient_email_document.setter
    def self_signed_recipient_email_document(self, self_signed_recipient_email_document):
        """Sets the self_signed_recipient_email_document of this UserSettingsInformation.

          # noqa: E501

        :param self_signed_recipient_email_document: The self_signed_recipient_email_document of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._self_signed_recipient_email_document = self_signed_recipient_email_document

    @property
    def self_signed_recipient_email_document_metadata(self):
        """Gets the self_signed_recipient_email_document_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata that indicates whether the `selfSignedRecipientEmailDocument` property is editable.   # noqa: E501

        :return: The self_signed_recipient_email_document_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._self_signed_recipient_email_document_metadata

    @self_signed_recipient_email_document_metadata.setter
    def self_signed_recipient_email_document_metadata(self, self_signed_recipient_email_document_metadata):
        """Sets the self_signed_recipient_email_document_metadata of this UserSettingsInformation.

        Metadata that indicates whether the `selfSignedRecipientEmailDocument` property is editable.   # noqa: E501

        :param self_signed_recipient_email_document_metadata: The self_signed_recipient_email_document_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._self_signed_recipient_email_document_metadata = self_signed_recipient_email_document_metadata

    @property
    def sender_email_notifications(self):
        """Gets the sender_email_notifications of this UserSettingsInformation.  # noqa: E501

          An array of email notifications that sets the email the user receives when they are a sender. When the specific email notification is set to true, the user will receive those types of email notifications from DocuSign.   The user inherits the default account sender email notification settings when the user is created. The email notifications are:  * envelopeComplete * changedSigner  * senderEnvelopeDeclined  * withdrawnConsent  * recipientViewed  * deliveryFailed     # noqa: E501

        :return: The sender_email_notifications of this UserSettingsInformation.  # noqa: E501
        :rtype: SenderEmailNotifications
        """
        return self._sender_email_notifications

    @sender_email_notifications.setter
    def sender_email_notifications(self, sender_email_notifications):
        """Sets the sender_email_notifications of this UserSettingsInformation.

          An array of email notifications that sets the email the user receives when they are a sender. When the specific email notification is set to true, the user will receive those types of email notifications from DocuSign.   The user inherits the default account sender email notification settings when the user is created. The email notifications are:  * envelopeComplete * changedSigner  * senderEnvelopeDeclined  * withdrawnConsent  * recipientViewed  * deliveryFailed     # noqa: E501

        :param sender_email_notifications: The sender_email_notifications of this UserSettingsInformation.  # noqa: E501
        :type: SenderEmailNotifications
        """

        self._sender_email_notifications = sender_email_notifications

    @property
    def signer_email_notifications(self):
        """Gets the signer_email_notifications of this UserSettingsInformation.  # noqa: E501

        An array of email notifications that specifies the email the user receives when they are a recipient. When the specific email notification is set to true, the user receives those types of email notifications from DocuSign. The user inherits the default account email notification settings when the user is created.   # noqa: E501

        :return: The signer_email_notifications of this UserSettingsInformation.  # noqa: E501
        :rtype: SignerEmailNotifications
        """
        return self._signer_email_notifications

    @signer_email_notifications.setter
    def signer_email_notifications(self, signer_email_notifications):
        """Sets the signer_email_notifications of this UserSettingsInformation.

        An array of email notifications that specifies the email the user receives when they are a recipient. When the specific email notification is set to true, the user receives those types of email notifications from DocuSign. The user inherits the default account email notification settings when the user is created.   # noqa: E501

        :param signer_email_notifications: The signer_email_notifications of this UserSettingsInformation.  # noqa: E501
        :type: SignerEmailNotifications
        """

        self._signer_email_notifications = signer_email_notifications

    @property
    def supplemental_document_include_in_download(self):
        """Gets the supplemental_document_include_in_download of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The supplemental_document_include_in_download of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._supplemental_document_include_in_download

    @supplemental_document_include_in_download.setter
    def supplemental_document_include_in_download(self, supplemental_document_include_in_download):
        """Sets the supplemental_document_include_in_download of this UserSettingsInformation.

          # noqa: E501

        :param supplemental_document_include_in_download: The supplemental_document_include_in_download of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._supplemental_document_include_in_download = supplemental_document_include_in_download

    @property
    def supplemental_documents_must_accept(self):
        """Gets the supplemental_documents_must_accept of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The supplemental_documents_must_accept of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._supplemental_documents_must_accept

    @supplemental_documents_must_accept.setter
    def supplemental_documents_must_accept(self, supplemental_documents_must_accept):
        """Sets the supplemental_documents_must_accept of this UserSettingsInformation.

          # noqa: E501

        :param supplemental_documents_must_accept: The supplemental_documents_must_accept of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._supplemental_documents_must_accept = supplemental_documents_must_accept

    @property
    def supplemental_documents_must_accept_metadata(self):
        """Gets the supplemental_documents_must_accept_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata that indicates whether the `supplementalDocumentsMustAccept` property is editable.   # noqa: E501

        :return: The supplemental_documents_must_accept_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._supplemental_documents_must_accept_metadata

    @supplemental_documents_must_accept_metadata.setter
    def supplemental_documents_must_accept_metadata(self, supplemental_documents_must_accept_metadata):
        """Sets the supplemental_documents_must_accept_metadata of this UserSettingsInformation.

        Metadata that indicates whether the `supplementalDocumentsMustAccept` property is editable.   # noqa: E501

        :param supplemental_documents_must_accept_metadata: The supplemental_documents_must_accept_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._supplemental_documents_must_accept_metadata = supplemental_documents_must_accept_metadata

    @property
    def supplemental_documents_must_read(self):
        """Gets the supplemental_documents_must_read of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The supplemental_documents_must_read of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._supplemental_documents_must_read

    @supplemental_documents_must_read.setter
    def supplemental_documents_must_read(self, supplemental_documents_must_read):
        """Sets the supplemental_documents_must_read of this UserSettingsInformation.

          # noqa: E501

        :param supplemental_documents_must_read: The supplemental_documents_must_read of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._supplemental_documents_must_read = supplemental_documents_must_read

    @property
    def supplemental_documents_must_read_metadata(self):
        """Gets the supplemental_documents_must_read_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata that indicates whether the `supplementalDocumentsMustRead` property is editable.   # noqa: E501

        :return: The supplemental_documents_must_read_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._supplemental_documents_must_read_metadata

    @supplemental_documents_must_read_metadata.setter
    def supplemental_documents_must_read_metadata(self, supplemental_documents_must_read_metadata):
        """Sets the supplemental_documents_must_read_metadata of this UserSettingsInformation.

        Metadata that indicates whether the `supplementalDocumentsMustRead` property is editable.   # noqa: E501

        :param supplemental_documents_must_read_metadata: The supplemental_documents_must_read_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._supplemental_documents_must_read_metadata = supplemental_documents_must_read_metadata

    @property
    def supplemental_documents_must_view(self):
        """Gets the supplemental_documents_must_view of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The supplemental_documents_must_view of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._supplemental_documents_must_view

    @supplemental_documents_must_view.setter
    def supplemental_documents_must_view(self, supplemental_documents_must_view):
        """Sets the supplemental_documents_must_view of this UserSettingsInformation.

          # noqa: E501

        :param supplemental_documents_must_view: The supplemental_documents_must_view of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._supplemental_documents_must_view = supplemental_documents_must_view

    @property
    def supplemental_documents_must_view_metadata(self):
        """Gets the supplemental_documents_must_view_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata that indicates whether the `supplementalDocumentsMustView` property is editable.   # noqa: E501

        :return: The supplemental_documents_must_view_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._supplemental_documents_must_view_metadata

    @supplemental_documents_must_view_metadata.setter
    def supplemental_documents_must_view_metadata(self, supplemental_documents_must_view_metadata):
        """Sets the supplemental_documents_must_view_metadata of this UserSettingsInformation.

        Metadata that indicates whether the `supplementalDocumentsMustView` property is editable.   # noqa: E501

        :param supplemental_documents_must_view_metadata: The supplemental_documents_must_view_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._supplemental_documents_must_view_metadata = supplemental_documents_must_view_metadata

    @property
    def template_active_creation(self):
        """Gets the template_active_creation of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The template_active_creation of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._template_active_creation

    @template_active_creation.setter
    def template_active_creation(self, template_active_creation):
        """Sets the template_active_creation of this UserSettingsInformation.

          # noqa: E501

        :param template_active_creation: The template_active_creation of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._template_active_creation = template_active_creation

    @property
    def template_active_creation_metadata(self):
        """Gets the template_active_creation_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata about the `templateActiveCreation` property.  # noqa: E501

        :return: The template_active_creation_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._template_active_creation_metadata

    @template_active_creation_metadata.setter
    def template_active_creation_metadata(self, template_active_creation_metadata):
        """Sets the template_active_creation_metadata of this UserSettingsInformation.

        Metadata about the `templateActiveCreation` property.  # noqa: E501

        :param template_active_creation_metadata: The template_active_creation_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._template_active_creation_metadata = template_active_creation_metadata

    @property
    def template_apply_notify(self):
        """Gets the template_apply_notify of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The template_apply_notify of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._template_apply_notify

    @template_apply_notify.setter
    def template_apply_notify(self, template_apply_notify):
        """Sets the template_apply_notify of this UserSettingsInformation.

          # noqa: E501

        :param template_apply_notify: The template_apply_notify of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._template_apply_notify = template_apply_notify

    @property
    def template_apply_notify_metadata(self):
        """Gets the template_apply_notify_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata about the `templateApplyNotify` property.  # noqa: E501

        :return: The template_apply_notify_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._template_apply_notify_metadata

    @template_apply_notify_metadata.setter
    def template_apply_notify_metadata(self, template_apply_notify_metadata):
        """Sets the template_apply_notify_metadata of this UserSettingsInformation.

        Metadata about the `templateApplyNotify` property.  # noqa: E501

        :param template_apply_notify_metadata: The template_apply_notify_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._template_apply_notify_metadata = template_apply_notify_metadata

    @property
    def template_auto_matching(self):
        """Gets the template_auto_matching of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The template_auto_matching of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._template_auto_matching

    @template_auto_matching.setter
    def template_auto_matching(self, template_auto_matching):
        """Sets the template_auto_matching of this UserSettingsInformation.

          # noqa: E501

        :param template_auto_matching: The template_auto_matching of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._template_auto_matching = template_auto_matching

    @property
    def template_auto_matching_metadata(self):
        """Gets the template_auto_matching_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata about the `templateAutoMatching` property.  # noqa: E501

        :return: The template_auto_matching_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._template_auto_matching_metadata

    @template_auto_matching_metadata.setter
    def template_auto_matching_metadata(self, template_auto_matching_metadata):
        """Sets the template_auto_matching_metadata of this UserSettingsInformation.

        Metadata about the `templateAutoMatching` property.  # noqa: E501

        :param template_auto_matching_metadata: The template_auto_matching_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._template_auto_matching_metadata = template_auto_matching_metadata

    @property
    def template_matching_sensitivity(self):
        """Gets the template_matching_sensitivity of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The template_matching_sensitivity of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._template_matching_sensitivity

    @template_matching_sensitivity.setter
    def template_matching_sensitivity(self, template_matching_sensitivity):
        """Sets the template_matching_sensitivity of this UserSettingsInformation.

          # noqa: E501

        :param template_matching_sensitivity: The template_matching_sensitivity of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._template_matching_sensitivity = template_matching_sensitivity

    @property
    def template_matching_sensitivity_metadata(self):
        """Gets the template_matching_sensitivity_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata about the `tempalteMatchingSensitivity` property.  # noqa: E501

        :return: The template_matching_sensitivity_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._template_matching_sensitivity_metadata

    @template_matching_sensitivity_metadata.setter
    def template_matching_sensitivity_metadata(self, template_matching_sensitivity_metadata):
        """Sets the template_matching_sensitivity_metadata of this UserSettingsInformation.

        Metadata about the `tempalteMatchingSensitivity` property.  # noqa: E501

        :param template_matching_sensitivity_metadata: The template_matching_sensitivity_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._template_matching_sensitivity_metadata = template_matching_sensitivity_metadata

    @property
    def template_page_level_matching(self):
        """Gets the template_page_level_matching of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The template_page_level_matching of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._template_page_level_matching

    @template_page_level_matching.setter
    def template_page_level_matching(self, template_page_level_matching):
        """Sets the template_page_level_matching of this UserSettingsInformation.

          # noqa: E501

        :param template_page_level_matching: The template_page_level_matching of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._template_page_level_matching = template_page_level_matching

    @property
    def template_page_level_matching_metadata(self):
        """Gets the template_page_level_matching_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata about the `templatePageLevelMatching` property.  # noqa: E501

        :return: The template_page_level_matching_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._template_page_level_matching_metadata

    @template_page_level_matching_metadata.setter
    def template_page_level_matching_metadata(self, template_page_level_matching_metadata):
        """Sets the template_page_level_matching_metadata of this UserSettingsInformation.

        Metadata about the `templatePageLevelMatching` property.  # noqa: E501

        :param template_page_level_matching_metadata: The template_page_level_matching_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._template_page_level_matching_metadata = template_page_level_matching_metadata

    @property
    def timezone_dst(self):
        """Gets the timezone_dst of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The timezone_dst of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._timezone_dst

    @timezone_dst.setter
    def timezone_dst(self, timezone_dst):
        """Sets the timezone_dst of this UserSettingsInformation.

          # noqa: E501

        :param timezone_dst: The timezone_dst of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._timezone_dst = timezone_dst

    @property
    def timezone_dst_metadata(self):
        """Gets the timezone_dst_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata about the `timezoneDST` property.  # noqa: E501

        :return: The timezone_dst_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._timezone_dst_metadata

    @timezone_dst_metadata.setter
    def timezone_dst_metadata(self, timezone_dst_metadata):
        """Sets the timezone_dst_metadata of this UserSettingsInformation.

        Metadata about the `timezoneDST` property.  # noqa: E501

        :param timezone_dst_metadata: The timezone_dst_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._timezone_dst_metadata = timezone_dst_metadata

    @property
    def timezone_mask(self):
        """Gets the timezone_mask of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The timezone_mask of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._timezone_mask

    @timezone_mask.setter
    def timezone_mask(self, timezone_mask):
        """Sets the timezone_mask of this UserSettingsInformation.

          # noqa: E501

        :param timezone_mask: The timezone_mask of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._timezone_mask = timezone_mask

    @property
    def timezone_mask_metadata(self):
        """Gets the timezone_mask_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata about the `timezoneMask` property.  # noqa: E501

        :return: The timezone_mask_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._timezone_mask_metadata

    @timezone_mask_metadata.setter
    def timezone_mask_metadata(self, timezone_mask_metadata):
        """Sets the timezone_mask_metadata of this UserSettingsInformation.

        Metadata about the `timezoneMask` property.  # noqa: E501

        :param timezone_mask_metadata: The timezone_mask_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._timezone_mask_metadata = timezone_mask_metadata

    @property
    def timezone_offset(self):
        """Gets the timezone_offset of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The timezone_offset of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._timezone_offset

    @timezone_offset.setter
    def timezone_offset(self, timezone_offset):
        """Sets the timezone_offset of this UserSettingsInformation.

          # noqa: E501

        :param timezone_offset: The timezone_offset of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._timezone_offset = timezone_offset

    @property
    def timezone_offset_metadata(self):
        """Gets the timezone_offset_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata about the `timezoneOffset` property.  # noqa: E501

        :return: The timezone_offset_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._timezone_offset_metadata

    @timezone_offset_metadata.setter
    def timezone_offset_metadata(self, timezone_offset_metadata):
        """Sets the timezone_offset_metadata of this UserSettingsInformation.

        Metadata about the `timezoneOffset` property.  # noqa: E501

        :param timezone_offset_metadata: The timezone_offset_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._timezone_offset_metadata = timezone_offset_metadata

    @property
    def timezone_sending_pref(self):
        """Gets the timezone_sending_pref of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The timezone_sending_pref of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._timezone_sending_pref

    @timezone_sending_pref.setter
    def timezone_sending_pref(self, timezone_sending_pref):
        """Sets the timezone_sending_pref of this UserSettingsInformation.

          # noqa: E501

        :param timezone_sending_pref: The timezone_sending_pref of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._timezone_sending_pref = timezone_sending_pref

    @property
    def timezone_sending_pref_metadata(self):
        """Gets the timezone_sending_pref_metadata of this UserSettingsInformation.  # noqa: E501

        Reserved for DocuSign.  # noqa: E501

        :return: The timezone_sending_pref_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._timezone_sending_pref_metadata

    @timezone_sending_pref_metadata.setter
    def timezone_sending_pref_metadata(self, timezone_sending_pref_metadata):
        """Sets the timezone_sending_pref_metadata of this UserSettingsInformation.

        Reserved for DocuSign.  # noqa: E501

        :param timezone_sending_pref_metadata: The timezone_sending_pref_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._timezone_sending_pref_metadata = timezone_sending_pref_metadata

    @property
    def timezone_signing_pref(self):
        """Gets the timezone_signing_pref of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The timezone_signing_pref of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._timezone_signing_pref

    @timezone_signing_pref.setter
    def timezone_signing_pref(self, timezone_signing_pref):
        """Sets the timezone_signing_pref of this UserSettingsInformation.

          # noqa: E501

        :param timezone_signing_pref: The timezone_signing_pref of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._timezone_signing_pref = timezone_signing_pref

    @property
    def timezone_signing_pref_metadata(self):
        """Gets the timezone_signing_pref_metadata of this UserSettingsInformation.  # noqa: E501

        Reserved for DocuSign.  # noqa: E501

        :return: The timezone_signing_pref_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._timezone_signing_pref_metadata

    @timezone_signing_pref_metadata.setter
    def timezone_signing_pref_metadata(self, timezone_signing_pref_metadata):
        """Sets the timezone_signing_pref_metadata of this UserSettingsInformation.

        Reserved for DocuSign.  # noqa: E501

        :param timezone_signing_pref_metadata: The timezone_signing_pref_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._timezone_signing_pref_metadata = timezone_signing_pref_metadata

    @property
    def transaction_point_site_name_url(self):
        """Gets the transaction_point_site_name_url of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The transaction_point_site_name_url of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._transaction_point_site_name_url

    @transaction_point_site_name_url.setter
    def transaction_point_site_name_url(self, transaction_point_site_name_url):
        """Sets the transaction_point_site_name_url of this UserSettingsInformation.

          # noqa: E501

        :param transaction_point_site_name_url: The transaction_point_site_name_url of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._transaction_point_site_name_url = transaction_point_site_name_url

    @property
    def transaction_point_site_name_url_metadata(self):
        """Gets the transaction_point_site_name_url_metadata of this UserSettingsInformation.  # noqa: E501

        Reserved for DocuSign.  # noqa: E501

        :return: The transaction_point_site_name_url_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._transaction_point_site_name_url_metadata

    @transaction_point_site_name_url_metadata.setter
    def transaction_point_site_name_url_metadata(self, transaction_point_site_name_url_metadata):
        """Sets the transaction_point_site_name_url_metadata of this UserSettingsInformation.

        Reserved for DocuSign.  # noqa: E501

        :param transaction_point_site_name_url_metadata: The transaction_point_site_name_url_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._transaction_point_site_name_url_metadata = transaction_point_site_name_url_metadata

    @property
    def transaction_point_user_name(self):
        """Gets the transaction_point_user_name of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The transaction_point_user_name of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._transaction_point_user_name

    @transaction_point_user_name.setter
    def transaction_point_user_name(self, transaction_point_user_name):
        """Sets the transaction_point_user_name of this UserSettingsInformation.

          # noqa: E501

        :param transaction_point_user_name: The transaction_point_user_name of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._transaction_point_user_name = transaction_point_user_name

    @property
    def transaction_point_user_name_metadata(self):
        """Gets the transaction_point_user_name_metadata of this UserSettingsInformation.  # noqa: E501

        Reserved for DocuSign.  # noqa: E501

        :return: The transaction_point_user_name_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._transaction_point_user_name_metadata

    @transaction_point_user_name_metadata.setter
    def transaction_point_user_name_metadata(self, transaction_point_user_name_metadata):
        """Sets the transaction_point_user_name_metadata of this UserSettingsInformation.

        Reserved for DocuSign.  # noqa: E501

        :param transaction_point_user_name_metadata: The transaction_point_user_name_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._transaction_point_user_name_metadata = transaction_point_user_name_metadata

    @property
    def vaulting_mode(self):
        """Gets the vaulting_mode of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The vaulting_mode of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._vaulting_mode

    @vaulting_mode.setter
    def vaulting_mode(self, vaulting_mode):
        """Sets the vaulting_mode of this UserSettingsInformation.

          # noqa: E501

        :param vaulting_mode: The vaulting_mode of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._vaulting_mode = vaulting_mode

    @property
    def vaulting_mode_metadata(self):
        """Gets the vaulting_mode_metadata of this UserSettingsInformation.  # noqa: E501

        Metadata about the `vaultingMode` property.  # noqa: E501

        :return: The vaulting_mode_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._vaulting_mode_metadata

    @vaulting_mode_metadata.setter
    def vaulting_mode_metadata(self, vaulting_mode_metadata):
        """Sets the vaulting_mode_metadata of this UserSettingsInformation.

        Metadata about the `vaultingMode` property.  # noqa: E501

        :param vaulting_mode_metadata: The vaulting_mode_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._vaulting_mode_metadata = vaulting_mode_metadata

    @property
    def web_forms(self):
        """Gets the web_forms of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The web_forms of this UserSettingsInformation.  # noqa: E501
        :rtype: str
        """
        return self._web_forms

    @web_forms.setter
    def web_forms(self, web_forms):
        """Sets the web_forms of this UserSettingsInformation.

          # noqa: E501

        :param web_forms: The web_forms of this UserSettingsInformation.  # noqa: E501
        :type: str
        """

        self._web_forms = web_forms

    @property
    def web_forms_metadata(self):
        """Gets the web_forms_metadata of this UserSettingsInformation.  # noqa: E501

          # noqa: E501

        :return: The web_forms_metadata of this UserSettingsInformation.  # noqa: E501
        :rtype: SettingsMetadata
        """
        return self._web_forms_metadata

    @web_forms_metadata.setter
    def web_forms_metadata(self, web_forms_metadata):
        """Sets the web_forms_metadata of this UserSettingsInformation.

          # noqa: E501

        :param web_forms_metadata: The web_forms_metadata of this UserSettingsInformation.  # noqa: E501
        :type: SettingsMetadata
        """

        self._web_forms_metadata = web_forms_metadata

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(UserSettingsInformation, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UserSettingsInformation):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UserSettingsInformation):
            return True

        return self.to_dict() != other.to_dict()
