# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.  # noqa: E501

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from docusign_esign.client.configuration import Configuration


class Signer(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'access_code': 'str',
        'access_code_metadata': 'PropertyMetadata',
        'add_access_code_to_email': 'str',
        'additional_notifications': 'list[RecipientAdditionalNotification]',
        'agent_can_edit_email': 'str',
        'agent_can_edit_name': 'str',
        'allow_system_override_for_locked_recipient': 'str',
        'auto_navigation': 'str',
        'auto_responded_reason': 'str',
        'bulk_recipients_uri': 'str',
        'bulk_send_v2_recipient': 'str',
        'can_sign_offline': 'str',
        'client_user_id': 'str',
        'completed_count': 'str',
        'consent_details_list': 'list[ConsentDetails]',
        'creation_reason': 'str',
        'custom_fields': 'list[str]',
        'declined_date_time': 'str',
        'declined_reason': 'str',
        'default_recipient': 'str',
        'delegated_by': 'DelegationInfo',
        'delegated_to': 'list[DelegationInfo]',
        'delivered_date_time': 'str',
        'delivery_method': 'str',
        'delivery_method_metadata': 'PropertyMetadata',
        'designator_id': 'str',
        'designator_id_guid': 'str',
        'document_visibility': 'list[DocumentVisibility]',
        'email': 'str',
        'email_metadata': 'PropertyMetadata',
        'email_notification': 'RecipientEmailNotification',
        'email_recipient_post_signing_url': 'str',
        'embedded_recipient_start_url': 'str',
        'error_details': 'ErrorDetails',
        'excluded_documents': 'list[str]',
        'fax_number': 'str',
        'fax_number_metadata': 'PropertyMetadata',
        'first_name': 'str',
        'first_name_metadata': 'PropertyMetadata',
        'full_name': 'str',
        'full_name_metadata': 'PropertyMetadata',
        'id_check_configuration_name': 'str',
        'id_check_configuration_name_metadata': 'PropertyMetadata',
        'id_check_information_input': 'IdCheckInformationInput',
        'identity_verification': 'RecipientIdentityVerification',
        'inherit_email_notification_configuration': 'str',
        'is_bulk_recipient': 'str',
        'is_bulk_recipient_metadata': 'PropertyMetadata',
        'last_name': 'str',
        'last_name_metadata': 'PropertyMetadata',
        'locked_recipient_phone_auth_editable': 'str',
        'locked_recipient_sms_editable': 'str',
        'name': 'str',
        'name_metadata': 'PropertyMetadata',
        'notary_id': 'str',
        'notary_signer_email_sent': 'str',
        'note': 'str',
        'note_metadata': 'PropertyMetadata',
        'offline_attributes': 'OfflineAttributes',
        'phone_authentication': 'RecipientPhoneAuthentication',
        'phone_number': 'RecipientPhoneNumber',
        'proof_file': 'RecipientProofFile',
        'recipient_attachments': 'list[RecipientAttachment]',
        'recipient_authentication_status': 'AuthenticationStatus',
        'recipient_feature_metadata': 'list[FeatureAvailableMetadata]',
        'recipient_id': 'str',
        'recipient_id_guid': 'str',
        'recipient_signature_providers': 'list[RecipientSignatureProvider]',
        'recipient_supplies_tabs': 'str',
        'recipient_type': 'str',
        'recipient_type_metadata': 'PropertyMetadata',
        'require_id_lookup': 'str',
        'require_id_lookup_metadata': 'PropertyMetadata',
        'require_signer_certificate': 'str',
        'require_sign_on_paper': 'str',
        'require_upload_signature': 'str',
        'role_name': 'str',
        'routing_order': 'str',
        'routing_order_metadata': 'PropertyMetadata',
        'sent_date_time': 'str',
        'signature_info': 'RecipientSignatureInformation',
        'signed_date_time': 'str',
        'sign_in_each_location': 'str',
        'sign_in_each_location_metadata': 'PropertyMetadata',
        'signing_group_id': 'str',
        'signing_group_id_metadata': 'PropertyMetadata',
        'signing_group_name': 'str',
        'signing_group_users': 'list[UserInfo]',
        'sms_authentication': 'RecipientSMSAuthentication',
        'social_authentications': 'list[SocialAuthentication]',
        'status': 'str',
        'status_code': 'str',
        'suppress_emails': 'str',
        'tabs': 'Tabs',
        'template_locked': 'str',
        'template_required': 'str',
        'total_tab_count': 'str',
        'user_id': 'str'
    }

    attribute_map = {
        'access_code': 'accessCode',
        'access_code_metadata': 'accessCodeMetadata',
        'add_access_code_to_email': 'addAccessCodeToEmail',
        'additional_notifications': 'additionalNotifications',
        'agent_can_edit_email': 'agentCanEditEmail',
        'agent_can_edit_name': 'agentCanEditName',
        'allow_system_override_for_locked_recipient': 'allowSystemOverrideForLockedRecipient',
        'auto_navigation': 'autoNavigation',
        'auto_responded_reason': 'autoRespondedReason',
        'bulk_recipients_uri': 'bulkRecipientsUri',
        'bulk_send_v2_recipient': 'bulkSendV2Recipient',
        'can_sign_offline': 'canSignOffline',
        'client_user_id': 'clientUserId',
        'completed_count': 'completedCount',
        'consent_details_list': 'consentDetailsList',
        'creation_reason': 'creationReason',
        'custom_fields': 'customFields',
        'declined_date_time': 'declinedDateTime',
        'declined_reason': 'declinedReason',
        'default_recipient': 'defaultRecipient',
        'delegated_by': 'delegatedBy',
        'delegated_to': 'delegatedTo',
        'delivered_date_time': 'deliveredDateTime',
        'delivery_method': 'deliveryMethod',
        'delivery_method_metadata': 'deliveryMethodMetadata',
        'designator_id': 'designatorId',
        'designator_id_guid': 'designatorIdGuid',
        'document_visibility': 'documentVisibility',
        'email': 'email',
        'email_metadata': 'emailMetadata',
        'email_notification': 'emailNotification',
        'email_recipient_post_signing_url': 'emailRecipientPostSigningURL',
        'embedded_recipient_start_url': 'embeddedRecipientStartURL',
        'error_details': 'errorDetails',
        'excluded_documents': 'excludedDocuments',
        'fax_number': 'faxNumber',
        'fax_number_metadata': 'faxNumberMetadata',
        'first_name': 'firstName',
        'first_name_metadata': 'firstNameMetadata',
        'full_name': 'fullName',
        'full_name_metadata': 'fullNameMetadata',
        'id_check_configuration_name': 'idCheckConfigurationName',
        'id_check_configuration_name_metadata': 'idCheckConfigurationNameMetadata',
        'id_check_information_input': 'idCheckInformationInput',
        'identity_verification': 'identityVerification',
        'inherit_email_notification_configuration': 'inheritEmailNotificationConfiguration',
        'is_bulk_recipient': 'isBulkRecipient',
        'is_bulk_recipient_metadata': 'isBulkRecipientMetadata',
        'last_name': 'lastName',
        'last_name_metadata': 'lastNameMetadata',
        'locked_recipient_phone_auth_editable': 'lockedRecipientPhoneAuthEditable',
        'locked_recipient_sms_editable': 'lockedRecipientSmsEditable',
        'name': 'name',
        'name_metadata': 'nameMetadata',
        'notary_id': 'notaryId',
        'notary_signer_email_sent': 'notarySignerEmailSent',
        'note': 'note',
        'note_metadata': 'noteMetadata',
        'offline_attributes': 'offlineAttributes',
        'phone_authentication': 'phoneAuthentication',
        'phone_number': 'phoneNumber',
        'proof_file': 'proofFile',
        'recipient_attachments': 'recipientAttachments',
        'recipient_authentication_status': 'recipientAuthenticationStatus',
        'recipient_feature_metadata': 'recipientFeatureMetadata',
        'recipient_id': 'recipientId',
        'recipient_id_guid': 'recipientIdGuid',
        'recipient_signature_providers': 'recipientSignatureProviders',
        'recipient_supplies_tabs': 'recipientSuppliesTabs',
        'recipient_type': 'recipientType',
        'recipient_type_metadata': 'recipientTypeMetadata',
        'require_id_lookup': 'requireIdLookup',
        'require_id_lookup_metadata': 'requireIdLookupMetadata',
        'require_signer_certificate': 'requireSignerCertificate',
        'require_sign_on_paper': 'requireSignOnPaper',
        'require_upload_signature': 'requireUploadSignature',
        'role_name': 'roleName',
        'routing_order': 'routingOrder',
        'routing_order_metadata': 'routingOrderMetadata',
        'sent_date_time': 'sentDateTime',
        'signature_info': 'signatureInfo',
        'signed_date_time': 'signedDateTime',
        'sign_in_each_location': 'signInEachLocation',
        'sign_in_each_location_metadata': 'signInEachLocationMetadata',
        'signing_group_id': 'signingGroupId',
        'signing_group_id_metadata': 'signingGroupIdMetadata',
        'signing_group_name': 'signingGroupName',
        'signing_group_users': 'signingGroupUsers',
        'sms_authentication': 'smsAuthentication',
        'social_authentications': 'socialAuthentications',
        'status': 'status',
        'status_code': 'statusCode',
        'suppress_emails': 'suppressEmails',
        'tabs': 'tabs',
        'template_locked': 'templateLocked',
        'template_required': 'templateRequired',
        'total_tab_count': 'totalTabCount',
        'user_id': 'userId'
    }

    def __init__(self, _configuration=None, **kwargs):  # noqa: E501
        """Signer - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._access_code = None
        self._access_code_metadata = None
        self._add_access_code_to_email = None
        self._additional_notifications = None
        self._agent_can_edit_email = None
        self._agent_can_edit_name = None
        self._allow_system_override_for_locked_recipient = None
        self._auto_navigation = None
        self._auto_responded_reason = None
        self._bulk_recipients_uri = None
        self._bulk_send_v2_recipient = None
        self._can_sign_offline = None
        self._client_user_id = None
        self._completed_count = None
        self._consent_details_list = None
        self._creation_reason = None
        self._custom_fields = None
        self._declined_date_time = None
        self._declined_reason = None
        self._default_recipient = None
        self._delegated_by = None
        self._delegated_to = None
        self._delivered_date_time = None
        self._delivery_method = None
        self._delivery_method_metadata = None
        self._designator_id = None
        self._designator_id_guid = None
        self._document_visibility = None
        self._email = None
        self._email_metadata = None
        self._email_notification = None
        self._email_recipient_post_signing_url = None
        self._embedded_recipient_start_url = None
        self._error_details = None
        self._excluded_documents = None
        self._fax_number = None
        self._fax_number_metadata = None
        self._first_name = None
        self._first_name_metadata = None
        self._full_name = None
        self._full_name_metadata = None
        self._id_check_configuration_name = None
        self._id_check_configuration_name_metadata = None
        self._id_check_information_input = None
        self._identity_verification = None
        self._inherit_email_notification_configuration = None
        self._is_bulk_recipient = None
        self._is_bulk_recipient_metadata = None
        self._last_name = None
        self._last_name_metadata = None
        self._locked_recipient_phone_auth_editable = None
        self._locked_recipient_sms_editable = None
        self._name = None
        self._name_metadata = None
        self._notary_id = None
        self._notary_signer_email_sent = None
        self._note = None
        self._note_metadata = None
        self._offline_attributes = None
        self._phone_authentication = None
        self._phone_number = None
        self._proof_file = None
        self._recipient_attachments = None
        self._recipient_authentication_status = None
        self._recipient_feature_metadata = None
        self._recipient_id = None
        self._recipient_id_guid = None
        self._recipient_signature_providers = None
        self._recipient_supplies_tabs = None
        self._recipient_type = None
        self._recipient_type_metadata = None
        self._require_id_lookup = None
        self._require_id_lookup_metadata = None
        self._require_signer_certificate = None
        self._require_sign_on_paper = None
        self._require_upload_signature = None
        self._role_name = None
        self._routing_order = None
        self._routing_order_metadata = None
        self._sent_date_time = None
        self._signature_info = None
        self._signed_date_time = None
        self._sign_in_each_location = None
        self._sign_in_each_location_metadata = None
        self._signing_group_id = None
        self._signing_group_id_metadata = None
        self._signing_group_name = None
        self._signing_group_users = None
        self._sms_authentication = None
        self._social_authentications = None
        self._status = None
        self._status_code = None
        self._suppress_emails = None
        self._tabs = None
        self._template_locked = None
        self._template_required = None
        self._total_tab_count = None
        self._user_id = None
        self.discriminator = None

        setattr(self, "_{}".format('access_code'), kwargs.get('access_code', None))
        setattr(self, "_{}".format('access_code_metadata'), kwargs.get('access_code_metadata', None))
        setattr(self, "_{}".format('add_access_code_to_email'), kwargs.get('add_access_code_to_email', None))
        setattr(self, "_{}".format('additional_notifications'), kwargs.get('additional_notifications', None))
        setattr(self, "_{}".format('agent_can_edit_email'), kwargs.get('agent_can_edit_email', None))
        setattr(self, "_{}".format('agent_can_edit_name'), kwargs.get('agent_can_edit_name', None))
        setattr(self, "_{}".format('allow_system_override_for_locked_recipient'), kwargs.get('allow_system_override_for_locked_recipient', None))
        setattr(self, "_{}".format('auto_navigation'), kwargs.get('auto_navigation', None))
        setattr(self, "_{}".format('auto_responded_reason'), kwargs.get('auto_responded_reason', None))
        setattr(self, "_{}".format('bulk_recipients_uri'), kwargs.get('bulk_recipients_uri', None))
        setattr(self, "_{}".format('bulk_send_v2_recipient'), kwargs.get('bulk_send_v2_recipient', None))
        setattr(self, "_{}".format('can_sign_offline'), kwargs.get('can_sign_offline', None))
        setattr(self, "_{}".format('client_user_id'), kwargs.get('client_user_id', None))
        setattr(self, "_{}".format('completed_count'), kwargs.get('completed_count', None))
        setattr(self, "_{}".format('consent_details_list'), kwargs.get('consent_details_list', None))
        setattr(self, "_{}".format('creation_reason'), kwargs.get('creation_reason', None))
        setattr(self, "_{}".format('custom_fields'), kwargs.get('custom_fields', None))
        setattr(self, "_{}".format('declined_date_time'), kwargs.get('declined_date_time', None))
        setattr(self, "_{}".format('declined_reason'), kwargs.get('declined_reason', None))
        setattr(self, "_{}".format('default_recipient'), kwargs.get('default_recipient', None))
        setattr(self, "_{}".format('delegated_by'), kwargs.get('delegated_by', None))
        setattr(self, "_{}".format('delegated_to'), kwargs.get('delegated_to', None))
        setattr(self, "_{}".format('delivered_date_time'), kwargs.get('delivered_date_time', None))
        setattr(self, "_{}".format('delivery_method'), kwargs.get('delivery_method', None))
        setattr(self, "_{}".format('delivery_method_metadata'), kwargs.get('delivery_method_metadata', None))
        setattr(self, "_{}".format('designator_id'), kwargs.get('designator_id', None))
        setattr(self, "_{}".format('designator_id_guid'), kwargs.get('designator_id_guid', None))
        setattr(self, "_{}".format('document_visibility'), kwargs.get('document_visibility', None))
        setattr(self, "_{}".format('email'), kwargs.get('email', None))
        setattr(self, "_{}".format('email_metadata'), kwargs.get('email_metadata', None))
        setattr(self, "_{}".format('email_notification'), kwargs.get('email_notification', None))
        setattr(self, "_{}".format('email_recipient_post_signing_url'), kwargs.get('email_recipient_post_signing_url', None))
        setattr(self, "_{}".format('embedded_recipient_start_url'), kwargs.get('embedded_recipient_start_url', None))
        setattr(self, "_{}".format('error_details'), kwargs.get('error_details', None))
        setattr(self, "_{}".format('excluded_documents'), kwargs.get('excluded_documents', None))
        setattr(self, "_{}".format('fax_number'), kwargs.get('fax_number', None))
        setattr(self, "_{}".format('fax_number_metadata'), kwargs.get('fax_number_metadata', None))
        setattr(self, "_{}".format('first_name'), kwargs.get('first_name', None))
        setattr(self, "_{}".format('first_name_metadata'), kwargs.get('first_name_metadata', None))
        setattr(self, "_{}".format('full_name'), kwargs.get('full_name', None))
        setattr(self, "_{}".format('full_name_metadata'), kwargs.get('full_name_metadata', None))
        setattr(self, "_{}".format('id_check_configuration_name'), kwargs.get('id_check_configuration_name', None))
        setattr(self, "_{}".format('id_check_configuration_name_metadata'), kwargs.get('id_check_configuration_name_metadata', None))
        setattr(self, "_{}".format('id_check_information_input'), kwargs.get('id_check_information_input', None))
        setattr(self, "_{}".format('identity_verification'), kwargs.get('identity_verification', None))
        setattr(self, "_{}".format('inherit_email_notification_configuration'), kwargs.get('inherit_email_notification_configuration', None))
        setattr(self, "_{}".format('is_bulk_recipient'), kwargs.get('is_bulk_recipient', None))
        setattr(self, "_{}".format('is_bulk_recipient_metadata'), kwargs.get('is_bulk_recipient_metadata', None))
        setattr(self, "_{}".format('last_name'), kwargs.get('last_name', None))
        setattr(self, "_{}".format('last_name_metadata'), kwargs.get('last_name_metadata', None))
        setattr(self, "_{}".format('locked_recipient_phone_auth_editable'), kwargs.get('locked_recipient_phone_auth_editable', None))
        setattr(self, "_{}".format('locked_recipient_sms_editable'), kwargs.get('locked_recipient_sms_editable', None))
        setattr(self, "_{}".format('name'), kwargs.get('name', None))
        setattr(self, "_{}".format('name_metadata'), kwargs.get('name_metadata', None))
        setattr(self, "_{}".format('notary_id'), kwargs.get('notary_id', None))
        setattr(self, "_{}".format('notary_signer_email_sent'), kwargs.get('notary_signer_email_sent', None))
        setattr(self, "_{}".format('note'), kwargs.get('note', None))
        setattr(self, "_{}".format('note_metadata'), kwargs.get('note_metadata', None))
        setattr(self, "_{}".format('offline_attributes'), kwargs.get('offline_attributes', None))
        setattr(self, "_{}".format('phone_authentication'), kwargs.get('phone_authentication', None))
        setattr(self, "_{}".format('phone_number'), kwargs.get('phone_number', None))
        setattr(self, "_{}".format('proof_file'), kwargs.get('proof_file', None))
        setattr(self, "_{}".format('recipient_attachments'), kwargs.get('recipient_attachments', None))
        setattr(self, "_{}".format('recipient_authentication_status'), kwargs.get('recipient_authentication_status', None))
        setattr(self, "_{}".format('recipient_feature_metadata'), kwargs.get('recipient_feature_metadata', None))
        setattr(self, "_{}".format('recipient_id'), kwargs.get('recipient_id', None))
        setattr(self, "_{}".format('recipient_id_guid'), kwargs.get('recipient_id_guid', None))
        setattr(self, "_{}".format('recipient_signature_providers'), kwargs.get('recipient_signature_providers', None))
        setattr(self, "_{}".format('recipient_supplies_tabs'), kwargs.get('recipient_supplies_tabs', None))
        setattr(self, "_{}".format('recipient_type'), kwargs.get('recipient_type', None))
        setattr(self, "_{}".format('recipient_type_metadata'), kwargs.get('recipient_type_metadata', None))
        setattr(self, "_{}".format('require_id_lookup'), kwargs.get('require_id_lookup', None))
        setattr(self, "_{}".format('require_id_lookup_metadata'), kwargs.get('require_id_lookup_metadata', None))
        setattr(self, "_{}".format('require_signer_certificate'), kwargs.get('require_signer_certificate', None))
        setattr(self, "_{}".format('require_sign_on_paper'), kwargs.get('require_sign_on_paper', None))
        setattr(self, "_{}".format('require_upload_signature'), kwargs.get('require_upload_signature', None))
        setattr(self, "_{}".format('role_name'), kwargs.get('role_name', None))
        setattr(self, "_{}".format('routing_order'), kwargs.get('routing_order', None))
        setattr(self, "_{}".format('routing_order_metadata'), kwargs.get('routing_order_metadata', None))
        setattr(self, "_{}".format('sent_date_time'), kwargs.get('sent_date_time', None))
        setattr(self, "_{}".format('signature_info'), kwargs.get('signature_info', None))
        setattr(self, "_{}".format('signed_date_time'), kwargs.get('signed_date_time', None))
        setattr(self, "_{}".format('sign_in_each_location'), kwargs.get('sign_in_each_location', None))
        setattr(self, "_{}".format('sign_in_each_location_metadata'), kwargs.get('sign_in_each_location_metadata', None))
        setattr(self, "_{}".format('signing_group_id'), kwargs.get('signing_group_id', None))
        setattr(self, "_{}".format('signing_group_id_metadata'), kwargs.get('signing_group_id_metadata', None))
        setattr(self, "_{}".format('signing_group_name'), kwargs.get('signing_group_name', None))
        setattr(self, "_{}".format('signing_group_users'), kwargs.get('signing_group_users', None))
        setattr(self, "_{}".format('sms_authentication'), kwargs.get('sms_authentication', None))
        setattr(self, "_{}".format('social_authentications'), kwargs.get('social_authentications', None))
        setattr(self, "_{}".format('status'), kwargs.get('status', None))
        setattr(self, "_{}".format('status_code'), kwargs.get('status_code', None))
        setattr(self, "_{}".format('suppress_emails'), kwargs.get('suppress_emails', None))
        setattr(self, "_{}".format('tabs'), kwargs.get('tabs', None))
        setattr(self, "_{}".format('template_locked'), kwargs.get('template_locked', None))
        setattr(self, "_{}".format('template_required'), kwargs.get('template_required', None))
        setattr(self, "_{}".format('total_tab_count'), kwargs.get('total_tab_count', None))
        setattr(self, "_{}".format('user_id'), kwargs.get('user_id', None))

    @property
    def access_code(self):
        """Gets the access_code of this Signer.  # noqa: E501

        If a value is provided, the recipient must enter the value as the access code to view and sign the envelope.   Maximum Length: 50 characters and it must conform to the account's access code format setting.  If blank, but the signer `accessCode` property is set in the envelope, then that value is used.  If blank and the signer `accessCode` property is not set, then the access code is not required.  # noqa: E501

        :return: The access_code of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._access_code

    @access_code.setter
    def access_code(self, access_code):
        """Sets the access_code of this Signer.

        If a value is provided, the recipient must enter the value as the access code to view and sign the envelope.   Maximum Length: 50 characters and it must conform to the account's access code format setting.  If blank, but the signer `accessCode` property is set in the envelope, then that value is used.  If blank and the signer `accessCode` property is not set, then the access code is not required.  # noqa: E501

        :param access_code: The access_code of this Signer.  # noqa: E501
        :type: str
        """

        self._access_code = access_code

    @property
    def access_code_metadata(self):
        """Gets the access_code_metadata of this Signer.  # noqa: E501

        Metadata that indicates whether the `accessCode` property is editable. This property is read-only.  # noqa: E501

        :return: The access_code_metadata of this Signer.  # noqa: E501
        :rtype: PropertyMetadata
        """
        return self._access_code_metadata

    @access_code_metadata.setter
    def access_code_metadata(self, access_code_metadata):
        """Sets the access_code_metadata of this Signer.

        Metadata that indicates whether the `accessCode` property is editable. This property is read-only.  # noqa: E501

        :param access_code_metadata: The access_code_metadata of this Signer.  # noqa: E501
        :type: PropertyMetadata
        """

        self._access_code_metadata = access_code_metadata

    @property
    def add_access_code_to_email(self):
        """Gets the add_access_code_to_email of this Signer.  # noqa: E501

        This Optional attribute indicates that the access code will be added to the email sent to the recipient; this nullifies the Security measure of Access Code on the recipient.  # noqa: E501

        :return: The add_access_code_to_email of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._add_access_code_to_email

    @add_access_code_to_email.setter
    def add_access_code_to_email(self, add_access_code_to_email):
        """Sets the add_access_code_to_email of this Signer.

        This Optional attribute indicates that the access code will be added to the email sent to the recipient; this nullifies the Security measure of Access Code on the recipient.  # noqa: E501

        :param add_access_code_to_email: The add_access_code_to_email of this Signer.  # noqa: E501
        :type: str
        """

        self._add_access_code_to_email = add_access_code_to_email

    @property
    def additional_notifications(self):
        """Gets the additional_notifications of this Signer.  # noqa: E501

          # noqa: E501

        :return: The additional_notifications of this Signer.  # noqa: E501
        :rtype: list[RecipientAdditionalNotification]
        """
        return self._additional_notifications

    @additional_notifications.setter
    def additional_notifications(self, additional_notifications):
        """Sets the additional_notifications of this Signer.

          # noqa: E501

        :param additional_notifications: The additional_notifications of this Signer.  # noqa: E501
        :type: list[RecipientAdditionalNotification]
        """

        self._additional_notifications = additional_notifications

    @property
    def agent_can_edit_email(self):
        """Gets the agent_can_edit_email of this Signer.  # noqa: E501

          # noqa: E501

        :return: The agent_can_edit_email of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._agent_can_edit_email

    @agent_can_edit_email.setter
    def agent_can_edit_email(self, agent_can_edit_email):
        """Sets the agent_can_edit_email of this Signer.

          # noqa: E501

        :param agent_can_edit_email: The agent_can_edit_email of this Signer.  # noqa: E501
        :type: str
        """

        self._agent_can_edit_email = agent_can_edit_email

    @property
    def agent_can_edit_name(self):
        """Gets the agent_can_edit_name of this Signer.  # noqa: E501

          # noqa: E501

        :return: The agent_can_edit_name of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._agent_can_edit_name

    @agent_can_edit_name.setter
    def agent_can_edit_name(self, agent_can_edit_name):
        """Sets the agent_can_edit_name of this Signer.

          # noqa: E501

        :param agent_can_edit_name: The agent_can_edit_name of this Signer.  # noqa: E501
        :type: str
        """

        self._agent_can_edit_name = agent_can_edit_name

    @property
    def allow_system_override_for_locked_recipient(self):
        """Gets the allow_system_override_for_locked_recipient of this Signer.  # noqa: E501

          # noqa: E501

        :return: The allow_system_override_for_locked_recipient of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._allow_system_override_for_locked_recipient

    @allow_system_override_for_locked_recipient.setter
    def allow_system_override_for_locked_recipient(self, allow_system_override_for_locked_recipient):
        """Sets the allow_system_override_for_locked_recipient of this Signer.

          # noqa: E501

        :param allow_system_override_for_locked_recipient: The allow_system_override_for_locked_recipient of this Signer.  # noqa: E501
        :type: str
        """

        self._allow_system_override_for_locked_recipient = allow_system_override_for_locked_recipient

    @property
    def auto_navigation(self):
        """Gets the auto_navigation of this Signer.  # noqa: E501

          # noqa: E501

        :return: The auto_navigation of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._auto_navigation

    @auto_navigation.setter
    def auto_navigation(self, auto_navigation):
        """Sets the auto_navigation of this Signer.

          # noqa: E501

        :param auto_navigation: The auto_navigation of this Signer.  # noqa: E501
        :type: str
        """

        self._auto_navigation = auto_navigation

    @property
    def auto_responded_reason(self):
        """Gets the auto_responded_reason of this Signer.  # noqa: E501

          # noqa: E501

        :return: The auto_responded_reason of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._auto_responded_reason

    @auto_responded_reason.setter
    def auto_responded_reason(self, auto_responded_reason):
        """Sets the auto_responded_reason of this Signer.

          # noqa: E501

        :param auto_responded_reason: The auto_responded_reason of this Signer.  # noqa: E501
        :type: str
        """

        self._auto_responded_reason = auto_responded_reason

    @property
    def bulk_recipients_uri(self):
        """Gets the bulk_recipients_uri of this Signer.  # noqa: E501

        Contains a URI for an endpoint that allows you to easily retrieve bulk recipient information.  # noqa: E501

        :return: The bulk_recipients_uri of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._bulk_recipients_uri

    @bulk_recipients_uri.setter
    def bulk_recipients_uri(self, bulk_recipients_uri):
        """Sets the bulk_recipients_uri of this Signer.

        Contains a URI for an endpoint that allows you to easily retrieve bulk recipient information.  # noqa: E501

        :param bulk_recipients_uri: The bulk_recipients_uri of this Signer.  # noqa: E501
        :type: str
        """

        self._bulk_recipients_uri = bulk_recipients_uri

    @property
    def bulk_send_v2_recipient(self):
        """Gets the bulk_send_v2_recipient of this Signer.  # noqa: E501

          # noqa: E501

        :return: The bulk_send_v2_recipient of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._bulk_send_v2_recipient

    @bulk_send_v2_recipient.setter
    def bulk_send_v2_recipient(self, bulk_send_v2_recipient):
        """Sets the bulk_send_v2_recipient of this Signer.

          # noqa: E501

        :param bulk_send_v2_recipient: The bulk_send_v2_recipient of this Signer.  # noqa: E501
        :type: str
        """

        self._bulk_send_v2_recipient = bulk_send_v2_recipient

    @property
    def can_sign_offline(self):
        """Gets the can_sign_offline of this Signer.  # noqa: E501

        When set to **true**, specifies that the signer can perform the signing ceremony offline.  # noqa: E501

        :return: The can_sign_offline of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._can_sign_offline

    @can_sign_offline.setter
    def can_sign_offline(self, can_sign_offline):
        """Sets the can_sign_offline of this Signer.

        When set to **true**, specifies that the signer can perform the signing ceremony offline.  # noqa: E501

        :param can_sign_offline: The can_sign_offline of this Signer.  # noqa: E501
        :type: str
        """

        self._can_sign_offline = can_sign_offline

    @property
    def client_user_id(self):
        """Gets the client_user_id of this Signer.  # noqa: E501

        Specifies whether the recipient is embedded or remote.   If the `clientUserId` property is not null then the recipient is embedded. Note that if the `ClientUserId` property is set and either `SignerMustHaveAccount` or `SignerMustLoginToSign` property of the account settings is set to  **true**, an error is generated on sending.ng.   Maximum length: 100 characters.   # noqa: E501

        :return: The client_user_id of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._client_user_id

    @client_user_id.setter
    def client_user_id(self, client_user_id):
        """Sets the client_user_id of this Signer.

        Specifies whether the recipient is embedded or remote.   If the `clientUserId` property is not null then the recipient is embedded. Note that if the `ClientUserId` property is set and either `SignerMustHaveAccount` or `SignerMustLoginToSign` property of the account settings is set to  **true**, an error is generated on sending.ng.   Maximum length: 100 characters.   # noqa: E501

        :param client_user_id: The client_user_id of this Signer.  # noqa: E501
        :type: str
        """

        self._client_user_id = client_user_id

    @property
    def completed_count(self):
        """Gets the completed_count of this Signer.  # noqa: E501

          # noqa: E501

        :return: The completed_count of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._completed_count

    @completed_count.setter
    def completed_count(self, completed_count):
        """Sets the completed_count of this Signer.

          # noqa: E501

        :param completed_count: The completed_count of this Signer.  # noqa: E501
        :type: str
        """

        self._completed_count = completed_count

    @property
    def consent_details_list(self):
        """Gets the consent_details_list of this Signer.  # noqa: E501

          # noqa: E501

        :return: The consent_details_list of this Signer.  # noqa: E501
        :rtype: list[ConsentDetails]
        """
        return self._consent_details_list

    @consent_details_list.setter
    def consent_details_list(self, consent_details_list):
        """Sets the consent_details_list of this Signer.

          # noqa: E501

        :param consent_details_list: The consent_details_list of this Signer.  # noqa: E501
        :type: list[ConsentDetails]
        """

        self._consent_details_list = consent_details_list

    @property
    def creation_reason(self):
        """Gets the creation_reason of this Signer.  # noqa: E501

          # noqa: E501

        :return: The creation_reason of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._creation_reason

    @creation_reason.setter
    def creation_reason(self, creation_reason):
        """Sets the creation_reason of this Signer.

          # noqa: E501

        :param creation_reason: The creation_reason of this Signer.  # noqa: E501
        :type: str
        """

        self._creation_reason = creation_reason

    @property
    def custom_fields(self):
        """Gets the custom_fields of this Signer.  # noqa: E501

        An optional array of strings that allows the sender to provide custom data about the recipient. This information is returned in the envelope status but otherwise not used by DocuSign. Each customField string can be a maximum of 100 characters.  # noqa: E501

        :return: The custom_fields of this Signer.  # noqa: E501
        :rtype: list[str]
        """
        return self._custom_fields

    @custom_fields.setter
    def custom_fields(self, custom_fields):
        """Sets the custom_fields of this Signer.

        An optional array of strings that allows the sender to provide custom data about the recipient. This information is returned in the envelope status but otherwise not used by DocuSign. Each customField string can be a maximum of 100 characters.  # noqa: E501

        :param custom_fields: The custom_fields of this Signer.  # noqa: E501
        :type: list[str]
        """

        self._custom_fields = custom_fields

    @property
    def declined_date_time(self):
        """Gets the declined_date_time of this Signer.  # noqa: E501

        The date and time the recipient declined the document.  # noqa: E501

        :return: The declined_date_time of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._declined_date_time

    @declined_date_time.setter
    def declined_date_time(self, declined_date_time):
        """Sets the declined_date_time of this Signer.

        The date and time the recipient declined the document.  # noqa: E501

        :param declined_date_time: The declined_date_time of this Signer.  # noqa: E501
        :type: str
        """

        self._declined_date_time = declined_date_time

    @property
    def declined_reason(self):
        """Gets the declined_reason of this Signer.  # noqa: E501

        The reason the recipient declined the document.  # noqa: E501

        :return: The declined_reason of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._declined_reason

    @declined_reason.setter
    def declined_reason(self, declined_reason):
        """Sets the declined_reason of this Signer.

        The reason the recipient declined the document.  # noqa: E501

        :param declined_reason: The declined_reason of this Signer.  # noqa: E501
        :type: str
        """

        self._declined_reason = declined_reason

    @property
    def default_recipient(self):
        """Gets the default_recipient of this Signer.  # noqa: E501

          # noqa: E501

        :return: The default_recipient of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._default_recipient

    @default_recipient.setter
    def default_recipient(self, default_recipient):
        """Sets the default_recipient of this Signer.

          # noqa: E501

        :param default_recipient: The default_recipient of this Signer.  # noqa: E501
        :type: str
        """

        self._default_recipient = default_recipient

    @property
    def delegated_by(self):
        """Gets the delegated_by of this Signer.  # noqa: E501

          # noqa: E501

        :return: The delegated_by of this Signer.  # noqa: E501
        :rtype: DelegationInfo
        """
        return self._delegated_by

    @delegated_by.setter
    def delegated_by(self, delegated_by):
        """Sets the delegated_by of this Signer.

          # noqa: E501

        :param delegated_by: The delegated_by of this Signer.  # noqa: E501
        :type: DelegationInfo
        """

        self._delegated_by = delegated_by

    @property
    def delegated_to(self):
        """Gets the delegated_to of this Signer.  # noqa: E501

          # noqa: E501

        :return: The delegated_to of this Signer.  # noqa: E501
        :rtype: list[DelegationInfo]
        """
        return self._delegated_to

    @delegated_to.setter
    def delegated_to(self, delegated_to):
        """Sets the delegated_to of this Signer.

          # noqa: E501

        :param delegated_to: The delegated_to of this Signer.  # noqa: E501
        :type: list[DelegationInfo]
        """

        self._delegated_to = delegated_to

    @property
    def delivered_date_time(self):
        """Gets the delivered_date_time of this Signer.  # noqa: E501

        Reserved: For DocuSign use only.  # noqa: E501

        :return: The delivered_date_time of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._delivered_date_time

    @delivered_date_time.setter
    def delivered_date_time(self, delivered_date_time):
        """Sets the delivered_date_time of this Signer.

        Reserved: For DocuSign use only.  # noqa: E501

        :param delivered_date_time: The delivered_date_time of this Signer.  # noqa: E501
        :type: str
        """

        self._delivered_date_time = delivered_date_time

    @property
    def delivery_method(self):
        """Gets the delivery_method of this Signer.  # noqa: E501

        Reserved: For DocuSign use only.  # noqa: E501

        :return: The delivery_method of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._delivery_method

    @delivery_method.setter
    def delivery_method(self, delivery_method):
        """Sets the delivery_method of this Signer.

        Reserved: For DocuSign use only.  # noqa: E501

        :param delivery_method: The delivery_method of this Signer.  # noqa: E501
        :type: str
        """

        self._delivery_method = delivery_method

    @property
    def delivery_method_metadata(self):
        """Gets the delivery_method_metadata of this Signer.  # noqa: E501

        Reserved for DocuSign.  # noqa: E501

        :return: The delivery_method_metadata of this Signer.  # noqa: E501
        :rtype: PropertyMetadata
        """
        return self._delivery_method_metadata

    @delivery_method_metadata.setter
    def delivery_method_metadata(self, delivery_method_metadata):
        """Sets the delivery_method_metadata of this Signer.

        Reserved for DocuSign.  # noqa: E501

        :param delivery_method_metadata: The delivery_method_metadata of this Signer.  # noqa: E501
        :type: PropertyMetadata
        """

        self._delivery_method_metadata = delivery_method_metadata

    @property
    def designator_id(self):
        """Gets the designator_id of this Signer.  # noqa: E501

          # noqa: E501

        :return: The designator_id of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._designator_id

    @designator_id.setter
    def designator_id(self, designator_id):
        """Sets the designator_id of this Signer.

          # noqa: E501

        :param designator_id: The designator_id of this Signer.  # noqa: E501
        :type: str
        """

        self._designator_id = designator_id

    @property
    def designator_id_guid(self):
        """Gets the designator_id_guid of this Signer.  # noqa: E501

          # noqa: E501

        :return: The designator_id_guid of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._designator_id_guid

    @designator_id_guid.setter
    def designator_id_guid(self, designator_id_guid):
        """Sets the designator_id_guid of this Signer.

          # noqa: E501

        :param designator_id_guid: The designator_id_guid of this Signer.  # noqa: E501
        :type: str
        """

        self._designator_id_guid = designator_id_guid

    @property
    def document_visibility(self):
        """Gets the document_visibility of this Signer.  # noqa: E501

          # noqa: E501

        :return: The document_visibility of this Signer.  # noqa: E501
        :rtype: list[DocumentVisibility]
        """
        return self._document_visibility

    @document_visibility.setter
    def document_visibility(self, document_visibility):
        """Sets the document_visibility of this Signer.

          # noqa: E501

        :param document_visibility: The document_visibility of this Signer.  # noqa: E501
        :type: list[DocumentVisibility]
        """

        self._document_visibility = document_visibility

    @property
    def email(self):
        """Gets the email of this Signer.  # noqa: E501

        Email id of the recipient. Notification of the document to sign is sent to this email id.   Maximum length: 100 characters.   # noqa: E501

        :return: The email of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this Signer.

        Email id of the recipient. Notification of the document to sign is sent to this email id.   Maximum length: 100 characters.   # noqa: E501

        :param email: The email of this Signer.  # noqa: E501
        :type: str
        """

        self._email = email

    @property
    def email_metadata(self):
        """Gets the email_metadata of this Signer.  # noqa: E501

        Metadata that indicates whether the `email` property is editable. This property is read-only.  # noqa: E501

        :return: The email_metadata of this Signer.  # noqa: E501
        :rtype: PropertyMetadata
        """
        return self._email_metadata

    @email_metadata.setter
    def email_metadata(self, email_metadata):
        """Sets the email_metadata of this Signer.

        Metadata that indicates whether the `email` property is editable. This property is read-only.  # noqa: E501

        :param email_metadata: The email_metadata of this Signer.  # noqa: E501
        :type: PropertyMetadata
        """

        self._email_metadata = email_metadata

    @property
    def email_notification(self):
        """Gets the email_notification of this Signer.  # noqa: E501

        A complex type that contains information sets the language of the recipient's email information.   **IMPORTANT**: If you enable email notification for one recipient, you must enable email notification for all recipients as it overrides the Envelope Subject and `EmailBlurb` property settings.   # noqa: E501

        :return: The email_notification of this Signer.  # noqa: E501
        :rtype: RecipientEmailNotification
        """
        return self._email_notification

    @email_notification.setter
    def email_notification(self, email_notification):
        """Sets the email_notification of this Signer.

        A complex type that contains information sets the language of the recipient's email information.   **IMPORTANT**: If you enable email notification for one recipient, you must enable email notification for all recipients as it overrides the Envelope Subject and `EmailBlurb` property settings.   # noqa: E501

        :param email_notification: The email_notification of this Signer.  # noqa: E501
        :type: RecipientEmailNotification
        """

        self._email_notification = email_notification

    @property
    def email_recipient_post_signing_url(self):
        """Gets the email_recipient_post_signing_url of this Signer.  # noqa: E501

          # noqa: E501

        :return: The email_recipient_post_signing_url of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._email_recipient_post_signing_url

    @email_recipient_post_signing_url.setter
    def email_recipient_post_signing_url(self, email_recipient_post_signing_url):
        """Sets the email_recipient_post_signing_url of this Signer.

          # noqa: E501

        :param email_recipient_post_signing_url: The email_recipient_post_signing_url of this Signer.  # noqa: E501
        :type: str
        """

        self._email_recipient_post_signing_url = email_recipient_post_signing_url

    @property
    def embedded_recipient_start_url(self):
        """Gets the embedded_recipient_start_url of this Signer.  # noqa: E501

        Specifies a sender provided valid URL string for redirecting an embedded recipient. When using this option, the embedded recipient still receives an email from DocuSign, just as a remote recipient would. When the document link in the email is clicked the recipient is redirected, through DocuSign, to the supplied URL to complete their actions. When routing to the URL, the sender's system (the server responding to the URL) must request a recipient token to launch a signing session.   If set to `SIGN_AT_DOCUSIGN`, the recipient is directed to an embedded signing or viewing process directly at DocuSign. The signing or viewing action is initiated by the DocuSign system and the transaction activity and Certificate of Completion records will reflect this. In all other ways the process is identical to an embedded signing or viewing operation that is launched by any partner.  It is important to remember that in a typical embedded workflow the authentication of an embedded recipient is the responsibility of the sending application, DocuSign expects that senders will follow their own process for establishing the recipient's identity. In this workflow the recipient goes through the sending application before the embedded signing or viewing process in initiated. However, when the sending application sets `EmbeddedRecipientStartURL=SIGN_AT_DOCUSIGN`, the recipient goes directly to the embedded signing or viewing process bypassing the sending application and any authentication steps the sending application would use. In this case, DocuSign recommends that you use one of the normal DocuSign authentication features (Access Code, Phone Authentication, SMS Authentication, etc.) to verify the identity of the recipient.  If the `clientUserId` property is NOT set, and the `embeddedRecipientStartURL` is set, DocuSign will ignore the redirect URL and launch the standard signing process for the email recipient. Information can be appended to the embedded recipient start URL using merge fields. The available merge fields items are: envelopeId, recipientId, recipientName, recipientEmail, and customFields. The `customFields` property must be set fort the recipient or envelope. The merge fields are enclosed in double brackets.   *Example*:   `http://senderHost/[[mergeField1]]/ beginSigningSession? [[mergeField2]]&[[mergeField3]]`   # noqa: E501

        :return: The embedded_recipient_start_url of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._embedded_recipient_start_url

    @embedded_recipient_start_url.setter
    def embedded_recipient_start_url(self, embedded_recipient_start_url):
        """Sets the embedded_recipient_start_url of this Signer.

        Specifies a sender provided valid URL string for redirecting an embedded recipient. When using this option, the embedded recipient still receives an email from DocuSign, just as a remote recipient would. When the document link in the email is clicked the recipient is redirected, through DocuSign, to the supplied URL to complete their actions. When routing to the URL, the sender's system (the server responding to the URL) must request a recipient token to launch a signing session.   If set to `SIGN_AT_DOCUSIGN`, the recipient is directed to an embedded signing or viewing process directly at DocuSign. The signing or viewing action is initiated by the DocuSign system and the transaction activity and Certificate of Completion records will reflect this. In all other ways the process is identical to an embedded signing or viewing operation that is launched by any partner.  It is important to remember that in a typical embedded workflow the authentication of an embedded recipient is the responsibility of the sending application, DocuSign expects that senders will follow their own process for establishing the recipient's identity. In this workflow the recipient goes through the sending application before the embedded signing or viewing process in initiated. However, when the sending application sets `EmbeddedRecipientStartURL=SIGN_AT_DOCUSIGN`, the recipient goes directly to the embedded signing or viewing process bypassing the sending application and any authentication steps the sending application would use. In this case, DocuSign recommends that you use one of the normal DocuSign authentication features (Access Code, Phone Authentication, SMS Authentication, etc.) to verify the identity of the recipient.  If the `clientUserId` property is NOT set, and the `embeddedRecipientStartURL` is set, DocuSign will ignore the redirect URL and launch the standard signing process for the email recipient. Information can be appended to the embedded recipient start URL using merge fields. The available merge fields items are: envelopeId, recipientId, recipientName, recipientEmail, and customFields. The `customFields` property must be set fort the recipient or envelope. The merge fields are enclosed in double brackets.   *Example*:   `http://senderHost/[[mergeField1]]/ beginSigningSession? [[mergeField2]]&[[mergeField3]]`   # noqa: E501

        :param embedded_recipient_start_url: The embedded_recipient_start_url of this Signer.  # noqa: E501
        :type: str
        """

        self._embedded_recipient_start_url = embedded_recipient_start_url

    @property
    def error_details(self):
        """Gets the error_details of this Signer.  # noqa: E501

        Array or errors.  # noqa: E501

        :return: The error_details of this Signer.  # noqa: E501
        :rtype: ErrorDetails
        """
        return self._error_details

    @error_details.setter
    def error_details(self, error_details):
        """Sets the error_details of this Signer.

        Array or errors.  # noqa: E501

        :param error_details: The error_details of this Signer.  # noqa: E501
        :type: ErrorDetails
        """

        self._error_details = error_details

    @property
    def excluded_documents(self):
        """Gets the excluded_documents of this Signer.  # noqa: E501

        Specifies the documents that are not visible to this recipient. Document Visibility must be enabled for the account and the `enforceSignerVisibility` property must be set to **true** for the envelope to use this.  When enforce signer visibility is enabled, documents with tabs can only be viewed by signers that have a tab on that document. Recipients that have an administrative role (Agent, Editor, or Intermediaries) or informational role (Certified Deliveries or Carbon Copies) can always see all the documents in an envelope, unless they are specifically excluded using this setting when an envelope is sent. Documents that do not have tabs are always visible to all recipients, unless they are specifically excluded using this setting when an envelope is sent.  # noqa: E501

        :return: The excluded_documents of this Signer.  # noqa: E501
        :rtype: list[str]
        """
        return self._excluded_documents

    @excluded_documents.setter
    def excluded_documents(self, excluded_documents):
        """Sets the excluded_documents of this Signer.

        Specifies the documents that are not visible to this recipient. Document Visibility must be enabled for the account and the `enforceSignerVisibility` property must be set to **true** for the envelope to use this.  When enforce signer visibility is enabled, documents with tabs can only be viewed by signers that have a tab on that document. Recipients that have an administrative role (Agent, Editor, or Intermediaries) or informational role (Certified Deliveries or Carbon Copies) can always see all the documents in an envelope, unless they are specifically excluded using this setting when an envelope is sent. Documents that do not have tabs are always visible to all recipients, unless they are specifically excluded using this setting when an envelope is sent.  # noqa: E501

        :param excluded_documents: The excluded_documents of this Signer.  # noqa: E501
        :type: list[str]
        """

        self._excluded_documents = excluded_documents

    @property
    def fax_number(self):
        """Gets the fax_number of this Signer.  # noqa: E501

        Reserved:  # noqa: E501

        :return: The fax_number of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._fax_number

    @fax_number.setter
    def fax_number(self, fax_number):
        """Sets the fax_number of this Signer.

        Reserved:  # noqa: E501

        :param fax_number: The fax_number of this Signer.  # noqa: E501
        :type: str
        """

        self._fax_number = fax_number

    @property
    def fax_number_metadata(self):
        """Gets the fax_number_metadata of this Signer.  # noqa: E501

        Reserved for DocuSign.  # noqa: E501

        :return: The fax_number_metadata of this Signer.  # noqa: E501
        :rtype: PropertyMetadata
        """
        return self._fax_number_metadata

    @fax_number_metadata.setter
    def fax_number_metadata(self, fax_number_metadata):
        """Sets the fax_number_metadata of this Signer.

        Reserved for DocuSign.  # noqa: E501

        :param fax_number_metadata: The fax_number_metadata of this Signer.  # noqa: E501
        :type: PropertyMetadata
        """

        self._fax_number_metadata = fax_number_metadata

    @property
    def first_name(self):
        """Gets the first_name of this Signer.  # noqa: E501

        The user's first name.  Maximum Length: 50 characters.  # noqa: E501

        :return: The first_name of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name):
        """Sets the first_name of this Signer.

        The user's first name.  Maximum Length: 50 characters.  # noqa: E501

        :param first_name: The first_name of this Signer.  # noqa: E501
        :type: str
        """

        self._first_name = first_name

    @property
    def first_name_metadata(self):
        """Gets the first_name_metadata of this Signer.  # noqa: E501

        Metadata that indicates whether the `firstName` property is editable. This property is read-only.  # noqa: E501

        :return: The first_name_metadata of this Signer.  # noqa: E501
        :rtype: PropertyMetadata
        """
        return self._first_name_metadata

    @first_name_metadata.setter
    def first_name_metadata(self, first_name_metadata):
        """Sets the first_name_metadata of this Signer.

        Metadata that indicates whether the `firstName` property is editable. This property is read-only.  # noqa: E501

        :param first_name_metadata: The first_name_metadata of this Signer.  # noqa: E501
        :type: PropertyMetadata
        """

        self._first_name_metadata = first_name_metadata

    @property
    def full_name(self):
        """Gets the full_name of this Signer.  # noqa: E501

          # noqa: E501

        :return: The full_name of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._full_name

    @full_name.setter
    def full_name(self, full_name):
        """Sets the full_name of this Signer.

          # noqa: E501

        :param full_name: The full_name of this Signer.  # noqa: E501
        :type: str
        """

        self._full_name = full_name

    @property
    def full_name_metadata(self):
        """Gets the full_name_metadata of this Signer.  # noqa: E501

        Reserved for DocuSign.  # noqa: E501

        :return: The full_name_metadata of this Signer.  # noqa: E501
        :rtype: PropertyMetadata
        """
        return self._full_name_metadata

    @full_name_metadata.setter
    def full_name_metadata(self, full_name_metadata):
        """Sets the full_name_metadata of this Signer.

        Reserved for DocuSign.  # noqa: E501

        :param full_name_metadata: The full_name_metadata of this Signer.  # noqa: E501
        :type: PropertyMetadata
        """

        self._full_name_metadata = full_name_metadata

    @property
    def id_check_configuration_name(self):
        """Gets the id_check_configuration_name of this Signer.  # noqa: E501

        Specifies authentication check by name. The names used here must be the same as the authentication type names used by the account (these name can also be found in the web console sending interface in the Identify list for a recipient,) This overrides any default authentication setting.  *Example*: Your account has ID Check and SMS Authentication available and in the web console Identify list these appear as 'ID Check $' and 'SMS Auth $'. To use ID check in an envelope, the idCheckConfigurationName should be 'ID Check '. If you wanted to use SMS, it would be 'SMS Auth $' and you would need to add you would need to add phone number information to the `smsAuthentication` node.  # noqa: E501

        :return: The id_check_configuration_name of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._id_check_configuration_name

    @id_check_configuration_name.setter
    def id_check_configuration_name(self, id_check_configuration_name):
        """Sets the id_check_configuration_name of this Signer.

        Specifies authentication check by name. The names used here must be the same as the authentication type names used by the account (these name can also be found in the web console sending interface in the Identify list for a recipient,) This overrides any default authentication setting.  *Example*: Your account has ID Check and SMS Authentication available and in the web console Identify list these appear as 'ID Check $' and 'SMS Auth $'. To use ID check in an envelope, the idCheckConfigurationName should be 'ID Check '. If you wanted to use SMS, it would be 'SMS Auth $' and you would need to add you would need to add phone number information to the `smsAuthentication` node.  # noqa: E501

        :param id_check_configuration_name: The id_check_configuration_name of this Signer.  # noqa: E501
        :type: str
        """

        self._id_check_configuration_name = id_check_configuration_name

    @property
    def id_check_configuration_name_metadata(self):
        """Gets the id_check_configuration_name_metadata of this Signer.  # noqa: E501

        Metadata that indicates whether the `idCheckConfigurationName` property is editable. This property is read-only.  # noqa: E501

        :return: The id_check_configuration_name_metadata of this Signer.  # noqa: E501
        :rtype: PropertyMetadata
        """
        return self._id_check_configuration_name_metadata

    @id_check_configuration_name_metadata.setter
    def id_check_configuration_name_metadata(self, id_check_configuration_name_metadata):
        """Sets the id_check_configuration_name_metadata of this Signer.

        Metadata that indicates whether the `idCheckConfigurationName` property is editable. This property is read-only.  # noqa: E501

        :param id_check_configuration_name_metadata: The id_check_configuration_name_metadata of this Signer.  # noqa: E501
        :type: PropertyMetadata
        """

        self._id_check_configuration_name_metadata = id_check_configuration_name_metadata

    @property
    def id_check_information_input(self):
        """Gets the id_check_information_input of this Signer.  # noqa: E501

        An object that contains input information related to a recipient ID check.  # noqa: E501

        :return: The id_check_information_input of this Signer.  # noqa: E501
        :rtype: IdCheckInformationInput
        """
        return self._id_check_information_input

    @id_check_information_input.setter
    def id_check_information_input(self, id_check_information_input):
        """Sets the id_check_information_input of this Signer.

        An object that contains input information related to a recipient ID check.  # noqa: E501

        :param id_check_information_input: The id_check_information_input of this Signer.  # noqa: E501
        :type: IdCheckInformationInput
        """

        self._id_check_information_input = id_check_information_input

    @property
    def identity_verification(self):
        """Gets the identity_verification of this Signer.  # noqa: E501

        Specifies the ID Verification workflow applied on an envelope by workflow ID. <br/>See the [list](/docs/esign-rest-api/reference/accounts/identityverifications/list/) method in the [IdentityVerifications](/docs/esign-rest-api/reference/accounts/identityverifications/) resource for more information on how to retrieve workflow IDs available for an account. <br/>This can be used in addition to other [recipient authentication](https://support.docusign.com/en/guides/ndse-user-guide-recipient-authentication) methods. <br/>Note that ID Verification and ID Check are two distinct methods. ID Verification checks recipients' identity by verifying their ID while ID Check relies on data available on public records (such as current and former address).  # noqa: E501

        :return: The identity_verification of this Signer.  # noqa: E501
        :rtype: RecipientIdentityVerification
        """
        return self._identity_verification

    @identity_verification.setter
    def identity_verification(self, identity_verification):
        """Sets the identity_verification of this Signer.

        Specifies the ID Verification workflow applied on an envelope by workflow ID. <br/>See the [list](/docs/esign-rest-api/reference/accounts/identityverifications/list/) method in the [IdentityVerifications](/docs/esign-rest-api/reference/accounts/identityverifications/) resource for more information on how to retrieve workflow IDs available for an account. <br/>This can be used in addition to other [recipient authentication](https://support.docusign.com/en/guides/ndse-user-guide-recipient-authentication) methods. <br/>Note that ID Verification and ID Check are two distinct methods. ID Verification checks recipients' identity by verifying their ID while ID Check relies on data available on public records (such as current and former address).  # noqa: E501

        :param identity_verification: The identity_verification of this Signer.  # noqa: E501
        :type: RecipientIdentityVerification
        """

        self._identity_verification = identity_verification

    @property
    def inherit_email_notification_configuration(self):
        """Gets the inherit_email_notification_configuration of this Signer.  # noqa: E501

        When set to **true** and the envelope recipient creates a DocuSign account after signing, the Manage Account Email Notification settings are used as the default settings for the recipient's account.   # noqa: E501

        :return: The inherit_email_notification_configuration of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._inherit_email_notification_configuration

    @inherit_email_notification_configuration.setter
    def inherit_email_notification_configuration(self, inherit_email_notification_configuration):
        """Sets the inherit_email_notification_configuration of this Signer.

        When set to **true** and the envelope recipient creates a DocuSign account after signing, the Manage Account Email Notification settings are used as the default settings for the recipient's account.   # noqa: E501

        :param inherit_email_notification_configuration: The inherit_email_notification_configuration of this Signer.  # noqa: E501
        :type: str
        """

        self._inherit_email_notification_configuration = inherit_email_notification_configuration

    @property
    def is_bulk_recipient(self):
        """Gets the is_bulk_recipient of this Signer.  # noqa: E501

        When set to **true**, this signer is a bulk recipient and the recipient information is contained in a bulk recipient file.   Note that when this is true the email and name for the recipient becomes bulk@recipient.com and \"Bulk Recipient\". These fields can not be changed for the bulk recipient.    # noqa: E501

        :return: The is_bulk_recipient of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._is_bulk_recipient

    @is_bulk_recipient.setter
    def is_bulk_recipient(self, is_bulk_recipient):
        """Sets the is_bulk_recipient of this Signer.

        When set to **true**, this signer is a bulk recipient and the recipient information is contained in a bulk recipient file.   Note that when this is true the email and name for the recipient becomes bulk@recipient.com and \"Bulk Recipient\". These fields can not be changed for the bulk recipient.    # noqa: E501

        :param is_bulk_recipient: The is_bulk_recipient of this Signer.  # noqa: E501
        :type: str
        """

        self._is_bulk_recipient = is_bulk_recipient

    @property
    def is_bulk_recipient_metadata(self):
        """Gets the is_bulk_recipient_metadata of this Signer.  # noqa: E501

        Reserved for DocuSign.  # noqa: E501

        :return: The is_bulk_recipient_metadata of this Signer.  # noqa: E501
        :rtype: PropertyMetadata
        """
        return self._is_bulk_recipient_metadata

    @is_bulk_recipient_metadata.setter
    def is_bulk_recipient_metadata(self, is_bulk_recipient_metadata):
        """Sets the is_bulk_recipient_metadata of this Signer.

        Reserved for DocuSign.  # noqa: E501

        :param is_bulk_recipient_metadata: The is_bulk_recipient_metadata of this Signer.  # noqa: E501
        :type: PropertyMetadata
        """

        self._is_bulk_recipient_metadata = is_bulk_recipient_metadata

    @property
    def last_name(self):
        """Gets the last_name of this Signer.  # noqa: E501

          # noqa: E501

        :return: The last_name of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name):
        """Sets the last_name of this Signer.

          # noqa: E501

        :param last_name: The last_name of this Signer.  # noqa: E501
        :type: str
        """

        self._last_name = last_name

    @property
    def last_name_metadata(self):
        """Gets the last_name_metadata of this Signer.  # noqa: E501

        Metadata that indicates whether the `lastName` property is editable. This property is read-only.  # noqa: E501

        :return: The last_name_metadata of this Signer.  # noqa: E501
        :rtype: PropertyMetadata
        """
        return self._last_name_metadata

    @last_name_metadata.setter
    def last_name_metadata(self, last_name_metadata):
        """Sets the last_name_metadata of this Signer.

        Metadata that indicates whether the `lastName` property is editable. This property is read-only.  # noqa: E501

        :param last_name_metadata: The last_name_metadata of this Signer.  # noqa: E501
        :type: PropertyMetadata
        """

        self._last_name_metadata = last_name_metadata

    @property
    def locked_recipient_phone_auth_editable(self):
        """Gets the locked_recipient_phone_auth_editable of this Signer.  # noqa: E501

          # noqa: E501

        :return: The locked_recipient_phone_auth_editable of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._locked_recipient_phone_auth_editable

    @locked_recipient_phone_auth_editable.setter
    def locked_recipient_phone_auth_editable(self, locked_recipient_phone_auth_editable):
        """Sets the locked_recipient_phone_auth_editable of this Signer.

          # noqa: E501

        :param locked_recipient_phone_auth_editable: The locked_recipient_phone_auth_editable of this Signer.  # noqa: E501
        :type: str
        """

        self._locked_recipient_phone_auth_editable = locked_recipient_phone_auth_editable

    @property
    def locked_recipient_sms_editable(self):
        """Gets the locked_recipient_sms_editable of this Signer.  # noqa: E501

          # noqa: E501

        :return: The locked_recipient_sms_editable of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._locked_recipient_sms_editable

    @locked_recipient_sms_editable.setter
    def locked_recipient_sms_editable(self, locked_recipient_sms_editable):
        """Sets the locked_recipient_sms_editable of this Signer.

          # noqa: E501

        :param locked_recipient_sms_editable: The locked_recipient_sms_editable of this Signer.  # noqa: E501
        :type: str
        """

        self._locked_recipient_sms_editable = locked_recipient_sms_editable

    @property
    def name(self):
        """Gets the name of this Signer.  # noqa: E501

          # noqa: E501

        :return: The name of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Signer.

          # noqa: E501

        :param name: The name of this Signer.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def name_metadata(self):
        """Gets the name_metadata of this Signer.  # noqa: E501

        Metadata that indicates whether the `name` property is editable. This property is read-only.  # noqa: E501

        :return: The name_metadata of this Signer.  # noqa: E501
        :rtype: PropertyMetadata
        """
        return self._name_metadata

    @name_metadata.setter
    def name_metadata(self, name_metadata):
        """Sets the name_metadata of this Signer.

        Metadata that indicates whether the `name` property is editable. This property is read-only.  # noqa: E501

        :param name_metadata: The name_metadata of this Signer.  # noqa: E501
        :type: PropertyMetadata
        """

        self._name_metadata = name_metadata

    @property
    def notary_id(self):
        """Gets the notary_id of this Signer.  # noqa: E501

          # noqa: E501

        :return: The notary_id of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._notary_id

    @notary_id.setter
    def notary_id(self, notary_id):
        """Sets the notary_id of this Signer.

          # noqa: E501

        :param notary_id: The notary_id of this Signer.  # noqa: E501
        :type: str
        """

        self._notary_id = notary_id

    @property
    def notary_signer_email_sent(self):
        """Gets the notary_signer_email_sent of this Signer.  # noqa: E501

          # noqa: E501

        :return: The notary_signer_email_sent of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._notary_signer_email_sent

    @notary_signer_email_sent.setter
    def notary_signer_email_sent(self, notary_signer_email_sent):
        """Sets the notary_signer_email_sent of this Signer.

          # noqa: E501

        :param notary_signer_email_sent: The notary_signer_email_sent of this Signer.  # noqa: E501
        :type: str
        """

        self._notary_signer_email_sent = notary_signer_email_sent

    @property
    def note(self):
        """Gets the note of this Signer.  # noqa: E501

        Specifies a note that is unique to this recipient. This note is sent to the recipient via the signing email. The note displays in the signing UI near the upper left corner of the document on the signing screen.  Maximum Length: 1000 characters.  # noqa: E501

        :return: The note of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._note

    @note.setter
    def note(self, note):
        """Sets the note of this Signer.

        Specifies a note that is unique to this recipient. This note is sent to the recipient via the signing email. The note displays in the signing UI near the upper left corner of the document on the signing screen.  Maximum Length: 1000 characters.  # noqa: E501

        :param note: The note of this Signer.  # noqa: E501
        :type: str
        """

        self._note = note

    @property
    def note_metadata(self):
        """Gets the note_metadata of this Signer.  # noqa: E501

        Metadata that indicates whether the `note` property is editable. This property is read-only.  # noqa: E501

        :return: The note_metadata of this Signer.  # noqa: E501
        :rtype: PropertyMetadata
        """
        return self._note_metadata

    @note_metadata.setter
    def note_metadata(self, note_metadata):
        """Sets the note_metadata of this Signer.

        Metadata that indicates whether the `note` property is editable. This property is read-only.  # noqa: E501

        :param note_metadata: The note_metadata of this Signer.  # noqa: E501
        :type: PropertyMetadata
        """

        self._note_metadata = note_metadata

    @property
    def offline_attributes(self):
        """Gets the offline_attributes of this Signer.  # noqa: E501

        Reserved for DocuSign.  # noqa: E501

        :return: The offline_attributes of this Signer.  # noqa: E501
        :rtype: OfflineAttributes
        """
        return self._offline_attributes

    @offline_attributes.setter
    def offline_attributes(self, offline_attributes):
        """Sets the offline_attributes of this Signer.

        Reserved for DocuSign.  # noqa: E501

        :param offline_attributes: The offline_attributes of this Signer.  # noqa: E501
        :type: OfflineAttributes
        """

        self._offline_attributes = offline_attributes

    @property
    def phone_authentication(self):
        """Gets the phone_authentication of this Signer.  # noqa: E501

        When `idCheckConfigurationName` is set to `Phone Auth $`, you use this complex type to provide the recipient authentication method details. It contains the following elements:  * `recipMayProvideNumber`: Boolean. When **true,** the recipient can use whatever phone number they choose. * `senderProvidedNumbers`: ArrayOfStrings.  A list of phone numbers the recipient can use. * `recordVoicePrint`: Reserved for DocuSign. * `validateRecipProvidedNumber`: Reserved for DocuSign.    # noqa: E501

        :return: The phone_authentication of this Signer.  # noqa: E501
        :rtype: RecipientPhoneAuthentication
        """
        return self._phone_authentication

    @phone_authentication.setter
    def phone_authentication(self, phone_authentication):
        """Sets the phone_authentication of this Signer.

        When `idCheckConfigurationName` is set to `Phone Auth $`, you use this complex type to provide the recipient authentication method details. It contains the following elements:  * `recipMayProvideNumber`: Boolean. When **true,** the recipient can use whatever phone number they choose. * `senderProvidedNumbers`: ArrayOfStrings.  A list of phone numbers the recipient can use. * `recordVoicePrint`: Reserved for DocuSign. * `validateRecipProvidedNumber`: Reserved for DocuSign.    # noqa: E501

        :param phone_authentication: The phone_authentication of this Signer.  # noqa: E501
        :type: RecipientPhoneAuthentication
        """

        self._phone_authentication = phone_authentication

    @property
    def phone_number(self):
        """Gets the phone_number of this Signer.  # noqa: E501

        Describes the recipient phone number.  # noqa: E501

        :return: The phone_number of this Signer.  # noqa: E501
        :rtype: RecipientPhoneNumber
        """
        return self._phone_number

    @phone_number.setter
    def phone_number(self, phone_number):
        """Sets the phone_number of this Signer.

        Describes the recipient phone number.  # noqa: E501

        :param phone_number: The phone_number of this Signer.  # noqa: E501
        :type: RecipientPhoneNumber
        """

        self._phone_number = phone_number

    @property
    def proof_file(self):
        """Gets the proof_file of this Signer.  # noqa: E501

        The proof file of the recipient.  # noqa: E501

        :return: The proof_file of this Signer.  # noqa: E501
        :rtype: RecipientProofFile
        """
        return self._proof_file

    @proof_file.setter
    def proof_file(self, proof_file):
        """Sets the proof_file of this Signer.

        The proof file of the recipient.  # noqa: E501

        :param proof_file: The proof_file of this Signer.  # noqa: E501
        :type: RecipientProofFile
        """

        self._proof_file = proof_file

    @property
    def recipient_attachments(self):
        """Gets the recipient_attachments of this Signer.  # noqa: E501

        Reserved:  # noqa: E501

        :return: The recipient_attachments of this Signer.  # noqa: E501
        :rtype: list[RecipientAttachment]
        """
        return self._recipient_attachments

    @recipient_attachments.setter
    def recipient_attachments(self, recipient_attachments):
        """Sets the recipient_attachments of this Signer.

        Reserved:  # noqa: E501

        :param recipient_attachments: The recipient_attachments of this Signer.  # noqa: E501
        :type: list[RecipientAttachment]
        """

        self._recipient_attachments = recipient_attachments

    @property
    def recipient_authentication_status(self):
        """Gets the recipient_authentication_status of this Signer.  # noqa: E501

        Information about the recipient's authentication status. This property is read-only.  # noqa: E501

        :return: The recipient_authentication_status of this Signer.  # noqa: E501
        :rtype: AuthenticationStatus
        """
        return self._recipient_authentication_status

    @recipient_authentication_status.setter
    def recipient_authentication_status(self, recipient_authentication_status):
        """Sets the recipient_authentication_status of this Signer.

        Information about the recipient's authentication status. This property is read-only.  # noqa: E501

        :param recipient_authentication_status: The recipient_authentication_status of this Signer.  # noqa: E501
        :type: AuthenticationStatus
        """

        self._recipient_authentication_status = recipient_authentication_status

    @property
    def recipient_feature_metadata(self):
        """Gets the recipient_feature_metadata of this Signer.  # noqa: E501

          # noqa: E501

        :return: The recipient_feature_metadata of this Signer.  # noqa: E501
        :rtype: list[FeatureAvailableMetadata]
        """
        return self._recipient_feature_metadata

    @recipient_feature_metadata.setter
    def recipient_feature_metadata(self, recipient_feature_metadata):
        """Sets the recipient_feature_metadata of this Signer.

          # noqa: E501

        :param recipient_feature_metadata: The recipient_feature_metadata of this Signer.  # noqa: E501
        :type: list[FeatureAvailableMetadata]
        """

        self._recipient_feature_metadata = recipient_feature_metadata

    @property
    def recipient_id(self):
        """Gets the recipient_id of this Signer.  # noqa: E501

        Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.  # noqa: E501

        :return: The recipient_id of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._recipient_id

    @recipient_id.setter
    def recipient_id(self, recipient_id):
        """Sets the recipient_id of this Signer.

        Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.  # noqa: E501

        :param recipient_id: The recipient_id of this Signer.  # noqa: E501
        :type: str
        """

        self._recipient_id = recipient_id

    @property
    def recipient_id_guid(self):
        """Gets the recipient_id_guid of this Signer.  # noqa: E501

          # noqa: E501

        :return: The recipient_id_guid of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._recipient_id_guid

    @recipient_id_guid.setter
    def recipient_id_guid(self, recipient_id_guid):
        """Sets the recipient_id_guid of this Signer.

          # noqa: E501

        :param recipient_id_guid: The recipient_id_guid of this Signer.  # noqa: E501
        :type: str
        """

        self._recipient_id_guid = recipient_id_guid

    @property
    def recipient_signature_providers(self):
        """Gets the recipient_signature_providers of this Signer.  # noqa: E501

          # noqa: E501

        :return: The recipient_signature_providers of this Signer.  # noqa: E501
        :rtype: list[RecipientSignatureProvider]
        """
        return self._recipient_signature_providers

    @recipient_signature_providers.setter
    def recipient_signature_providers(self, recipient_signature_providers):
        """Sets the recipient_signature_providers of this Signer.

          # noqa: E501

        :param recipient_signature_providers: The recipient_signature_providers of this Signer.  # noqa: E501
        :type: list[RecipientSignatureProvider]
        """

        self._recipient_signature_providers = recipient_signature_providers

    @property
    def recipient_supplies_tabs(self):
        """Gets the recipient_supplies_tabs of this Signer.  # noqa: E501

          # noqa: E501

        :return: The recipient_supplies_tabs of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._recipient_supplies_tabs

    @recipient_supplies_tabs.setter
    def recipient_supplies_tabs(self, recipient_supplies_tabs):
        """Sets the recipient_supplies_tabs of this Signer.

          # noqa: E501

        :param recipient_supplies_tabs: The recipient_supplies_tabs of this Signer.  # noqa: E501
        :type: str
        """

        self._recipient_supplies_tabs = recipient_supplies_tabs

    @property
    def recipient_type(self):
        """Gets the recipient_type of this Signer.  # noqa: E501

          # noqa: E501

        :return: The recipient_type of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._recipient_type

    @recipient_type.setter
    def recipient_type(self, recipient_type):
        """Sets the recipient_type of this Signer.

          # noqa: E501

        :param recipient_type: The recipient_type of this Signer.  # noqa: E501
        :type: str
        """

        self._recipient_type = recipient_type

    @property
    def recipient_type_metadata(self):
        """Gets the recipient_type_metadata of this Signer.  # noqa: E501

        Metadata that indicates whether the `recipientType` property is editable. This property is read-only.  # noqa: E501

        :return: The recipient_type_metadata of this Signer.  # noqa: E501
        :rtype: PropertyMetadata
        """
        return self._recipient_type_metadata

    @recipient_type_metadata.setter
    def recipient_type_metadata(self, recipient_type_metadata):
        """Sets the recipient_type_metadata of this Signer.

        Metadata that indicates whether the `recipientType` property is editable. This property is read-only.  # noqa: E501

        :param recipient_type_metadata: The recipient_type_metadata of this Signer.  # noqa: E501
        :type: PropertyMetadata
        """

        self._recipient_type_metadata = recipient_type_metadata

    @property
    def require_id_lookup(self):
        """Gets the require_id_lookup of this Signer.  # noqa: E501

        When set to **true**, the recipient is required to use the specified ID check method (including Phone and SMS authentication) to validate their identity.   # noqa: E501

        :return: The require_id_lookup of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._require_id_lookup

    @require_id_lookup.setter
    def require_id_lookup(self, require_id_lookup):
        """Sets the require_id_lookup of this Signer.

        When set to **true**, the recipient is required to use the specified ID check method (including Phone and SMS authentication) to validate their identity.   # noqa: E501

        :param require_id_lookup: The require_id_lookup of this Signer.  # noqa: E501
        :type: str
        """

        self._require_id_lookup = require_id_lookup

    @property
    def require_id_lookup_metadata(self):
        """Gets the require_id_lookup_metadata of this Signer.  # noqa: E501

        Metadata that indicates whether the `requireIdLookup` property is editable. This property is read-only.  # noqa: E501

        :return: The require_id_lookup_metadata of this Signer.  # noqa: E501
        :rtype: PropertyMetadata
        """
        return self._require_id_lookup_metadata

    @require_id_lookup_metadata.setter
    def require_id_lookup_metadata(self, require_id_lookup_metadata):
        """Sets the require_id_lookup_metadata of this Signer.

        Metadata that indicates whether the `requireIdLookup` property is editable. This property is read-only.  # noqa: E501

        :param require_id_lookup_metadata: The require_id_lookup_metadata of this Signer.  # noqa: E501
        :type: PropertyMetadata
        """

        self._require_id_lookup_metadata = require_id_lookup_metadata

    @property
    def require_signer_certificate(self):
        """Gets the require_signer_certificate of this Signer.  # noqa: E501

        Sets the type of signer certificate required for signing. If left blank, no certificate is required. Only one type of certificate can be set for a signer. The possible values are:  * docusign_express - Requires a DocuSign Express certificate. * safe - Requires a SAFE-BioPharma certificate. * open_trust - Requires an OpenTrust certificate.   **Important**: There are certain rules and restrictions that must be followed when requiring OpenTrust digital signatures. See [ML:OpenTrust Rules and Restrictions] for more information.     # noqa: E501

        :return: The require_signer_certificate of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._require_signer_certificate

    @require_signer_certificate.setter
    def require_signer_certificate(self, require_signer_certificate):
        """Sets the require_signer_certificate of this Signer.

        Sets the type of signer certificate required for signing. If left blank, no certificate is required. Only one type of certificate can be set for a signer. The possible values are:  * docusign_express - Requires a DocuSign Express certificate. * safe - Requires a SAFE-BioPharma certificate. * open_trust - Requires an OpenTrust certificate.   **Important**: There are certain rules and restrictions that must be followed when requiring OpenTrust digital signatures. See [ML:OpenTrust Rules and Restrictions] for more information.     # noqa: E501

        :param require_signer_certificate: The require_signer_certificate of this Signer.  # noqa: E501
        :type: str
        """

        self._require_signer_certificate = require_signer_certificate

    @property
    def require_sign_on_paper(self):
        """Gets the require_sign_on_paper of this Signer.  # noqa: E501

        When set to **true**, the signer must print, sign, and upload or fax the signed documents to DocuSign.  # noqa: E501

        :return: The require_sign_on_paper of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._require_sign_on_paper

    @require_sign_on_paper.setter
    def require_sign_on_paper(self, require_sign_on_paper):
        """Sets the require_sign_on_paper of this Signer.

        When set to **true**, the signer must print, sign, and upload or fax the signed documents to DocuSign.  # noqa: E501

        :param require_sign_on_paper: The require_sign_on_paper of this Signer.  # noqa: E501
        :type: str
        """

        self._require_sign_on_paper = require_sign_on_paper

    @property
    def require_upload_signature(self):
        """Gets the require_upload_signature of this Signer.  # noqa: E501

          # noqa: E501

        :return: The require_upload_signature of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._require_upload_signature

    @require_upload_signature.setter
    def require_upload_signature(self, require_upload_signature):
        """Sets the require_upload_signature of this Signer.

          # noqa: E501

        :param require_upload_signature: The require_upload_signature of this Signer.  # noqa: E501
        :type: str
        """

        self._require_upload_signature = require_upload_signature

    @property
    def role_name(self):
        """Gets the role_name of this Signer.  # noqa: E501

        Optional element. Specifies the role name associated with the recipient.<br/><br/>This is required when working with template recipients.  # noqa: E501

        :return: The role_name of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._role_name

    @role_name.setter
    def role_name(self, role_name):
        """Sets the role_name of this Signer.

        Optional element. Specifies the role name associated with the recipient.<br/><br/>This is required when working with template recipients.  # noqa: E501

        :param role_name: The role_name of this Signer.  # noqa: E501
        :type: str
        """

        self._role_name = role_name

    @property
    def routing_order(self):
        """Gets the routing_order of this Signer.  # noqa: E501

        Specifies the routing order of the recipient in the envelope.   # noqa: E501

        :return: The routing_order of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._routing_order

    @routing_order.setter
    def routing_order(self, routing_order):
        """Sets the routing_order of this Signer.

        Specifies the routing order of the recipient in the envelope.   # noqa: E501

        :param routing_order: The routing_order of this Signer.  # noqa: E501
        :type: str
        """

        self._routing_order = routing_order

    @property
    def routing_order_metadata(self):
        """Gets the routing_order_metadata of this Signer.  # noqa: E501

        Metadata that indicates whether the `routingOrder` property is editable. This property is read-only.  # noqa: E501

        :return: The routing_order_metadata of this Signer.  # noqa: E501
        :rtype: PropertyMetadata
        """
        return self._routing_order_metadata

    @routing_order_metadata.setter
    def routing_order_metadata(self, routing_order_metadata):
        """Sets the routing_order_metadata of this Signer.

        Metadata that indicates whether the `routingOrder` property is editable. This property is read-only.  # noqa: E501

        :param routing_order_metadata: The routing_order_metadata of this Signer.  # noqa: E501
        :type: PropertyMetadata
        """

        self._routing_order_metadata = routing_order_metadata

    @property
    def sent_date_time(self):
        """Gets the sent_date_time of this Signer.  # noqa: E501

        The date and time the envelope was sent.  # noqa: E501

        :return: The sent_date_time of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._sent_date_time

    @sent_date_time.setter
    def sent_date_time(self, sent_date_time):
        """Sets the sent_date_time of this Signer.

        The date and time the envelope was sent.  # noqa: E501

        :param sent_date_time: The sent_date_time of this Signer.  # noqa: E501
        :type: str
        """

        self._sent_date_time = sent_date_time

    @property
    def signature_info(self):
        """Gets the signature_info of this Signer.  # noqa: E501

        Allows the sender to pre-specify the signature name, signature initials and signature font used in the signature stamp for the recipient.  Used only with recipient types In Person Signers and Signers.  # noqa: E501

        :return: The signature_info of this Signer.  # noqa: E501
        :rtype: RecipientSignatureInformation
        """
        return self._signature_info

    @signature_info.setter
    def signature_info(self, signature_info):
        """Sets the signature_info of this Signer.

        Allows the sender to pre-specify the signature name, signature initials and signature font used in the signature stamp for the recipient.  Used only with recipient types In Person Signers and Signers.  # noqa: E501

        :param signature_info: The signature_info of this Signer.  # noqa: E501
        :type: RecipientSignatureInformation
        """

        self._signature_info = signature_info

    @property
    def signed_date_time(self):
        """Gets the signed_date_time of this Signer.  # noqa: E501

        Reserved: For DocuSign use only.   # noqa: E501

        :return: The signed_date_time of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._signed_date_time

    @signed_date_time.setter
    def signed_date_time(self, signed_date_time):
        """Sets the signed_date_time of this Signer.

        Reserved: For DocuSign use only.   # noqa: E501

        :param signed_date_time: The signed_date_time of this Signer.  # noqa: E501
        :type: str
        """

        self._signed_date_time = signed_date_time

    @property
    def sign_in_each_location(self):
        """Gets the sign_in_each_location of this Signer.  # noqa: E501

        When set to **true**, specifies that the signer must sign in all locations.  # noqa: E501

        :return: The sign_in_each_location of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._sign_in_each_location

    @sign_in_each_location.setter
    def sign_in_each_location(self, sign_in_each_location):
        """Sets the sign_in_each_location of this Signer.

        When set to **true**, specifies that the signer must sign in all locations.  # noqa: E501

        :param sign_in_each_location: The sign_in_each_location of this Signer.  # noqa: E501
        :type: str
        """

        self._sign_in_each_location = sign_in_each_location

    @property
    def sign_in_each_location_metadata(self):
        """Gets the sign_in_each_location_metadata of this Signer.  # noqa: E501

        Metadata that indicates whether the `signInEachLocation` property is editable. This property is read-only.  # noqa: E501

        :return: The sign_in_each_location_metadata of this Signer.  # noqa: E501
        :rtype: PropertyMetadata
        """
        return self._sign_in_each_location_metadata

    @sign_in_each_location_metadata.setter
    def sign_in_each_location_metadata(self, sign_in_each_location_metadata):
        """Sets the sign_in_each_location_metadata of this Signer.

        Metadata that indicates whether the `signInEachLocation` property is editable. This property is read-only.  # noqa: E501

        :param sign_in_each_location_metadata: The sign_in_each_location_metadata of this Signer.  # noqa: E501
        :type: PropertyMetadata
        """

        self._sign_in_each_location_metadata = sign_in_each_location_metadata

    @property
    def signing_group_id(self):
        """Gets the signing_group_id of this Signer.  # noqa: E501

        When set to **true** and the feature is enabled in the sender's account, the signing recipient is required to draw signatures and initials at each signature/initial tab ( instead of adopting a signature/initial style or only drawing a signature/initial once).  # noqa: E501

        :return: The signing_group_id of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._signing_group_id

    @signing_group_id.setter
    def signing_group_id(self, signing_group_id):
        """Sets the signing_group_id of this Signer.

        When set to **true** and the feature is enabled in the sender's account, the signing recipient is required to draw signatures and initials at each signature/initial tab ( instead of adopting a signature/initial style or only drawing a signature/initial once).  # noqa: E501

        :param signing_group_id: The signing_group_id of this Signer.  # noqa: E501
        :type: str
        """

        self._signing_group_id = signing_group_id

    @property
    def signing_group_id_metadata(self):
        """Gets the signing_group_id_metadata of this Signer.  # noqa: E501

        Metadata that indicates whether the `signingGroupId` property is editable. This property is read-only.  # noqa: E501

        :return: The signing_group_id_metadata of this Signer.  # noqa: E501
        :rtype: PropertyMetadata
        """
        return self._signing_group_id_metadata

    @signing_group_id_metadata.setter
    def signing_group_id_metadata(self, signing_group_id_metadata):
        """Sets the signing_group_id_metadata of this Signer.

        Metadata that indicates whether the `signingGroupId` property is editable. This property is read-only.  # noqa: E501

        :param signing_group_id_metadata: The signing_group_id_metadata of this Signer.  # noqa: E501
        :type: PropertyMetadata
        """

        self._signing_group_id_metadata = signing_group_id_metadata

    @property
    def signing_group_name(self):
        """Gets the signing_group_name of this Signer.  # noqa: E501

        The display name for the signing group.   Maximum Length: 100 characters.   # noqa: E501

        :return: The signing_group_name of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._signing_group_name

    @signing_group_name.setter
    def signing_group_name(self, signing_group_name):
        """Sets the signing_group_name of this Signer.

        The display name for the signing group.   Maximum Length: 100 characters.   # noqa: E501

        :param signing_group_name: The signing_group_name of this Signer.  # noqa: E501
        :type: str
        """

        self._signing_group_name = signing_group_name

    @property
    def signing_group_users(self):
        """Gets the signing_group_users of this Signer.  # noqa: E501

        A complex type that contains information about users in the signing group.  # noqa: E501

        :return: The signing_group_users of this Signer.  # noqa: E501
        :rtype: list[UserInfo]
        """
        return self._signing_group_users

    @signing_group_users.setter
    def signing_group_users(self, signing_group_users):
        """Sets the signing_group_users of this Signer.

        A complex type that contains information about users in the signing group.  # noqa: E501

        :param signing_group_users: The signing_group_users of this Signer.  # noqa: E501
        :type: list[UserInfo]
        """

        self._signing_group_users = signing_group_users

    @property
    def sms_authentication(self):
        """Gets the sms_authentication of this Signer.  # noqa: E501

        When `idCheckConfigurationName` is set to `SMS Auth $`, you use this complex type to provide the recipient authentication method details. It contains the element `senderProvidedNumbers`, which is an array of phone numbers that the recipient can use for SMS text authentication.     # noqa: E501

        :return: The sms_authentication of this Signer.  # noqa: E501
        :rtype: RecipientSMSAuthentication
        """
        return self._sms_authentication

    @sms_authentication.setter
    def sms_authentication(self, sms_authentication):
        """Sets the sms_authentication of this Signer.

        When `idCheckConfigurationName` is set to `SMS Auth $`, you use this complex type to provide the recipient authentication method details. It contains the element `senderProvidedNumbers`, which is an array of phone numbers that the recipient can use for SMS text authentication.     # noqa: E501

        :param sms_authentication: The sms_authentication of this Signer.  # noqa: E501
        :type: RecipientSMSAuthentication
        """

        self._sms_authentication = sms_authentication

    @property
    def social_authentications(self):
        """Gets the social_authentications of this Signer.  # noqa: E501

         Lists the social ID type that can be used for recipient authentication.  # noqa: E501

        :return: The social_authentications of this Signer.  # noqa: E501
        :rtype: list[SocialAuthentication]
        """
        return self._social_authentications

    @social_authentications.setter
    def social_authentications(self, social_authentications):
        """Sets the social_authentications of this Signer.

         Lists the social ID type that can be used for recipient authentication.  # noqa: E501

        :param social_authentications: The social_authentications of this Signer.  # noqa: E501
        :type: list[SocialAuthentication]
        """

        self._social_authentications = social_authentications

    @property
    def status(self):
        """Gets the status of this Signer.  # noqa: E501

        Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  * created - The envelope is saved as a draft and can be modified and sent later.  # noqa: E501

        :return: The status of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this Signer.

        Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  * created - The envelope is saved as a draft and can be modified and sent later.  # noqa: E501

        :param status: The status of this Signer.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def status_code(self):
        """Gets the status_code of this Signer.  # noqa: E501

          # noqa: E501

        :return: The status_code of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._status_code

    @status_code.setter
    def status_code(self, status_code):
        """Sets the status_code of this Signer.

          # noqa: E501

        :param status_code: The status_code of this Signer.  # noqa: E501
        :type: str
        """

        self._status_code = status_code

    @property
    def suppress_emails(self):
        """Gets the suppress_emails of this Signer.  # noqa: E501

          # noqa: E501

        :return: The suppress_emails of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._suppress_emails

    @suppress_emails.setter
    def suppress_emails(self, suppress_emails):
        """Sets the suppress_emails of this Signer.

          # noqa: E501

        :param suppress_emails: The suppress_emails of this Signer.  # noqa: E501
        :type: str
        """

        self._suppress_emails = suppress_emails

    @property
    def tabs(self):
        """Gets the tabs of this Signer.  # noqa: E501

        The tabs to assign to the recipient. [More information](/docs/esign-rest-api/esign101/concepts/tabs/).  # noqa: E501

        :return: The tabs of this Signer.  # noqa: E501
        :rtype: Tabs
        """
        return self._tabs

    @tabs.setter
    def tabs(self, tabs):
        """Sets the tabs of this Signer.

        The tabs to assign to the recipient. [More information](/docs/esign-rest-api/esign101/concepts/tabs/).  # noqa: E501

        :param tabs: The tabs of this Signer.  # noqa: E501
        :type: Tabs
        """

        self._tabs = tabs

    @property
    def template_locked(self):
        """Gets the template_locked of this Signer.  # noqa: E501

        When set to **true**, the sender cannot change any attributes of the recipient. Used only when working with template recipients.   # noqa: E501

        :return: The template_locked of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._template_locked

    @template_locked.setter
    def template_locked(self, template_locked):
        """Sets the template_locked of this Signer.

        When set to **true**, the sender cannot change any attributes of the recipient. Used only when working with template recipients.   # noqa: E501

        :param template_locked: The template_locked of this Signer.  # noqa: E501
        :type: str
        """

        self._template_locked = template_locked

    @property
    def template_required(self):
        """Gets the template_required of this Signer.  # noqa: E501

        When set to **true**, the sender may not remove the recipient. Used only when working with template recipients.  # noqa: E501

        :return: The template_required of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._template_required

    @template_required.setter
    def template_required(self, template_required):
        """Sets the template_required of this Signer.

        When set to **true**, the sender may not remove the recipient. Used only when working with template recipients.  # noqa: E501

        :param template_required: The template_required of this Signer.  # noqa: E501
        :type: str
        """

        self._template_required = template_required

    @property
    def total_tab_count(self):
        """Gets the total_tab_count of this Signer.  # noqa: E501

          # noqa: E501

        :return: The total_tab_count of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._total_tab_count

    @total_tab_count.setter
    def total_tab_count(self, total_tab_count):
        """Sets the total_tab_count of this Signer.

          # noqa: E501

        :param total_tab_count: The total_tab_count of this Signer.  # noqa: E501
        :type: str
        """

        self._total_tab_count = total_tab_count

    @property
    def user_id(self):
        """Gets the user_id of this Signer.  # noqa: E501

          # noqa: E501

        :return: The user_id of this Signer.  # noqa: E501
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this Signer.

          # noqa: E501

        :param user_id: The user_id of this Signer.  # noqa: E501
        :type: str
        """

        self._user_id = user_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Signer, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Signer):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Signer):
            return True

        return self.to_dict() != other.to_dict()
