# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.  # noqa: E501

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..client.configuration import Configuration
from ..client.api_client import ApiClient


class TemplatesApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def create_custom_fields(self, account_id, template_id, **kwargs):
        """
        Creates custom document fields in an existing template document.
        Creates custom document fields in an existing template document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_custom_fields(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param TemplateCustomFields template_custom_fields:
        :return: CustomFields
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_custom_fields_with_http_info(account_id, template_id, **kwargs)
        else:
            (data) = self.create_custom_fields_with_http_info(account_id, template_id, **kwargs)
            return data

    def create_custom_fields_with_http_info(self, account_id, template_id, **kwargs):
        """
        Creates custom document fields in an existing template document.
        Creates custom document fields in an existing template document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_custom_fields_with_http_info(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param TemplateCustomFields template_custom_fields:
        :return: CustomFields
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'template_id', 'template_custom_fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_custom_fields`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `create_custom_fields`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/custom_fields'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'template_custom_fields' in params:
            body_params = params['template_custom_fields']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CustomFields',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_document_fields(self, account_id, document_id, template_id, **kwargs):
        """
        Creates custom document fields in an existing template document.
        Creates custom document fields in an existing template document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_document_fields(account_id, document_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param DocumentFieldsInformation document_fields_information:
        :return: DocumentFieldsInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_document_fields_with_http_info(account_id, document_id, template_id, **kwargs)
        else:
            (data) = self.create_document_fields_with_http_info(account_id, document_id, template_id, **kwargs)
            return data

    def create_document_fields_with_http_info(self, account_id, document_id, template_id, **kwargs):
        """
        Creates custom document fields in an existing template document.
        Creates custom document fields in an existing template document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_document_fields_with_http_info(account_id, document_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param DocumentFieldsInformation document_fields_information:
        :return: DocumentFieldsInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'template_id', 'document_fields_information']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_document_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_document_fields`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `create_document_fields`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `create_document_fields`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/fields'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'document_fields_information' in params:
            body_params = params['document_fields_information']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DocumentFieldsInformation',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_edit_view(self, account_id, template_id, **kwargs):
        """
        Provides a URL to start an edit view of the Template UI
        This method returns a URL for starting an edit view of a template that uses the DocuSign Template UI.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_edit_view(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param ReturnUrlRequest return_url_request:
        :return: ViewUrl
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_edit_view_with_http_info(account_id, template_id, **kwargs)
        else:
            (data) = self.create_edit_view_with_http_info(account_id, template_id, **kwargs)
            return data

    def create_edit_view_with_http_info(self, account_id, template_id, **kwargs):
        """
        Provides a URL to start an edit view of the Template UI
        This method returns a URL for starting an edit view of a template that uses the DocuSign Template UI.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_edit_view_with_http_info(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param ReturnUrlRequest return_url_request:
        :return: ViewUrl
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'template_id', 'return_url_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_edit_view" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_edit_view`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `create_edit_view`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/views/edit'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'return_url_request' in params:
            body_params = params['return_url_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ViewUrl',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_lock(self, account_id, template_id, **kwargs):
        """
        Lock a template.
        Locks the specified template, and sets the time until the lock expires, to prevent other users or recipients from accessing and changing the template.  ###### Note: Users must have envelope locking capability enabled to use this function (the userSetting property `canLockEnvelopes` must be set to **true** for the user).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_lock(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param LockRequest lock_request:
        :return: LockInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_lock_with_http_info(account_id, template_id, **kwargs)
        else:
            (data) = self.create_lock_with_http_info(account_id, template_id, **kwargs)
            return data

    def create_lock_with_http_info(self, account_id, template_id, **kwargs):
        """
        Lock a template.
        Locks the specified template, and sets the time until the lock expires, to prevent other users or recipients from accessing and changing the template.  ###### Note: Users must have envelope locking capability enabled to use this function (the userSetting property `canLockEnvelopes` must be set to **true** for the user).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_lock_with_http_info(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param LockRequest lock_request:
        :return: LockInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'template_id', 'lock_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_lock" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_lock`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `create_lock`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/lock'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'lock_request' in params:
            body_params = params['lock_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='LockInformation',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_recipients(self, account_id, template_id, **kwargs):
        """
        Adds tabs for a recipient.
        Adds one or more recipients to a template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_recipients(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param str resend_envelope:
        :param TemplateRecipients template_recipients:
        :return: Recipients
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_recipients_with_http_info(account_id, template_id, **kwargs)
        else:
            (data) = self.create_recipients_with_http_info(account_id, template_id, **kwargs)
            return data

    def create_recipients_with_http_info(self, account_id, template_id, **kwargs):
        """
        Adds tabs for a recipient.
        Adds one or more recipients to a template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_recipients_with_http_info(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param str resend_envelope:
        :param TemplateRecipients template_recipients:
        :return: Recipients
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'template_id', 'resend_envelope', 'template_recipients']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_recipients" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_recipients`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `create_recipients`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/recipients'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}
        if 'resend_envelope' in params:
            query_params['resend_envelope'] = params['resend_envelope']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'template_recipients' in params:
            body_params = params['template_recipients']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Recipients',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_tabs(self, account_id, recipient_id, template_id, **kwargs):
        """
        Adds tabs for a recipient.
        Adds one or more tabs for a recipient.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_tabs(account_id, recipient_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param TemplateTabs template_tabs:
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_tabs_with_http_info(account_id, recipient_id, template_id, **kwargs)
        else:
            (data) = self.create_tabs_with_http_info(account_id, recipient_id, template_id, **kwargs)
            return data

    def create_tabs_with_http_info(self, account_id, recipient_id, template_id, **kwargs):
        """
        Adds tabs for a recipient.
        Adds one or more tabs for a recipient.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_tabs_with_http_info(account_id, recipient_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param TemplateTabs template_tabs:
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'recipient_id', 'template_id', 'template_tabs']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_tabs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_tabs`")
        # verify the required parameter 'recipient_id' is set
        if ('recipient_id' not in params) or (params['recipient_id'] is None):
            raise ValueError("Missing the required parameter `recipient_id` when calling `create_tabs`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `create_tabs`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/tabs'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'recipient_id' in params:
            path_params['recipientId'] = params['recipient_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'template_tabs' in params:
            body_params = params['template_tabs']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Tabs',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_template(self, account_id, **kwargs):
        """
        Creates an envelope from a template.
        Creates a template definition using a multipart request.  ###Template Email Subject Merge Fields  Call this endpoint to insert a recipient name and email address merge fields into the email subject line when creating or sending from a template.  The merge fields, based on the recipient's role name, are added to the `emailSubject` property when the template is created or when the template is used to create an envelope. After a template sender adds the name and email information for the recipient and sends the envelope, the recipient information is automatically merged into the appropriate fields in the email subject line.  Both the sender and the recipients will see the information in the email subject line for any emails associated with the template. This provides an easy way for senders to organize their envelope emails without having to open an envelope to check the recipient. ###### Note: If merging the recipient information into the subject line causes the subject line to exceed 100 characters, then any characters over the 100 character limit are not included in the subject line. For cases where the recipient name or email is expected to be long, you should consider placing the merge field at the start of the email subject.  To add a recipient's name in the subject line add the following text in the `emailSubject` property when creating the template or when sending an envelope from a template:  [[<roleName>_UserName]]  Example:  `\"emailSubject\":\"[[Signer 1_UserName]], Please sign this NDA\",`  To add a recipient's email address in the subject line add the following text in the `emailSubject` property when creating the template or when sending an envelope from a template:  [[<roleName>_Email]]  Example:  `\"emailSubject\":\"[[Signer 1_Email]], Please sign this NDA\",`   In both cases the <roleName> is the recipient's contents of the `roleName` property in the template.  For cases where another recipient (such as an Agent, Editor, or Intermediary recipient) is entering the name and email information for the recipient included in the email subject, then [[<roleName>_UserName]] or [[<roleName>_Email]] is shown in the email subject.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_template(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param EnvelopeTemplate envelope_template:
        :return: TemplateSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_template_with_http_info(account_id, **kwargs)
        else:
            (data) = self.create_template_with_http_info(account_id, **kwargs)
            return data

    def create_template_with_http_info(self, account_id, **kwargs):
        """
        Creates an envelope from a template.
        Creates a template definition using a multipart request.  ###Template Email Subject Merge Fields  Call this endpoint to insert a recipient name and email address merge fields into the email subject line when creating or sending from a template.  The merge fields, based on the recipient's role name, are added to the `emailSubject` property when the template is created or when the template is used to create an envelope. After a template sender adds the name and email information for the recipient and sends the envelope, the recipient information is automatically merged into the appropriate fields in the email subject line.  Both the sender and the recipients will see the information in the email subject line for any emails associated with the template. This provides an easy way for senders to organize their envelope emails without having to open an envelope to check the recipient. ###### Note: If merging the recipient information into the subject line causes the subject line to exceed 100 characters, then any characters over the 100 character limit are not included in the subject line. For cases where the recipient name or email is expected to be long, you should consider placing the merge field at the start of the email subject.  To add a recipient's name in the subject line add the following text in the `emailSubject` property when creating the template or when sending an envelope from a template:  [[<roleName>_UserName]]  Example:  `\"emailSubject\":\"[[Signer 1_UserName]], Please sign this NDA\",`  To add a recipient's email address in the subject line add the following text in the `emailSubject` property when creating the template or when sending an envelope from a template:  [[<roleName>_Email]]  Example:  `\"emailSubject\":\"[[Signer 1_Email]], Please sign this NDA\",`   In both cases the <roleName> is the recipient's contents of the `roleName` property in the template.  For cases where another recipient (such as an Agent, Editor, or Intermediary recipient) is entering the name and email information for the recipient included in the email subject, then [[<roleName>_UserName]] or [[<roleName>_Email]] is shown in the email subject.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_template_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param EnvelopeTemplate envelope_template:
        :return: TemplateSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'envelope_template']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_template" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_template`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'envelope_template' in params:
            body_params = params['envelope_template']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='TemplateSummary',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_template_document_responsive_html_preview(self, account_id, document_id, template_id, **kwargs):
        """
        Post Responsive HTML Preview for a document in a template.
        Creates a preview of the [responsive](/docs/esign-rest-api/esign101/concepts/responsive/), HTML version of a specific template document. This method enables you to preview a PDF document conversion to responsive HTML across device types prior to sending.  The request body is a `documentHtmlDefinition` object, which holds the responsive signing parameters that define how to generate the HTML version of the signing document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_template_document_responsive_html_preview(account_id, document_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param DocumentHtmlDefinition document_html_definition:
        :return: DocumentHtmlDefinitions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_template_document_responsive_html_preview_with_http_info(account_id, document_id, template_id, **kwargs)
        else:
            (data) = self.create_template_document_responsive_html_preview_with_http_info(account_id, document_id, template_id, **kwargs)
            return data

    def create_template_document_responsive_html_preview_with_http_info(self, account_id, document_id, template_id, **kwargs):
        """
        Post Responsive HTML Preview for a document in a template.
        Creates a preview of the [responsive](/docs/esign-rest-api/esign101/concepts/responsive/), HTML version of a specific template document. This method enables you to preview a PDF document conversion to responsive HTML across device types prior to sending.  The request body is a `documentHtmlDefinition` object, which holds the responsive signing parameters that define how to generate the HTML version of the signing document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_template_document_responsive_html_preview_with_http_info(account_id, document_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param DocumentHtmlDefinition document_html_definition:
        :return: DocumentHtmlDefinitions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'template_id', 'document_html_definition']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_template_document_responsive_html_preview" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_template_document_responsive_html_preview`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `create_template_document_responsive_html_preview`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `create_template_document_responsive_html_preview`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/responsive_html_preview'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'document_html_definition' in params:
            body_params = params['document_html_definition']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DocumentHtmlDefinitions',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_template_document_tabs(self, account_id, document_id, template_id, **kwargs):
        """
        Adds the tabs to a tempate
        Adds tabs to the document specified by `documentId` in the template specified by `templateId`.  In the request body, you only need to specify the tabs that your are adding. For example, to add a text [prefill tab](/docs/esign-rest-api/reference/templates/templatedocumenttabs/create/#definition__templatetabs_prefilltabs), your request body might look like this:  ``` {   \"prefillTabs\": {     \"textTabs\": [       {         \"value\": \"a prefill text tab\",         \"pageNumber\": \"1\",         \"documentId\": \"1\",         \"xPosition\": 316,         \"yPosition\": 97       }     ]   } } ``` 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_template_document_tabs(account_id, document_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param TemplateTabs template_tabs:
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_template_document_tabs_with_http_info(account_id, document_id, template_id, **kwargs)
        else:
            (data) = self.create_template_document_tabs_with_http_info(account_id, document_id, template_id, **kwargs)
            return data

    def create_template_document_tabs_with_http_info(self, account_id, document_id, template_id, **kwargs):
        """
        Adds the tabs to a tempate
        Adds tabs to the document specified by `documentId` in the template specified by `templateId`.  In the request body, you only need to specify the tabs that your are adding. For example, to add a text [prefill tab](/docs/esign-rest-api/reference/templates/templatedocumenttabs/create/#definition__templatetabs_prefilltabs), your request body might look like this:  ``` {   \"prefillTabs\": {     \"textTabs\": [       {         \"value\": \"a prefill text tab\",         \"pageNumber\": \"1\",         \"documentId\": \"1\",         \"xPosition\": 316,         \"yPosition\": 97       }     ]   } } ``` 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_template_document_tabs_with_http_info(account_id, document_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param TemplateTabs template_tabs:
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'template_id', 'template_tabs']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_template_document_tabs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_template_document_tabs`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `create_template_document_tabs`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `create_template_document_tabs`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/tabs'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'template_tabs' in params:
            body_params = params['template_tabs']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Tabs',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_template_recipient_preview(self, account_id, template_id, **kwargs):
        """
        Provides a URL to start a recipient view of the Envelope UI
        This method returns a URL for a template recipient preview  in the DocuSign UI that you can embed in your application. You use this method to enable the sender to preview the recipients' experience.  For more information, see [Preview and Send](https://support.docusign.com/en/guides/ndse-user-guide-send-your-documents).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_template_recipient_preview(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param RecipientPreviewRequest recipient_preview_request:
        :return: ViewUrl
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_template_recipient_preview_with_http_info(account_id, template_id, **kwargs)
        else:
            (data) = self.create_template_recipient_preview_with_http_info(account_id, template_id, **kwargs)
            return data

    def create_template_recipient_preview_with_http_info(self, account_id, template_id, **kwargs):
        """
        Provides a URL to start a recipient view of the Envelope UI
        This method returns a URL for a template recipient preview  in the DocuSign UI that you can embed in your application. You use this method to enable the sender to preview the recipients' experience.  For more information, see [Preview and Send](https://support.docusign.com/en/guides/ndse-user-guide-send-your-documents).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_template_recipient_preview_with_http_info(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param RecipientPreviewRequest recipient_preview_request:
        :return: ViewUrl
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'template_id', 'recipient_preview_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_template_recipient_preview" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_template_recipient_preview`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `create_template_recipient_preview`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/views/recipient_preview'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'recipient_preview_request' in params:
            body_params = params['recipient_preview_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ViewUrl',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_template_responsive_html_preview(self, account_id, template_id, **kwargs):
        """
        Get Responsive HTML Preview for all documents in a template.
        Creates a preview of the [responsive](/docs/esign-rest-api/esign101/concepts/responsive/), HTML versions of all of the documents associated with a template. This method enables you to preview the PDF document conversions to responsive HTML across device types prior to sending.  The request body is a `documentHtmlDefinition` object, which holds the responsive signing parameters that define how to generate the HTML version of the documents.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_template_responsive_html_preview(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param DocumentHtmlDefinition document_html_definition:
        :return: DocumentHtmlDefinitions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_template_responsive_html_preview_with_http_info(account_id, template_id, **kwargs)
        else:
            (data) = self.create_template_responsive_html_preview_with_http_info(account_id, template_id, **kwargs)
            return data

    def create_template_responsive_html_preview_with_http_info(self, account_id, template_id, **kwargs):
        """
        Get Responsive HTML Preview for all documents in a template.
        Creates a preview of the [responsive](/docs/esign-rest-api/esign101/concepts/responsive/), HTML versions of all of the documents associated with a template. This method enables you to preview the PDF document conversions to responsive HTML across device types prior to sending.  The request body is a `documentHtmlDefinition` object, which holds the responsive signing parameters that define how to generate the HTML version of the documents.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_template_responsive_html_preview_with_http_info(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param DocumentHtmlDefinition document_html_definition:
        :return: DocumentHtmlDefinitions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'template_id', 'document_html_definition']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_template_responsive_html_preview" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_template_responsive_html_preview`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `create_template_responsive_html_preview`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/responsive_html_preview'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'document_html_definition' in params:
            body_params = params['document_html_definition']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DocumentHtmlDefinitions',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_custom_fields(self, account_id, template_id, **kwargs):
        """
        Deletes envelope custom fields in a template.
        Deletes envelope custom fields in a template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_custom_fields(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param TemplateCustomFields template_custom_fields:
        :return: CustomFields
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_custom_fields_with_http_info(account_id, template_id, **kwargs)
        else:
            (data) = self.delete_custom_fields_with_http_info(account_id, template_id, **kwargs)
            return data

    def delete_custom_fields_with_http_info(self, account_id, template_id, **kwargs):
        """
        Deletes envelope custom fields in a template.
        Deletes envelope custom fields in a template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_custom_fields_with_http_info(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param TemplateCustomFields template_custom_fields:
        :return: CustomFields
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'template_id', 'template_custom_fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_custom_fields`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `delete_custom_fields`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/custom_fields'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'template_custom_fields' in params:
            body_params = params['template_custom_fields']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CustomFields',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_document_fields(self, account_id, document_id, template_id, **kwargs):
        """
        Deletes custom document fields from an existing template document.
        Deletes custom document fields from an existing template document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_document_fields(account_id, document_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param DocumentFieldsInformation document_fields_information:
        :return: DocumentFieldsInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_document_fields_with_http_info(account_id, document_id, template_id, **kwargs)
        else:
            (data) = self.delete_document_fields_with_http_info(account_id, document_id, template_id, **kwargs)
            return data

    def delete_document_fields_with_http_info(self, account_id, document_id, template_id, **kwargs):
        """
        Deletes custom document fields from an existing template document.
        Deletes custom document fields from an existing template document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_document_fields_with_http_info(account_id, document_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param DocumentFieldsInformation document_fields_information:
        :return: DocumentFieldsInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'template_id', 'document_fields_information']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_document_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_document_fields`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `delete_document_fields`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `delete_document_fields`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/fields'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'document_fields_information' in params:
            body_params = params['document_fields_information']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DocumentFieldsInformation',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_document_page(self, account_id, document_id, page_number, template_id, **kwargs):
        """
        Deletes a page from a document in an template.
        Deletes a page from a document in a template based on the page number.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_document_page(account_id, document_id, page_number, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str page_number: The page number being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param PageRequest page_request:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_document_page_with_http_info(account_id, document_id, page_number, template_id, **kwargs)
        else:
            (data) = self.delete_document_page_with_http_info(account_id, document_id, page_number, template_id, **kwargs)
            return data

    def delete_document_page_with_http_info(self, account_id, document_id, page_number, template_id, **kwargs):
        """
        Deletes a page from a document in an template.
        Deletes a page from a document in a template based on the page number.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_document_page_with_http_info(account_id, document_id, page_number, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str page_number: The page number being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param PageRequest page_request:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'page_number', 'template_id', 'page_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_document_page" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_document_page`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `delete_document_page`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `delete_document_page`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `delete_document_page`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/pages/{pageNumber}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'page_request' in params:
            body_params = params['page_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_documents(self, account_id, template_id, **kwargs):
        """
        Deletes documents from a template.
        Deletes one or more documents from an existing template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_documents(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param EnvelopeDefinition envelope_definition:
        :return: TemplateDocumentsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_documents_with_http_info(account_id, template_id, **kwargs)
        else:
            (data) = self.delete_documents_with_http_info(account_id, template_id, **kwargs)
            return data

    def delete_documents_with_http_info(self, account_id, template_id, **kwargs):
        """
        Deletes documents from a template.
        Deletes one or more documents from an existing template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_documents_with_http_info(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param EnvelopeDefinition envelope_definition:
        :return: TemplateDocumentsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'template_id', 'envelope_definition']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_documents" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_documents`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `delete_documents`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/documents'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'envelope_definition' in params:
            body_params = params['envelope_definition']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='TemplateDocumentsResult',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_group_share(self, account_id, template_id, template_part, **kwargs):
        """
        Removes a member group's sharing permissions for a template.
        Removes a member group's sharing permissions for a specified template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_group_share(account_id, template_id, template_part, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param str template_part: Currently, the only defined part is **groups**. (required)
        :param GroupInformation group_information:
        :return: GroupInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_group_share_with_http_info(account_id, template_id, template_part, **kwargs)
        else:
            (data) = self.delete_group_share_with_http_info(account_id, template_id, template_part, **kwargs)
            return data

    def delete_group_share_with_http_info(self, account_id, template_id, template_part, **kwargs):
        """
        Removes a member group's sharing permissions for a template.
        Removes a member group's sharing permissions for a specified template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_group_share_with_http_info(account_id, template_id, template_part, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param str template_part: Currently, the only defined part is **groups**. (required)
        :param GroupInformation group_information:
        :return: GroupInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'template_id', 'template_part', 'group_information']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_group_share" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_group_share`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `delete_group_share`")
        # verify the required parameter 'template_part' is set
        if ('template_part' not in params) or (params['template_part'] is None):
            raise ValueError("Missing the required parameter `template_part` when calling `delete_group_share`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/{templatePart}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']
        if 'template_part' in params:
            path_params['templatePart'] = params['template_part']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'group_information' in params:
            body_params = params['group_information']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='GroupInformation',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_lock(self, account_id, template_id, **kwargs):
        """
        Deletes a template lock.
        Deletes the lock from the specified template. The `X-DocuSign-Edit` header must be included in the request.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_lock(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param LockRequest lock_request:
        :return: LockInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_lock_with_http_info(account_id, template_id, **kwargs)
        else:
            (data) = self.delete_lock_with_http_info(account_id, template_id, **kwargs)
            return data

    def delete_lock_with_http_info(self, account_id, template_id, **kwargs):
        """
        Deletes a template lock.
        Deletes the lock from the specified template. The `X-DocuSign-Edit` header must be included in the request.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_lock_with_http_info(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param LockRequest lock_request:
        :return: LockInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'template_id', 'lock_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_lock" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_lock`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `delete_lock`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/lock'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'lock_request' in params:
            body_params = params['lock_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='LockInformation',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_recipient(self, account_id, recipient_id, template_id, **kwargs):
        """
        Deletes the specified recipient file from a template.
        Deletes the specified recipient file from the specified template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_recipient(account_id, recipient_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param TemplateRecipients template_recipients:
        :return: Recipients
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_recipient_with_http_info(account_id, recipient_id, template_id, **kwargs)
        else:
            (data) = self.delete_recipient_with_http_info(account_id, recipient_id, template_id, **kwargs)
            return data

    def delete_recipient_with_http_info(self, account_id, recipient_id, template_id, **kwargs):
        """
        Deletes the specified recipient file from a template.
        Deletes the specified recipient file from the specified template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_recipient_with_http_info(account_id, recipient_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param TemplateRecipients template_recipients:
        :return: Recipients
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'recipient_id', 'template_id', 'template_recipients']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_recipient" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_recipient`")
        # verify the required parameter 'recipient_id' is set
        if ('recipient_id' not in params) or (params['recipient_id'] is None):
            raise ValueError("Missing the required parameter `recipient_id` when calling `delete_recipient`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `delete_recipient`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'recipient_id' in params:
            path_params['recipientId'] = params['recipient_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'template_recipients' in params:
            body_params = params['template_recipients']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Recipients',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_recipients(self, account_id, template_id, **kwargs):
        """
        Deletes recipients from a template.
        Deletes one or more recipients from a template. Recipients to be deleted are listed in the request, with the `recipientId` being used as the key for deleting recipients.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_recipients(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param TemplateRecipients template_recipients:
        :return: Recipients
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_recipients_with_http_info(account_id, template_id, **kwargs)
        else:
            (data) = self.delete_recipients_with_http_info(account_id, template_id, **kwargs)
            return data

    def delete_recipients_with_http_info(self, account_id, template_id, **kwargs):
        """
        Deletes recipients from a template.
        Deletes one or more recipients from a template. Recipients to be deleted are listed in the request, with the `recipientId` being used as the key for deleting recipients.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_recipients_with_http_info(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param TemplateRecipients template_recipients:
        :return: Recipients
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'template_id', 'template_recipients']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_recipients" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_recipients`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `delete_recipients`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/recipients'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'template_recipients' in params:
            body_params = params['template_recipients']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Recipients',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_tabs(self, account_id, recipient_id, template_id, **kwargs):
        """
        Deletes the tabs associated with a recipient in a template.
        Deletes one or more tabs associated with a recipient in a template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_tabs(account_id, recipient_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param TemplateTabs template_tabs:
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_tabs_with_http_info(account_id, recipient_id, template_id, **kwargs)
        else:
            (data) = self.delete_tabs_with_http_info(account_id, recipient_id, template_id, **kwargs)
            return data

    def delete_tabs_with_http_info(self, account_id, recipient_id, template_id, **kwargs):
        """
        Deletes the tabs associated with a recipient in a template.
        Deletes one or more tabs associated with a recipient in a template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_tabs_with_http_info(account_id, recipient_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param TemplateTabs template_tabs:
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'recipient_id', 'template_id', 'template_tabs']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_tabs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_tabs`")
        # verify the required parameter 'recipient_id' is set
        if ('recipient_id' not in params) or (params['recipient_id'] is None):
            raise ValueError("Missing the required parameter `recipient_id` when calling `delete_tabs`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `delete_tabs`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/tabs'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'recipient_id' in params:
            path_params['recipientId'] = params['recipient_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'template_tabs' in params:
            body_params = params['template_tabs']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Tabs',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_template_document_tabs(self, account_id, document_id, template_id, **kwargs):
        """
        Deletes tabs from an envelope document
        Deletes tabs from the document specified by `documentId` in the template specified by `templateId`. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_template_document_tabs(account_id, document_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param TemplateTabs template_tabs:
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_template_document_tabs_with_http_info(account_id, document_id, template_id, **kwargs)
        else:
            (data) = self.delete_template_document_tabs_with_http_info(account_id, document_id, template_id, **kwargs)
            return data

    def delete_template_document_tabs_with_http_info(self, account_id, document_id, template_id, **kwargs):
        """
        Deletes tabs from an envelope document
        Deletes tabs from the document specified by `documentId` in the template specified by `templateId`. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_template_document_tabs_with_http_info(account_id, document_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param TemplateTabs template_tabs:
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'template_id', 'template_tabs']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_template_document_tabs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_template_document_tabs`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `delete_template_document_tabs`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `delete_template_document_tabs`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/tabs'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'template_tabs' in params:
            body_params = params['template_tabs']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Tabs',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get(self, account_id, template_id, **kwargs):
        """
        Gets a list of templates for a specified account.
        Retrieves the definition of the specified template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param str include:
        :return: EnvelopeTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_with_http_info(account_id, template_id, **kwargs)
        else:
            (data) = self.get_with_http_info(account_id, template_id, **kwargs)
            return data

    def get_with_http_info(self, account_id, template_id, **kwargs):
        """
        Gets a list of templates for a specified account.
        Retrieves the definition of the specified template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_with_http_info(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param str include:
        :return: EnvelopeTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'template_id', 'include']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `get`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}
        if 'include' in params:
            query_params['include'] = params['include']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EnvelopeTemplate',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document(self, account_id, document_id, template_id, **kwargs):
        """
        Gets PDF documents from a template.
        Retrieves one or more PDF documents from the specified template.  You can specify the ID of the document to retrieve or can specify `combined` to retrieve all documents in the template as one pdf.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document(account_id, document_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param str encrypt:
        :param str show_changes:
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_with_http_info(account_id, document_id, template_id, **kwargs)
        else:
            (data) = self.get_document_with_http_info(account_id, document_id, template_id, **kwargs)
            return data

    def get_document_with_http_info(self, account_id, document_id, template_id, **kwargs):
        """
        Gets PDF documents from a template.
        Retrieves one or more PDF documents from the specified template.  You can specify the ID of the document to retrieve or can specify `combined` to retrieve all documents in the template as one pdf.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_with_http_info(account_id, document_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param str encrypt:
        :param str show_changes:
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'template_id', 'encrypt', 'show_changes']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_document`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `get_document`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `get_document`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}
        if 'encrypt' in params:
            query_params['encrypt'] = params['encrypt']
        if 'show_changes' in params:
            query_params['show_changes'] = params['show_changes']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/pdf'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_page_image(self, account_id, document_id, page_number, template_id, **kwargs):
        """
        Gets a page image from a template for display.
        Retrieves a page image for display from the specified template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_page_image(account_id, document_id, page_number, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str page_number: The page number being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param str dpi:
        :param str max_height:
        :param str max_width:
        :param str show_changes:
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_page_image_with_http_info(account_id, document_id, page_number, template_id, **kwargs)
        else:
            (data) = self.get_document_page_image_with_http_info(account_id, document_id, page_number, template_id, **kwargs)
            return data

    def get_document_page_image_with_http_info(self, account_id, document_id, page_number, template_id, **kwargs):
        """
        Gets a page image from a template for display.
        Retrieves a page image for display from the specified template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_page_image_with_http_info(account_id, document_id, page_number, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str page_number: The page number being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param str dpi:
        :param str max_height:
        :param str max_width:
        :param str show_changes:
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'page_number', 'template_id', 'dpi', 'max_height', 'max_width', 'show_changes']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_page_image" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_document_page_image`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `get_document_page_image`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_document_page_image`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `get_document_page_image`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/pages/{pageNumber}/page_image'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}
        if 'dpi' in params:
            query_params['dpi'] = params['dpi']
        if 'max_height' in params:
            query_params['max_height'] = params['max_height']
        if 'max_width' in params:
            query_params['max_width'] = params['max_width']
        if 'show_changes' in params:
            query_params['show_changes'] = params['show_changes']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['image/png'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_tabs(self, account_id, document_id, template_id, **kwargs):
        """
        Returns tabs on the document.
        Returns the tabs on the document specified by `documentId` in the template specified by `templateId`.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_tabs(account_id, document_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param str page_numbers:
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_tabs_with_http_info(account_id, document_id, template_id, **kwargs)
        else:
            (data) = self.get_document_tabs_with_http_info(account_id, document_id, template_id, **kwargs)
            return data

    def get_document_tabs_with_http_info(self, account_id, document_id, template_id, **kwargs):
        """
        Returns tabs on the document.
        Returns the tabs on the document specified by `documentId` in the template specified by `templateId`.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_tabs_with_http_info(account_id, document_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param str page_numbers:
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'template_id', 'page_numbers']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_tabs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_document_tabs`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `get_document_tabs`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `get_document_tabs`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/tabs'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}
        if 'page_numbers' in params:
            query_params['page_numbers'] = params['page_numbers']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Tabs',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_lock(self, account_id, template_id, **kwargs):
        """
        Gets template lock information.
        Retrieves general information about the template lock.  If the call is made by the user who has the lock and the request has the same integrator key as original, then the `X-DocuSign-Edit` header  field and additional lock information is included in the response. This allows users to recover a lost editing session token and the `X-DocuSign-Edit` header.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_lock(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :return: LockInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_lock_with_http_info(account_id, template_id, **kwargs)
        else:
            (data) = self.get_lock_with_http_info(account_id, template_id, **kwargs)
            return data

    def get_lock_with_http_info(self, account_id, template_id, **kwargs):
        """
        Gets template lock information.
        Retrieves general information about the template lock.  If the call is made by the user who has the lock and the request has the same integrator key as original, then the `X-DocuSign-Edit` header  field and additional lock information is included in the response. This allows users to recover a lost editing session token and the `X-DocuSign-Edit` header.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_lock_with_http_info(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :return: LockInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'template_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_lock" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_lock`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `get_lock`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/lock'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='LockInformation',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_notification_settings(self, account_id, template_id, **kwargs):
        """
        Gets template notification information.
        Retrieves the envelope notification, reminders and expirations, information for an existing template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_notification_settings(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :return: Notification
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_notification_settings_with_http_info(account_id, template_id, **kwargs)
        else:
            (data) = self.get_notification_settings_with_http_info(account_id, template_id, **kwargs)
            return data

    def get_notification_settings_with_http_info(self, account_id, template_id, **kwargs):
        """
        Gets template notification information.
        Retrieves the envelope notification, reminders and expirations, information for an existing template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_notification_settings_with_http_info(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :return: Notification
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'template_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_notification_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_notification_settings`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `get_notification_settings`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/notification'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Notification',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_tabs(self, account_id, document_id, page_number, template_id, **kwargs):
        """
        Returns tabs on the specified page.
        Returns the tabs from the page specified by `pageNumber` of the document specified by `documentId` in the template specified by `templateId`. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_tabs(account_id, document_id, page_number, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str page_number: The page number being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_tabs_with_http_info(account_id, document_id, page_number, template_id, **kwargs)
        else:
            (data) = self.get_page_tabs_with_http_info(account_id, document_id, page_number, template_id, **kwargs)
            return data

    def get_page_tabs_with_http_info(self, account_id, document_id, page_number, template_id, **kwargs):
        """
        Returns tabs on the specified page.
        Returns the tabs from the page specified by `pageNumber` of the document specified by `documentId` in the template specified by `templateId`. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_tabs_with_http_info(account_id, document_id, page_number, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str page_number: The page number being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'page_number', 'template_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_tabs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_page_tabs`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `get_page_tabs`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_tabs`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `get_page_tabs`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/pages/{pageNumber}/tabs'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Tabs',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_pages(self, account_id, document_id, template_id, **kwargs):
        """
        Returns document page image(s) based on input.
        Returns images of the pages in a template document for display based on the parameters that you specify.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pages(account_id, document_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param str count:
        :param str dpi:
        :param str max_height:
        :param str max_width:
        :param str nocache:
        :param str show_changes:
        :param str start_position:
        :return: PageImages
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_pages_with_http_info(account_id, document_id, template_id, **kwargs)
        else:
            (data) = self.get_pages_with_http_info(account_id, document_id, template_id, **kwargs)
            return data

    def get_pages_with_http_info(self, account_id, document_id, template_id, **kwargs):
        """
        Returns document page image(s) based on input.
        Returns images of the pages in a template document for display based on the parameters that you specify.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pages_with_http_info(account_id, document_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param str count:
        :param str dpi:
        :param str max_height:
        :param str max_width:
        :param str nocache:
        :param str show_changes:
        :param str start_position:
        :return: PageImages
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'template_id', 'count', 'dpi', 'max_height', 'max_width', 'nocache', 'show_changes', 'start_position']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pages" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_pages`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `get_pages`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `get_pages`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/pages'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}
        if 'count' in params:
            query_params['count'] = params['count']
        if 'dpi' in params:
            query_params['dpi'] = params['dpi']
        if 'max_height' in params:
            query_params['max_height'] = params['max_height']
        if 'max_width' in params:
            query_params['max_width'] = params['max_width']
        if 'nocache' in params:
            query_params['nocache'] = params['nocache']
        if 'show_changes' in params:
            query_params['show_changes'] = params['show_changes']
        if 'start_position' in params:
            query_params['start_position'] = params['start_position']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PageImages',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_template_document_html_definitions(self, account_id, document_id, template_id, **kwargs):
        """
        Get the Original HTML Definition used to generate the Responsive HTML for a given document in a template.
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_template_document_html_definitions(account_id, document_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :return: DocumentHtmlDefinitionOriginals
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_template_document_html_definitions_with_http_info(account_id, document_id, template_id, **kwargs)
        else:
            (data) = self.get_template_document_html_definitions_with_http_info(account_id, document_id, template_id, **kwargs)
            return data

    def get_template_document_html_definitions_with_http_info(self, account_id, document_id, template_id, **kwargs):
        """
        Get the Original HTML Definition used to generate the Responsive HTML for a given document in a template.
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_template_document_html_definitions_with_http_info(account_id, document_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :return: DocumentHtmlDefinitionOriginals
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'template_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_template_document_html_definitions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_template_document_html_definitions`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `get_template_document_html_definitions`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `get_template_document_html_definitions`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/html_definitions'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DocumentHtmlDefinitionOriginals',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_template_html_definitions(self, account_id, template_id, **kwargs):
        """
        Get the Original HTML Definition used to generate the Responsive HTML for the template.
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_template_html_definitions(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :return: DocumentHtmlDefinitionOriginals
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_template_html_definitions_with_http_info(account_id, template_id, **kwargs)
        else:
            (data) = self.get_template_html_definitions_with_http_info(account_id, template_id, **kwargs)
            return data

    def get_template_html_definitions_with_http_info(self, account_id, template_id, **kwargs):
        """
        Get the Original HTML Definition used to generate the Responsive HTML for the template.
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_template_html_definitions_with_http_info(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :return: DocumentHtmlDefinitionOriginals
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'template_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_template_html_definitions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_template_html_definitions`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `get_template_html_definitions`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/html_definitions'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DocumentHtmlDefinitionOriginals',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_custom_fields(self, account_id, template_id, **kwargs):
        """
        Gets the custom document fields from a template.
        Retrieves the custom document field information from an existing template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_custom_fields(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :return: CustomFields
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_custom_fields_with_http_info(account_id, template_id, **kwargs)
        else:
            (data) = self.list_custom_fields_with_http_info(account_id, template_id, **kwargs)
            return data

    def list_custom_fields_with_http_info(self, account_id, template_id, **kwargs):
        """
        Gets the custom document fields from a template.
        Retrieves the custom document field information from an existing template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_custom_fields_with_http_info(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :return: CustomFields
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'template_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `list_custom_fields`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `list_custom_fields`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/custom_fields'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CustomFields',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_document_fields(self, account_id, document_id, template_id, **kwargs):
        """
        Gets the custom document fields for a an existing template document.
        Retrieves the custom document fields for an existing template document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_document_fields(account_id, document_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :return: DocumentFieldsInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_document_fields_with_http_info(account_id, document_id, template_id, **kwargs)
        else:
            (data) = self.list_document_fields_with_http_info(account_id, document_id, template_id, **kwargs)
            return data

    def list_document_fields_with_http_info(self, account_id, document_id, template_id, **kwargs):
        """
        Gets the custom document fields for a an existing template document.
        Retrieves the custom document fields for an existing template document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_document_fields_with_http_info(account_id, document_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :return: DocumentFieldsInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'template_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_document_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `list_document_fields`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `list_document_fields`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `list_document_fields`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/fields'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DocumentFieldsInformation',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_documents(self, account_id, template_id, **kwargs):
        """
        Gets a list of documents associated with a template.
        Retrieves a list of documents associated with the specified template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_documents(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param str include_tabs:
        :return: TemplateDocumentsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_documents_with_http_info(account_id, template_id, **kwargs)
        else:
            (data) = self.list_documents_with_http_info(account_id, template_id, **kwargs)
            return data

    def list_documents_with_http_info(self, account_id, template_id, **kwargs):
        """
        Gets a list of documents associated with a template.
        Retrieves a list of documents associated with the specified template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_documents_with_http_info(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param str include_tabs:
        :return: TemplateDocumentsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'template_id', 'include_tabs']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_documents" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `list_documents`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `list_documents`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/documents'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}
        if 'include_tabs' in params:
            query_params['include_tabs'] = params['include_tabs']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='TemplateDocumentsResult',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_recipients(self, account_id, template_id, **kwargs):
        """
        Gets recipient information from a template.
        Retrieves the information for all recipients in the specified template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_recipients(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param str include_anchor_tab_locations:  When set to **true** and `include_tabs` is set to **true**, all tabs with anchor tab properties are included in the response. 
        :param str include_extended:  When set to **true**, the extended properties are included in the response. 
        :param str include_tabs: When set to **true**, the tab information associated with the recipient is included in the response.
        :return: Recipients
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_recipients_with_http_info(account_id, template_id, **kwargs)
        else:
            (data) = self.list_recipients_with_http_info(account_id, template_id, **kwargs)
            return data

    def list_recipients_with_http_info(self, account_id, template_id, **kwargs):
        """
        Gets recipient information from a template.
        Retrieves the information for all recipients in the specified template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_recipients_with_http_info(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param str include_anchor_tab_locations:  When set to **true** and `include_tabs` is set to **true**, all tabs with anchor tab properties are included in the response. 
        :param str include_extended:  When set to **true**, the extended properties are included in the response. 
        :param str include_tabs: When set to **true**, the tab information associated with the recipient is included in the response.
        :return: Recipients
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'template_id', 'include_anchor_tab_locations', 'include_extended', 'include_tabs']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_recipients" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `list_recipients`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `list_recipients`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/recipients'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}
        if 'include_anchor_tab_locations' in params:
            query_params['include_anchor_tab_locations'] = params['include_anchor_tab_locations']
        if 'include_extended' in params:
            query_params['include_extended'] = params['include_extended']
        if 'include_tabs' in params:
            query_params['include_tabs'] = params['include_tabs']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Recipients',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_tabs(self, account_id, recipient_id, template_id, **kwargs):
        """
        Gets the tabs information for a signer or sign-in-person recipient in a template.
        Gets the tabs information for a signer or sign-in-person recipient in a template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_tabs(account_id, recipient_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param str include_anchor_tab_locations: When set to **true**, all tabs with anchor tab properties are included in the response. 
        :param str include_metadata:
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_tabs_with_http_info(account_id, recipient_id, template_id, **kwargs)
        else:
            (data) = self.list_tabs_with_http_info(account_id, recipient_id, template_id, **kwargs)
            return data

    def list_tabs_with_http_info(self, account_id, recipient_id, template_id, **kwargs):
        """
        Gets the tabs information for a signer or sign-in-person recipient in a template.
        Gets the tabs information for a signer or sign-in-person recipient in a template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_tabs_with_http_info(account_id, recipient_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param str include_anchor_tab_locations: When set to **true**, all tabs with anchor tab properties are included in the response. 
        :param str include_metadata:
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'recipient_id', 'template_id', 'include_anchor_tab_locations', 'include_metadata']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_tabs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `list_tabs`")
        # verify the required parameter 'recipient_id' is set
        if ('recipient_id' not in params) or (params['recipient_id'] is None):
            raise ValueError("Missing the required parameter `recipient_id` when calling `list_tabs`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `list_tabs`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/tabs'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'recipient_id' in params:
            path_params['recipientId'] = params['recipient_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}
        if 'include_anchor_tab_locations' in params:
            query_params['include_anchor_tab_locations'] = params['include_anchor_tab_locations']
        if 'include_metadata' in params:
            query_params['include_metadata'] = params['include_metadata']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Tabs',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_templates(self, account_id, **kwargs):
        """
        Gets the definition of a template.
        Retrieves the list of templates for the specified account. The request can be limited to a specific folder.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_templates(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str count: Number of records to return in the cache.
        :param str created_from_date:
        :param str created_to_date:
        :param str folder_ids: A comma separated list of folder ID GUIDs.
        :param str folder_types:
        :param str from_date: Start of the search date range. Only returns templates created on or after this date/time. If no value is specified, there is no limit on the earliest date created.
        :param str include: A comma separated list of additional template attributes to include in the response. Valid values are: recipients, folders, documents, custom_fields, and notifications.
        :param str is_deleted_template_only:
        :param str is_download:
        :param str modified_from_date:
        :param str modified_to_date:
        :param str order: Sets the direction order used to sort the list. Valid values are: -asc = ascending sort order (a to z)  -desc = descending sort order (z to a)
        :param str order_by: Sets the file attribute used to sort the list. Valid values are:  -name: template name  -modified: date/time template was last modified.  -used: date/time the template was last used.
        :param str search_fields:
        :param str search_text: The search text used to search the names of templates.
        :param str shared_by_me: If true, the response only includes templates shared by the user. If false, the response only returns template not shared by the user. If not specified, the response is not affected.
        :param str start_position: The starting index for the first template shown in the response. This must be greater than or equal to 0 (zero).
        :param str template_ids:
        :param str to_date: End of the search date range. Only returns templates created up to this date/time. If no value is provided, this defaults to the current date.
        :param str used_from_date: Start of the search date range. Only returns templates used or edited on or after this date/time. If no value is specified, there is no limit on the earliest date used.
        :param str used_to_date: End of the search date range. Only returns templates used or edited up to this date/time. If no value is provided, this defaults to the current date.
        :param str user_filter: Sets if the templates shown in the response Valid values are:  -owned_by_me: only shows templates the user owns.  -shared_with_me: only shows templates that are shared with the user.  -all: shows all templates owned or shared with the user.
        :param str user_id:
        :return: EnvelopeTemplateResults
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_templates_with_http_info(account_id, **kwargs)
        else:
            (data) = self.list_templates_with_http_info(account_id, **kwargs)
            return data

    def list_templates_with_http_info(self, account_id, **kwargs):
        """
        Gets the definition of a template.
        Retrieves the list of templates for the specified account. The request can be limited to a specific folder.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_templates_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str count: Number of records to return in the cache.
        :param str created_from_date:
        :param str created_to_date:
        :param str folder_ids: A comma separated list of folder ID GUIDs.
        :param str folder_types:
        :param str from_date: Start of the search date range. Only returns templates created on or after this date/time. If no value is specified, there is no limit on the earliest date created.
        :param str include: A comma separated list of additional template attributes to include in the response. Valid values are: recipients, folders, documents, custom_fields, and notifications.
        :param str is_deleted_template_only:
        :param str is_download:
        :param str modified_from_date:
        :param str modified_to_date:
        :param str order: Sets the direction order used to sort the list. Valid values are: -asc = ascending sort order (a to z)  -desc = descending sort order (z to a)
        :param str order_by: Sets the file attribute used to sort the list. Valid values are:  -name: template name  -modified: date/time template was last modified.  -used: date/time the template was last used.
        :param str search_fields:
        :param str search_text: The search text used to search the names of templates.
        :param str shared_by_me: If true, the response only includes templates shared by the user. If false, the response only returns template not shared by the user. If not specified, the response is not affected.
        :param str start_position: The starting index for the first template shown in the response. This must be greater than or equal to 0 (zero).
        :param str template_ids:
        :param str to_date: End of the search date range. Only returns templates created up to this date/time. If no value is provided, this defaults to the current date.
        :param str used_from_date: Start of the search date range. Only returns templates used or edited on or after this date/time. If no value is specified, there is no limit on the earliest date used.
        :param str used_to_date: End of the search date range. Only returns templates used or edited up to this date/time. If no value is provided, this defaults to the current date.
        :param str user_filter: Sets if the templates shown in the response Valid values are:  -owned_by_me: only shows templates the user owns.  -shared_with_me: only shows templates that are shared with the user.  -all: shows all templates owned or shared with the user.
        :param str user_id:
        :return: EnvelopeTemplateResults
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'count', 'created_from_date', 'created_to_date', 'folder_ids', 'folder_types', 'from_date', 'include', 'is_deleted_template_only', 'is_download', 'modified_from_date', 'modified_to_date', 'order', 'order_by', 'search_fields', 'search_text', 'shared_by_me', 'start_position', 'template_ids', 'to_date', 'used_from_date', 'used_to_date', 'user_filter', 'user_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_templates" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `list_templates`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}
        if 'count' in params:
            query_params['count'] = params['count']
        if 'created_from_date' in params:
            query_params['created_from_date'] = params['created_from_date']
        if 'created_to_date' in params:
            query_params['created_to_date'] = params['created_to_date']
        if 'folder_ids' in params:
            query_params['folder_ids'] = params['folder_ids']
        if 'folder_types' in params:
            query_params['folder_types'] = params['folder_types']
        if 'from_date' in params:
            query_params['from_date'] = params['from_date']
        if 'include' in params:
            query_params['include'] = params['include']
        if 'is_deleted_template_only' in params:
            query_params['is_deleted_template_only'] = params['is_deleted_template_only']
        if 'is_download' in params:
            query_params['is_download'] = params['is_download']
        if 'modified_from_date' in params:
            query_params['modified_from_date'] = params['modified_from_date']
        if 'modified_to_date' in params:
            query_params['modified_to_date'] = params['modified_to_date']
        if 'order' in params:
            query_params['order'] = params['order']
        if 'order_by' in params:
            query_params['order_by'] = params['order_by']
        if 'search_fields' in params:
            query_params['search_fields'] = params['search_fields']
        if 'search_text' in params:
            query_params['search_text'] = params['search_text']
        if 'shared_by_me' in params:
            query_params['shared_by_me'] = params['shared_by_me']
        if 'start_position' in params:
            query_params['start_position'] = params['start_position']
        if 'template_ids' in params:
            query_params['template_ids'] = params['template_ids']
        if 'to_date' in params:
            query_params['to_date'] = params['to_date']
        if 'used_from_date' in params:
            query_params['used_from_date'] = params['used_from_date']
        if 'used_to_date' in params:
            query_params['used_to_date'] = params['used_to_date']
        if 'user_filter' in params:
            query_params['user_filter'] = params['user_filter']
        if 'user_id' in params:
            query_params['user_id'] = params['user_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EnvelopeTemplateResults',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def rotate_document_page(self, account_id, document_id, page_number, template_id, **kwargs):
        """
        Rotates page image from a template for display.
        Rotates page image from a template for display. The page image can be rotated to the left or right.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.rotate_document_page(account_id, document_id, page_number, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str page_number: The page number being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param PageRequest page_request:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.rotate_document_page_with_http_info(account_id, document_id, page_number, template_id, **kwargs)
        else:
            (data) = self.rotate_document_page_with_http_info(account_id, document_id, page_number, template_id, **kwargs)
            return data

    def rotate_document_page_with_http_info(self, account_id, document_id, page_number, template_id, **kwargs):
        """
        Rotates page image from a template for display.
        Rotates page image from a template for display. The page image can be rotated to the left or right.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.rotate_document_page_with_http_info(account_id, document_id, page_number, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str page_number: The page number being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param PageRequest page_request:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'page_number', 'template_id', 'page_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method rotate_document_page" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `rotate_document_page`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `rotate_document_page`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `rotate_document_page`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `rotate_document_page`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/pages/{pageNumber}/page_image'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'page_request' in params:
            body_params = params['page_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update(self, account_id, template_id, **kwargs):
        """
        Updates an existing template.
        Updates an existing template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param EnvelopeTemplate envelope_template:
        :return: TemplateUpdateSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_with_http_info(account_id, template_id, **kwargs)
        else:
            (data) = self.update_with_http_info(account_id, template_id, **kwargs)
            return data

    def update_with_http_info(self, account_id, template_id, **kwargs):
        """
        Updates an existing template.
        Updates an existing template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_with_http_info(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param EnvelopeTemplate envelope_template:
        :return: TemplateUpdateSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'template_id', 'envelope_template']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `update`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'envelope_template' in params:
            body_params = params['envelope_template']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='TemplateUpdateSummary',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_custom_fields(self, account_id, template_id, **kwargs):
        """
        Updates envelope custom fields in a template.
        Updates the custom fields in a template.  Each custom field used in a template must have a unique name.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_custom_fields(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param TemplateCustomFields template_custom_fields:
        :return: CustomFields
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_custom_fields_with_http_info(account_id, template_id, **kwargs)
        else:
            (data) = self.update_custom_fields_with_http_info(account_id, template_id, **kwargs)
            return data

    def update_custom_fields_with_http_info(self, account_id, template_id, **kwargs):
        """
        Updates envelope custom fields in a template.
        Updates the custom fields in a template.  Each custom field used in a template must have a unique name.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_custom_fields_with_http_info(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param TemplateCustomFields template_custom_fields:
        :return: CustomFields
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'template_id', 'template_custom_fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_custom_fields`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `update_custom_fields`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/custom_fields'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'template_custom_fields' in params:
            body_params = params['template_custom_fields']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CustomFields',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_document(self, account_id, document_id, template_id, **kwargs):
        """
        Adds a document to a template document.
        Adds the specified document to an existing template document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_document(account_id, document_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param str is_envelope_definition:
        :param EnvelopeDefinition envelope_definition:
        :return: EnvelopeDocument
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_document_with_http_info(account_id, document_id, template_id, **kwargs)
        else:
            (data) = self.update_document_with_http_info(account_id, document_id, template_id, **kwargs)
            return data

    def update_document_with_http_info(self, account_id, document_id, template_id, **kwargs):
        """
        Adds a document to a template document.
        Adds the specified document to an existing template document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_document_with_http_info(account_id, document_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param str is_envelope_definition:
        :param EnvelopeDefinition envelope_definition:
        :return: EnvelopeDocument
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'template_id', 'is_envelope_definition', 'envelope_definition']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_document" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_document`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `update_document`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `update_document`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}
        if 'is_envelope_definition' in params:
            query_params['is_envelope_definition'] = params['is_envelope_definition']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'envelope_definition' in params:
            body_params = params['envelope_definition']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EnvelopeDocument',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_document_fields(self, account_id, document_id, template_id, **kwargs):
        """
        Updates existing custom document fields in an existing template document.
        Updates existing custom document fields in an existing template document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_document_fields(account_id, document_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param DocumentFieldsInformation document_fields_information:
        :return: DocumentFieldsInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_document_fields_with_http_info(account_id, document_id, template_id, **kwargs)
        else:
            (data) = self.update_document_fields_with_http_info(account_id, document_id, template_id, **kwargs)
            return data

    def update_document_fields_with_http_info(self, account_id, document_id, template_id, **kwargs):
        """
        Updates existing custom document fields in an existing template document.
        Updates existing custom document fields in an existing template document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_document_fields_with_http_info(account_id, document_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param DocumentFieldsInformation document_fields_information:
        :return: DocumentFieldsInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'template_id', 'document_fields_information']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_document_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_document_fields`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `update_document_fields`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `update_document_fields`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/fields'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'document_fields_information' in params:
            body_params = params['document_fields_information']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DocumentFieldsInformation',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_documents(self, account_id, template_id, **kwargs):
        """
        Adds documents to a template document.
        Adds one or more documents to an existing template document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_documents(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param EnvelopeDefinition envelope_definition:
        :return: TemplateDocumentsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_documents_with_http_info(account_id, template_id, **kwargs)
        else:
            (data) = self.update_documents_with_http_info(account_id, template_id, **kwargs)
            return data

    def update_documents_with_http_info(self, account_id, template_id, **kwargs):
        """
        Adds documents to a template document.
        Adds one or more documents to an existing template document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_documents_with_http_info(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param EnvelopeDefinition envelope_definition:
        :return: TemplateDocumentsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'template_id', 'envelope_definition']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_documents" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_documents`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `update_documents`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/documents'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'envelope_definition' in params:
            body_params = params['envelope_definition']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='TemplateDocumentsResult',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_group_share(self, account_id, template_id, template_part, **kwargs):
        """
        Shares a template with a group
        Shares a template with the specified members group.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_group_share(account_id, template_id, template_part, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param str template_part: Currently, the only defined part is **groups**. (required)
        :param GroupInformation group_information:
        :return: GroupInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_group_share_with_http_info(account_id, template_id, template_part, **kwargs)
        else:
            (data) = self.update_group_share_with_http_info(account_id, template_id, template_part, **kwargs)
            return data

    def update_group_share_with_http_info(self, account_id, template_id, template_part, **kwargs):
        """
        Shares a template with a group
        Shares a template with the specified members group.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_group_share_with_http_info(account_id, template_id, template_part, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param str template_part: Currently, the only defined part is **groups**. (required)
        :param GroupInformation group_information:
        :return: GroupInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'template_id', 'template_part', 'group_information']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_group_share" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_group_share`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `update_group_share`")
        # verify the required parameter 'template_part' is set
        if ('template_part' not in params) or (params['template_part'] is None):
            raise ValueError("Missing the required parameter `template_part` when calling `update_group_share`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/{templatePart}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']
        if 'template_part' in params:
            path_params['templatePart'] = params['template_part']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'group_information' in params:
            body_params = params['group_information']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='GroupInformation',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_lock(self, account_id, template_id, **kwargs):
        """
        Updates a template lock.
        Updates the lock duration time or update the `lockedByApp` property information for the specified template. The user and integrator key must match the user specified by the `lockByUser` property and integrator key information and the `X-DocuSign-Edit` header must be included or an error will be generated.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_lock(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param LockRequest lock_request:
        :return: LockInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_lock_with_http_info(account_id, template_id, **kwargs)
        else:
            (data) = self.update_lock_with_http_info(account_id, template_id, **kwargs)
            return data

    def update_lock_with_http_info(self, account_id, template_id, **kwargs):
        """
        Updates a template lock.
        Updates the lock duration time or update the `lockedByApp` property information for the specified template. The user and integrator key must match the user specified by the `lockByUser` property and integrator key information and the `X-DocuSign-Edit` header must be included or an error will be generated.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_lock_with_http_info(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param LockRequest lock_request:
        :return: LockInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'template_id', 'lock_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_lock" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_lock`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `update_lock`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/lock'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'lock_request' in params:
            body_params = params['lock_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='LockInformation',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_notification_settings(self, account_id, template_id, **kwargs):
        """
        Updates the notification  structure for an existing template.
        Updates the notification structure for an existing template. Use this endpoint to set reminder and expiration notifications.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_notification_settings(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param TemplateNotificationRequest template_notification_request:
        :return: Notification
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_notification_settings_with_http_info(account_id, template_id, **kwargs)
        else:
            (data) = self.update_notification_settings_with_http_info(account_id, template_id, **kwargs)
            return data

    def update_notification_settings_with_http_info(self, account_id, template_id, **kwargs):
        """
        Updates the notification  structure for an existing template.
        Updates the notification structure for an existing template. Use this endpoint to set reminder and expiration notifications.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_notification_settings_with_http_info(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param TemplateNotificationRequest template_notification_request:
        :return: Notification
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'template_id', 'template_notification_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_notification_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_notification_settings`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `update_notification_settings`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/notification'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'template_notification_request' in params:
            body_params = params['template_notification_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Notification',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_recipients(self, account_id, template_id, **kwargs):
        """
        Updates recipients in a template.
        Updates recipients in a template.   You can edit the following properties: `email`, `userName`, `routingOrder`, `faxNumber`, `deliveryMethod`, `accessCode`, and `requireIdLookup`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_recipients(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param str resend_envelope:
        :param TemplateRecipients template_recipients:
        :return: RecipientsUpdateSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_recipients_with_http_info(account_id, template_id, **kwargs)
        else:
            (data) = self.update_recipients_with_http_info(account_id, template_id, **kwargs)
            return data

    def update_recipients_with_http_info(self, account_id, template_id, **kwargs):
        """
        Updates recipients in a template.
        Updates recipients in a template.   You can edit the following properties: `email`, `userName`, `routingOrder`, `faxNumber`, `deliveryMethod`, `accessCode`, and `requireIdLookup`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_recipients_with_http_info(account_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param str resend_envelope:
        :param TemplateRecipients template_recipients:
        :return: RecipientsUpdateSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'template_id', 'resend_envelope', 'template_recipients']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_recipients" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_recipients`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `update_recipients`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/recipients'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}
        if 'resend_envelope' in params:
            query_params['resend_envelope'] = params['resend_envelope']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'template_recipients' in params:
            body_params = params['template_recipients']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='RecipientsUpdateSummary',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_tabs(self, account_id, recipient_id, template_id, **kwargs):
        """
        Updates the tabs for a recipient.
        Updates one or more tabs for a recipient in a template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_tabs(account_id, recipient_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param TemplateTabs template_tabs:
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_tabs_with_http_info(account_id, recipient_id, template_id, **kwargs)
        else:
            (data) = self.update_tabs_with_http_info(account_id, recipient_id, template_id, **kwargs)
            return data

    def update_tabs_with_http_info(self, account_id, recipient_id, template_id, **kwargs):
        """
        Updates the tabs for a recipient.
        Updates one or more tabs for a recipient in a template.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_tabs_with_http_info(account_id, recipient_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str recipient_id: The ID of the recipient being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param TemplateTabs template_tabs:
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'recipient_id', 'template_id', 'template_tabs']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_tabs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_tabs`")
        # verify the required parameter 'recipient_id' is set
        if ('recipient_id' not in params) or (params['recipient_id'] is None):
            raise ValueError("Missing the required parameter `recipient_id` when calling `update_tabs`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `update_tabs`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/tabs'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'recipient_id' in params:
            path_params['recipientId'] = params['recipient_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'template_tabs' in params:
            body_params = params['template_tabs']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Tabs',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_template_document_tabs(self, account_id, document_id, template_id, **kwargs):
        """
        Updates the tabs for a template
        Updates tabs in the document specified by `documentId` in the template specified by `templateId`. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_template_document_tabs(account_id, document_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param TemplateTabs template_tabs:
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_template_document_tabs_with_http_info(account_id, document_id, template_id, **kwargs)
        else:
            (data) = self.update_template_document_tabs_with_http_info(account_id, document_id, template_id, **kwargs)
            return data

    def update_template_document_tabs_with_http_info(self, account_id, document_id, template_id, **kwargs):
        """
        Updates the tabs for a template
        Updates tabs in the document specified by `documentId` in the template specified by `templateId`. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_template_document_tabs_with_http_info(account_id, document_id, template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str document_id: The ID of the document being accessed. (required)
        :param str template_id: The ID of the template being accessed. (required)
        :param TemplateTabs template_tabs:
        :return: Tabs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'document_id', 'template_id', 'template_tabs']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_template_document_tabs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_template_document_tabs`")
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `update_template_document_tabs`")
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `update_template_document_tabs`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/tabs'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'template_tabs' in params:
            body_params = params['template_tabs']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Tabs',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
