# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.  # noqa: E501

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..client.configuration import Configuration
from ..client.api_client import ApiClient


class BulkProcessDataApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def create_bulk_process_request(self, account_id, process_action, **kwargs):
        """
        Uses the specified bulk envelopes list to update the envelopes specified in the payload
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_bulk_process_request(account_id, process_action, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str process_action: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_bulk_process_request_with_http_info(account_id, process_action, **kwargs)
        else:
            (data) = self.create_bulk_process_request_with_http_info(account_id, process_action, **kwargs)
            return data

    def create_bulk_process_request_with_http_info(self, account_id, process_action, **kwargs):
        """
        Uses the specified bulk envelopes list to update the envelopes specified in the payload
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_bulk_process_request_with_http_info(account_id, process_action, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str process_action: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'process_action']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_bulk_process_request" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_bulk_process_request`")
        # verify the required parameter 'process_action' is set
        if ('process_action' not in params) or (params['process_action'] is None):
            raise ValueError("Missing the required parameter `process_action` when calling `create_bulk_process_request`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/bulk_process_data/actions/{processAction}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'process_action' in params:
            path_params['processAction'] = params['process_action']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_bulk_process_request_to_queue(self, account_id, bulk_process_list_id, process_action, **kwargs):
        """
        Uses the specified bulk envelopes list to update the envelopes specified in the payload
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_bulk_process_request_to_queue(account_id, bulk_process_list_id, process_action, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str bulk_process_list_id: (required)
        :param str process_action: (required)
        :param BulkProcessRequest bulk_process_request:
        :return: BulkProcessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_bulk_process_request_to_queue_with_http_info(account_id, bulk_process_list_id, process_action, **kwargs)
        else:
            (data) = self.create_bulk_process_request_to_queue_with_http_info(account_id, bulk_process_list_id, process_action, **kwargs)
            return data

    def create_bulk_process_request_to_queue_with_http_info(self, account_id, bulk_process_list_id, process_action, **kwargs):
        """
        Uses the specified bulk envelopes list to update the envelopes specified in the payload
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_bulk_process_request_to_queue_with_http_info(account_id, bulk_process_list_id, process_action, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str bulk_process_list_id: (required)
        :param str process_action: (required)
        :param BulkProcessRequest bulk_process_request:
        :return: BulkProcessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'bulk_process_list_id', 'process_action', 'bulk_process_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_bulk_process_request_to_queue" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_bulk_process_request_to_queue`")
        # verify the required parameter 'bulk_process_list_id' is set
        if ('bulk_process_list_id' not in params) or (params['bulk_process_list_id'] is None):
            raise ValueError("Missing the required parameter `bulk_process_list_id` when calling `create_bulk_process_request_to_queue`")
        # verify the required parameter 'process_action' is set
        if ('process_action' not in params) or (params['process_action'] is None):
            raise ValueError("Missing the required parameter `process_action` when calling `create_bulk_process_request_to_queue`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/bulk_process_data/actions/{processAction}/{bulkProcessListId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'bulk_process_list_id' in params:
            path_params['bulkProcessListId'] = params['bulk_process_list_id']
        if 'process_action' in params:
            path_params['processAction'] = params['process_action']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'bulk_process_request' in params:
            body_params = params['bulk_process_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='BulkProcessResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_bulk_process_list(self, account_id, bulk_process_list_id, process_action, **kwargs):
        """
        Deletes a specific bulk process list
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_bulk_process_list(account_id, bulk_process_list_id, process_action, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str bulk_process_list_id: (required)
        :param str process_action: (required)
        :return: BulkProcessResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_bulk_process_list_with_http_info(account_id, bulk_process_list_id, process_action, **kwargs)
        else:
            (data) = self.delete_bulk_process_list_with_http_info(account_id, bulk_process_list_id, process_action, **kwargs)
            return data

    def delete_bulk_process_list_with_http_info(self, account_id, bulk_process_list_id, process_action, **kwargs):
        """
        Deletes a specific bulk process list
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_bulk_process_list_with_http_info(account_id, bulk_process_list_id, process_action, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str bulk_process_list_id: (required)
        :param str process_action: (required)
        :return: BulkProcessResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'bulk_process_list_id', 'process_action']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_bulk_process_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_bulk_process_list`")
        # verify the required parameter 'bulk_process_list_id' is set
        if ('bulk_process_list_id' not in params) or (params['bulk_process_list_id'] is None):
            raise ValueError("Missing the required parameter `bulk_process_list_id` when calling `delete_bulk_process_list`")
        # verify the required parameter 'process_action' is set
        if ('process_action' not in params) or (params['process_action'] is None):
            raise ValueError("Missing the required parameter `process_action` when calling `delete_bulk_process_list`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/bulk_process_data/actions/{processAction}/{bulkProcessListId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'bulk_process_list_id' in params:
            path_params['bulkProcessListId'] = params['bulk_process_list_id']
        if 'process_action' in params:
            path_params['processAction'] = params['process_action']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='BulkProcessResult',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_bulk_process_lists(self, account_id, process_action, **kwargs):
        """
        Deletes a specific bulk process list
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_bulk_process_lists(account_id, process_action, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str process_action: (required)
        :param BulkProcessingLists bulk_processing_lists:
        :return: BulkProcessResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_bulk_process_lists_with_http_info(account_id, process_action, **kwargs)
        else:
            (data) = self.delete_bulk_process_lists_with_http_info(account_id, process_action, **kwargs)
            return data

    def delete_bulk_process_lists_with_http_info(self, account_id, process_action, **kwargs):
        """
        Deletes a specific bulk process list
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_bulk_process_lists_with_http_info(account_id, process_action, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str process_action: (required)
        :param BulkProcessingLists bulk_processing_lists:
        :return: BulkProcessResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'process_action', 'bulk_processing_lists']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_bulk_process_lists" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_bulk_process_lists`")
        # verify the required parameter 'process_action' is set
        if ('process_action' not in params) or (params['process_action'] is None):
            raise ValueError("Missing the required parameter `process_action` when calling `delete_bulk_process_lists`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/bulk_process_data/actions/{processAction}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'process_action' in params:
            path_params['processAction'] = params['process_action']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'bulk_processing_lists' in params:
            body_params = params['bulk_processing_lists']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='BulkProcessResult',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_bulk_process_list(self, account_id, bulk_process_list_id, process_action, **kwargs):
        """
        Gets a specific bulk process list
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_bulk_process_list(account_id, bulk_process_list_id, process_action, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str bulk_process_list_id: (required)
        :param str process_action: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_bulk_process_list_with_http_info(account_id, bulk_process_list_id, process_action, **kwargs)
        else:
            (data) = self.get_bulk_process_list_with_http_info(account_id, bulk_process_list_id, process_action, **kwargs)
            return data

    def get_bulk_process_list_with_http_info(self, account_id, bulk_process_list_id, process_action, **kwargs):
        """
        Gets a specific bulk process list
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_bulk_process_list_with_http_info(account_id, bulk_process_list_id, process_action, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str bulk_process_list_id: (required)
        :param str process_action: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'bulk_process_list_id', 'process_action']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bulk_process_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_bulk_process_list`")
        # verify the required parameter 'bulk_process_list_id' is set
        if ('bulk_process_list_id' not in params) or (params['bulk_process_list_id'] is None):
            raise ValueError("Missing the required parameter `bulk_process_list_id` when calling `get_bulk_process_list`")
        # verify the required parameter 'process_action' is set
        if ('process_action' not in params) or (params['process_action'] is None):
            raise ValueError("Missing the required parameter `process_action` when calling `get_bulk_process_list`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/bulk_process_data/actions/{processAction}/{bulkProcessListId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'bulk_process_list_id' in params:
            path_params['bulkProcessListId'] = params['bulk_process_list_id']
        if 'process_action' in params:
            path_params['processAction'] = params['process_action']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_bulk_process_lists(self, account_id, process_action, **kwargs):
        """
        Lists top-level details for all bulk process lists visible to the current user
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_bulk_process_lists(account_id, process_action, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str process_action: (required)
        :return: BulkProcessingListSummaries
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_bulk_process_lists_with_http_info(account_id, process_action, **kwargs)
        else:
            (data) = self.get_bulk_process_lists_with_http_info(account_id, process_action, **kwargs)
            return data

    def get_bulk_process_lists_with_http_info(self, account_id, process_action, **kwargs):
        """
        Lists top-level details for all bulk process lists visible to the current user
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_bulk_process_lists_with_http_info(account_id, process_action, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str process_action: (required)
        :return: BulkProcessingListSummaries
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'process_action']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bulk_process_lists" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_bulk_process_lists`")
        # verify the required parameter 'process_action' is set
        if ('process_action' not in params) or (params['process_action'] is None):
            raise ValueError("Missing the required parameter `process_action` when calling `get_bulk_process_lists`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/bulk_process_data/actions/{processAction}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'process_action' in params:
            path_params['processAction'] = params['process_action']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='BulkProcessingListSummaries',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_bulk_process_list(self, account_id, bulk_process_list_id, process_action, **kwargs):
        """
        Updates a specific bulk process list
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_bulk_process_list(account_id, bulk_process_list_id, process_action, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str bulk_process_list_id: (required)
        :param str process_action: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_bulk_process_list_with_http_info(account_id, bulk_process_list_id, process_action, **kwargs)
        else:
            (data) = self.update_bulk_process_list_with_http_info(account_id, bulk_process_list_id, process_action, **kwargs)
            return data

    def update_bulk_process_list_with_http_info(self, account_id, bulk_process_list_id, process_action, **kwargs):
        """
        Updates a specific bulk process list
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_bulk_process_list_with_http_info(account_id, bulk_process_list_id, process_action, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str bulk_process_list_id: (required)
        :param str process_action: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'bulk_process_list_id', 'process_action']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_bulk_process_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_bulk_process_list`")
        # verify the required parameter 'bulk_process_list_id' is set
        if ('bulk_process_list_id' not in params) or (params['bulk_process_list_id'] is None):
            raise ValueError("Missing the required parameter `bulk_process_list_id` when calling `update_bulk_process_list`")
        # verify the required parameter 'process_action' is set
        if ('process_action' not in params) or (params['process_action'] is None):
            raise ValueError("Missing the required parameter `process_action` when calling `update_bulk_process_list`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/bulk_process_data/actions/{processAction}/{bulkProcessListId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'bulk_process_list_id' in params:
            path_params['bulkProcessListId'] = params['bulk_process_list_id']
        if 'process_action' in params:
            path_params['processAction'] = params['process_action']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
