# Copyright (c) 2020, NVIDIA CORPORATION.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# -*- coding: utf-8 -*-
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: nvidia/clara/platform/clara.proto

# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
import grpc

from nvidia_clara.grpc import payloads_pb2 as nvidia_dot_clara_dot_platform_dot_payloads__pb2


class PayloadsStub(object):
  # missing associated documentation comment in .proto file
  pass

  def __init__(self, channel):
    """Constructor.

    Args:
      channel: A grpc.Channel.
    """
    self.AddMetadata = channel.unary_unary(
        '/nvidia.clara.platform.Payloads/AddMetadata',
        request_serializer=nvidia_dot_clara_dot_platform_dot_payloads__pb2.PayloadsAddMetadataRequest.SerializeToString,
        response_deserializer=nvidia_dot_clara_dot_platform_dot_payloads__pb2.PayloadsAddMetadataResponse.FromString,
        )
    self.Create = channel.unary_unary(
        '/nvidia.clara.platform.Payloads/Create',
        request_serializer=nvidia_dot_clara_dot_platform_dot_payloads__pb2.PayloadsCreateRequest.SerializeToString,
        response_deserializer=nvidia_dot_clara_dot_platform_dot_payloads__pb2.PayloadsCreateResponse.FromString,
        )
    self.Delete = channel.unary_unary(
        '/nvidia.clara.platform.Payloads/Delete',
        request_serializer=nvidia_dot_clara_dot_platform_dot_payloads__pb2.PayloadsDeleteRequest.SerializeToString,
        response_deserializer=nvidia_dot_clara_dot_platform_dot_payloads__pb2.PayloadsDeleteResponse.FromString,
        )
    self.Details = channel.unary_stream(
        '/nvidia.clara.platform.Payloads/Details',
        request_serializer=nvidia_dot_clara_dot_platform_dot_payloads__pb2.PayloadsDetailsRequest.SerializeToString,
        response_deserializer=nvidia_dot_clara_dot_platform_dot_payloads__pb2.PayloadsDetailsResponse.FromString,
        )
    self.Download = channel.unary_stream(
        '/nvidia.clara.platform.Payloads/Download',
        request_serializer=nvidia_dot_clara_dot_platform_dot_payloads__pb2.PayloadsDownloadRequest.SerializeToString,
        response_deserializer=nvidia_dot_clara_dot_platform_dot_payloads__pb2.PayloadsDownloadResponse.FromString,
        )
    self.Remove = channel.unary_unary(
        '/nvidia.clara.platform.Payloads/Remove',
        request_serializer=nvidia_dot_clara_dot_platform_dot_payloads__pb2.PayloadsRemoveRequest.SerializeToString,
        response_deserializer=nvidia_dot_clara_dot_platform_dot_payloads__pb2.PayloadsRemoveResponse.FromString,
        )
    self.RemoveMetadata = channel.unary_unary(
        '/nvidia.clara.platform.Payloads/RemoveMetadata',
        request_serializer=nvidia_dot_clara_dot_platform_dot_payloads__pb2.PayloadsRemoveMetadataRequest.SerializeToString,
        response_deserializer=nvidia_dot_clara_dot_platform_dot_payloads__pb2.PayloadsRemoveMetadataResponse.FromString,
        )
    self.Upload = channel.stream_unary(
        '/nvidia.clara.platform.Payloads/Upload',
        request_serializer=nvidia_dot_clara_dot_platform_dot_payloads__pb2.PayloadsUploadRequest.SerializeToString,
        response_deserializer=nvidia_dot_clara_dot_platform_dot_payloads__pb2.PayloadsUploadResponse.FromString,
        )


class PayloadsServicer(object):
  # missing associated documentation comment in .proto file
  pass

  def AddMetadata(self, request, context):
    """Requests the addition of metadata to a payload.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def Create(self, request, context):
    """Requests the creation of a new payload.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def Delete(self, request, context):
    """Requests the deletion of a known payload.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def Details(self, request, context):
    """Requests the details (file listing) of a known payload.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def Download(self, request, context):
    """Requests the download of a blob (file) from a known payload.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def Remove(self, request, context):
    """Requests the removal, or deletion, of a blob from a known payload.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def RemoveMetadata(self, request, context):
    """Requests the removal of metadata from a payload.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def Upload(self, request_iterator, context):
    """Requests the upload of a blob (file) to a known payload.
    When payload type is PAYLOAD_TYPE_PIPELINE, uploads are written to the ~/input/ folder of the payload.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')


def add_PayloadsServicer_to_server(servicer, server):
  rpc_method_handlers = {
      'AddMetadata': grpc.unary_unary_rpc_method_handler(
          servicer.AddMetadata,
          request_deserializer=nvidia_dot_clara_dot_platform_dot_payloads__pb2.PayloadsAddMetadataRequest.FromString,
          response_serializer=nvidia_dot_clara_dot_platform_dot_payloads__pb2.PayloadsAddMetadataResponse.SerializeToString,
      ),
      'Create': grpc.unary_unary_rpc_method_handler(
          servicer.Create,
          request_deserializer=nvidia_dot_clara_dot_platform_dot_payloads__pb2.PayloadsCreateRequest.FromString,
          response_serializer=nvidia_dot_clara_dot_platform_dot_payloads__pb2.PayloadsCreateResponse.SerializeToString,
      ),
      'Delete': grpc.unary_unary_rpc_method_handler(
          servicer.Delete,
          request_deserializer=nvidia_dot_clara_dot_platform_dot_payloads__pb2.PayloadsDeleteRequest.FromString,
          response_serializer=nvidia_dot_clara_dot_platform_dot_payloads__pb2.PayloadsDeleteResponse.SerializeToString,
      ),
      'Details': grpc.unary_stream_rpc_method_handler(
          servicer.Details,
          request_deserializer=nvidia_dot_clara_dot_platform_dot_payloads__pb2.PayloadsDetailsRequest.FromString,
          response_serializer=nvidia_dot_clara_dot_platform_dot_payloads__pb2.PayloadsDetailsResponse.SerializeToString,
      ),
      'Download': grpc.unary_stream_rpc_method_handler(
          servicer.Download,
          request_deserializer=nvidia_dot_clara_dot_platform_dot_payloads__pb2.PayloadsDownloadRequest.FromString,
          response_serializer=nvidia_dot_clara_dot_platform_dot_payloads__pb2.PayloadsDownloadResponse.SerializeToString,
      ),
      'Remove': grpc.unary_unary_rpc_method_handler(
          servicer.Remove,
          request_deserializer=nvidia_dot_clara_dot_platform_dot_payloads__pb2.PayloadsRemoveRequest.FromString,
          response_serializer=nvidia_dot_clara_dot_platform_dot_payloads__pb2.PayloadsRemoveResponse.SerializeToString,
      ),
      'RemoveMetadata': grpc.unary_unary_rpc_method_handler(
          servicer.RemoveMetadata,
          request_deserializer=nvidia_dot_clara_dot_platform_dot_payloads__pb2.PayloadsRemoveMetadataRequest.FromString,
          response_serializer=nvidia_dot_clara_dot_platform_dot_payloads__pb2.PayloadsRemoveMetadataResponse.SerializeToString,
      ),
      'Upload': grpc.stream_unary_rpc_method_handler(
          servicer.Upload,
          request_deserializer=nvidia_dot_clara_dot_platform_dot_payloads__pb2.PayloadsUploadRequest.FromString,
          response_serializer=nvidia_dot_clara_dot_platform_dot_payloads__pb2.PayloadsUploadResponse.SerializeToString,
      ),
  }
  generic_handler = grpc.method_handlers_generic_handler(
      'nvidia.clara.platform.Payloads', rpc_method_handlers)
  server.add_generic_rpc_handlers((generic_handler,))
