"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnIntegration = exports.toJson_RespondersProperty = exports.toJson_CfnIntegrationProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnIntegrationProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnIntegrationProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'OpsgenieApiEndpoint': obj.opsgenieApiEndpoint,
        'OpsgenieApiKey': obj.opsgenieApiKey,
        'Enabled': obj.enabled,
        'Name': obj.name,
        'IntegrationType': obj.integrationType,
        'OwnerTeamId': obj.ownerTeamId,
        'OwnerTeamName': obj.ownerTeamName,
        'AllowReadAccess': obj.allowReadAccess,
        'AllowWriteAccess': obj.allowWriteAccess,
        'AllowDeleteAccess': obj.allowDeleteAccess,
        'AllowConfigurationAccess': obj.allowConfigurationAccess,
        'Responders': obj.responders?.map(y => toJson_RespondersProperty(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnIntegrationProps = toJson_CfnIntegrationProps;
/**
 * Converts an object of type 'RespondersProperty' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_RespondersProperty(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'type': obj.type,
        'name': obj.name,
        'username': obj.username,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_RespondersProperty = toJson_RespondersProperty;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `Atlassian::Opsgenie::Integration`
 *
 * @cloudformationResource Atlassian::Opsgenie::Integration
 * @stability external
 * @link https://github.com/opsgenie/opsgenie-cloudformation-resources
 */
class CfnIntegration extends cdk.CfnResource {
    /**
     * Create a new `Atlassian::Opsgenie::Integration`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnIntegration.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnIntegrationProps(props) });
        this.props = props;
        this.attrIntegrationId = cdk.Token.asString(this.getAtt('IntegrationId'));
        this.attrIntegrationApiKey = cdk.Token.asString(this.getAtt('IntegrationApiKey'));
    }
}
exports.CfnIntegration = CfnIntegration;
_a = JSII_RTTI_SYMBOL_1;
CfnIntegration[_a] = { fqn: "@cdk-cloudformation/atlassian-opsgenie-integration.CfnIntegration", version: "1.0.1-alpha.6" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnIntegration.CFN_RESOURCE_TYPE_NAME = "Atlassian::Opsgenie::Integration";
//# sourceMappingURL=data:application/json;base64,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