// Copyright (c) Saga Inc.
import React, { useState } from 'react';
import Dropdown from './Dropdown';
import SelectDropdownIcon from '../icons/SelectDropdownIcon';
import { classNames } from '../../utils/classNames';
// import css
import '../../../css/elements/DropdownButton.css';
/**
 * The Dropdown Button component, which allows a user to select
 * an option from a list of items (while the displayed text on
 * the button stays static).
 *
 * If open, the select dropdown automatically closes when the user clicks.
 */
const DropdownButton = (props) => {
    const [displayDropdown, setDisplayDropdown] = useState(false);
    const width = props.width || 'block';
    const widthClass = `element-width-${width}`;
    const disabledClass = props.disabled ? 'mito-dropdown-button-disabled' : 'mito-dropdown-button-enabled';
    return (React.createElement("div", { className: classNames('mito-dropdown-button', 'text-header-4', widthClass, disabledClass), onClick: () => {
            setDisplayDropdown((prevDisplayDropdown) => {
                /*
                    Only change the visibility of the dropdown if:
                    1) the button is not disabled AND
                    2) the button is not already open because the dropdown handles closing itself
                */
                if (!props.disabled && !prevDisplayDropdown) {
                    return true;
                }
                return prevDisplayDropdown;
            });
        } },
        React.createElement("p", { className: 'mito-dropdown-button-text' }, props.text),
        React.createElement("div", { className: 'mito-dropdown-button-icon-container' },
            React.createElement(SelectDropdownIcon, { purpleOrDarkOrWhite: props.disabled ? 'dark' : 'purple' })),
        displayDropdown &&
            React.createElement(Dropdown, { closeDropdown: () => setDisplayDropdown(false), searchable: props.searchable, width: props.dropdownWidth }, props.children)));
};
export default DropdownButton;
//# sourceMappingURL=DropdownButton.js.map