# SOMptimised
An optimised version of [sklearn-som](https://pypi.org/project/sklearn-som/) with extended features.

Additional features:

* Can save additional features into the SOM beyond those used to train it
* Can serialise (i.e. save SOM state into a binary file onto the disk)
* Can load back the SOM in its previous state from a binary file on the disk

This SOM implementation has been optimised in terms of speed with respect to [sklearn-som](https://pypi.org/project/sklearn-som/) just by using more efficient numpy functions and features and by reducing the number of loops when possible.

Performance boost does not scale linearly with SOM or dataset size but, as an indication, a 50x50 SOM run on 14 000 data points (1 epoch) takes on my machine:

* **7.3s of CPU and wall time to fit with this library**
* 2min of CPU and wall time to fit with [sklearn-som](https://pypi.org/project/sklearn-som/)

For more details, please visit the [documentation](https://wilfriedmercier.github.io/SOMptimised/index.html).

# How to use

Using the SOM is quite straightforward. To do so, data has to be load as a 2D array

```python
import pandas

table      = pandas.read_csv('examples/iris_dataset/iris_dataset.csv')
target     = table['target']
table      = table[['petal length (cm)', 'petal width (cm)', 'sepal length (cm)']]
data       = table.to_numpy()

data_train = data[:-10] # Training set
data_test  = data[-10:] # Test set
```

Training is done with the `fit` method and predictions are done with the `predict` method

```python
from SOMptimised import SOM

nf  = data_train.shape[1] # Number of features
som = SOM(m=1, n=3, dim=nf, lr=1, sigma=1, max_iter=1e4, random_state=None)
som.fit(data_train, epochs=1, shuffle=True)

pred_test = som.predict(data_test)
```

The current state of the SOM can be saved into a binary file and loaded back from it into any python code using the `write` and `read` methods

```
som.write('output_file')

new_som = SOM.read('output_file')
```

# License

MIT License

Copyright (c) 2022 Wilfried Mercier

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
