"use strict";
const assert_1 = require("@aws-cdk/assert");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
module.exports = {
    'can create a receipt filter'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        // WHEN
        new lib_1.ReceiptFilter(stack, 'Filter', {
            ip: '1.2.3.4/16',
            receiptFilterName: 'MyFilter',
            policy: lib_1.ReceiptFilterPolicy.BLOCK,
        });
        // THEN
        assert_1.expect(stack).toMatch({
            'Resources': {
                'FilterC907D6DA': {
                    'Type': 'AWS::SES::ReceiptFilter',
                    'Properties': {
                        'Filter': {
                            'IpFilter': {
                                'Cidr': '1.2.3.4/16',
                                'Policy': 'Block',
                            },
                            'Name': 'MyFilter',
                        },
                    },
                },
            },
        });
        test.done();
    },
    'can create a white list filter'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        // WHEN
        new lib_1.WhiteListReceiptFilter(stack, 'WhiteList', {
            ips: [
                '10.0.0.0/16',
                '1.2.3.4',
            ],
        });
        // THEN
        assert_1.expect(stack).toMatch({
            'Resources': {
                'WhiteListBlockAllAE2CDDFF': {
                    'Type': 'AWS::SES::ReceiptFilter',
                    'Properties': {
                        'Filter': {
                            'IpFilter': {
                                'Cidr': '0.0.0.0/0',
                                'Policy': 'Block',
                            },
                        },
                    },
                },
                'WhiteListAllow1000016F396A7F2': {
                    'Type': 'AWS::SES::ReceiptFilter',
                    'Properties': {
                        'Filter': {
                            'IpFilter': {
                                'Cidr': '10.0.0.0/16',
                                'Policy': 'Allow',
                            },
                        },
                    },
                },
                'WhiteListAllow1234A4DDAD4E': {
                    'Type': 'AWS::SES::ReceiptFilter',
                    'Properties': {
                        'Filter': {
                            'IpFilter': {
                                'Cidr': '1.2.3.4',
                                'Policy': 'Allow',
                            },
                        },
                    },
                },
            },
        });
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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