import re

from datasets import load_dataset

from minieval.datatypes import Instance, Task, TaskConfig
from minieval.few_shot import FewShot


class HellaSwag(Task):
    HF_PATH = "hellaswag"
    FEW_SHOT = FewShot.get("hellaswag::olmes")

    def __init__(self, config: TaskConfig):
        self.config = config
        requests = []
        for subset in ["train", "validation", "test"]:
            dataset = load_dataset(path=self.HF_PATH, split=subset)
            requests += list(map(self._process_instance, dataset))
        self.requests = requests

    def _process_instance(self, doc):
        ctx = doc["ctx_a"] + " " + doc["ctx_b"].capitalize()
        choices = [self._preprocess(ending) for ending in doc["endings"]]
        gold_idx = int(doc["label"])

        return Instance(
            question=self._preprocess(ctx),
            gold_completion=choices[gold_idx],
            choices=choices,
            solution=gold_idx,
            metadata={"id": doc["ind"]},
        )

    def _preprocess(cls, text):
        text = text.strip()
        text = re.sub("\\.? \\[title\\]", ". ", text)
        text = re.sub("\\[.*?\\]", "", text)
        text = text.replace("  ", " ")
        return text
