from datasets import load_dataset

from minieval.datatypes import Instance, LMOutput, Task, TaskConfig
from minieval.extract import math_latex


class AIME(Task):
    HF_PATH = "allenai/aime-2021-2025"

    def __init__(self, config: TaskConfig):
        self.config = config
        dataset = load_dataset(path=self.HF_PATH, split="train")
        self.requests = list(map(self._process_doc, dataset))

    def _process_doc(self, doc):
        problem_from = doc.get("url").split("/")[-2]
        year = problem_from.split("_")[0]
        aime_number = "AIME_" + problem_from.split("_")[2]

        return Instance(
            question=doc["problem"],
            gold_completion=doc["solution"],
            solution=doc["answer"],
            subset=year,
            metadata={
                "id": aime_number,
                "year": year,
            },
        )
    
    def _extract_answer(self, generation: LMOutput) -> list[str]:
        return math_latex.extract_math_answer(generation.text)
