from minieval.datatypes import TaskConfig, TaskRegistry
from minieval.formatters import CoT
from minieval.metrics import PassAtK, Top1
from minieval.score.core import ExactMatch, ExactMatchFlex
from minieval.tasks.minerva import MinervaMath, Math500
from minieval.tasks.gpqa import GPQA, SuperGPQA
from minieval.tasks.gsm import GSM8K, GSMPlus, GSMSymbolicMain, GSMSymbolicP1, GSMSymbolicP2
from minieval.tasks.aime import AIME
from minieval.tasks.mmlu import MMLU, MMLUPro
from minieval.tasks.arc import ARCEasy, ARCChallenge


@TaskRegistry.register("minerva:cot", task=MinervaMath)
class MinervaCoT(TaskConfig):
    formatter=CoT()
    scorer=[ExactMatchFlex()]
    metric=[Top1()]
    generation_kwargs = {
        "max_gen_toks": 2048,
        "temperature": 0.0,
    }


@TaskRegistry.register("minerva:selfc", task=MinervaMath)
class MinervaCoT(TaskConfig):
    formatter=CoT()
    scorer=[ExactMatchFlex()]
    metric=[PassAtK(k=1), PassAtK(k=2), PassAtK(k=5), PassAtK(k=20)]
    generation_kwargs = {
        "max_gen_toks": 2048,
        "temperature": 0.0,
        "repeats": 20
    }


@TaskRegistry.register("minerva_500:cot", task=Math500)
class Minerva500CoT(TaskConfig):
    formatter=CoT()
    scorer=[ExactMatchFlex()]
    metric=[Top1()]
    generation_kwargs = {
        "max_gen_toks": 2048,
        "temperature": 0.0,
    }


@TaskRegistry.register("gpqa:cot", task=GPQA)
class GPQACoT(TaskConfig):
    # "description": 'Answer the following multiple-choice question by giving the correct answer letter in parentheses. Provide CONCISE reasoning for the answer, and make sure to finish the response with "Therefore, the answer is (ANSWER_LETTER)" where (ANSWER_LETTER) is one of (A), (B), (C), (D).\n\n',
    formatter=CoT()
    scorer=[ExactMatch()]
    metric=[Top1()]
    generation_kwargs = {
        "max_gen_toks": 8192,
        "temperature": 0.0,
    }


@TaskRegistry.register("gsm:cot", task=GSM8K)
class GSMCoT(TaskConfig):
    formatter=CoT()
    scorer=[ExactMatchFlex()]
    metric=[Top1()]
    generation_kwargs = {
        "max_gen_toks": 2048,
        "temperature": 0.0,
    }


@TaskRegistry.register("aime:cot", task=AIME)
class AIMECoT(TaskConfig):
    # INSTRUCTION = "Present the answer in LaTex format: \\boxed{Your answer}"
    formatter=CoT()
    scorer=[ExactMatchFlex()]
    metric=[Top1()]
    generation_kwargs = {
        "max_gen_toks": 8192,
        "temperature": 0.0,
    }


@TaskRegistry.register("mmlu:cot", task=MMLU)
class MMLUCoT(TaskConfig):
    formatter=CoT()
    scorer=[ExactMatch()]
    metric=[Top1()]
    generation_kwargs = {
        "max_gen_toks": 2048,
        "temperature": 0.0,
        "stop_sequences": ["Question:"],
    }


@TaskRegistry.register("mmlu_pro:cot", task=MMLUPro)
class MMLUProCoT(TaskConfig):
    formatter=CoT()
    scorer=[ExactMatch()]
    metric=[Top1()]
    generation_kwargs = {
        "max_gen_toks": 2048,
        "temperature": 0.0,
        "stop_sequences": ["Question:"],
    }