from minieval.datatypes import Instance, LMOutput, Scorer
from minieval.extract import math_latex


class ExactMatch(Scorer):
    name = 'exact_match'

    def _score_response_single(self, input: Instance, output: LMOutput) -> LMOutput:
        answer = output.extracted_answer
        correct = input.solution

        assert not isinstance(answer, list), \
            f"EM Flex requires a list of answers! Seeing: {answer}"

        output.score[self.name] = float(answer == correct)
        return output


class ExactMatchFlex(Scorer):
    """ Allow any extracted answer to be correct """
    name = 'exact_match_flex'

    def _score_response_single(self, input: Instance, output: LMOutput) -> LMOutput:
        gen_answers = output.extracted_answer
        correct = input.solution

        assert isinstance(gen_answers, list), \
            f"EM Flex requires a list of answers! Seeing: {gen_answers}"

        for gen in gen_answers:
            if math_latex.is_equiv(gen, correct):
                output.score[self.name] = float(True)
                return output
            
        output.score[self.name] = float(False)
        return output