from minieval.datatypes import Formatter, Instance


def base_model_chat_template(messages, tokenize=False):
    assert not tokenize
    assert len(messages) == 1, \
        "Basic chat template currently only supports single-turn conversations!"
    
    message = messages[0]["content"]
    prompt = f"Question: {message}\nAnswer:"
    return prompt


class CoT(Formatter):
    TEMPLATE = "{question}"

    def _build_message(self, instance: Instance):
        messages = [{"role": "user", "content": self.TEMPLATE.format(question=instance.question)}]
        return messages


class MC(Formatter):
    TEMPLATE = "{question}\nChoices:\n{choices}"

    def _build_message(self, instance: Instance):
        choices_text = \
            "\n".join(f"{chr(65+i)}. {choice}" for i, choice in enumerate(instance.choices))
        question_text = self.TEMPLATE.format(
            question=instance.question,
            choices=choices_text
        )
        messages = [{"role": "user", "content": question_text}]
        return messages


class RC(Formatter):
    TEMPLATE = "{question}\nChoices:\n{choices}"

    def _build_message(self, instance: Instance):
        choices_text = \
            "\n".join(f"{chr(65+i)}. {choice}" for i, choice in enumerate(instance.choices))
        question_text = self.TEMPLATE.format(
            question=instance.question,
            choices=choices_text
        )
        messages = [{"role": "user", "content": question_text}]
        return messages
