from ..datatypes import LMOutput


class MockLLM:
    def generate(self, requests, **kwargs) -> list[list[LMOutput]]:
        return [[LMOutput(text=" mock continuation. The answer is (A), or \\boxed{answer}", logprobs=[1, 1, 1, 1])] for _ in requests]
    
    def logprobs(self, requests, continuations, **kwargs) -> list[list[LMOutput]]:
        return [[LMOutput(logprobs=[1, 1, 1, 1])] for _ in requests]
