# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['streamlit_tfx']

package_data = \
{'': ['*']}

install_requires = \
['ipywidgets>=7.7.0,<8.0.0', 'streamlit>=1.9.2,<2.0.0', 'tfx>=1.8.0,<2.0.0']

setup_kwargs = {
    'name': 'streamlit-tfx',
    'version': '22.6.4.dev0',
    'description': 'TensorFlow Extended visualizers for Streamlit apps',
    'long_description': "# streamlit-tfx: TensorFlow Extended visualizers for Streamlit apps\n\n`streamlit-tfx` provides utilities for visualizing [TensorFlow Extended](https://www.tensorflow.org/tfx)\nartifacts in [Streamlit](https://streamlit.io) apps.\n\n[![GitHub][github_badge]][github_link] [![PyPI][pypi_badge]][pypi_link]\n\n> ### 🌱 Just sprouting!\n> This project is in the very beginning stages of development. It's not well tested and is only intended to be used as a demo.\n\n## Installation\n\n``` shell\npip install streamlit-tfx\n```\n\n## Getting started\n\n```python\nimport streamlit_tfx as st_tfx\n\nst_tfx.display(item)\nst_tfx.display_statistics(statistics)\nst_tfx.display_schema(schema)\nst_tfx.display_anomalies(anomalies)\nst_tfx.display_eval_result_plot(eval_result)\nst_tfx.display_eval_result_slicing_attributions(eval_result)\nst_tfx.display_eval_result_slicing_metrics(eval_result)\nst_tfx.display_eval_results_time_series(eval_results)\n```\n\n---\n\nMost artifacts in `tests/artifacts/` were generated by running the [TFX Keras Component tutorial](https://www.tensorflow.org/tfx/tutorials/tfx/components_keras).\nThe anomalies artifact with anomalies was generated by running the [TensorFlow Model Analysis tutorial](https://www.tensorflow.org/tfx/tutorials/model_analysis/tfma_basic).\n\n🚀 Inspired by [spacy-streamlit](https://github.com/explosion/spacy-streamlit)\nand [streamlit-player](https://github.com/okld/streamlit-player).\n\n[github_badge]: https://badgen.net/badge/icon/GitHub?icon=github&color=black&label\n[github_link]: https://github.com/codesue/streamlit-tfx\n\n[pypi_badge]: https://badgen.net/pypi/v/streamlit-tfx?icon=pypi&color=black&label\n[pypi_link]: https://pypi.org/project/streamlit-tfx\n",
    'author': 'Suzen Fylke',
    'author_email': 'codesue@users.noreply.github.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/codesue/streamlit-tfx',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<3.10',
}


setup(**setup_kwargs)
